/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.core;

import liquibase.database.AbstractDatabase;
import liquibase.database.AbstractDatabaseTest;
import liquibase.database.core.H2Database;
import org.junit.Assert;
import org.junit.Test;

public class H2DatabaseTest
extends AbstractDatabaseTest {
    public H2DatabaseTest() throws Exception {
        super((AbstractDatabase)new H2Database());
    }

    protected String getProductNameString() {
        return "H2";
    }

    @Test
    public void supportsInitiallyDeferrableColumns() {
        Assert.assertFalse((boolean)this.getDatabase().supportsInitiallyDeferrableColumns());
    }

    @Test
    public void getCurrentDateTimeFunction() {
        Assert.assertEquals((Object)"NOW()", (Object)this.getDatabase().getCurrentDateTimeFunction());
    }

    @Test
    public void testGetDefaultDriver() {
        AbstractDatabase database = this.getDatabase();
        Assert.assertEquals((Object)"org.h2.Driver", (Object)database.getDefaultDriver("jdbc:h2:mem:liquibase"));
        Assert.assertNull((Object)database.getDefaultDriver("jdbc:db2://localhost;databaseName=liquibase"));
    }

    @Test
    public void escapeTableName_noSchema() {
        AbstractDatabase database = this.getDatabase();
        Assert.assertEquals((Object)"tableName", (Object)database.escapeTableName(null, "tableName"));
    }

    @Test
    public void escapeTableName_withSchema() {
        AbstractDatabase database = this.getDatabase();
        Assert.assertEquals((Object)"schemaName.tableName", (Object)database.escapeTableName("schemaName", "tableName"));
    }
}

