/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.core;

import junit.framework.TestCase;
import liquibase.database.core.InformixDatabase;

public class InformixDatabaseTest
extends TestCase {
    private InformixDatabase database;

    protected void setUp() throws Exception {
        this.database = new InformixDatabase();
    }

    public void testGetDateLiteral() {
        String d = this.database.getDateLiteral("2010-11-12 13:14:15");
        InformixDatabaseTest.assertEquals((String)"DATETIME (2010-11-12 13:14:15) YEAR TO FRACTION(5)", (String)d);
        d = this.database.getDateLiteral("2010-11-12");
        InformixDatabaseTest.assertEquals((String)"'2010-11-12'", (String)d);
        d = this.database.getDateLiteral("13:14:15");
        InformixDatabaseTest.assertEquals((String)"INTERVAL (13:14:15) HOUR TO FRACTION(5)", (String)d);
    }

    public void testGetDefaultDriver() {
        InformixDatabaseTest.assertEquals((String)"com.informix.jdbc.IfxDriver", (String)this.database.getDefaultDriver("jdbc:informix-sqli://localhost:9088/liquibase:informixserver=ol_ids_1150_1"));
    }
}

