/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.core;

import liquibase.database.AbstractDatabase;
import liquibase.database.AbstractDatabaseTest;
import liquibase.database.core.MSSQLDatabase;
import liquibase.exception.DatabaseException;
import org.junit.Assert;
import org.junit.Test;

public class MSSQLDatabaseTest
extends AbstractDatabaseTest {
    public MSSQLDatabaseTest() throws Exception {
        super((AbstractDatabase)new MSSQLDatabase());
    }

    protected String getProductNameString() {
        return "Microsoft SQL Server";
    }

    @Test
    public void supportsInitiallyDeferrableColumns() {
        Assert.assertFalse((boolean)this.getDatabase().supportsInitiallyDeferrableColumns());
    }

    @Test
    public void getCurrentDateTimeFunction() {
        Assert.assertEquals((Object)"GETDATE()", (Object)this.getDatabase().getCurrentDateTimeFunction());
    }

    @Test
    public void getDefaultDriver() {
        MSSQLDatabase database = new MSSQLDatabase();
        Assert.assertEquals((Object)"com.microsoft.sqlserver.jdbc.SQLServerDriver", (Object)database.getDefaultDriver("jdbc:sqlserver://localhost;databaseName=liquibase"));
        Assert.assertNull((Object)database.getDefaultDriver("jdbc:oracle:thin://localhost;databaseName=liquibase"));
    }

    @Test
    public void escapeTableName_noSchema() {
        MSSQLDatabase database = new MSSQLDatabase();
        Assert.assertEquals((Object)"[dbo].[tableName]", (Object)database.escapeTableName(null, "tableName"));
    }

    @Test
    public void escapeTableName_withSchema() {
        MSSQLDatabase database = new MSSQLDatabase();
        Assert.assertEquals((Object)"[schemaName].[tableName]", (Object)database.escapeTableName("schemaName", "tableName"));
    }

    @Test
    public void changeDefaultSchema() throws DatabaseException {
        MSSQLDatabase database = new MSSQLDatabase();
        Assert.assertEquals((Object)"dbo", (Object)database.getDefaultSchemaName());
        database.setDefaultSchemaName("myschema");
        Assert.assertEquals((Object)"myschema", (Object)database.getDefaultSchemaName());
    }
}

