/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.core;

import liquibase.database.AbstractDatabase;
import liquibase.database.AbstractDatabaseTest;
import liquibase.database.core.MySQLDatabase;
import org.junit.Assert;
import org.junit.Test;

public class MySQLDatabaseTest
extends AbstractDatabaseTest {
    public MySQLDatabaseTest() throws Exception {
        super((AbstractDatabase)new MySQLDatabase());
    }

    protected String getProductNameString() {
        return "MySQL";
    }

    @Test
    public void supportsInitiallyDeferrableColumns() {
        Assert.assertFalse((boolean)this.getDatabase().supportsInitiallyDeferrableColumns());
    }

    @Test
    public void getCurrentDateTimeFunction() {
        Assert.assertEquals((Object)"NOW()", (Object)this.getDatabase().getCurrentDateTimeFunction());
    }

    public void testGetDefaultDriver() {
        MySQLDatabase database = new MySQLDatabase();
        Assert.assertEquals((Object)"com.mysql.jdbc.Driver", (Object)database.getDefaultDriver("jdbc:mysql://localhost/liquibase"));
        Assert.assertNull((Object)database.getDefaultDriver("jdbc:db2://localhost;databaseName=liquibase"));
    }

    @Test
    public void escapeTableName_noSchema() {
        AbstractDatabase database = this.getDatabase();
        Assert.assertEquals((Object)"`tableName`", (Object)database.escapeTableName(null, "tableName"));
    }

    @Test
    public void escapeTableName_withSchema() {
        AbstractDatabase database = this.getDatabase();
        Assert.assertEquals((Object)"`schemaName`.`tableName`", (Object)database.escapeTableName("schemaName", "tableName"));
    }
}

