/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.core;

import liquibase.database.AbstractDatabase;
import liquibase.database.AbstractDatabaseTest;
import liquibase.database.core.OracleDatabase;
import org.junit.Assert;
import org.junit.Test;

public class OracleDatabaseTest
extends AbstractDatabaseTest {
    public OracleDatabaseTest() throws Exception {
        super((AbstractDatabase)new OracleDatabase());
    }

    protected String getProductNameString() {
        return "Oracle";
    }

    @Test
    public void escapeTableName_noSchema() {
        AbstractDatabase database = this.getDatabase();
        Assert.assertEquals((Object)"tableName", (Object)database.escapeTableName(null, "tableName"));
    }

    @Test
    public void escapeTableName_withSchema() {
        AbstractDatabase database = this.getDatabase();
        Assert.assertEquals((Object)"schemaName.tableName", (Object)database.escapeTableName("schemaName", "tableName"));
    }

    @Test
    public void supportsInitiallyDeferrableColumns() {
        Assert.assertTrue((boolean)this.getDatabase().supportsInitiallyDeferrableColumns());
    }

    @Test
    public void getCurrentDateTimeFunction() {
        Assert.assertEquals((Object)"SYSTIMESTAMP", (Object)this.getDatabase().getCurrentDateTimeFunction());
    }

    public void testGetDefaultDriver() {
        OracleDatabase database = new OracleDatabase();
        Assert.assertEquals((Object)"oracle.jdbc.OracleDriver", (Object)database.getDefaultDriver("jdbc:oracle:thin:@localhost/XE"));
        Assert.assertNull((Object)database.getDefaultDriver("jdbc:db2://localhost;databaseName=liquibase"));
    }
}

