/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.core;

import liquibase.database.AbstractDatabase;
import liquibase.database.AbstractDatabaseTest;
import liquibase.database.core.PostgresDatabase;
import org.junit.Assert;
import org.junit.Test;

public class PostgresDatabaseTest
extends AbstractDatabaseTest {
    public PostgresDatabaseTest() throws Exception {
        super((AbstractDatabase)new PostgresDatabase());
    }

    protected String getProductNameString() {
        return "PostgreSQL";
    }

    @Test
    public void supportsInitiallyDeferrableColumns() {
        Assert.assertTrue((boolean)this.getDatabase().supportsInitiallyDeferrableColumns());
    }

    @Test
    public void getCurrentDateTimeFunction() {
        Assert.assertEquals((Object)"NOW()", (Object)this.getDatabase().getCurrentDateTimeFunction());
    }

    @Test
    public void testDropDatabaseObjects() throws Exception {
    }

    @Test
    public void testCheckDatabaseChangeLogTable() throws Exception {
    }

    public void testGetDefaultDriver() {
        PostgresDatabase database = new PostgresDatabase();
        Assert.assertEquals((Object)"org.postgresql.Driver", (Object)database.getDefaultDriver("jdbc:postgresql://localhost/liquibase"));
        Assert.assertNull((Object)database.getDefaultDriver("jdbc:db2://localhost;databaseName=liquibase"));
    }

    @Test
    public void escapeTableName_noSchema() {
        AbstractDatabase database = this.getDatabase();
        Assert.assertEquals((Object)"\"tableName\"", (Object)database.escapeTableName(null, "tableName"));
    }

    @Test
    public void escapeTableName_reservedWord() {
        AbstractDatabase database = this.getDatabase();
        Assert.assertEquals((Object)"\"user\"", (Object)database.escapeTableName(null, "user"));
    }

    @Test
    public void escapeTableName_withSchema() {
        AbstractDatabase database = this.getDatabase();
        Assert.assertEquals((Object)"\"schemaName\".\"tableName\"", (Object)database.escapeTableName("schemaName", "tableName"));
    }
}

