/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.core;

import java.util.Arrays;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.core.SybaseDatabase;
import liquibase.exception.DatabaseException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.statement.SqlStatement;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class SybaseDatabaseTest {
    @Test
    public void testIsSybaseProductName() {
        SybaseDatabase database = new SybaseDatabase();
        Assert.assertTrue((String)"Sybase SQL Server is a valid product name", (boolean)database.isSybaseProductName("Sybase SQL Server"));
        Assert.assertTrue((String)"sql server is a valid product name", (boolean)database.isSybaseProductName("sql server"));
        Assert.assertTrue((String)"ASE is a valid product name", (boolean)database.isSybaseProductName("ASE"));
        Assert.assertTrue((String)"Adaptive Server Enterprise is a valid product name", (boolean)database.isSybaseProductName("Adaptive Server Enterprise"));
    }

    private void configureExecutor(Database database, String ... viewInfoRows) {
        Executor executor = (Executor)EasyMock.createNiceMock(Executor.class);
        try {
            Class stringClassMatcher = (Class)EasyMock.anyObject();
            EasyMock.expect((Object)executor.queryForList((SqlStatement)EasyMock.anyObject(), stringClassMatcher)).andReturn(Arrays.asList(viewInfoRows));
        }
        catch (DatabaseException e) {
            throw new RuntimeException(e);
        }
        EasyMock.replay((Object[])new Object[]{executor});
        ExecutorService.getInstance().setExecutor(database, executor);
    }

    @Test
    public void testGetViewDefinitionWhenNoRows() throws Exception {
        SybaseDatabase database = new SybaseDatabase();
        this.configureExecutor((Database)database, new String[0]);
        Assert.assertEquals((Object)"", (Object)database.getViewDefinition("dbo", "view_name"));
    }

    @Test
    public void testGetViewDefinitionWhenSingleRow() throws Exception {
        SybaseDatabase database = new SybaseDatabase();
        this.configureExecutor((Database)database, "foo");
        Assert.assertEquals((Object)"foo", (Object)database.getViewDefinition("dbo", "view_name"));
    }

    @Test
    public void testGetViewDefinitionWhenMultipleRows() throws Exception {
        SybaseDatabase database = new SybaseDatabase();
        this.configureExecutor((Database)database, "foo", " bar", " bat");
        Assert.assertEquals((Object)"foo bar bat", (Object)database.getViewDefinition("dbo", "view_name"));
    }

    @Test
    public void testGetDatabaseMajorVersionWhenImplemented() throws Exception {
        DatabaseConnection connection = (DatabaseConnection)EasyMock.createNiceMock(DatabaseConnection.class);
        EasyMock.expect((Object)connection.getDatabaseMajorVersion()).andReturn((Object)15);
        EasyMock.replay((Object[])new Object[]{connection});
        SybaseDatabase database = new SybaseDatabase();
        database.setConnection(connection);
        Assert.assertEquals((long)15L, (long)database.getDatabaseMajorVersion());
    }

    @Test
    public void testGetDatabaseMinorVersionWhenImplemented() throws Exception {
        DatabaseConnection connection = (DatabaseConnection)EasyMock.createNiceMock(DatabaseConnection.class);
        EasyMock.expect((Object)connection.getDatabaseMinorVersion()).andReturn((Object)5);
        EasyMock.replay((Object[])new Object[]{connection});
        SybaseDatabase database = new SybaseDatabase();
        database.setConnection(connection);
        Assert.assertEquals((long)5L, (long)database.getDatabaseMinorVersion());
    }

    @Test
    public void testGetDatabaseMajorVersionWhenNotImplemented() throws Exception {
        DatabaseConnection connection = (DatabaseConnection)EasyMock.createNiceMock(DatabaseConnection.class);
        EasyMock.expect((Object)connection.getDatabaseMajorVersion()).andThrow((Throwable)new UnsupportedOperationException());
        EasyMock.replay((Object[])new Object[]{connection});
        SybaseDatabase database = new SybaseDatabase();
        database.setConnection(connection);
        Assert.assertEquals((long)-1L, (long)database.getDatabaseMajorVersion());
    }

    @Test
    public void testGetDatabaseMinorVersionWhenNotImplemented() throws Exception {
        DatabaseConnection connection = (DatabaseConnection)EasyMock.createNiceMock(DatabaseConnection.class);
        EasyMock.expect((Object)connection.getDatabaseMinorVersion()).andThrow((Throwable)new UnsupportedOperationException());
        EasyMock.replay((Object[])new Object[]{connection});
        SybaseDatabase database = new SybaseDatabase();
        database.setConnection(connection);
        Assert.assertEquals((long)-1L, (long)database.getDatabaseMinorVersion());
    }
}

