/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.typeconversion.core;

import liquibase.database.structure.type.DataType;
import liquibase.database.typeconversion.core.DefaultTypeConverterTest;
import liquibase.database.typeconversion.core.InformixTypeConverter;
import org.junit.Assert;

public class InformixTypeConverterTest
extends DefaultTypeConverterTest {
    public void testGetColumnType() {
        InformixTypeConverter typeConverter = new InformixTypeConverter();
        DataType type = typeConverter.getDataType("int", Boolean.valueOf(true));
        Assert.assertEquals((Object)"SERIAL", (Object)type.toString());
        type = typeConverter.getDataType("INT", Boolean.valueOf(true));
        Assert.assertEquals((Object)"SERIAL", (Object)type.toString());
        type = typeConverter.getDataType("integer", Boolean.valueOf(true));
        Assert.assertEquals((Object)"SERIAL", (Object)type.toString());
        type = typeConverter.getDataType("INTEGER", Boolean.valueOf(true));
        Assert.assertEquals((Object)"SERIAL", (Object)type.toString());
        type = typeConverter.getDataType("BIGINT", Boolean.valueOf(true));
        Assert.assertEquals((Object)"SERIAL8", (Object)type.toString());
        type = typeConverter.getDataType("bigint", Boolean.valueOf(true));
        Assert.assertEquals((Object)"SERIAL8", (Object)type.toString());
        type = typeConverter.getDataType("int8", Boolean.valueOf(true));
        Assert.assertEquals((Object)"SERIAL8", (Object)type.toString());
        try {
            type = typeConverter.getDataType("integ", Boolean.valueOf(true));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Unknown autoincrement type: integ", (Object)e.getMessage());
        }
        try {
            type = typeConverter.getDataType("varchar(10)", Boolean.valueOf(true));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Unknown autoincrement type: varchar(10)", (Object)e.getMessage());
        }
    }
}

