/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.typeconversion.core;

import liquibase.database.typeconversion.core.DefaultTypeConverterTest;
import liquibase.database.typeconversion.core.PostgresTypeConverter;
import org.junit.Assert;
import org.junit.Test;

public class PostgresTypeConverterTest
extends DefaultTypeConverterTest {
    @Test
    public void getFalseBooleanValue() {
        Assert.assertEquals((Object)"FALSE", (Object)new PostgresTypeConverter().getBooleanType().getFalseBooleanValue());
    }

    @Test
    public void getTrueBooleanValue() {
        Assert.assertEquals((Object)"TRUE", (Object)new PostgresTypeConverter().getBooleanType().getTrueBooleanValue());
    }

    @Test
    public void getBlobType() {
        Assert.assertEquals((Object)"BYTEA", (Object)new PostgresTypeConverter().getBlobType().toString());
    }

    @Test
    public void getBooleanType() {
        Assert.assertEquals((Object)"BOOLEAN", (Object)new PostgresTypeConverter().getBooleanType().toString());
    }

    @Test
    public void getCurrencyType() {
        Assert.assertEquals((Object)"DECIMAL", (Object)new PostgresTypeConverter().getCurrencyType().toString());
    }

    @Test
    public void getUUIDType() {
        Assert.assertEquals((Object)"CHAR(36)", (Object)new PostgresTypeConverter().getUUIDType().toString());
    }

    @Test
    public void getClobType() {
        Assert.assertEquals((Object)"TEXT", (Object)new PostgresTypeConverter().getClobType().toString());
    }

    @Test
    public void getDateType() {
        Assert.assertEquals((Object)"DATE", (Object)new PostgresTypeConverter().getDateType().toString());
    }

    @Test
    public void getDateTimeType() {
        Assert.assertEquals((Object)"TIMESTAMP WITH TIME ZONE", (Object)new PostgresTypeConverter().getDateTimeType().toString());
    }

    @Test
    public void getColumnType_BigSerial_AutoIncrement() {
        Assert.assertEquals((Object)"bigserial", (Object)new PostgresTypeConverter().getDataType("bigserial", Boolean.valueOf(true)).toString());
    }

    @Test
    public void getColumnType_BigInt_AutoIncrement() {
        Assert.assertEquals((Object)"bigserial", (Object)new PostgresTypeConverter().getDataType("bigint", Boolean.valueOf(true)).toString());
    }

    @Test
    public void getColumnType_TinyText() {
        Assert.assertEquals((Object)"TEXT", (Object)new PostgresTypeConverter().getDataType("TINYTEXT", Boolean.valueOf(false)).toString());
    }

    @Test
    public void getColumnType_Text() {
        Assert.assertEquals((Object)"TEXT", (Object)new PostgresTypeConverter().getDataType("TEXT", Boolean.valueOf(false)).toString());
    }

    @Test
    public void getColumnType_MediumText() {
        Assert.assertEquals((Object)"TEXT", (Object)new PostgresTypeConverter().getDataType("MEDIUMTEXT", Boolean.valueOf(false)).toString());
    }

    @Test
    public void getColumnType_LongText() {
        Assert.assertEquals((Object)"TEXT", (Object)new PostgresTypeConverter().getDataType("LONGTEXT", Boolean.valueOf(false)).toString());
    }

    @Test
    public void getColumnType_TinyBlob() {
        Assert.assertEquals((Object)"BYTEA", (Object)new PostgresTypeConverter().getDataType("TINYBLOB", Boolean.valueOf(false)).toString());
    }

    @Test
    public void getColumnType_Blob() {
        Assert.assertEquals((Object)"BYTEA", (Object)new PostgresTypeConverter().getDataType("BLOB", Boolean.valueOf(false)).toString());
    }

    @Test
    public void getColumnType_MediumBlob() {
        Assert.assertEquals((Object)"BYTEA", (Object)new PostgresTypeConverter().getDataType("MEDIUMBLOB", Boolean.valueOf(false)).toString());
    }

    @Test
    public void getColumnType_LongBlob() {
        Assert.assertEquals((Object)"BYTEA", (Object)new PostgresTypeConverter().getDataType("LONGBLOB", Boolean.valueOf(false)).toString());
    }
}

