/*
 * Decompiled with CFR 0.152.
 */
package liquibase.integration.commandline;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Properties;
import liquibase.exception.CommandLineParsingException;
import liquibase.integration.commandline.Main;
import liquibase.util.StringUtils;
import org.junit.Assert;
import org.junit.Test;

public class MainTest {
    @Test
    public void migrateWithAllParameters() throws Exception {
        String[] args = new String[]{"--driver=DRIVER", "--username=USERNAME", "--password=PASSWORD", "--url=URL", "--changeLogFile=FILE", "--classpath=CLASSPATH;CLASSPATH2", "--contexts=CONTEXT1,CONTEXT2", "--promptForNonLocalDatabase=true", "update"};
        Main cli = new Main();
        cli.parseOptions(args);
        Assert.assertEquals((Object)"DRIVER", (Object)cli.driver);
        Assert.assertEquals((Object)"USERNAME", (Object)cli.username);
        Assert.assertEquals((Object)"PASSWORD", (Object)cli.password);
        Assert.assertEquals((Object)"URL", (Object)cli.url);
        Assert.assertEquals((Object)"FILE", (Object)cli.changeLogFile);
        Assert.assertEquals((Object)"CLASSPATH;CLASSPATH2", (Object)cli.classpath);
        Assert.assertEquals((Object)"CONTEXT1,CONTEXT2", (Object)cli.contexts);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)cli.promptForNonLocalDatabase);
        Assert.assertEquals((Object)"update", (Object)cli.command);
    }

    @Test
    public void falseBooleanParameters() throws Exception {
        String[] args = new String[]{"--promptForNonLocalDatabase=false", "update"};
        Main cli = new Main();
        cli.parseOptions(args);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)cli.promptForNonLocalDatabase);
        Assert.assertEquals((Object)"update", (Object)cli.command);
    }

    @Test
    public void convertMigrateToUpdate() throws Exception {
        String[] args = new String[]{"--promptForNonLocalDatabase=false", "migrate"};
        Main cli = new Main();
        cli.parseOptions(args);
        Assert.assertEquals((Object)"update", (Object)cli.command);
    }

    @Test
    public void trueBooleanParameters() throws Exception {
        String[] args = new String[]{"--promptForNonLocalDatabase=true", "update"};
        Main cli = new Main();
        cli.parseOptions(args);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)cli.promptForNonLocalDatabase);
        Assert.assertEquals((Object)"update", (Object)cli.command);
    }

    @Test(expected=CommandLineParsingException.class)
    public void parameterWithoutDash() throws Exception {
        String[] args = new String[]{"promptForNonLocalDatabase=true", "update"};
        Main cli = new Main();
        cli.parseOptions(args);
    }

    @Test(expected=CommandLineParsingException.class)
    public void unknownParameter() throws Exception {
        String[] args = new String[]{"--promptForNonLocalDatabase=true", "--badParam=here", "migrate"};
        Main cli = new Main();
        cli.parseOptions(args);
    }

    @Test(expected=CommandLineParsingException.class)
    public void configureNonExistantClassloaderLocation() throws Exception {
        Main cli = new Main();
        cli.classpath = "badClasspathLocation";
        cli.configureClassLoader();
    }

    @Test
    public void windowsConfigureClassLoaderLocation() throws Exception {
        Main cli = new Main();
        if (cli.isWindows()) {
            System.setProperty("os.name", "Windows XP");
            cli.classpath = "c:\\;c:\\windows\\";
            cli.applyDefaults();
            cli.configureClassLoader();
            URL[] classloaderURLs = ((URLClassLoader)cli.classLoader).getURLs();
            Assert.assertEquals((long)2L, (long)classloaderURLs.length);
            Assert.assertEquals((Object)"file:/c:/", (Object)classloaderURLs[0].toExternalForm());
            Assert.assertEquals((Object)"file:/c:/windows/", (Object)classloaderURLs[1].toExternalForm());
        }
    }

    @Test
    public void unixConfigureClassLoaderLocation() throws Exception {
        Main cli = new Main();
        if (!cli.isWindows()) {
            System.setProperty("os.name", "Linux");
            cli.classpath = "/tmp:/";
            cli.applyDefaults();
            cli.configureClassLoader();
            URL[] classloaderURLs = ((URLClassLoader)cli.classLoader).getURLs();
            Assert.assertEquals((long)2L, (long)classloaderURLs.length);
            Assert.assertEquals((Object)"file:/tmp/", (Object)classloaderURLs[0].toExternalForm());
            Assert.assertEquals((Object)"file:/", (Object)classloaderURLs[1].toExternalForm());
        }
    }

    @Test
    public void propertiesFileWithNoOtherArgs() throws Exception {
        Main cli = new Main();
        Properties props = new Properties();
        props.setProperty("driver", "DRIVER");
        props.setProperty("username", "USERNAME");
        props.setProperty("password", "PASSWD");
        props.setProperty("url", "URL");
        props.setProperty("changeLogFile", "FILE");
        props.setProperty("classpath", "CLASSPAHT");
        props.setProperty("contexts", "CONTEXTS");
        props.setProperty("promptForNonLocalDatabase", "TRUE");
        ByteArrayOutputStream propFile = new ByteArrayOutputStream();
        props.store(propFile, "");
        cli.parsePropertiesFile((InputStream)new ByteArrayInputStream(propFile.toByteArray()));
        Assert.assertEquals((Object)"DRIVER", (Object)cli.driver);
        Assert.assertEquals((Object)"USERNAME", (Object)cli.username);
        Assert.assertEquals((Object)"PASSWD", (Object)cli.password);
        Assert.assertEquals((Object)"URL", (Object)cli.url);
        Assert.assertEquals((Object)"FILE", (Object)cli.changeLogFile);
        Assert.assertEquals((Object)"CLASSPAHT", (Object)cli.classpath);
        Assert.assertEquals((Object)"CONTEXTS", (Object)cli.contexts);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)cli.promptForNonLocalDatabase);
    }

    @Test
    public void propertiesFileWithOtherArgs() throws Exception {
        Main cli = new Main();
        cli.username = "PASSED USERNAME";
        cli.password = "PASSED PASSWD";
        Properties props = new Properties();
        props.setProperty("driver", "DRIVER");
        props.setProperty("username", "USERNAME");
        props.setProperty("password", "PASSWD");
        props.setProperty("url", "URL");
        props.setProperty("changeLogFile", "FILE");
        props.setProperty("classpath", "CLASSPAHT");
        props.setProperty("contexts", "CONTEXTS");
        props.setProperty("promptForNonLocalDatabase", "TRUE");
        ByteArrayOutputStream propFile = new ByteArrayOutputStream();
        props.store(propFile, "");
        cli.parsePropertiesFile((InputStream)new ByteArrayInputStream(propFile.toByteArray()));
        Assert.assertEquals((Object)"DRIVER", (Object)cli.driver);
        Assert.assertEquals((Object)"PASSED USERNAME", (Object)cli.username);
        Assert.assertEquals((Object)"PASSED PASSWD", (Object)cli.password);
        Assert.assertEquals((Object)"URL", (Object)cli.url);
        Assert.assertEquals((Object)"FILE", (Object)cli.changeLogFile);
        Assert.assertEquals((Object)"CLASSPAHT", (Object)cli.classpath);
        Assert.assertEquals((Object)"CONTEXTS", (Object)cli.contexts);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)cli.promptForNonLocalDatabase);
    }

    @Test
    public void applyDefaults() {
        Main cli = new Main();
        cli.promptForNonLocalDatabase = Boolean.TRUE;
        cli.applyDefaults();
        Assert.assertEquals((Object)Boolean.TRUE, (Object)cli.promptForNonLocalDatabase);
        cli.promptForNonLocalDatabase = Boolean.FALSE;
        cli.applyDefaults();
        Assert.assertEquals((Object)Boolean.FALSE, (Object)cli.promptForNonLocalDatabase);
        cli.promptForNonLocalDatabase = null;
        cli.applyDefaults();
        Assert.assertEquals((Object)Boolean.FALSE, (Object)cli.promptForNonLocalDatabase);
    }

    @Test(expected=CommandLineParsingException.class)
    public void propertiesFileWithBadArgs() throws Exception {
        Main cli = new Main();
        Properties props = new Properties();
        props.setProperty("driver", "DRIVER");
        props.setProperty("username", "USERNAME");
        props.setProperty("badArg", "ARG");
        ByteArrayOutputStream propFile = new ByteArrayOutputStream();
        props.store(propFile, "");
        cli.parsePropertiesFile((InputStream)new ByteArrayInputStream(propFile.toByteArray()));
    }

    @Test
    public void checkSetup() {
        String[] cmdParms;
        int i;
        int i2;
        Main cli = new Main();
        Assert.assertTrue((cli.checkSetup().size() > 0 ? 1 : 0) != 0);
        cli.driver = "driver";
        cli.username = "username";
        cli.password = "pwd";
        cli.url = "url";
        cli.changeLogFile = "file";
        cli.classpath = "classpath";
        Assert.assertTrue((cli.checkSetup().size() > 0 ? 1 : 0) != 0);
        cli.command = "BadCommand";
        Assert.assertTrue((cli.checkSetup().size() > 0 ? 1 : 0) != 0);
        cli.command = "migrate";
        Assert.assertEquals((long)0L, (long)cli.checkSetup().size());
        String[] noArgCommand = new String[]{"migrate", "migrateSQL", "update", "updateSQL", "futureRollbackSQL", "updateTestingRollback", "listLocks", "dropAll", "releaseLocks", "validate", "help", "generateChangeLog", "clearCheckSums", "changelogSync", "changelogSyncSQL", "markNextChangeSetRan", "markNextChangeSetRanSQL"};
        cli.commandParams.clear();
        cli.commandParams.add("--logLevel=debug");
        for (i2 = 0; i2 < noArgCommand.length; ++i2) {
            cli.command = noArgCommand[i2];
            Assert.assertEquals((long)1L, (long)cli.checkSetup().size());
        }
        cli.command = "update";
        cli.commandParams.clear();
        cli.changeLogParameters.clear();
        cli.changeLogParameters.put("engine", "myisam");
        Assert.assertEquals((long)0L, (long)cli.checkSetup().size());
        cli.commandParams.clear();
        for (i2 = 0; i2 < noArgCommand.length; ++i2) {
            cli.command = noArgCommand[i2];
            Assert.assertEquals((long)0L, (long)cli.checkSetup().size());
        }
        String[] singleArgCommand = new String[]{"updateCount", "updateCountSQL", "rollback", "rollbackToDate", "rollbackCount", "rollbackSQL", "rollbackToDateSQL", "rollbackCountSQL", "tag", "dbDoc"};
        cli.commandParams.add("--logLevel=debug");
        for (i = 0; i < singleArgCommand.length; ++i) {
            cli.command = singleArgCommand[i];
            Assert.assertEquals((long)1L, (long)cli.checkSetup().size());
        }
        cli.commandParams.clear();
        cli.commandParams.add("someCommandValue");
        for (i = 0; i < singleArgCommand.length; ++i) {
            cli.command = singleArgCommand[i];
            Assert.assertEquals((long)0L, (long)cli.checkSetup().size());
        }
        cli.command = "status";
        cli.commandParams.clear();
        Assert.assertEquals((long)0L, (long)cli.checkSetup().size());
        cli.commandParams.add("--verbose");
        Assert.assertEquals((long)0L, (long)cli.checkSetup().size());
        cli.commandParams.clear();
        cli.commandParams.add("--logLevel=debug");
        Assert.assertEquals((long)1L, (long)cli.checkSetup().size());
        String[] multiArgCommand = new String[]{"diff", "diffChangeLog"};
        cli.commandParams.clear();
        for (int i3 = 0; i3 < multiArgCommand.length; ++i3) {
            cli.command = multiArgCommand[i3];
            Assert.assertEquals((long)0L, (long)cli.checkSetup().size());
        }
        for (String param : cmdParms = new String[]{"--referenceUsername=USERNAME", "--referencePassword=PASSWORD", "--referenceUrl=URL", "--referenceDriver=DRIVER"}) {
            cli.commandParams.add(param);
        }
        Assert.assertEquals((long)0L, (long)cli.checkSetup().size());
        cli.commandParams.add("--logLevel=debug");
        Assert.assertEquals((long)1L, (long)cli.checkSetup().size());
    }

    @Test
    public void printHelp() throws Exception {
        String line;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Main cli = new Main();
        cli.printHelp(new PrintStream(stream));
        BufferedReader reader = new BufferedReader(new StringReader(new String(stream.toByteArray())));
        while ((line = reader.readLine()) != null) {
            if (line.length() <= 80) continue;
            Assert.fail((String)("'" + line + "' is longer than 80 chars"));
        }
    }

    @Test
    public void tag() throws Exception {
        String[] args = new String[]{"--driver=DRIVER", "--username=USERNAME", "--password=PASSWORD", "--url=URL", "--changeLogFile=FILE", "--classpath=CLASSPATH;CLASSPATH2", "--contexts=CONTEXT1,CONTEXT2", "tag", "TagHere"};
        Main cli = new Main();
        cli.parseOptions(args);
        Assert.assertEquals((Object)"DRIVER", (Object)cli.driver);
        Assert.assertEquals((Object)"USERNAME", (Object)cli.username);
        Assert.assertEquals((Object)"PASSWORD", (Object)cli.password);
        Assert.assertEquals((Object)"URL", (Object)cli.url);
        Assert.assertEquals((Object)"FILE", (Object)cli.changeLogFile);
        Assert.assertEquals((Object)"CLASSPATH;CLASSPATH2", (Object)cli.classpath);
        Assert.assertEquals((Object)"CONTEXT1,CONTEXT2", (Object)cli.contexts);
        Assert.assertEquals((Object)"tag", (Object)cli.command);
        Assert.assertEquals((Object)"TagHere", cli.commandParams.iterator().next());
    }

    @Test
    public void migrateWithEqualsInParams() throws Exception {
        String url = "dbc:sqlserver://127.0.0.1;DatabaseName=dev_nn;user=ffdatabase;password=p!88worD";
        String[] args = new String[]{"--url=" + url, "migrate"};
        Main cli = new Main();
        cli.parseOptions(args);
        Assert.assertEquals((Object)url, (Object)cli.url);
    }

    @Test
    public void fixArgs() {
        Main liquibase = new Main();
        String[] fixedArgs = liquibase.fixupArgs(new String[]{"--defaultsFile", "liquibase.properties", "migrate"});
        Assert.assertEquals((Object)"--defaultsFile=liquibase.properties migrate", (Object)StringUtils.join(Arrays.asList(fixedArgs), (String)" "));
        fixedArgs = liquibase.fixupArgs(new String[]{"--defaultsFile=liquibase.properties", "migrate"});
        Assert.assertEquals((Object)"--defaultsFile=liquibase.properties migrate", (Object)StringUtils.join(Arrays.asList(fixedArgs), (String)" "));
        fixedArgs = liquibase.fixupArgs(new String[]{"--driver=DRIVER", "--username=USERNAME", "--password=PASSWORD", "--url=URL", "--changeLogFile=FILE", "--classpath=CLASSPATH;CLASSPATH2", "--contexts=CONTEXT1,CONTEXT2", "--promptForNonLocalDatabase=true", "migrate"});
        Assert.assertEquals((Object)"--driver=DRIVER --username=USERNAME --password=PASSWORD --url=URL --changeLogFile=FILE --classpath=CLASSPATH;CLASSPATH2 --contexts=CONTEXT1,CONTEXT2 --promptForNonLocalDatabase=true migrate", (Object)StringUtils.join(Arrays.asList(fixedArgs), (String)" "));
    }

    @Test
    public void testVersionArg() throws IOException, CommandLineParsingException {
        Main.main((String[])new String[]{"--version"});
    }

    @Test
    public void testSplitArgWithValueEndingByEqualSing() throws CommandLineParsingException {
        String argName = "password";
        String argValue = "s3-cr3t=";
        Main tested = new Main();
        tested.parseOptions(new String[]{"--password=s3-cr3t="});
        Assert.assertEquals((Object)"s3-cr3t=", (Object)tested.password);
    }
}

