/*
 * Decompiled with CFR 0.152.
 */
package liquibase.lockservice;

import java.lang.reflect.Field;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import liquibase.database.Database;
import liquibase.database.core.MySQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.exception.LockException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.lockservice.DatabaseChangeLogLock;
import liquibase.lockservice.LockService;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.LockDatabaseChangeLogStatement;
import liquibase.statement.core.SelectFromDatabaseChangeLogLockStatement;
import liquibase.statement.core.UnlockDatabaseChangeLogStatement;
import org.easymock.classextension.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LockServiceTest {
    @Before
    public void before() {
        LockService.resetAll();
    }

    @After
    public void after() {
        LockService.resetAll();
    }

    @Test
    public void getInstance() {
        OracleDatabase oracle1 = new OracleDatabase(){

            public boolean equals(Object o) {
                return o == this;
            }
        };
        OracleDatabase oracle2 = new OracleDatabase(){

            public boolean equals(Object o) {
                return o == this;
            }
        };
        MySQLDatabase mysql = new MySQLDatabase(){

            public boolean equals(Object o) {
                return o == this;
            }
        };
        Assert.assertNotNull((Object)LockService.getInstance((Database)oracle1));
        Assert.assertNotNull((Object)LockService.getInstance((Database)oracle2));
        Assert.assertNotNull((Object)LockService.getInstance((Database)mysql));
        Assert.assertTrue((LockService.getInstance((Database)oracle1) == LockService.getInstance((Database)oracle1) ? 1 : 0) != 0);
        Assert.assertTrue((LockService.getInstance((Database)oracle2) == LockService.getInstance((Database)oracle2) ? 1 : 0) != 0);
        Assert.assertTrue((LockService.getInstance((Database)mysql) == LockService.getInstance((Database)mysql) ? 1 : 0) != 0);
        Assert.assertTrue((LockService.getInstance((Database)oracle1) != LockService.getInstance((Database)oracle2) ? 1 : 0) != 0);
        Assert.assertTrue((LockService.getInstance((Database)oracle1) != LockService.getInstance((Database)mysql) ? 1 : 0) != 0);
    }

    @Test
    public void aquireLock_hasLockAlready() throws Exception {
        Database database = (Database)EasyMock.createMock(Database.class);
        EasyMock.replay((Object)database);
        LockService lockService = LockService.getInstance((Database)database);
        Assert.assertFalse((boolean)lockService.hasChangeLogLock());
        Field field = lockService.getClass().getDeclaredField("hasChangeLogLock");
        field.setAccessible(true);
        field.set(lockService, true);
        Assert.assertTrue((boolean)lockService.hasChangeLogLock());
        Assert.assertTrue((boolean)lockService.acquireLock());
    }

    @Test
    public void acquireLock_tableExistsNotLocked() throws Exception {
        Database database = (Database)EasyMock.createMock(Database.class);
        Executor executor = (Executor)EasyMock.createMock(Executor.class);
        database.checkDatabaseChangeLogLockTable();
        org.easymock.EasyMock.expectLastCall();
        database.rollback();
        org.easymock.EasyMock.expectLastCall().anyTimes();
        database.setCanCacheLiquibaseTableInfo(true);
        org.easymock.EasyMock.expectLastCall();
        org.easymock.EasyMock.expect((Object)executor.queryForObject((SqlStatement)org.easymock.EasyMock.isA(SelectFromDatabaseChangeLogLockStatement.class), (Class)org.easymock.EasyMock.eq(Boolean.class))).andReturn((Object)false);
        executor.comment("Lock Database");
        org.easymock.EasyMock.expectLastCall();
        org.easymock.EasyMock.expect((Object)executor.update((SqlStatement)org.easymock.EasyMock.isA(LockDatabaseChangeLogStatement.class))).andReturn((Object)1);
        database.commit();
        org.easymock.EasyMock.expectLastCall();
        EasyMock.replay((Object)executor);
        EasyMock.replay((Object)database);
        ExecutorService.getInstance().setExecutor(database, executor);
        LockService service = LockService.getInstance((Database)database);
        Assert.assertTrue((boolean)service.acquireLock());
        EasyMock.verify((Object)database);
        EasyMock.verify((Object)executor);
    }

    @Test
    public void acquireLock_tableExistsIsLocked() throws Exception {
        Database database = (Database)EasyMock.createMock(Database.class);
        Executor executor = (Executor)EasyMock.createMock(Executor.class);
        database.checkDatabaseChangeLogLockTable();
        org.easymock.EasyMock.expectLastCall();
        database.rollback();
        org.easymock.EasyMock.expectLastCall().anyTimes();
        org.easymock.EasyMock.expect((Object)executor.queryForObject((SqlStatement)org.easymock.EasyMock.isA(SelectFromDatabaseChangeLogLockStatement.class), (Class)org.easymock.EasyMock.eq(Boolean.class))).andReturn((Object)true);
        EasyMock.replay((Object)database);
        EasyMock.replay((Object)executor);
        ExecutorService.getInstance().setExecutor(database, executor);
        LockService service = LockService.getInstance((Database)database);
        Assert.assertFalse((boolean)service.acquireLock());
        EasyMock.verify((Object)database);
    }

    @Test
    public void waitForLock_notLocked() throws Exception {
        Database database = (Database)EasyMock.createMock(Database.class);
        Executor executor = (Executor)EasyMock.createMock(Executor.class);
        database.checkDatabaseChangeLogLockTable();
        org.easymock.EasyMock.expectLastCall();
        database.setCanCacheLiquibaseTableInfo(true);
        org.easymock.EasyMock.expectLastCall();
        database.rollback();
        org.easymock.EasyMock.expectLastCall().anyTimes();
        org.easymock.EasyMock.expect((Object)executor.queryForObject((SqlStatement)org.easymock.EasyMock.isA(SelectFromDatabaseChangeLogLockStatement.class), (Class)org.easymock.EasyMock.eq(Boolean.class))).andReturn((Object)false);
        executor.comment("Lock Database");
        org.easymock.EasyMock.expectLastCall();
        org.easymock.EasyMock.expect((Object)executor.update((SqlStatement)org.easymock.EasyMock.isA(LockDatabaseChangeLogStatement.class))).andReturn((Object)1);
        database.commit();
        org.easymock.EasyMock.expectLastCall();
        EasyMock.replay((Object)database);
        EasyMock.replay((Object)executor);
        ExecutorService.getInstance().setExecutor(database, executor);
        LockService service = LockService.getInstance((Database)database);
        service.waitForLock();
        EasyMock.verify((Object)database);
        EasyMock.verify((Object)executor);
    }

    @Test
    public void waitForLock_lockedThenReleased() throws Exception {
        Database database = (Database)EasyMock.createMock(Database.class);
        Executor executor = (Executor)EasyMock.createMock(Executor.class);
        database.checkDatabaseChangeLogLockTable();
        org.easymock.EasyMock.expectLastCall().anyTimes();
        database.setCanCacheLiquibaseTableInfo(true);
        org.easymock.EasyMock.expectLastCall();
        org.easymock.EasyMock.expect((Object)executor.queryForObject((SqlStatement)org.easymock.EasyMock.isA(SelectFromDatabaseChangeLogLockStatement.class), (Class)org.easymock.EasyMock.eq(Boolean.class))).andReturn((Object)true);
        org.easymock.EasyMock.expect((Object)executor.queryForObject((SqlStatement)org.easymock.EasyMock.isA(SelectFromDatabaseChangeLogLockStatement.class), (Class)org.easymock.EasyMock.eq(Boolean.class))).andReturn((Object)true);
        org.easymock.EasyMock.expect((Object)executor.queryForObject((SqlStatement)org.easymock.EasyMock.isA(SelectFromDatabaseChangeLogLockStatement.class), (Class)org.easymock.EasyMock.eq(Boolean.class))).andReturn((Object)true);
        org.easymock.EasyMock.expect((Object)executor.queryForObject((SqlStatement)org.easymock.EasyMock.isA(SelectFromDatabaseChangeLogLockStatement.class), (Class)org.easymock.EasyMock.eq(Boolean.class))).andReturn((Object)false);
        executor.comment("Lock Database");
        org.easymock.EasyMock.expectLastCall();
        database.rollback();
        org.easymock.EasyMock.expectLastCall().anyTimes();
        org.easymock.EasyMock.expect((Object)executor.update((SqlStatement)org.easymock.EasyMock.isA(LockDatabaseChangeLogStatement.class))).andReturn((Object)1);
        database.commit();
        org.easymock.EasyMock.expectLastCall();
        EasyMock.replay((Object)database);
        EasyMock.replay((Object)executor);
        ExecutorService.getInstance().setExecutor(database, executor);
        LockService service = LockService.getInstance((Database)database);
        service.setChangeLogLockRecheckTime(1L);
        service.waitForLock();
        EasyMock.verify((Object)database);
        EasyMock.verify((Object)executor);
    }

    @Test
    public void waitForLock_lockedThenTimeout() throws Exception {
        Database database = (Database)EasyMock.createMock(Database.class);
        Executor executor = (Executor)EasyMock.createMock(Executor.class);
        database.checkDatabaseChangeLogLockTable();
        org.easymock.EasyMock.expectLastCall().anyTimes();
        org.easymock.EasyMock.expect((Object)executor.queryForObject((SqlStatement)org.easymock.EasyMock.isA(SelectFromDatabaseChangeLogLockStatement.class), (Class)org.easymock.EasyMock.eq(Boolean.class))).andReturn((Object)true).anyTimes();
        org.easymock.EasyMock.expect((Object)database.hasDatabaseChangeLogLockTable()).andReturn((Object)true);
        ArrayList resultList = new ArrayList();
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("ID", 1);
        result.put("LOCKED", true);
        Date lockDate = new Date();
        result.put("LOCKGRANTED", lockDate);
        result.put("LOCKEDBY", "Locker");
        resultList.add(result);
        org.easymock.EasyMock.expect((Object)executor.queryForList((SqlStatement)org.easymock.EasyMock.isA(SelectFromDatabaseChangeLogLockStatement.class))).andReturn(resultList);
        database.rollback();
        org.easymock.EasyMock.expectLastCall().anyTimes();
        EasyMock.replay((Object)database);
        EasyMock.replay((Object)executor);
        ExecutorService.getInstance().setExecutor(database, executor);
        LockService service = LockService.getInstance((Database)database);
        service.setChangeLogLockWaitTime(10L);
        service.setChangeLogLockRecheckTime(5L);
        try {
            service.waitForLock();
            Assert.fail((String)"Should have thrown exception");
        }
        catch (LockException e) {
            Assert.assertEquals((Object)("Could not acquire change log lock.  Currently locked by Locker since " + DateFormat.getDateTimeInstance(3, 3).format(lockDate)), (Object)e.getMessage());
        }
        EasyMock.verify((Object)database);
    }

    @Test
    public void releaseLock_tableExistsAndLocked() throws Exception {
        Database database = (Database)EasyMock.createMock(Database.class);
        Executor executor = (Executor)EasyMock.createMock(Executor.class);
        org.easymock.EasyMock.expect((Object)executor.update((SqlStatement)org.easymock.EasyMock.isA(UnlockDatabaseChangeLogStatement.class))).andReturn((Object)1);
        org.easymock.EasyMock.expect((Object)database.hasDatabaseChangeLogLockTable()).andReturn((Object)true);
        database.commit();
        org.easymock.EasyMock.expectLastCall().atLeastOnce();
        database.setCanCacheLiquibaseTableInfo(false);
        org.easymock.EasyMock.expectLastCall();
        executor.comment("Release Database Lock");
        org.easymock.EasyMock.expectLastCall().anyTimes();
        database.rollback();
        org.easymock.EasyMock.expectLastCall().anyTimes();
        EasyMock.replay((Object)database);
        EasyMock.replay((Object)executor);
        ExecutorService.getInstance().setExecutor(database, executor);
        LockService service = LockService.getInstance((Database)database);
        service.releaseLock();
        EasyMock.verify((Object)database);
    }

    @Test
    public void listLocks_hasLocks() throws Exception {
        Database database = (Database)EasyMock.createMock(Database.class);
        Executor executor = (Executor)EasyMock.createMock(Executor.class);
        database.checkDatabaseChangeLogLockTable();
        org.easymock.EasyMock.expectLastCall().anyTimes();
        org.easymock.EasyMock.expect((Object)executor.queryForObject((SqlStatement)org.easymock.EasyMock.isA(SelectFromDatabaseChangeLogLockStatement.class), (Class)org.easymock.EasyMock.eq(Boolean.class))).andReturn((Object)true).anyTimes();
        org.easymock.EasyMock.expect((Object)database.hasDatabaseChangeLogLockTable()).andReturn((Object)true);
        ArrayList resultList = new ArrayList();
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("ID", 1);
        result.put("LOCKED", true);
        Date lockDate = new Date();
        result.put("LOCKGRANTED", lockDate);
        result.put("LOCKEDBY", "Locker");
        resultList.add(result);
        org.easymock.EasyMock.expect((Object)executor.queryForList((SqlStatement)org.easymock.EasyMock.isA(SelectFromDatabaseChangeLogLockStatement.class))).andReturn(resultList);
        EasyMock.replay((Object)database);
        EasyMock.replay((Object)executor);
        ExecutorService.getInstance().setExecutor(database, executor);
        LockService service = LockService.getInstance((Database)database);
        DatabaseChangeLogLock[] locks = service.listLocks();
        Assert.assertEquals((long)1L, (long)locks.length);
        Assert.assertEquals((long)1L, (long)locks[0].getId());
        Assert.assertEquals((Object)"Locker", (Object)locks[0].getLockedBy());
        Assert.assertEquals((Object)lockDate, (Object)locks[0].getLockGranted());
        EasyMock.verify((Object)database);
    }

    @Test
    public void listLocks_tableExistsUnlocked() throws Exception {
        Database database = (Database)EasyMock.createMock(Database.class);
        Executor executor = (Executor)EasyMock.createMock(Executor.class);
        database.checkDatabaseChangeLogLockTable();
        org.easymock.EasyMock.expectLastCall().anyTimes();
        org.easymock.EasyMock.expect((Object)executor.queryForObject((SqlStatement)org.easymock.EasyMock.isA(SelectFromDatabaseChangeLogLockStatement.class), (Class)org.easymock.EasyMock.eq(Boolean.class))).andReturn((Object)true).anyTimes();
        org.easymock.EasyMock.expect((Object)database.hasDatabaseChangeLogLockTable()).andReturn((Object)true);
        ArrayList resultList = new ArrayList();
        org.easymock.EasyMock.expect((Object)executor.queryForList((SqlStatement)org.easymock.EasyMock.isA(SelectFromDatabaseChangeLogLockStatement.class))).andReturn(resultList);
        EasyMock.replay((Object)database);
        EasyMock.replay((Object)executor);
        ExecutorService.getInstance().setExecutor(database, executor);
        LockService service = LockService.getInstance((Database)database);
        DatabaseChangeLogLock[] locks = service.listLocks();
        Assert.assertEquals((long)0L, (long)locks.length);
        EasyMock.verify((Object)database);
    }

    @Test
    public void listLocks_tableDoesNotExists() throws Exception {
        Database database = (Database)EasyMock.createMock(Database.class);
        org.easymock.EasyMock.expect((Object)database.hasDatabaseChangeLogLockTable()).andReturn((Object)false);
        EasyMock.replay((Object)database);
        LockService service = LockService.getInstance((Database)database);
        DatabaseChangeLogLock[] locks = service.listLocks();
        Assert.assertEquals((long)0L, (long)locks.length);
        EasyMock.verify((Object)database);
    }
}

