/*
 * Decompiled with CFR 0.152.
 */
package liquibase.parser;

import java.util.List;
import liquibase.parser.ChangeLogParser;
import liquibase.parser.ChangeLogParserFactory;
import liquibase.parser.MockChangeLogParser;
import liquibase.parser.core.sql.SqlChangeLogParser;
import liquibase.parser.core.xml.XMLChangeLogSAXParser;
import liquibase.resource.ResourceAccessor;
import liquibase.test.JUnitResourceAccessor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ChangeLogParserFactoryTest {
    @Before
    public void setup() {
        ChangeLogParserFactory.reset();
    }

    @Test
    public void getInstance() {
        Assert.assertNotNull((Object)ChangeLogParserFactory.getInstance());
        Assert.assertTrue((ChangeLogParserFactory.getInstance() == ChangeLogParserFactory.getInstance() ? 1 : 0) != 0);
    }

    @Test
    public void register() {
        ChangeLogParserFactory.getInstance().getParsers().clear();
        Assert.assertEquals((long)0L, (long)ChangeLogParserFactory.getInstance().getParsers().size());
        ChangeLogParserFactory.getInstance().register((ChangeLogParser)new MockChangeLogParser("mock"));
        Assert.assertEquals((long)1L, (long)ChangeLogParserFactory.getInstance().getParsers().size());
    }

    @Test
    public void unregister_instance() {
        ChangeLogParserFactory factory = ChangeLogParserFactory.getInstance();
        factory.getParsers().clear();
        Assert.assertEquals((long)0L, (long)factory.getParsers().size());
        XMLChangeLogSAXParser changeLogParser = new XMLChangeLogSAXParser();
        factory.register((ChangeLogParser)new SqlChangeLogParser());
        factory.register((ChangeLogParser)changeLogParser);
        Assert.assertEquals((long)2L, (long)factory.getParsers().size());
        factory.unregister((ChangeLogParser)changeLogParser);
        Assert.assertEquals((long)1L, (long)factory.getParsers().size());
    }

    @Test
    public void reset() {
        ChangeLogParserFactory instance1 = ChangeLogParserFactory.getInstance();
        ChangeLogParserFactory.reset();
        Assert.assertFalse((instance1 == ChangeLogParserFactory.getInstance() ? 1 : 0) != 0);
    }

    @Test
    public void builtInGeneratorsAreFound() {
        List generators = ChangeLogParserFactory.getInstance().getParsers();
        Assert.assertEquals((long)3L, (long)generators.size());
    }

    @Test
    public void getParsers() throws Exception {
        ChangeLogParser parser = ChangeLogParserFactory.getInstance().getParser("asdf.xml", (ResourceAccessor)new JUnitResourceAccessor());
        Assert.assertNotNull((Object)parser);
        Assert.assertTrue((boolean)(parser instanceof XMLChangeLogSAXParser));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void getExtensionParser() throws Exception {
        ChangeLogParserFactory parserFactory = ChangeLogParserFactory.getInstance();
        ChangeLogParser defaultParser = parserFactory.getParser("asdf.xml", (ResourceAccessor)new JUnitResourceAccessor());
        Assert.assertNotNull((Object)defaultParser);
        Assert.assertTrue((boolean)(defaultParser instanceof XMLChangeLogSAXParser));
        XMLChangeLogSAXParser otherXmlParser = new XMLChangeLogSAXParser(){

            public int getPriority() {
                return 100;
            }
        };
        parserFactory.register((ChangeLogParser)otherXmlParser);
        try {
            Assert.assertTrue((otherXmlParser == parserFactory.getParser("asdf.xml", (ResourceAccessor)new JUnitResourceAccessor()) ? 1 : 0) != 0);
            Assert.assertFalse((defaultParser == parserFactory.getParser("asdf.xml", (ResourceAccessor)new JUnitResourceAccessor()) ? 1 : 0) != 0);
        }
        finally {
            parserFactory.unregister((ChangeLogParser)otherXmlParser);
        }
    }
}

