/*
 * Decompiled with CFR 0.152.
 */
package liquibase.parser.core.formattedsql;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import liquibase.change.core.EmptyChange;
import liquibase.change.core.RawSQLChange;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.parser.core.formattedsql.FormattedSqlChangeLogParser;
import liquibase.resource.ResourceAccessor;
import liquibase.test.JUnitResourceAccessor;
import liquibase.util.StringUtils;
import org.junit.Assert;
import org.junit.Test;

public class FormattedSqlChangeLogParserTest {
    private static final String VALID_CHANGELOG = "--liquibase formatted sql\n\n--changeset nvoxland:1\nselect * from table1;\n\n--changeset nvoxland:2 (stripComments:false splitStatements:false endDelimiter:X runOnChange:true runAlways:true context:y dbms:mysql runInTransaction:false failOnError:false)\ncreate table table1 (\n  id int primary key\n);\n\n--rollback delete from table1;\n--rollback drop table table1;\n\n--ChangeSet nvoxland:3\ncreate table table2 (\n  id int primary key\n);\ncreate table table3 (\n  id int primary key\n);\n--rollback drop table table2;\n--ChangeSet alwyn:4\nselect (*) from table2;\n--rollback not required\n--ChangeSet nvoxland:5\nselect (*) from table2;\n--rollback not required\n--ChangeSet paikens:6\ncreate table ${tablename} (\n  id int primary key\n);\n--rollback drop table ${tablename};\n-- changeset mysql:1\ncreate table mysql_boo (\n  id int primary key\n);\n-- rollback drop table mysql_boo;\n";
    private static final String INVALID_CHANGELOG = "select * from table1";

    @Test
    public void supports() throws Exception {
        Assert.assertTrue((boolean)new MockFormattedSqlChangeLogParser(VALID_CHANGELOG).supports("asdf.sql", new JUnitResourceAccessor()));
        Assert.assertFalse((boolean)new MockFormattedSqlChangeLogParser(INVALID_CHANGELOG).supports("asdf.sql", new JUnitResourceAccessor()));
    }

    @Test
    public void parse() throws Exception {
        ChangeLogParameters params = new ChangeLogParameters();
        params.set("tablename", (Object)"table4");
        DatabaseChangeLog changeLog = new MockFormattedSqlChangeLogParser(VALID_CHANGELOG).parse("asdf.sql", params, new JUnitResourceAccessor());
        Assert.assertEquals((Object)"asdf.sql", (Object)changeLog.getLogicalFilePath());
        Assert.assertEquals((long)7L, (long)changeLog.getChangeSets().size());
        Assert.assertEquals((Object)"nvoxland", (Object)((ChangeSet)changeLog.getChangeSets().get(0)).getAuthor());
        Assert.assertEquals((Object)"1", (Object)((ChangeSet)changeLog.getChangeSets().get(0)).getId());
        Assert.assertEquals((long)1L, (long)((ChangeSet)changeLog.getChangeSets().get(0)).getChanges().size());
        Assert.assertEquals((Object)"select * from table1;", (Object)((RawSQLChange)((ChangeSet)changeLog.getChangeSets().get(0)).getChanges().get(0)).getSql());
        Assert.assertNull((Object)((RawSQLChange)((ChangeSet)changeLog.getChangeSets().get(0)).getChanges().get(0)).getEndDelimiter());
        Assert.assertTrue((boolean)((RawSQLChange)((ChangeSet)changeLog.getChangeSets().get(0)).getChanges().get(0)).isSplittingStatements());
        Assert.assertTrue((boolean)((RawSQLChange)((ChangeSet)changeLog.getChangeSets().get(0)).getChanges().get(0)).isStrippingComments());
        Assert.assertFalse((boolean)((ChangeSet)changeLog.getChangeSets().get(0)).isAlwaysRun());
        Assert.assertFalse((boolean)((ChangeSet)changeLog.getChangeSets().get(0)).isRunOnChange());
        Assert.assertTrue((boolean)((ChangeSet)changeLog.getChangeSets().get(0)).isRunInTransaction());
        Assert.assertNull((Object)((ChangeSet)changeLog.getChangeSets().get(0)).getContexts());
        Assert.assertNull((Object)((ChangeSet)changeLog.getChangeSets().get(0)).getDbmsSet());
        Assert.assertEquals((Object)"nvoxland", (Object)((ChangeSet)changeLog.getChangeSets().get(1)).getAuthor());
        Assert.assertEquals((Object)"2", (Object)((ChangeSet)changeLog.getChangeSets().get(1)).getId());
        Assert.assertEquals((long)1L, (long)((ChangeSet)changeLog.getChangeSets().get(1)).getChanges().size());
        Assert.assertEquals((Object)"create table table1 (\n  id int primary key\n);", (Object)((RawSQLChange)((ChangeSet)changeLog.getChangeSets().get(1)).getChanges().get(0)).getSql());
        Assert.assertEquals((Object)"X", (Object)((RawSQLChange)((ChangeSet)changeLog.getChangeSets().get(1)).getChanges().get(0)).getEndDelimiter());
        Assert.assertFalse((boolean)((RawSQLChange)((ChangeSet)changeLog.getChangeSets().get(1)).getChanges().get(0)).isSplittingStatements());
        Assert.assertFalse((boolean)((RawSQLChange)((ChangeSet)changeLog.getChangeSets().get(1)).getChanges().get(0)).isStrippingComments());
        Assert.assertEquals((Object)"X", (Object)((RawSQLChange)((ChangeSet)changeLog.getChangeSets().get(1)).getChanges().get(0)).getEndDelimiter());
        Assert.assertFalse((boolean)((RawSQLChange)((ChangeSet)changeLog.getChangeSets().get(1)).getChanges().get(0)).isSplittingStatements());
        Assert.assertFalse((boolean)((RawSQLChange)((ChangeSet)changeLog.getChangeSets().get(1)).getChanges().get(0)).isStrippingComments());
        Assert.assertTrue((boolean)((ChangeSet)changeLog.getChangeSets().get(1)).isAlwaysRun());
        Assert.assertTrue((boolean)((ChangeSet)changeLog.getChangeSets().get(1)).isRunOnChange());
        Assert.assertFalse((boolean)((ChangeSet)changeLog.getChangeSets().get(1)).isRunInTransaction());
        Assert.assertEquals((Object)"y", (Object)StringUtils.join((Collection)((ChangeSet)changeLog.getChangeSets().get(1)).getContexts(), (String)","));
        Assert.assertEquals((Object)"mysql", (Object)StringUtils.join((Collection)((ChangeSet)changeLog.getChangeSets().get(1)).getDbmsSet(), (String)","));
        Assert.assertEquals((long)1L, (long)((ChangeSet)changeLog.getChangeSets().get(1)).getRollBackChanges().length);
        Assert.assertEquals((Object)"delete from table1;\ndrop table table1;", (Object)((RawSQLChange)((ChangeSet)changeLog.getChangeSets().get(1)).getRollBackChanges()[0]).getSql());
        Assert.assertEquals((Object)"nvoxland", (Object)((ChangeSet)changeLog.getChangeSets().get(2)).getAuthor());
        Assert.assertEquals((Object)"3", (Object)((ChangeSet)changeLog.getChangeSets().get(2)).getId());
        Assert.assertEquals((long)1L, (long)((ChangeSet)changeLog.getChangeSets().get(2)).getChanges().size());
        Assert.assertEquals((Object)"create table table2 (\n  id int primary key\n);\ncreate table table3 (\n  id int primary key\n);", (Object)((RawSQLChange)((ChangeSet)changeLog.getChangeSets().get(2)).getChanges().get(0)).getSql());
        Assert.assertNull((Object)((RawSQLChange)((ChangeSet)changeLog.getChangeSets().get(2)).getChanges().get(0)).getEndDelimiter());
        Assert.assertTrue((boolean)((RawSQLChange)((ChangeSet)changeLog.getChangeSets().get(2)).getChanges().get(0)).isSplittingStatements());
        Assert.assertTrue((boolean)((RawSQLChange)((ChangeSet)changeLog.getChangeSets().get(2)).getChanges().get(0)).isStrippingComments());
        Assert.assertEquals((long)1L, (long)((ChangeSet)changeLog.getChangeSets().get(2)).getRollBackChanges().length);
        Assert.assertTrue((boolean)(((ChangeSet)changeLog.getChangeSets().get(2)).getRollBackChanges()[0] instanceof RawSQLChange));
        Assert.assertEquals((Object)"drop table table2;", (Object)((RawSQLChange)((ChangeSet)changeLog.getChangeSets().get(2)).getRollBackChanges()[0]).getSql());
        Assert.assertEquals((Object)"alwyn", (Object)((ChangeSet)changeLog.getChangeSets().get(3)).getAuthor());
        Assert.assertEquals((Object)"4", (Object)((ChangeSet)changeLog.getChangeSets().get(3)).getId());
        Assert.assertEquals((long)1L, (long)((ChangeSet)changeLog.getChangeSets().get(3)).getRollBackChanges().length);
        Assert.assertTrue((boolean)(((ChangeSet)changeLog.getChangeSets().get(3)).getRollBackChanges()[0] instanceof EmptyChange));
        Assert.assertEquals((Object)"nvoxland", (Object)((ChangeSet)changeLog.getChangeSets().get(4)).getAuthor());
        Assert.assertEquals((Object)"5", (Object)((ChangeSet)changeLog.getChangeSets().get(4)).getId());
        Assert.assertEquals((long)1L, (long)((ChangeSet)changeLog.getChangeSets().get(4)).getRollBackChanges().length);
        Assert.assertTrue((boolean)(((ChangeSet)changeLog.getChangeSets().get(4)).getRollBackChanges()[0] instanceof EmptyChange));
        Assert.assertEquals((Object)"paikens", (Object)((ChangeSet)changeLog.getChangeSets().get(5)).getAuthor());
        Assert.assertEquals((Object)"6", (Object)((ChangeSet)changeLog.getChangeSets().get(5)).getId());
        Assert.assertEquals((long)1L, (long)((ChangeSet)changeLog.getChangeSets().get(5)).getChanges().size());
        Assert.assertTrue((boolean)(((ChangeSet)changeLog.getChangeSets().get(5)).getChanges().get(0) instanceof RawSQLChange));
        Assert.assertEquals((Object)"create table table4 (\n  id int primary key\n);", (Object)((RawSQLChange)((ChangeSet)changeLog.getChangeSets().get(5)).getChanges().get(0)).getSql());
        Assert.assertEquals((long)1L, (long)((ChangeSet)changeLog.getChangeSets().get(5)).getRollBackChanges().length);
        Assert.assertTrue((boolean)(((ChangeSet)changeLog.getChangeSets().get(5)).getRollBackChanges()[0] instanceof RawSQLChange));
        Assert.assertEquals((Object)"drop table table4;", (Object)((RawSQLChange)((ChangeSet)changeLog.getChangeSets().get(5)).getRollBackChanges()[0]).getSql());
        Assert.assertEquals((Object)"mysql", (Object)((ChangeSet)changeLog.getChangeSets().get(6)).getAuthor());
        Assert.assertEquals((Object)"1", (Object)((ChangeSet)changeLog.getChangeSets().get(6)).getId());
        Assert.assertEquals((long)1L, (long)((ChangeSet)changeLog.getChangeSets().get(6)).getChanges().size());
        Assert.assertTrue((boolean)(((ChangeSet)changeLog.getChangeSets().get(6)).getChanges().get(0) instanceof RawSQLChange));
        Assert.assertEquals((Object)"create table mysql_boo (\n  id int primary key\n);", (Object)((RawSQLChange)((ChangeSet)changeLog.getChangeSets().get(6)).getChanges().get(0)).getSql());
        Assert.assertEquals((long)1L, (long)((ChangeSet)changeLog.getChangeSets().get(6)).getRollBackChanges().length);
        Assert.assertTrue((boolean)(((ChangeSet)changeLog.getChangeSets().get(6)).getRollBackChanges()[0] instanceof RawSQLChange));
        Assert.assertEquals((Object)"drop table mysql_boo;", (Object)((RawSQLChange)((ChangeSet)changeLog.getChangeSets().get(6)).getRollBackChanges()[0]).getSql());
    }

    private static class MockFormattedSqlChangeLogParser
    extends FormattedSqlChangeLogParser {
        private String changeLog;

        public MockFormattedSqlChangeLogParser(String changeLog) {
            this.changeLog = changeLog;
        }

        protected InputStream openChangeLogFile(String physicalChangeLogLocation, ResourceAccessor resourceAccessor) throws IOException {
            return new ByteArrayInputStream(this.changeLog.getBytes());
        }
    }
}

