/*
 * Decompiled with CFR 0.152.
 */
package liquibase.parser.core.xml;

import liquibase.change.Change;
import liquibase.change.core.AddColumnChange;
import liquibase.change.core.CreateTableChange;
import liquibase.change.core.RawSQLChange;
import liquibase.change.custom.CustomChangeWrapper;
import liquibase.change.custom.ExampleCustomSqlChange;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.exception.ChangeLogParseException;
import liquibase.parser.core.xml.XMLChangeLogSAXParser;
import liquibase.precondition.Precondition;
import liquibase.precondition.core.OrPrecondition;
import liquibase.precondition.core.PreconditionContainer;
import liquibase.resource.ResourceAccessor;
import liquibase.test.JUnitResourceAccessor;
import org.junit.Assert;
import org.junit.Test;

public class XMLChangeLogSAXParserTest {
    @Test
    public void simpleChangeLog() throws Exception {
        DatabaseChangeLog changeLog = new XMLChangeLogSAXParser().parse("liquibase/parser/core/xml/simpleChangeLog.xml", new ChangeLogParameters(), (ResourceAccessor)new JUnitResourceAccessor());
        Assert.assertEquals((Object)"liquibase/parser/core/xml/simpleChangeLog.xml", (Object)changeLog.getLogicalFilePath());
        Assert.assertEquals((Object)"liquibase/parser/core/xml/simpleChangeLog.xml", (Object)changeLog.getPhysicalFilePath());
        Assert.assertEquals((long)0L, (long)changeLog.getPreconditions().getNestedPreconditions().size());
        Assert.assertEquals((long)1L, (long)changeLog.getChangeSets().size());
        ChangeSet changeSet = (ChangeSet)changeLog.getChangeSets().get(0);
        Assert.assertEquals((Object)"nvoxland", (Object)changeSet.getAuthor());
        Assert.assertEquals((Object)"1", (Object)changeSet.getId());
        Assert.assertEquals((long)1L, (long)changeSet.getChanges().size());
        Assert.assertEquals((Object)"liquibase/parser/core/xml/simpleChangeLog.xml", (Object)changeSet.getFilePath());
        Assert.assertEquals((Object)"Some comments go here", (Object)changeSet.getComments());
        Change change = (Change)changeSet.getChanges().get(0);
        Assert.assertEquals((Object)"createTable", (Object)change.getChangeMetaData().getName());
        Assert.assertTrue((boolean)(change instanceof CreateTableChange));
    }

    @Test
    public void multiChangeSetChangeLog() throws Exception {
        DatabaseChangeLog changeLog = new XMLChangeLogSAXParser().parse("liquibase/parser/core/xml/multiChangeSetChangeLog.xml", new ChangeLogParameters(), (ResourceAccessor)new JUnitResourceAccessor());
        Assert.assertEquals((Object)"liquibase/parser/core/xml/multiChangeSetChangeLog.xml", (Object)changeLog.getLogicalFilePath());
        Assert.assertEquals((Object)"liquibase/parser/core/xml/multiChangeSetChangeLog.xml", (Object)changeLog.getPhysicalFilePath());
        Assert.assertEquals((long)0L, (long)changeLog.getPreconditions().getNestedPreconditions().size());
        Assert.assertEquals((long)4L, (long)changeLog.getChangeSets().size());
        ChangeSet changeSet = (ChangeSet)changeLog.getChangeSets().get(0);
        Assert.assertEquals((Object)"nvoxland", (Object)changeSet.getAuthor());
        Assert.assertEquals((Object)"1", (Object)changeSet.getId());
        Assert.assertEquals((long)1L, (long)changeSet.getChanges().size());
        Assert.assertEquals((Object)"liquibase/parser/core/xml/multiChangeSetChangeLog.xml", (Object)changeSet.getFilePath());
        Assert.assertNull((Object)changeSet.getComments());
        Assert.assertFalse((boolean)changeSet.shouldAlwaysRun());
        Assert.assertFalse((boolean)changeSet.shouldRunOnChange());
        Change change = (Change)changeSet.getChanges().get(0);
        Assert.assertEquals((Object)"createTable", (Object)change.getChangeMetaData().getName());
        Assert.assertTrue((boolean)(change instanceof CreateTableChange));
        changeSet = (ChangeSet)changeLog.getChangeSets().get(1);
        Assert.assertEquals((Object)"nvoxland", (Object)changeSet.getAuthor());
        Assert.assertEquals((Object)"2", (Object)changeSet.getId());
        Assert.assertEquals((long)2L, (long)changeSet.getChanges().size());
        Assert.assertEquals((Object)"liquibase/parser/core/xml/multiChangeSetChangeLog.xml", (Object)changeSet.getFilePath());
        Assert.assertEquals((Object)"Testing add column", (Object)changeSet.getComments());
        Assert.assertTrue((boolean)changeSet.shouldAlwaysRun());
        Assert.assertTrue((boolean)changeSet.shouldRunOnChange());
        Assert.assertEquals((long)2L, (long)changeSet.getRollBackChanges().length);
        Assert.assertTrue((boolean)(changeSet.getRollBackChanges()[0] instanceof RawSQLChange));
        Assert.assertTrue((boolean)(changeSet.getRollBackChanges()[1] instanceof RawSQLChange));
        change = (Change)changeSet.getChanges().get(0);
        Assert.assertEquals((Object)"addColumn", (Object)change.getChangeMetaData().getName());
        Assert.assertTrue((boolean)(change instanceof AddColumnChange));
        change = (Change)changeSet.getChanges().get(1);
        Assert.assertEquals((Object)"addColumn", (Object)change.getChangeMetaData().getName());
        Assert.assertTrue((boolean)(change instanceof AddColumnChange));
        changeSet = (ChangeSet)changeLog.getChangeSets().get(2);
        Assert.assertEquals((Object)"bob", (Object)changeSet.getAuthor());
        Assert.assertEquals((Object)"3", (Object)changeSet.getId());
        Assert.assertEquals((long)1L, (long)changeSet.getChanges().size());
        Assert.assertEquals((Object)"liquibase/parser/core/xml/multiChangeSetChangeLog.xml", (Object)changeSet.getFilePath());
        Assert.assertNull((Object)changeSet.getComments());
        Assert.assertFalse((boolean)changeSet.shouldAlwaysRun());
        Assert.assertFalse((boolean)changeSet.shouldRunOnChange());
        change = (Change)changeSet.getChanges().get(0);
        Assert.assertEquals((Object)"createTable", (Object)change.getChangeMetaData().getName());
        Assert.assertTrue((boolean)(change instanceof CreateTableChange));
        changeSet = (ChangeSet)changeLog.getChangeSets().get(3);
        Assert.assertEquals((long)1L, (long)changeSet.getChanges().size());
        change = (Change)changeSet.getChanges().get(0);
        Assert.assertTrue((boolean)(change instanceof CustomChangeWrapper));
        CustomChangeWrapper wrapper = (CustomChangeWrapper)change;
        wrapper.generateStatements(null);
        Assert.assertTrue((boolean)(wrapper.getCustomChange() instanceof ExampleCustomSqlChange));
        ExampleCustomSqlChange exChg = (ExampleCustomSqlChange)wrapper.getCustomChange();
        Assert.assertEquals((Object)"table", (Object)exChg.getTableName());
        Assert.assertEquals((Object)"column", (Object)exChg.getColumnName());
    }

    @Test
    public void logicalPathChangeLog() throws Exception {
        DatabaseChangeLog changeLog = new XMLChangeLogSAXParser().parse("liquibase/parser/core/xml/logicalPathChangeLog.xml", new ChangeLogParameters(), (ResourceAccessor)new JUnitResourceAccessor());
        Assert.assertEquals((Object)"liquibase/parser-logical/xml/logicalPathChangeLog.xml", (Object)changeLog.getLogicalFilePath());
        Assert.assertEquals((Object)"liquibase/parser/core/xml/logicalPathChangeLog.xml", (Object)changeLog.getPhysicalFilePath());
        Assert.assertEquals((long)0L, (long)changeLog.getPreconditions().getNestedPreconditions().size());
        Assert.assertEquals((long)1L, (long)changeLog.getChangeSets().size());
        Assert.assertEquals((Object)"liquibase/parser-logical/xml/logicalPathChangeLog.xml", (Object)((ChangeSet)changeLog.getChangeSets().get(0)).getFilePath());
    }

    @Test
    public void preconditionsChangeLog() throws Exception {
        DatabaseChangeLog changeLog = new XMLChangeLogSAXParser().parse("liquibase/parser/core/xml/preconditionsChangeLog.xml", new ChangeLogParameters(), (ResourceAccessor)new JUnitResourceAccessor());
        Assert.assertEquals((Object)"liquibase/parser/core/xml/preconditionsChangeLog.xml", (Object)changeLog.getLogicalFilePath());
        Assert.assertEquals((Object)"liquibase/parser/core/xml/preconditionsChangeLog.xml", (Object)changeLog.getPhysicalFilePath());
        Assert.assertNotNull((Object)changeLog.getPreconditions());
        Assert.assertEquals((long)2L, (long)changeLog.getPreconditions().getNestedPreconditions().size());
        Assert.assertEquals((Object)"runningAs", (Object)((Precondition)changeLog.getPreconditions().getNestedPreconditions().get(0)).getName());
        Assert.assertEquals((Object)"or", (Object)((Precondition)changeLog.getPreconditions().getNestedPreconditions().get(1)).getName());
        Assert.assertEquals((Object)"dbms", (Object)((Precondition)((OrPrecondition)changeLog.getPreconditions().getNestedPreconditions().get(1)).getNestedPreconditions().get(0)).getName());
        Assert.assertEquals((Object)"dbms", (Object)((Precondition)((OrPrecondition)changeLog.getPreconditions().getNestedPreconditions().get(1)).getNestedPreconditions().get(1)).getName());
        Assert.assertEquals((long)1L, (long)changeLog.getChangeSets().size());
    }

    @Test
    public void testNestedChangeLog() throws Exception {
        String nestedFileName = "liquibase/parser/core/xml/nestedChangeLog.xml";
        DatabaseChangeLog changeLog = new XMLChangeLogSAXParser().parse("liquibase/parser/core/xml/nestedChangeLog.xml", new ChangeLogParameters(), (ResourceAccessor)new JUnitResourceAccessor());
        this.nestedFileAssertions(changeLog, "liquibase/parser/core/xml/nestedChangeLog.xml");
    }

    @Test
    public void nestedRelativeChangeLog() throws Exception {
        String nestedFileName = "liquibase/parser/core/xml/nestedRelativeChangeLog.xml";
        DatabaseChangeLog changeLog = new XMLChangeLogSAXParser().parse("liquibase/parser/core/xml/nestedRelativeChangeLog.xml", new ChangeLogParameters(), (ResourceAccessor)new JUnitResourceAccessor());
        this.nestedFileAssertions(changeLog, "liquibase/parser/core/xml/nestedRelativeChangeLog.xml");
    }

    private void nestedFileAssertions(DatabaseChangeLog changeLog, String nestedFileName) {
        Assert.assertEquals((Object)nestedFileName, (Object)changeLog.getLogicalFilePath());
        Assert.assertEquals((Object)nestedFileName, (Object)changeLog.getPhysicalFilePath());
        Assert.assertEquals((long)1L, (long)changeLog.getPreconditions().getNestedPreconditions().size());
        Assert.assertEquals((long)0L, (long)((PreconditionContainer)changeLog.getPreconditions().getNestedPreconditions().get(0)).getNestedPreconditions().size());
        Assert.assertEquals((long)3L, (long)changeLog.getChangeSets().size());
        ChangeSet changeSet = (ChangeSet)changeLog.getChangeSets().get(0);
        Assert.assertEquals((Object)"nvoxland", (Object)changeSet.getAuthor());
        Assert.assertEquals((Object)"1", (Object)changeSet.getId());
        Assert.assertEquals((long)1L, (long)changeSet.getChanges().size());
        Assert.assertEquals((Object)nestedFileName, (Object)changeSet.getFilePath());
        Change change = (Change)changeSet.getChanges().get(0);
        Assert.assertEquals((Object)"createTable", (Object)change.getChangeMetaData().getName());
        Assert.assertTrue((boolean)(change instanceof CreateTableChange));
        Assert.assertEquals((Object)"employee", (Object)((CreateTableChange)change).getTableName());
        changeSet = (ChangeSet)changeLog.getChangeSets().get(1);
        Assert.assertEquals((Object)"nvoxland", (Object)changeSet.getAuthor());
        Assert.assertEquals((Object)"1", (Object)changeSet.getId());
        Assert.assertEquals((long)1L, (long)changeSet.getChanges().size());
        Assert.assertEquals((Object)"liquibase/parser/core/xml/simpleChangeLog.xml", (Object)changeSet.getFilePath());
        change = (Change)changeSet.getChanges().get(0);
        Assert.assertEquals((Object)"createTable", (Object)change.getChangeMetaData().getName());
        Assert.assertTrue((boolean)(change instanceof CreateTableChange));
        Assert.assertEquals((Object)"person", (Object)((CreateTableChange)change).getTableName());
        changeSet = (ChangeSet)changeLog.getChangeSets().get(2);
        Assert.assertEquals((Object)"nvoxland", (Object)changeSet.getAuthor());
        Assert.assertEquals((Object)"2", (Object)changeSet.getId());
        Assert.assertEquals((long)1L, (long)changeSet.getChanges().size());
        Assert.assertEquals((Object)nestedFileName, (Object)changeSet.getFilePath());
        change = (Change)changeSet.getChanges().get(0);
        Assert.assertEquals((Object)"addColumn", (Object)change.getChangeMetaData().getName());
        Assert.assertTrue((boolean)(change instanceof AddColumnChange));
        Assert.assertEquals((Object)"employee", (Object)((AddColumnChange)change).getTableName());
    }

    @Test
    public void doubleNestedChangeLog() throws Exception {
        String doubleNestedFileName = "liquibase/parser/core/xml/doubleNestedChangeLog.xml";
        String nestedFileName = "liquibase/parser/core/xml/nestedChangeLog.xml";
        DatabaseChangeLog changeLog = new XMLChangeLogSAXParser().parse("liquibase/parser/core/xml/doubleNestedChangeLog.xml", new ChangeLogParameters(), (ResourceAccessor)new JUnitResourceAccessor());
        this.doubleNestedFileAssertions("liquibase/parser/core/xml/doubleNestedChangeLog.xml", "liquibase/parser/core/xml/nestedChangeLog.xml", changeLog);
    }

    @Test
    public void doubleNestedRelativeChangeLog() throws Exception {
        String doubleNestedFileName = "liquibase/parser/core/xml/doubleNestedRelativeChangeLog.xml";
        String nestedFileName = "liquibase/parser/core/xml/nestedRelativeChangeLog.xml";
        DatabaseChangeLog changeLog = new XMLChangeLogSAXParser().parse("liquibase/parser/core/xml/doubleNestedRelativeChangeLog.xml", new ChangeLogParameters(), (ResourceAccessor)new JUnitResourceAccessor());
        this.doubleNestedFileAssertions("liquibase/parser/core/xml/doubleNestedRelativeChangeLog.xml", "liquibase/parser/core/xml/nestedRelativeChangeLog.xml", changeLog);
    }

    private void doubleNestedFileAssertions(String doubleNestedFileName, String nestedFileName, DatabaseChangeLog changeLog) {
        Assert.assertEquals((Object)doubleNestedFileName, (Object)changeLog.getLogicalFilePath());
        Assert.assertEquals((Object)doubleNestedFileName, (Object)changeLog.getPhysicalFilePath());
        Assert.assertEquals((long)1L, (long)changeLog.getPreconditions().getNestedPreconditions().size());
        PreconditionContainer nested = (PreconditionContainer)changeLog.getPreconditions().getNestedPreconditions().get(0);
        Assert.assertEquals((long)1L, (long)nested.getNestedPreconditions().size());
        Assert.assertEquals((long)0L, (long)((PreconditionContainer)nested.getNestedPreconditions().get(0)).getNestedPreconditions().size());
        Assert.assertEquals((long)4L, (long)changeLog.getChangeSets().size());
        ChangeSet changeSet = (ChangeSet)changeLog.getChangeSets().get(0);
        Assert.assertEquals((Object)"nvoxland", (Object)changeSet.getAuthor());
        Assert.assertEquals((Object)"1", (Object)changeSet.getId());
        Assert.assertEquals((long)1L, (long)changeSet.getChanges().size());
        Assert.assertEquals((Object)doubleNestedFileName, (Object)changeSet.getFilePath());
        Change change = (Change)changeSet.getChanges().get(0);
        Assert.assertEquals((Object)"createTable", (Object)change.getChangeMetaData().getName());
        Assert.assertTrue((boolean)(change instanceof CreateTableChange));
        Assert.assertEquals((Object)"partner", (Object)((CreateTableChange)change).getTableName());
        changeSet = (ChangeSet)changeLog.getChangeSets().get(1);
        Assert.assertEquals((Object)"nvoxland", (Object)changeSet.getAuthor());
        Assert.assertEquals((Object)"1", (Object)changeSet.getId());
        Assert.assertEquals((long)1L, (long)changeSet.getChanges().size());
        Assert.assertEquals((Object)nestedFileName, (Object)changeSet.getFilePath());
        change = (Change)changeSet.getChanges().get(0);
        Assert.assertEquals((Object)"createTable", (Object)change.getChangeMetaData().getName());
        Assert.assertTrue((boolean)(change instanceof CreateTableChange));
        Assert.assertEquals((Object)"employee", (Object)((CreateTableChange)change).getTableName());
        changeSet = (ChangeSet)changeLog.getChangeSets().get(2);
        Assert.assertEquals((Object)"nvoxland", (Object)changeSet.getAuthor());
        Assert.assertEquals((Object)"1", (Object)changeSet.getId());
        Assert.assertEquals((long)1L, (long)changeSet.getChanges().size());
        Assert.assertEquals((Object)"liquibase/parser/core/xml/simpleChangeLog.xml", (Object)changeSet.getFilePath());
        change = (Change)changeSet.getChanges().get(0);
        Assert.assertEquals((Object)"createTable", (Object)change.getChangeMetaData().getName());
        Assert.assertTrue((boolean)(change instanceof CreateTableChange));
        Assert.assertEquals((Object)"person", (Object)((CreateTableChange)change).getTableName());
        changeSet = (ChangeSet)changeLog.getChangeSets().get(3);
        Assert.assertEquals((Object)"nvoxland", (Object)changeSet.getAuthor());
        Assert.assertEquals((Object)"2", (Object)changeSet.getId());
        Assert.assertEquals((long)1L, (long)changeSet.getChanges().size());
        Assert.assertEquals((Object)nestedFileName, (Object)changeSet.getFilePath());
        change = (Change)changeSet.getChanges().get(0);
        Assert.assertEquals((Object)"addColumn", (Object)change.getChangeMetaData().getName());
        Assert.assertTrue((boolean)(change instanceof AddColumnChange));
        Assert.assertEquals((Object)"employee", (Object)((AddColumnChange)change).getTableName());
    }

    @Test
    public void missingChangeLog() throws Exception {
        try {
            DatabaseChangeLog changeLog = new XMLChangeLogSAXParser().parse("liquibase/changelog/parser/xml/missingChangeLog.xml", new ChangeLogParameters(), (ResourceAccessor)new JUnitResourceAccessor());
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof ChangeLogParseException));
            Assert.assertEquals((Object)"liquibase/changelog/parser/xml/missingChangeLog.xml does not exist", (Object)e.getMessage());
        }
    }

    @Test
    public void malformedChangeLog() throws Exception {
        try {
            DatabaseChangeLog changeLog = new XMLChangeLogSAXParser().parse("liquibase/parser/core/xml/malformedChangeLog.xml", new ChangeLogParameters(), (ResourceAccessor)new JUnitResourceAccessor());
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof ChangeLogParseException));
            Assert.assertTrue((boolean)e.getMessage().startsWith("Error parsing line"));
        }
    }

    @Test
    public void otherNamespaceAttributesChangeLog() throws Exception {
        DatabaseChangeLog changeLog = new XMLChangeLogSAXParser().parse("liquibase/parser/core/xml/simpleChangeLog.xml", new ChangeLogParameters(), (ResourceAccessor)new JUnitResourceAccessor());
        Assert.assertEquals((Object)"liquibase/parser/core/xml/simpleChangeLog.xml", (Object)changeLog.getLogicalFilePath());
        Assert.assertEquals((Object)"liquibase/parser/core/xml/simpleChangeLog.xml", (Object)changeLog.getPhysicalFilePath());
        Assert.assertEquals((long)0L, (long)changeLog.getPreconditions().getNestedPreconditions().size());
        Assert.assertEquals((long)1L, (long)changeLog.getChangeSets().size());
        ChangeSet changeSet = (ChangeSet)changeLog.getChangeSets().get(0);
        Assert.assertEquals((Object)"nvoxland", (Object)changeSet.getAuthor());
        Assert.assertEquals((Object)"1", (Object)changeSet.getId());
        Assert.assertEquals((long)1L, (long)changeSet.getChanges().size());
        Assert.assertEquals((Object)"liquibase/parser/core/xml/simpleChangeLog.xml", (Object)changeSet.getFilePath());
        Assert.assertEquals((Object)"Some comments go here", (Object)changeSet.getComments());
        Change change = (Change)changeSet.getChanges().get(0);
        Assert.assertEquals((Object)"createTable", (Object)change.getChangeMetaData().getName());
        Assert.assertTrue((boolean)(change instanceof CreateTableChange));
    }

    @Test
    public void rawSqlParameter() throws Exception {
        ChangeLogParameters params = new ChangeLogParameters();
        params.set("tablename", (Object)"rawsql");
        DatabaseChangeLog changeLog = new XMLChangeLogSAXParser().parse("liquibase/parser/core/xml/rawSqlParameters.xml", params, (ResourceAccessor)new JUnitResourceAccessor());
        Assert.assertEquals((Object)"liquibase/parser/core/xml/rawSqlParameters.xml", (Object)changeLog.getLogicalFilePath());
        Assert.assertEquals((Object)"liquibase/parser/core/xml/rawSqlParameters.xml", (Object)changeLog.getPhysicalFilePath());
        Assert.assertEquals((long)1L, (long)changeLog.getChangeSets().size());
        ChangeSet changeSet = (ChangeSet)changeLog.getChangeSets().get(0);
        Assert.assertEquals((Object)"paikens", (Object)changeSet.getAuthor());
        Assert.assertEquals((Object)"1", (Object)changeSet.getId());
        Assert.assertEquals((Object)"liquibase/parser/core/xml/rawSqlParameters.xml", (Object)changeSet.getFilePath());
        Assert.assertEquals((long)1L, (long)changeSet.getChanges().size());
        Assert.assertTrue((boolean)(changeSet.getChanges().get(0) instanceof RawSQLChange));
        Assert.assertEquals((Object)"create table rawsql;", (Object)((RawSQLChange)changeSet.getChanges().get(0)).getSql());
        Assert.assertEquals((long)1L, (long)changeSet.getRollBackChanges().length);
        Assert.assertTrue((boolean)(changeSet.getRollBackChanges()[0] instanceof RawSQLChange));
        Assert.assertEquals((Object)"drop table rawsql", (Object)((RawSQLChange)changeSet.getRollBackChanges()[0]).getSql());
    }
}

