/*
 * Decompiled with CFR 0.152.
 */
package liquibase.resource;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import liquibase.resource.CompositeResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CompositeFileOpenerTest {
    ResourceAccessor first;
    ResourceAccessor second;
    ResourceAccessor hasDir;
    ResourceAccessor noDir;
    CompositeResourceAccessor composite;
    InputStream validStream;
    Enumeration<URL> empty;
    Enumeration<URL> hasElements;

    @Before
    public void setUp() throws IOException {
        this.first = (ResourceAccessor)EasyMock.createMock(ResourceAccessor.class);
        this.second = (ResourceAccessor)EasyMock.createMock(ResourceAccessor.class);
        this.composite = new CompositeResourceAccessor(new ResourceAccessor[]{this.first, this.second});
        this.validStream = this.getClass().getClassLoader().getResourceAsStream("liquibase/resource/CompositeFileOpenerTest.class");
        this.empty = new Vector().elements();
        this.hasElements = this.getClass().getClassLoader().getResources("liquibase");
    }

    @After
    public void tearDown() throws IOException {
        this.validStream.close();
    }

    @Test
    public void streamFirstHas() throws IOException {
        EasyMock.expect((Object)this.first.getResourceAsStream("file")).andReturn((Object)this.validStream);
        EasyMock.replay((Object[])new Object[]{this.first});
        EasyMock.replay((Object[])new Object[]{this.second});
        InputStream is = this.composite.getResourceAsStream("file");
        Assert.assertEquals((Object)this.validStream, (Object)is);
        EasyMock.verify((Object[])new Object[]{this.first});
        EasyMock.verify((Object[])new Object[]{this.second});
    }

    @Test
    public void streamSecondHas() throws IOException {
        EasyMock.expect((Object)this.first.getResourceAsStream("file")).andReturn(null);
        EasyMock.expect((Object)this.second.getResourceAsStream("file")).andReturn((Object)this.validStream);
        EasyMock.replay((Object[])new Object[]{this.first});
        EasyMock.replay((Object[])new Object[]{this.second});
        InputStream is = this.composite.getResourceAsStream("file");
        Assert.assertEquals((Object)this.validStream, (Object)is);
        EasyMock.verify((Object[])new Object[]{this.first});
        EasyMock.verify((Object[])new Object[]{this.second});
    }

    @Test
    public void streamNeitherHas() throws IOException {
        EasyMock.expect((Object)this.first.getResourceAsStream("file")).andReturn(null);
        EasyMock.expect((Object)this.second.getResourceAsStream("file")).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.first});
        EasyMock.replay((Object[])new Object[]{this.second});
        InputStream is = this.composite.getResourceAsStream("file");
        Assert.assertNull((Object)is);
        EasyMock.verify((Object[])new Object[]{this.first});
        EasyMock.verify((Object[])new Object[]{this.second});
    }

    @Test
    public void resourcesFirstHas() throws IOException {
        EasyMock.expect((Object)this.first.getResources("file")).andReturn(this.hasElements);
        EasyMock.replay((Object[])new Object[]{this.first});
        EasyMock.replay((Object[])new Object[]{this.second});
        Enumeration urls = this.composite.getResources("file");
        EasyMock.verify((Object[])new Object[]{this.first});
        EasyMock.verify((Object[])new Object[]{this.second});
    }

    @Test
    public void resourcesSecondHas() throws IOException {
        EasyMock.expect((Object)this.first.getResources("file")).andReturn(this.empty);
        EasyMock.expect((Object)this.second.getResources("file")).andReturn(this.hasElements);
        EasyMock.replay((Object[])new Object[]{this.first});
        EasyMock.replay((Object[])new Object[]{this.second});
        Enumeration urls = this.composite.getResources("file");
        EasyMock.verify((Object[])new Object[]{this.first});
        EasyMock.verify((Object[])new Object[]{this.second});
    }

    @Test
    public void resourcesNeitherHas() throws IOException {
        EasyMock.expect((Object)this.first.getResources("file")).andReturn(this.empty);
        EasyMock.expect((Object)this.second.getResources("file")).andReturn(this.empty);
        EasyMock.replay((Object[])new Object[]{this.first});
        EasyMock.replay((Object[])new Object[]{this.second});
        Enumeration urls = this.composite.getResources("file");
        Assert.assertFalse((boolean)urls.hasMoreElements());
        Assert.assertFalse((urls == this.empty ? 1 : 0) != 0);
        EasyMock.verify((Object[])new Object[]{this.first});
        EasyMock.verify((Object[])new Object[]{this.second});
    }
}

