/*
 * Decompiled with CFR 0.152.
 */
package liquibase.resource;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import liquibase.resource.FileSystemResourceAccessor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FileSystemFileOpenerTest {
    FileSystemResourceAccessor opener;

    @Before
    public void createFileOpener() throws URISyntaxException {
        File thisClassFile = new File(new URI(this.getClass().getClassLoader().getResource("liquibase/resource/FileSystemResourceAccessor.class").toExternalForm()));
        String packageDirectory = thisClassFile.getParent();
        this.opener = new FileSystemResourceAccessor(packageDirectory);
    }

    @Test(expected=IllegalArgumentException.class)
    public void onlyAcceptsDirectories() throws URISyntaxException {
        File thisClassFile = new File(new URI(this.getClass().getClassLoader().getResource("liquibase/resource/FileSystemResourceAccessor.class").toExternalForm()));
        FileSystemResourceAccessor o = new FileSystemResourceAccessor(thisClassFile.getAbsolutePath());
    }

    @Test
    public void singleFileTest() throws IOException {
        Assert.assertNotNull((Object)this.opener.getResourceAsStream("FileSystemResourceAccessor.class"));
    }

    @Test
    public void multipleFileTest() throws IOException {
        Enumeration files = this.opener.getResources(".");
        boolean found = false;
        while (files.hasMoreElements()) {
            URL u = (URL)files.nextElement();
            found |= u.getFile().lastIndexOf("FileSystemResourceAccessor") > -1;
        }
        Assert.assertTrue((boolean)found);
    }

    @Test
    public void ahphabeticalOrderTest() throws IOException {
        Enumeration files = this.opener.getResources(".");
        boolean correct = false;
        String lastFile = null;
        while (files.hasMoreElements()) {
            URL u = (URL)files.nextElement();
            String currentFile = u.getFile().substring(u.getFile().lastIndexOf("/") + 1);
            if (lastFile != null) {
                correct |= lastFile.compareTo(currentFile) < 0;
            }
            lastFile = currentFile;
        }
        Assert.assertTrue((boolean)correct);
    }
}

