/*
 * Decompiled with CFR 0.152.
 */
package liquibase.serializer;

import java.util.Map;
import liquibase.serializer.ChangeLogSerializer;
import liquibase.serializer.ChangeLogSerializerFactory;
import liquibase.serializer.MockChangeLogSerializer;
import liquibase.serializer.core.string.StringChangeLogSerializer;
import liquibase.serializer.core.xml.XMLChangeLogSerializer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ChangeLogSerializerFactoryTest {
    @Before
    public void setup() {
        ChangeLogSerializerFactory.reset();
    }

    @Test
    public void getInstance() {
        Assert.assertNotNull((Object)ChangeLogSerializerFactory.getInstance());
        Assert.assertTrue((ChangeLogSerializerFactory.getInstance() == ChangeLogSerializerFactory.getInstance() ? 1 : 0) != 0);
    }

    @Test
    public void register() {
        ChangeLogSerializerFactory.getInstance().getSerializers().clear();
        Assert.assertEquals((long)0L, (long)ChangeLogSerializerFactory.getInstance().getSerializers().size());
        ChangeLogSerializerFactory.getInstance().register((ChangeLogSerializer)new MockChangeLogSerializer("mock"));
        Assert.assertEquals((long)1L, (long)ChangeLogSerializerFactory.getInstance().getSerializers().size());
    }

    @Test
    public void unregister_instance() {
        ChangeLogSerializerFactory factory = ChangeLogSerializerFactory.getInstance();
        factory.getSerializers().clear();
        Assert.assertEquals((long)0L, (long)factory.getSerializers().size());
        XMLChangeLogSerializer changeLogSerializer = new XMLChangeLogSerializer();
        factory.register((ChangeLogSerializer)new StringChangeLogSerializer());
        factory.register((ChangeLogSerializer)changeLogSerializer);
        Assert.assertEquals((long)2L, (long)factory.getSerializers().size());
        factory.unregister((ChangeLogSerializer)changeLogSerializer);
        Assert.assertEquals((long)1L, (long)factory.getSerializers().size());
    }

    @Test
    public void reset() {
        ChangeLogSerializerFactory instance1 = ChangeLogSerializerFactory.getInstance();
        ChangeLogSerializerFactory.reset();
        Assert.assertFalse((instance1 == ChangeLogSerializerFactory.getInstance() ? 1 : 0) != 0);
    }

    @Test
    public void builtInGeneratorsAreFound() {
        Map generators = ChangeLogSerializerFactory.getInstance().getSerializers();
        Assert.assertEquals((long)2L, (long)generators.size());
    }

    @Test
    public void getSerializers() {
        ChangeLogSerializer serializer = ChangeLogSerializerFactory.getInstance().getSerializer("xml");
        Assert.assertNotNull((Object)serializer);
        Assert.assertTrue((boolean)(serializer instanceof XMLChangeLogSerializer));
    }
}

