/*
 * Decompiled with CFR 0.152.
 */
package liquibase.serializer.core.string;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.SortedSet;
import java.util.TreeSet;
import liquibase.change.Change;
import liquibase.change.ChangeFactory;
import liquibase.change.ChangeProperty;
import liquibase.change.ColumnConfig;
import liquibase.change.ConstraintsConfig;
import liquibase.change.core.AddColumnChange;
import liquibase.change.core.AddForeignKeyConstraintChange;
import liquibase.change.core.AddUniqueConstraintChange;
import liquibase.change.core.LoadDataColumnConfig;
import liquibase.change.core.RawSQLChange;
import liquibase.change.core.SQLFileChange;
import liquibase.change.custom.CustomChangeWrapper;
import liquibase.change.custom.CustomSqlChange;
import liquibase.change.custom.ExampleCustomSqlChange;
import liquibase.changelog.ChangeLogParameters;
import liquibase.logging.Logger;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import liquibase.serializer.core.string.StringChangeLogSerializer;
import liquibase.statement.DatabaseFunction;
import org.junit.Assert;
import org.junit.Test;

public class StringChangeLogSerializerTest {
    @Test
    public void serialized_CustomChange() throws Exception {
        String expectedString = "customChange:[\n    className=\"liquibase.change.custom.ExampleCustomSqlChange\"\n    paramValues={\n        columnName=\"column_name\",\n        newValue=\"new_value\",\n        tableName=\"table_name\"\n    }\n]";
        CustomChangeWrapper wrapper = new CustomChangeWrapper();
        wrapper.setResourceAccessor((ResourceAccessor)new ClassLoaderResourceAccessor());
        wrapper.setClassLoader(this.getClass().getClassLoader());
        wrapper.setClass("liquibase.change.custom.ExampleCustomSqlChange");
        wrapper.setParam("columnName", "column_name");
        wrapper.setParam("newValue", "new_value");
        wrapper.setParam("tableName", "table_name");
        Assert.assertEquals((Object)expectedString, (Object)new StringChangeLogSerializer().serialize((Change)wrapper));
    }

    @Test
    public void serialized_AddColumnChange() {
        AddColumnChange change = new AddColumnChange();
        Assert.assertEquals((Object)"addColumn:[\n    columns=[]\n]", (Object)new StringChangeLogSerializer().serialize((Change)change));
        change.setTableName("TABLE_NAME");
        Assert.assertEquals((Object)"addColumn:[\n    columns=[]\n    tableName=\"TABLE_NAME\"\n]", (Object)new StringChangeLogSerializer().serialize((Change)change));
        change.setSchemaName("SCHEMA_NAME");
        Assert.assertEquals((Object)"addColumn:[\n    columns=[]\n    schemaName=\"SCHEMA_NAME\"\n    tableName=\"TABLE_NAME\"\n]", (Object)new StringChangeLogSerializer().serialize((Change)change));
        ColumnConfig column = new ColumnConfig();
        change.addColumn(column);
        column.setName("COLUMN_NAME");
        Assert.assertEquals((Object)"addColumn:[\n    columns=[\n        column:[\n            name=\"COLUMN_NAME\"\n        ]\n    ]\n    schemaName=\"SCHEMA_NAME\"\n    tableName=\"TABLE_NAME\"\n]", (Object)new StringChangeLogSerializer().serialize((Change)change));
        ColumnConfig column2 = new ColumnConfig();
        change.addColumn(column2);
        column2.setName("COLUMN2_NAME");
        column2.setAutoIncrement(Boolean.valueOf(true));
        column2.setValueNumeric((Number)52);
        Assert.assertEquals((Object)"addColumn:[\n    columns=[\n        column:[\n            name=\"COLUMN_NAME\"\n        ],\n        column:[\n            autoIncrement=\"true\"\n            name=\"COLUMN2_NAME\"\n            valueNumeric=\"52\"\n        ]\n    ]\n    schemaName=\"SCHEMA_NAME\"\n    tableName=\"TABLE_NAME\"\n]", (Object)new StringChangeLogSerializer().serialize((Change)change));
    }

    @Test
    public void serialized_AddForeignKeyConstraint() {
        AddForeignKeyConstraintChange change = new AddForeignKeyConstraintChange();
        Assert.assertEquals((Object)"addForeignKeyConstraint:[]", (Object)new StringChangeLogSerializer().serialize((Change)change));
        change.setBaseTableName("TABLE_NAME");
        change.setBaseColumnNames("COL1, COL2");
        change.setBaseTableSchemaName("BASE_SCHEM");
        change.setConstraintName("FK_TEST");
        change.setDeferrable(Boolean.valueOf(true));
        change.setInitiallyDeferred(Boolean.valueOf(true));
        change.setReferencesUniqueColumn(Boolean.valueOf(false));
        change.setDeleteCascade(Boolean.valueOf(true));
        change.setOnDelete("SET NULL");
        change.setOnUpdate("NO ACTION");
        change.setReferencedTableName("REF_TABLE");
        change.setReferencedColumnNames("COLA, COLB");
        change.setReferencedTableSchemaName("REF_SCHEM");
        Assert.assertEquals((Object)"addForeignKeyConstraint:[\n    baseColumnNames=\"COL1, COL2\"\n    baseTableName=\"TABLE_NAME\"\n    baseTableSchemaName=\"BASE_SCHEM\"\n    constraintName=\"FK_TEST\"\n    deferrable=\"true\"\n    initiallyDeferred=\"true\"\n    onDelete=\"SET NULL\"\n    onUpdate=\"NO ACTION\"\n    referencedColumnNames=\"COLA, COLB\"\n    referencedTableName=\"REF_TABLE\"\n    referencedTableSchemaName=\"REF_SCHEM\"\n    referencesUniqueColumn=\"false\"\n]", (Object)new StringChangeLogSerializer().serialize((Change)change));
    }

    @Test
    public void serialized_AddUniqueKeyConstraint() {
        AddUniqueConstraintChange change = new AddUniqueConstraintChange();
        Assert.assertEquals((Object)"addUniqueConstraint:[]", (Object)new StringChangeLogSerializer().serialize((Change)change));
        change.setTableName("TABLE_NAME");
        change.setColumnNames("COL1, COL2");
        change.setSchemaName("BASE_SCHEM");
        change.setConstraintName("FK_TEST");
        change.setDeferrable(Boolean.valueOf(true));
        change.setInitiallyDeferred(Boolean.valueOf(true));
        change.setDisabled(Boolean.valueOf(true));
        change.setTablespace("TABLESPACE1");
        Assert.assertEquals((Object)"addUniqueConstraint:[\n    columnNames=\"COL1, COL2\"\n    constraintName=\"FK_TEST\"\n    deferrable=\"true\"\n    disabled=\"true\"\n    initiallyDeferred=\"true\"\n    schemaName=\"BASE_SCHEM\"\n    tableName=\"TABLE_NAME\"\n    tablespace=\"TABLESPACE1\"\n]", (Object)new StringChangeLogSerializer().serialize((Change)change));
    }

    @Test
    public void serialized_SQLFileChange() {
        SQLFileChange change = new SQLFileChange();
        Assert.assertEquals((Object)"sqlFile:[\n    splitStatements=\"true\"\n    stripComments=\"false\"\n]", (Object)new StringChangeLogSerializer().serialize((Change)change));
        change.setPath("PATH/TO/File.txt");
        Assert.assertEquals((Object)"sqlFile:[\n    path=\"PATH/TO/File.txt\"\n    splitStatements=\"true\"\n    stripComments=\"false\"\n]", (Object)new StringChangeLogSerializer().serialize((Change)change));
    }

    @Test
    public void serialized_rawSql() {
        RawSQLChange change = new RawSQLChange();
        Assert.assertEquals((Object)"sql:[\n    splitStatements=\"true\"\n    stripComments=\"false\"\n]", (Object)new StringChangeLogSerializer().serialize((Change)change));
        change.setSql("some SQL Here");
        Assert.assertEquals((Object)"sql:[\n    splitStatements=\"true\"\n    sql=\"some SQL Here\"\n    stripComments=\"false\"\n]", (Object)new StringChangeLogSerializer().serialize((Change)change));
    }

    @Test
    public void tryAllChanges() throws Exception {
        for (SortedSet changeClassSet : ChangeFactory.getInstance().getRegistry().values()) {
            Change change = (Change)((Class)changeClassSet.iterator().next()).getConstructor(new Class[0]).newInstance(new Object[0]);
            this.setFields(change);
            String string = new StringChangeLogSerializer().serialize(change);
            Assert.assertTrue((String)("@ in string.  Probably poorly serialzed object reference." + string), (string.indexOf("@") < 0 ? 1 : 0) != 0);
        }
    }

    private void setFields(Object object) throws Exception {
        Class<?> clazz = object.getClass();
        if (clazz.getName().indexOf(".ext.") > 0) {
            return;
        }
        for (Field field : clazz.getDeclaredFields()) {
            if (field.getAnnotation(ChangeProperty.class) != null && !field.getAnnotation(ChangeProperty.class).includeInSerialization()) continue;
            field.setAccessible(true);
            if (field.getType().getName().equals("[[Z") || field.getName().equals("serialVersionUID") || field.getType().equals(Logger.class) || field.getType().equals(ResourceAccessor.class) || field.getType().equals(ClassLoader.class)) continue;
            if (field.getType().equals(Long.TYPE)) {
                field.set(object, this.createInteger().longValue());
                continue;
            }
            if (field.getType().equals(String.class)) {
                field.set(object, this.createString());
                continue;
            }
            if (field.getType().equals(Number.class)) {
                field.set(object, this.createNumber());
                continue;
            }
            if (field.getType().equals(Integer.class)) {
                field.set(object, this.createInteger());
                continue;
            }
            if (field.getType().equals(BigInteger.class)) {
                field.set(object, this.createBigInteger());
                continue;
            }
            if (field.getType().equals(Date.class)) {
                field.set(object, this.createDate());
                continue;
            }
            if (field.getType().equals(Boolean.class)) {
                field.set(object, this.createBoolean());
                continue;
            }
            if (field.getType().equals(ColumnConfig.class)) {
                field.set(object, this.createColumnConfig());
                continue;
            }
            if (field.getType().equals(DatabaseFunction.class)) {
                field.set(object, this.createDatabaseFunction());
                continue;
            }
            if (field.getType().equals(ConstraintsConfig.class)) {
                field.set(object, this.createConstraintsConfig());
                continue;
            }
            if (field.getType().getName().equals("liquibase.change.custom.CustomChange")) {
                field.set(object, this.createCustomChange());
                continue;
            }
            if (field.getType().equals(Map.class)) {
                field.set(object, this.createMap());
                continue;
            }
            if (field.getType().equals(ChangeLogParameters.class)) continue;
            if (Collection.class.isAssignableFrom(field.getType())) {
                Type genericType = field.getGenericType();
                if (genericType instanceof ParameterizedType) {
                    int genericsLength = ((ParameterizedType)genericType).getActualTypeArguments().length;
                    if (genericsLength == 1) {
                        AbstractCollection collection;
                        Class typeToCreate = (Class)((ParameterizedType)genericType).getActualTypeArguments()[0];
                        if (field.getType().equals(List.class)) {
                            collection = new ArrayList();
                        } else if (field.getType().equals(SortedSet.class)) {
                            collection = new TreeSet();
                        } else {
                            throw new RuntimeException("Unknow collection type: " + field.getType().getName());
                        }
                        if (typeToCreate.equals(ColumnConfig.class)) {
                            collection.add(this.createColumnConfig());
                            collection.add(this.createColumnConfig());
                        } else if (typeToCreate.equals(LoadDataColumnConfig.class)) {
                            collection.add(this.createLoadDataColumnConfig());
                            collection.add(this.createLoadDataColumnConfig());
                        } else if (typeToCreate.equals(String.class)) {
                            collection.add(this.createString());
                            collection.add(this.createString());
                        } else {
                            throw new RuntimeException("Unknown generic type for " + clazz.getName() + "." + field.getName() + ": " + typeToCreate.getName());
                        }
                        field.set(object, collection);
                        continue;
                    }
                    throw new RuntimeException("Found " + genericsLength + " generics for " + clazz.getName() + "." + field.getName());
                }
                Assert.fail((String)"List not generic");
                continue;
            }
            Assert.fail((String)("Unknown field type in " + clazz.getName() + ": " + field.getType().getName()));
        }
    }

    private LoadDataColumnConfig createLoadDataColumnConfig() throws Exception {
        LoadDataColumnConfig config = new LoadDataColumnConfig();
        this.setFields(config);
        return config;
    }

    private String createString() {
        return Long.toString(Math.abs(new Random().nextLong()), 36);
    }

    private Number createNumber() {
        return new Random().nextDouble() * 10000.0;
    }

    private Integer createInteger() {
        return new Random().nextInt();
    }

    private BigInteger createBigInteger() {
        return new BigInteger(20, new Random());
    }

    private Date createDate() {
        return new Date(new Random().nextLong());
    }

    private Boolean createBoolean() {
        return true;
    }

    private Map createMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(this.createString(), this.createString());
        map.put(this.createString(), this.createString());
        map.put(this.createString(), this.createString());
        return map;
    }

    private ColumnConfig createColumnConfig() throws Exception {
        ColumnConfig config = new ColumnConfig();
        this.setFields(config);
        return config;
    }

    private DatabaseFunction createDatabaseFunction() throws Exception {
        DatabaseFunction function = new DatabaseFunction("FUNCTION_HERE");
        this.setFields(function);
        return function;
    }

    private ConstraintsConfig createConstraintsConfig() throws Exception {
        ConstraintsConfig config = new ConstraintsConfig();
        this.setFields(config);
        return config;
    }

    private CustomSqlChange createCustomChange() throws Exception {
        ExampleCustomSqlChange config = new ExampleCustomSqlChange();
        this.setFields(config);
        return config;
    }
}

