/*
 * Decompiled with CFR 0.152.
 */
package liquibase.servicelocator;

import java.lang.reflect.Modifier;
import liquibase.database.Database;
import liquibase.parser.ChangeLogParser;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.CompositeResourceAccessor;
import liquibase.resource.ResourceAccessor;
import liquibase.servicelocator.ServiceLocator;
import liquibase.test.TestContext;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ServiceLocatorTest {
    private ServiceLocator serviceLocator;

    @Before
    public void setup() throws Exception {
        CompositeResourceAccessor resourceAccessor = new CompositeResourceAccessor(new ResourceAccessor[]{new ClassLoaderResourceAccessor(), TestContext.getInstance().getTestResourceAccessor()});
        this.serviceLocator = ServiceLocator.getInstance();
        this.serviceLocator.setResourceAccessor((ResourceAccessor)resourceAccessor);
    }

    @After
    public void teardown() {
        ServiceLocator.reset();
    }

    @Test
    public void reset() {
        ServiceLocator instance1 = ServiceLocator.getInstance();
        ServiceLocator.reset();
        Assert.assertFalse((instance1 == ServiceLocator.getInstance() ? 1 : 0) != 0);
    }

    @Test
    public void getClasses() throws Exception {
        Class[] classes = this.serviceLocator.findClasses(ChangeLogParser.class);
        Assert.assertTrue((classes.length > 0 ? 1 : 0) != 0);
    }

    @Test
    public void findClass() throws Exception {
        Class[] classes;
        for (Class clazz : classes = this.serviceLocator.findClasses(Database.class)) {
            Assert.assertFalse((String)(clazz.getName() + " is abstract"), (boolean)Modifier.isAbstract(clazz.getModifiers()));
            Assert.assertFalse((String)(clazz.getName() + " is an interface"), (boolean)Modifier.isInterface(clazz.getModifiers()));
            Assert.assertNotNull(clazz.getConstructors());
        }
        Assert.assertTrue((classes.length > 0 ? 1 : 0) != 0);
    }
}

