/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sqlgenerator;

import java.util.Comparator;
import java.util.TreeSet;
import liquibase.database.Database;
import liquibase.database.core.MockDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.sql.Sql;
import liquibase.sqlgenerator.MockSqlGenerator;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.SqlGeneratorComparator;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.MockSqlStatement;
import org.junit.Assert;
import org.junit.Test;

public class SqlGeneratorChainTest {
    @Test
    public void generateSql_nullGenerators() {
        SqlGeneratorChain chain = new SqlGeneratorChain(null);
        Assert.assertNull((Object)chain.generateSql((SqlStatement)new MockSqlStatement(), (Database)new MockDatabase()));
    }

    @Test
    public void generateSql_noGenerators() {
        TreeSet generators = new TreeSet(new SqlGeneratorComparator());
        SqlGeneratorChain chain = new SqlGeneratorChain(generators);
        Assert.assertEquals((long)0L, (long)chain.generateSql((SqlStatement)new MockSqlStatement(), (Database)new MockDatabase()).length);
    }

    @Test
    public void generateSql_oneGenerators() {
        TreeSet<MockSqlGenerator> generators = new TreeSet<MockSqlGenerator>((Comparator<MockSqlGenerator>)new SqlGeneratorComparator());
        generators.add(new MockSqlGenerator(1, "A1", "A2"));
        SqlGeneratorChain chain = new SqlGeneratorChain(generators);
        Sql[] sql = chain.generateSql((SqlStatement)new MockSqlStatement(), (Database)new MockDatabase());
        Assert.assertEquals((long)2L, (long)sql.length);
        Assert.assertEquals((Object)"A1", (Object)sql[0].toSql());
        Assert.assertEquals((Object)"A2", (Object)sql[1].toSql());
    }

    @Test
    public void generateSql_twoGenerators() {
        TreeSet<MockSqlGenerator> generators = new TreeSet<MockSqlGenerator>((Comparator<MockSqlGenerator>)new SqlGeneratorComparator());
        generators.add(new MockSqlGenerator(2, "B1", "B2"));
        generators.add(new MockSqlGenerator(1, "A1", "A2"));
        SqlGeneratorChain chain = new SqlGeneratorChain(generators);
        Sql[] sql = chain.generateSql((SqlStatement)new MockSqlStatement(), (Database)new MockDatabase());
        Assert.assertEquals((long)4L, (long)sql.length);
        Assert.assertEquals((Object)"B1", (Object)sql[0].toSql());
        Assert.assertEquals((Object)"B2", (Object)sql[1].toSql());
        Assert.assertEquals((Object)"A1", (Object)sql[2].toSql());
        Assert.assertEquals((Object)"A2", (Object)sql[3].toSql());
    }

    @Test
    public void generateSql_threeGenerators() {
        TreeSet<MockSqlGenerator> generators = new TreeSet<MockSqlGenerator>((Comparator<MockSqlGenerator>)new SqlGeneratorComparator());
        generators.add(new MockSqlGenerator(2, "B1", "B2"));
        generators.add(new MockSqlGenerator(1, "A1", "A2"));
        generators.add(new MockSqlGenerator(3, "C1", "C2"));
        SqlGeneratorChain chain = new SqlGeneratorChain(generators);
        Sql[] sql = chain.generateSql((SqlStatement)new MockSqlStatement(), (Database)new MockDatabase());
        Assert.assertEquals((long)6L, (long)sql.length);
        Assert.assertEquals((Object)"C1", (Object)sql[0].toSql());
        Assert.assertEquals((Object)"C2", (Object)sql[1].toSql());
        Assert.assertEquals((Object)"B1", (Object)sql[2].toSql());
        Assert.assertEquals((Object)"B2", (Object)sql[3].toSql());
        Assert.assertEquals((Object)"A1", (Object)sql[4].toSql());
        Assert.assertEquals((Object)"A2", (Object)sql[5].toSql());
    }

    @Test
    public void validate_nullGenerators() {
        SqlGeneratorChain chain = new SqlGeneratorChain(null);
        ValidationErrors validationErrors = chain.validate((SqlStatement)new MockSqlStatement(), (Database)new MockDatabase());
        Assert.assertFalse((boolean)validationErrors.hasErrors());
    }

    @Test
    public void validate_oneGenerators_noErrors() {
        TreeSet<MockSqlGenerator> generators = new TreeSet<MockSqlGenerator>((Comparator<MockSqlGenerator>)new SqlGeneratorComparator());
        generators.add(new MockSqlGenerator(1, "A1", "A2"));
        SqlGeneratorChain chain = new SqlGeneratorChain(generators);
        ValidationErrors validationErrors = chain.validate((SqlStatement)new MockSqlStatement(), (Database)new MockDatabase());
        Assert.assertFalse((boolean)validationErrors.hasErrors());
    }

    @Test
    public void validate_oneGenerators_hasErrors() {
        TreeSet<MockSqlGenerator> generators = new TreeSet<MockSqlGenerator>((Comparator<MockSqlGenerator>)new SqlGeneratorComparator());
        generators.add(new MockSqlGenerator(1, "A1", "A2").addValidationError("E1"));
        SqlGeneratorChain chain = new SqlGeneratorChain(generators);
        ValidationErrors validationErrors = chain.validate((SqlStatement)new MockSqlStatement(), (Database)new MockDatabase());
        Assert.assertTrue((boolean)validationErrors.hasErrors());
    }

    @Test
    public void validate_twoGenerators_noErrors() {
        TreeSet<MockSqlGenerator> generators = new TreeSet<MockSqlGenerator>((Comparator<MockSqlGenerator>)new SqlGeneratorComparator());
        generators.add(new MockSqlGenerator(2, "B1", "B2"));
        generators.add(new MockSqlGenerator(1, "A1", "A2"));
        SqlGeneratorChain chain = new SqlGeneratorChain(generators);
        ValidationErrors validationErrors = chain.validate((SqlStatement)new MockSqlStatement(), (Database)new MockDatabase());
        Assert.assertFalse((boolean)validationErrors.hasErrors());
    }

    @Test
    public void validate_twoGenerators_firstHasErrors() {
        TreeSet<MockSqlGenerator> generators = new TreeSet<MockSqlGenerator>((Comparator<MockSqlGenerator>)new SqlGeneratorComparator());
        generators.add(new MockSqlGenerator(2, "B1", "B2").addValidationError("E1"));
        generators.add(new MockSqlGenerator(1, "A1", "A2"));
        SqlGeneratorChain chain = new SqlGeneratorChain(generators);
        ValidationErrors validationErrors = chain.validate((SqlStatement)new MockSqlStatement(), (Database)new MockDatabase());
        Assert.assertTrue((boolean)validationErrors.hasErrors());
    }

    @Test
    public void validate_twoGenerators_secondHasErrors() {
        TreeSet<MockSqlGenerator> generators = new TreeSet<MockSqlGenerator>((Comparator<MockSqlGenerator>)new SqlGeneratorComparator());
        generators.add(new MockSqlGenerator(2, "B1", "B2"));
        generators.add(new MockSqlGenerator(1, "A1", "A2").addValidationError("E1"));
        SqlGeneratorChain chain = new SqlGeneratorChain(generators);
        ValidationErrors validationErrors = chain.validate((SqlStatement)new MockSqlStatement(), (Database)new MockDatabase());
        Assert.assertTrue((boolean)validationErrors.hasErrors());
    }
}

