/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sqlgenerator;

import java.util.Collection;
import java.util.SortedSet;
import liquibase.database.Database;
import liquibase.database.core.H2Database;
import liquibase.exception.ValidationErrors;
import liquibase.exception.Warnings;
import liquibase.sql.Sql;
import liquibase.sqlgenerator.MockSqlGenerator;
import liquibase.sqlgenerator.SqlGenerator;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.sqlgenerator.core.AddAutoIncrementGenerator;
import liquibase.sqlgenerator.core.AddAutoIncrementGeneratorDB2;
import liquibase.sqlgenerator.core.AddAutoIncrementGeneratorHsqlH2;
import liquibase.sqlgenerator.core.AddColumnGenerator;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.AddAutoIncrementStatement;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlGeneratorFactoryTest {
    @After
    public void teardown() {
        SqlGeneratorFactory.reset();
    }

    @Test
    public void getInstance() {
        Assert.assertNotNull((Object)SqlGeneratorFactory.getInstance());
        Assert.assertTrue((SqlGeneratorFactory.getInstance() == SqlGeneratorFactory.getInstance() ? 1 : 0) != 0);
    }

    @Test
    public void register() {
        SqlGeneratorFactory.getInstance().getGenerators().clear();
        Assert.assertEquals((long)0L, (long)SqlGeneratorFactory.getInstance().getGenerators().size());
        SqlGeneratorFactory.getInstance().register((SqlGenerator)new MockSqlGenerator(1, "A1"));
        Assert.assertEquals((long)1L, (long)SqlGeneratorFactory.getInstance().getGenerators().size());
    }

    @Test
    public void unregister_instance() {
        SqlGeneratorFactory factory = SqlGeneratorFactory.getInstance();
        factory.getGenerators().clear();
        Assert.assertEquals((long)0L, (long)factory.getGenerators().size());
        AddAutoIncrementGeneratorHsqlH2 sqlGenerator = new AddAutoIncrementGeneratorHsqlH2();
        factory.register((SqlGenerator)new AddAutoIncrementGenerator());
        factory.register((SqlGenerator)sqlGenerator);
        factory.register((SqlGenerator)new AddAutoIncrementGeneratorDB2());
        Assert.assertEquals((long)3L, (long)factory.getGenerators().size());
        factory.unregister((SqlGenerator)sqlGenerator);
        Assert.assertEquals((long)2L, (long)factory.getGenerators().size());
    }

    @Test
    public void unregister_class() {
        SqlGeneratorFactory factory = SqlGeneratorFactory.getInstance();
        factory.getGenerators().clear();
        Assert.assertEquals((long)0L, (long)factory.getGenerators().size());
        AddAutoIncrementGeneratorHsqlH2 sqlGenerator = new AddAutoIncrementGeneratorHsqlH2();
        factory.register((SqlGenerator)new AddAutoIncrementGenerator());
        factory.register((SqlGenerator)sqlGenerator);
        factory.register((SqlGenerator)new AddAutoIncrementGeneratorDB2());
        Assert.assertEquals((long)3L, (long)factory.getGenerators().size());
        factory.unregister(AddAutoIncrementGeneratorHsqlH2.class);
        Assert.assertEquals((long)2L, (long)factory.getGenerators().size());
    }

    @Test
    public void unregister_class_doesNotExist() {
        SqlGeneratorFactory factory = SqlGeneratorFactory.getInstance();
        factory.getGenerators().clear();
        Assert.assertEquals((long)0L, (long)factory.getGenerators().size());
        factory.register((SqlGenerator)new AddAutoIncrementGenerator());
        factory.register((SqlGenerator)new AddAutoIncrementGeneratorHsqlH2());
        factory.register((SqlGenerator)new AddAutoIncrementGeneratorDB2());
        Assert.assertEquals((long)3L, (long)factory.getGenerators().size());
        factory.unregister(AddColumnGenerator.class);
        Assert.assertEquals((long)3L, (long)factory.getGenerators().size());
    }

    @Test
    public void reset() {
        SqlGeneratorFactory instance1 = SqlGeneratorFactory.getInstance();
        SqlGeneratorFactory.reset();
        Assert.assertFalse((instance1 == SqlGeneratorFactory.getInstance() ? 1 : 0) != 0);
    }

    @Test
    public void builtInGeneratorsAreFound() {
        Collection generators = SqlGeneratorFactory.getInstance().getGenerators();
        Assert.assertTrue((generators.size() > 10 ? 1 : 0) != 0);
    }

    @Test
    public void getGenerators() {
        SortedSet allGenerators = SqlGeneratorFactory.getInstance().getGenerators((SqlStatement)new AddAutoIncrementStatement(null, "person", "name", "varchar(255)", null, null), (Database)new H2Database());
        Assert.assertNotNull((Object)allGenerators);
        Assert.assertEquals((long)1L, (long)allGenerators.size());
    }

    private SqlGenerator addGenerator(final Class<? extends SqlStatement> sqlStatementClass, final Class<? extends Database> sqlDatabaseClass, final int level) {
        SqlGenerator generator = new SqlGenerator(){

            public int getPriority() {
                return level;
            }

            public boolean requiresUpdatedDatabaseMetadata(Database database) {
                return false;
            }

            public Warnings warn(SqlStatement sqlStatement, Database database, SqlGeneratorChain sqlGeneratorChain) {
                return new Warnings();
            }

            public ValidationErrors validate(SqlStatement sqlStatement, Database database, SqlGeneratorChain sqlGeneratorChain) {
                return new ValidationErrors();
            }

            public boolean supports(SqlStatement statement, Database database) {
                boolean ret = sqlStatementClass.isAssignableFrom(statement.getClass()) && sqlDatabaseClass.isAssignableFrom(database.getClass());
                return ret;
            }

            public Sql[] generateSql(SqlStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
                return new Sql[0];
            }
        };
        SqlGeneratorFactory.getInstance().register(generator);
        return generator;
    }
}

