/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sqlgenerator.core;

import java.math.BigInteger;
import liquibase.database.Database;
import liquibase.database.core.H2Database;
import liquibase.database.core.HsqlDatabase;
import liquibase.sqlgenerator.SqlGenerator;
import liquibase.sqlgenerator.core.AddAutoIncrementGeneratorHsqlH2;
import liquibase.sqlgenerator.core.AddAutoIncrementGeneratorTest;
import liquibase.statement.core.AddAutoIncrementStatement;
import liquibase.test.TestContext;
import org.junit.Test;

public class AddAutoIncrementGeneratorHsqlH2Test
extends AddAutoIncrementGeneratorTest {
    public AddAutoIncrementGeneratorHsqlH2Test() throws Exception {
        super((SqlGenerator<AddAutoIncrementStatement>)new AddAutoIncrementGeneratorHsqlH2());
    }

    protected boolean shouldBeImplementation(Database database) {
        return database instanceof HsqlDatabase || database instanceof H2Database;
    }

    @Test
    public void testAddAutoIncrement() throws Exception {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!(database instanceof H2Database) && !(database instanceof HsqlDatabase)) continue;
            super.testAddAutoIncrementStatement(database, null, null, "ALTER TABLE SCHEMA_NAME.TABLE_NAME ALTER COLUMN COLUMN_NAME BIGINT GENERATED BY DEFAULT AS IDENTITY");
        }
    }

    @Test
    public void testAddAutoIncrementStartWith() throws Exception {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!(database instanceof H2Database) && !(database instanceof HsqlDatabase)) continue;
            super.testAddAutoIncrementStatement(database, BigInteger.valueOf(2L), null, "ALTER TABLE SCHEMA_NAME.TABLE_NAME ALTER COLUMN COLUMN_NAME BIGINT GENERATED BY DEFAULT AS IDENTITY (START WITH 2)");
        }
    }

    @Test
    public void testAddAutoIncrementStartWithIncrementBy() throws Exception {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!(database instanceof H2Database) && !(database instanceof HsqlDatabase)) continue;
            super.testAddAutoIncrementStatement(database, BigInteger.valueOf(2L), BigInteger.TEN, "ALTER TABLE SCHEMA_NAME.TABLE_NAME ALTER COLUMN COLUMN_NAME BIGINT GENERATED BY DEFAULT AS IDENTITY (START WITH 2, INCREMENT BY 10)");
        }
    }
}

