/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sqlgenerator.core;

import java.math.BigInteger;
import liquibase.database.Database;
import liquibase.database.core.DerbyDatabase;
import liquibase.database.core.H2Database;
import liquibase.database.core.HsqlDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.typeconversion.TypeConverterFactory;
import liquibase.sql.Sql;
import liquibase.sqlgenerator.AbstractSqlGeneratorTest;
import liquibase.sqlgenerator.SqlGenerator;
import liquibase.sqlgenerator.core.AddAutoIncrementGenerator;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.AddAutoIncrementStatement;
import org.junit.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddAutoIncrementGeneratorTest
extends AbstractSqlGeneratorTest<AddAutoIncrementStatement> {
    protected static final String TABLE_NAME = "TABLE_NAME";
    protected static final String COLUMN_NAME = "COLUMN_NAME";
    protected static final String SCHEMA_NAME = "SCHEMA_NAME";

    public AddAutoIncrementGeneratorTest() throws Exception {
        this((SqlGenerator<AddAutoIncrementStatement>)new AddAutoIncrementGenerator());
    }

    protected AddAutoIncrementGeneratorTest(SqlGenerator<AddAutoIncrementStatement> addAutoIncrementGenerator) throws Exception {
        super(addAutoIncrementGenerator);
    }

    @Override
    protected AddAutoIncrementStatement createSampleSqlStatement() {
        return new AddAutoIncrementStatement(null, TABLE_NAME, COLUMN_NAME, null, null, null);
    }

    @Override
    protected boolean waitForException(Database database) {
        return database instanceof MSSQLDatabase;
    }

    @Override
    protected boolean shouldBeImplementation(Database database) {
        return database.supportsAutoIncrement() && !(database instanceof DerbyDatabase) && !(database instanceof MSSQLDatabase) && !(database instanceof HsqlDatabase) && !(database instanceof H2Database);
    }

    protected AddAutoIncrementStatement createAddAutoIncrementStatement(Database database, BigInteger startWith, BigInteger incrementBy) {
        AddAutoIncrementStatement statement = new AddAutoIncrementStatement(SCHEMA_NAME, TABLE_NAME, COLUMN_NAME, TypeConverterFactory.getInstance().findTypeConverter(database).getDataType("BIGINT", Boolean.valueOf(true)).toString(), startWith, incrementBy);
        return statement;
    }

    protected void testAddAutoIncrementStatement(Database database, BigInteger startWith, BigInteger incrementBy, String expectedSql) throws Exception {
        AddAutoIncrementStatement statement = this.createAddAutoIncrementStatement(database, startWith, incrementBy);
        Sql[] generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
        Assert.assertEquals((Object)expectedSql, (Object)generatedSql[0].toSql());
    }
}

