/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sqlgenerator.core;

import liquibase.database.Database;
import liquibase.database.core.DB2Database;
import liquibase.database.core.DerbyDatabase;
import liquibase.database.core.FirebirdDatabase;
import liquibase.database.core.H2Database;
import liquibase.database.core.HsqlDatabase;
import liquibase.database.core.InformixDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.SybaseASADatabase;
import liquibase.database.core.SybaseDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.sqlgenerator.MockSqlGeneratorChain;
import liquibase.sqlgenerator.SqlGenerator;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AddColumnGeneratorDefaultClauseBeforeNotNull;
import liquibase.sqlgenerator.core.AddColumnGeneratorTest;
import liquibase.statement.AutoIncrementConstraint;
import liquibase.statement.ColumnConstraint;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.AddColumnStatement;
import org.junit.Assert;
import org.junit.Test;

public class AddColumnGeneratorDefaultClauseBeforeNotNullTest
extends AddColumnGeneratorTest {
    public AddColumnGeneratorDefaultClauseBeforeNotNullTest() throws Exception {
        super((SqlGenerator<AddColumnStatement>)new AddColumnGeneratorDefaultClauseBeforeNotNull());
    }

    @Test
    public void validate_noAutoIncrementWithDerby() {
        ValidationErrors validationErrors = this.generatorUnderTest.validate((SqlStatement)new AddColumnStatement(null, "table_name", "column_name", "int", null, new ColumnConstraint[]{new AutoIncrementConstraint("column_name")}), (Database)new DerbyDatabase(), (SqlGeneratorChain)new MockSqlGeneratorChain());
        Assert.assertTrue((boolean)validationErrors.getErrorMessages().contains("Cannot add an identity column to a database"));
    }

    protected boolean shouldBeImplementation(Database database) {
        return database instanceof OracleDatabase || database instanceof HsqlDatabase || database instanceof H2Database || database instanceof DerbyDatabase || database instanceof DB2Database || database instanceof FirebirdDatabase || database instanceof SybaseASADatabase || database instanceof SybaseDatabase || database instanceof InformixDatabase;
    }
}

