/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sqlgenerator.core;

import liquibase.database.Database;
import liquibase.database.core.CacheDatabase;
import liquibase.database.core.DB2Database;
import liquibase.database.core.DerbyDatabase;
import liquibase.database.core.H2Database;
import liquibase.database.core.MySQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.SQLiteDatabase;
import liquibase.sqlgenerator.AbstractSqlGeneratorTest;
import liquibase.sqlgenerator.MockSqlGeneratorChain;
import liquibase.sqlgenerator.SqlGenerator;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AddColumnGenerator;
import liquibase.statement.AutoIncrementConstraint;
import liquibase.statement.ColumnConstraint;
import liquibase.statement.PrimaryKeyConstraint;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.AddColumnStatement;
import org.junit.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddColumnGeneratorTest
extends AbstractSqlGeneratorTest<AddColumnStatement> {
    public AddColumnGeneratorTest() throws Exception {
        this((SqlGenerator<AddColumnStatement>)new AddColumnGenerator());
    }

    protected AddColumnGeneratorTest(SqlGenerator<AddColumnStatement> generatorUnderTest) throws Exception {
        super(generatorUnderTest);
    }

    @Override
    protected AddColumnStatement createSampleSqlStatement() {
        return new AddColumnStatement(null, "table_name", "column_name", "column_type", null, new ColumnConstraint[0]);
    }

    @Override
    public void isValid() throws Exception {
        super.isValid();
        AddColumnStatement addPKColumn = new AddColumnStatement(null, "table_name", "column_name", "column_type", null, new ColumnConstraint[]{new PrimaryKeyConstraint("pk_name")});
        Assert.assertFalse((boolean)this.generatorUnderTest.validate((SqlStatement)addPKColumn, (Database)new OracleDatabase(), (SqlGeneratorChain)new MockSqlGeneratorChain()).hasErrors());
        Assert.assertTrue((boolean)this.generatorUnderTest.validate((SqlStatement)addPKColumn, (Database)new CacheDatabase(), (SqlGeneratorChain)new MockSqlGeneratorChain()).getErrorMessages().contains("Cannot add a primary key column"));
        Assert.assertTrue((boolean)this.generatorUnderTest.validate((SqlStatement)addPKColumn, (Database)new H2Database(), (SqlGeneratorChain)new MockSqlGeneratorChain()).getErrorMessages().contains("Cannot add a primary key column"));
        Assert.assertTrue((boolean)this.generatorUnderTest.validate((SqlStatement)addPKColumn, (Database)new DB2Database(), (SqlGeneratorChain)new MockSqlGeneratorChain()).getErrorMessages().contains("Cannot add a primary key column"));
        Assert.assertTrue((boolean)this.generatorUnderTest.validate((SqlStatement)addPKColumn, (Database)new DerbyDatabase(), (SqlGeneratorChain)new MockSqlGeneratorChain()).getErrorMessages().contains("Cannot add a primary key column"));
        Assert.assertTrue((boolean)this.generatorUnderTest.validate((SqlStatement)addPKColumn, (Database)new SQLiteDatabase(), (SqlGeneratorChain)new MockSqlGeneratorChain()).getErrorMessages().contains("Cannot add a primary key column"));
        Assert.assertTrue((boolean)this.generatorUnderTest.validate((SqlStatement)new AddColumnStatement(null, null, null, null, null, new ColumnConstraint[]{new AutoIncrementConstraint()}), (Database)new MySQLDatabase(), (SqlGeneratorChain)new MockSqlGeneratorChain()).getErrorMessages().contains("Cannot add a non-primary key identity column"));
        Assert.assertTrue((boolean)this.generatorUnderTest.validate((SqlStatement)new AddColumnStatement(null, null, null, null, null, new ColumnConstraint[]{new AutoIncrementConstraint()}), (Database)new MySQLDatabase(), (SqlGeneratorChain)new MockSqlGeneratorChain()).getErrorMessages().contains("Cannot add a non-primary key identity column"));
    }
}

