/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sqlgenerator.core;

import java.math.BigInteger;
import liquibase.change.ColumnConfig;
import liquibase.database.Database;
import liquibase.database.core.DB2Database;
import liquibase.database.core.DerbyDatabase;
import liquibase.database.core.H2Database;
import liquibase.database.core.HsqlDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.MySQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.database.core.SQLiteDatabase;
import liquibase.database.core.SybaseASADatabase;
import liquibase.database.core.SybaseDatabase;
import liquibase.database.structure.type.DataType;
import liquibase.database.structure.type.IntType;
import liquibase.database.typeconversion.TypeConverterFactory;
import liquibase.sql.Sql;
import liquibase.sqlgenerator.AbstractSqlGeneratorTest;
import liquibase.sqlgenerator.core.CreateTableGenerator;
import liquibase.statement.AutoIncrementConstraint;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.CreateTableStatement;
import liquibase.test.TestContext;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateTableGeneratorTest
extends AbstractSqlGeneratorTest<CreateTableStatement> {
    protected static final String TABLE_NAME = "TABLE_NAME";
    protected static final String SCHEMA_NAME = "SCHEMA_NAME";
    protected static final String COLUMN_NAME1 = "COLUMN1_NAME";

    public CreateTableGeneratorTest() throws Exception {
        super(new CreateTableGenerator());
    }

    @Override
    protected CreateTableStatement createSampleSqlStatement() {
        CreateTableStatement statement = new CreateTableStatement(SCHEMA_NAME, TABLE_NAME);
        statement.addColumn(COLUMN_NAME1, (DataType)new IntType());
        return statement;
    }

    @Test
    public void testWithColumnWithDefaultValue() {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!(database instanceof OracleDatabase)) continue;
            CreateTableStatement statement = new CreateTableStatement(SCHEMA_NAME, TABLE_NAME);
            statement.addColumn(COLUMN_NAME1, TypeConverterFactory.getInstance().findTypeConverter(database).getDataType("java.sql.Types.TIMESTAMP", Boolean.valueOf(false)), new ColumnConfig().setDefaultValue("null").getDefaultValueObject());
            if (!this.shouldBeImplementation(database)) continue;
            Assert.assertEquals((Object)"CREATE TABLE SCHEMA_NAME.TABLE_NAME (COLUMN1_NAME TIMESTAMP DEFAULT null)", (Object)this.generatorUnderTest.generateSql((SqlStatement)statement, database, null)[0].toSql());
        }
    }

    @Test
    public void testWithColumnSpecificIntType() {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            CreateTableStatement statement = new CreateTableStatement(SCHEMA_NAME, TABLE_NAME);
            statement.addColumn(COLUMN_NAME1, TypeConverterFactory.getInstance().findTypeConverter(database).getDataType("int(11) unsigned", Boolean.valueOf(false)));
            if (!(database instanceof MySQLDatabase)) continue;
            Assert.assertEquals((Object)"CREATE TABLE `SCHEMA_NAME`.`TABLE_NAME` (`COLUMN1_NAME` INT(11) unsigned)", (Object)this.generatorUnderTest.generateSql((SqlStatement)statement, database, null)[0].toSql());
        }
    }

    @Test
    public void testAutoIncrementDB2Database() throws Exception {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!(database instanceof DB2Database)) continue;
            CreateTableStatement statement = new CreateTableStatement(SCHEMA_NAME, TABLE_NAME);
            statement.addColumn(COLUMN_NAME1, TypeConverterFactory.getInstance().findTypeConverter(database).getDataType("BIGINT", Boolean.valueOf(true)), (Object)new AutoIncrementConstraint(COLUMN_NAME1));
            Sql[] generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
            Assert.assertEquals((Object)"CREATE TABLE SCHEMA_NAME.TABLE_NAME (COLUMN1_NAME BIGINT GENERATED BY DEFAULT AS IDENTITY)", (Object)generatedSql[0].toSql());
        }
    }

    @Test
    public void testAutoIncrementStartWithDB2Database() throws Exception {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!(database instanceof DB2Database)) continue;
            CreateTableStatement statement = new CreateTableStatement(SCHEMA_NAME, TABLE_NAME);
            statement.addColumn(COLUMN_NAME1, TypeConverterFactory.getInstance().findTypeConverter(database).getDataType("BIGINT", Boolean.valueOf(true)), (Object)new AutoIncrementConstraint(COLUMN_NAME1, BigInteger.ZERO, null));
            Sql[] generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
            Assert.assertEquals((Object)"CREATE TABLE SCHEMA_NAME.TABLE_NAME (COLUMN1_NAME BIGINT GENERATED BY DEFAULT AS IDENTITY (START WITH 0))", (Object)generatedSql[0].toSql());
        }
    }

    @Test
    public void testAutoIncrementStartWithIncrementByDB2Database() throws Exception {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!(database instanceof DB2Database)) continue;
            CreateTableStatement statement = new CreateTableStatement(SCHEMA_NAME, TABLE_NAME);
            statement.addColumn(COLUMN_NAME1, TypeConverterFactory.getInstance().findTypeConverter(database).getDataType("BIGINT", Boolean.valueOf(true)), (Object)new AutoIncrementConstraint(COLUMN_NAME1, BigInteger.ZERO, BigInteger.TEN));
            Sql[] generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
            Assert.assertEquals((Object)"CREATE TABLE SCHEMA_NAME.TABLE_NAME (COLUMN1_NAME BIGINT GENERATED BY DEFAULT AS IDENTITY (START WITH 0, INCREMENT BY 10))", (Object)generatedSql[0].toSql());
        }
    }

    @Test
    public void testAutoIncrementDerbyDatabase() throws Exception {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!(database instanceof DerbyDatabase)) continue;
            CreateTableStatement statement = new CreateTableStatement(SCHEMA_NAME, TABLE_NAME);
            statement.addColumn(COLUMN_NAME1, TypeConverterFactory.getInstance().findTypeConverter(database).getDataType("BIGINT", Boolean.valueOf(true)), (Object)new AutoIncrementConstraint(COLUMN_NAME1));
            Sql[] generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
            Assert.assertEquals((Object)"CREATE TABLE SCHEMA_NAME.TABLE_NAME (COLUMN1_NAME BIGINT GENERATED BY DEFAULT AS IDENTITY)", (Object)generatedSql[0].toSql());
        }
    }

    @Test
    public void testAutoIncrementStartWithDerbyDatabase() throws Exception {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!(database instanceof DerbyDatabase)) continue;
            CreateTableStatement statement = new CreateTableStatement(SCHEMA_NAME, TABLE_NAME);
            statement.addColumn(COLUMN_NAME1, TypeConverterFactory.getInstance().findTypeConverter(database).getDataType("BIGINT", Boolean.valueOf(true)), (Object)new AutoIncrementConstraint(COLUMN_NAME1, BigInteger.ZERO, null));
            Sql[] generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
            Assert.assertEquals((Object)"CREATE TABLE SCHEMA_NAME.TABLE_NAME (COLUMN1_NAME BIGINT GENERATED BY DEFAULT AS IDENTITY (START WITH 0))", (Object)generatedSql[0].toSql());
        }
    }

    @Test
    public void testAutoIncrementStartWithIncrementByDerbyDatabase() throws Exception {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!(database instanceof DerbyDatabase)) continue;
            CreateTableStatement statement = new CreateTableStatement(SCHEMA_NAME, TABLE_NAME);
            statement.addColumn(COLUMN_NAME1, TypeConverterFactory.getInstance().findTypeConverter(database).getDataType("BIGINT", Boolean.valueOf(true)), (Object)new AutoIncrementConstraint(COLUMN_NAME1, BigInteger.ZERO, BigInteger.TEN));
            Sql[] generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
            Assert.assertEquals((Object)"CREATE TABLE SCHEMA_NAME.TABLE_NAME (COLUMN1_NAME BIGINT GENERATED BY DEFAULT AS IDENTITY (START WITH 0, INCREMENT BY 10))", (Object)generatedSql[0].toSql());
        }
    }

    @Test
    public void testAutoIncrementH2Database() throws Exception {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!(database instanceof H2Database)) continue;
            CreateTableStatement statement = new CreateTableStatement(SCHEMA_NAME, TABLE_NAME);
            statement.addColumn(COLUMN_NAME1, TypeConverterFactory.getInstance().findTypeConverter(database).getDataType("BIGINT", Boolean.valueOf(true)), (Object)new AutoIncrementConstraint(COLUMN_NAME1));
            Sql[] generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
            Assert.assertEquals((Object)"CREATE TABLE SCHEMA_NAME.TABLE_NAME (COLUMN1_NAME BIGINT GENERATED BY DEFAULT AS IDENTITY)", (Object)generatedSql[0].toSql());
        }
    }

    @Test
    public void testAutoIncrementStartWithH2Database() throws Exception {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!(database instanceof H2Database)) continue;
            CreateTableStatement statement = new CreateTableStatement(SCHEMA_NAME, TABLE_NAME);
            statement.addColumn(COLUMN_NAME1, TypeConverterFactory.getInstance().findTypeConverter(database).getDataType("BIGINT", Boolean.valueOf(true)), (Object)new AutoIncrementConstraint(COLUMN_NAME1, BigInteger.ZERO, null));
            Sql[] generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
            Assert.assertEquals((Object)"CREATE TABLE SCHEMA_NAME.TABLE_NAME (COLUMN1_NAME BIGINT GENERATED BY DEFAULT AS IDENTITY (START WITH 0))", (Object)generatedSql[0].toSql());
        }
    }

    @Test
    public void testAutoIncrementStartWithIncrementByH2Database() throws Exception {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!(database instanceof H2Database)) continue;
            CreateTableStatement statement = new CreateTableStatement(SCHEMA_NAME, TABLE_NAME);
            statement.addColumn(COLUMN_NAME1, TypeConverterFactory.getInstance().findTypeConverter(database).getDataType("BIGINT", Boolean.valueOf(true)), (Object)new AutoIncrementConstraint(COLUMN_NAME1, BigInteger.ZERO, BigInteger.TEN));
            Sql[] generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
            Assert.assertEquals((Object)"CREATE TABLE SCHEMA_NAME.TABLE_NAME (COLUMN1_NAME BIGINT GENERATED BY DEFAULT AS IDENTITY (START WITH 0, INCREMENT BY 10))", (Object)generatedSql[0].toSql());
        }
    }

    @Test
    public void testAutoIncrementHsqlDatabase() throws Exception {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!(database instanceof HsqlDatabase)) continue;
            CreateTableStatement statement = new CreateTableStatement(SCHEMA_NAME, TABLE_NAME);
            statement.addColumn(COLUMN_NAME1, TypeConverterFactory.getInstance().findTypeConverter(database).getDataType("BIGINT", Boolean.valueOf(true)), (Object)new AutoIncrementConstraint(COLUMN_NAME1));
            Sql[] generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
            Assert.assertEquals((Object)"CREATE TABLE SCHEMA_NAME.TABLE_NAME (COLUMN1_NAME BIGINT GENERATED BY DEFAULT AS IDENTITY)", (Object)generatedSql[0].toSql());
        }
    }

    @Test
    public void testAutoIncrementStartWithHsqlDatabase() throws Exception {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!(database instanceof HsqlDatabase)) continue;
            CreateTableStatement statement = new CreateTableStatement(SCHEMA_NAME, TABLE_NAME);
            statement.addColumn(COLUMN_NAME1, TypeConverterFactory.getInstance().findTypeConverter(database).getDataType("BIGINT", Boolean.valueOf(true)), (Object)new AutoIncrementConstraint(COLUMN_NAME1, BigInteger.ONE, null));
            Sql[] generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
            Assert.assertEquals((Object)"CREATE TABLE SCHEMA_NAME.TABLE_NAME (COLUMN1_NAME BIGINT GENERATED BY DEFAULT AS IDENTITY (START WITH 1))", (Object)generatedSql[0].toSql());
        }
    }

    @Test
    public void testAutoIncrementStartWithIncrementByHsqlDatabase() throws Exception {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!(database instanceof HsqlDatabase)) continue;
            CreateTableStatement statement = new CreateTableStatement(SCHEMA_NAME, TABLE_NAME);
            statement.addColumn(COLUMN_NAME1, TypeConverterFactory.getInstance().findTypeConverter(database).getDataType("BIGINT", Boolean.valueOf(true)), (Object)new AutoIncrementConstraint(COLUMN_NAME1, BigInteger.ONE, BigInteger.TEN));
            Sql[] generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
            Assert.assertEquals((Object)"CREATE TABLE SCHEMA_NAME.TABLE_NAME (COLUMN1_NAME BIGINT GENERATED BY DEFAULT AS IDENTITY (START WITH 1, INCREMENT BY 10))", (Object)generatedSql[0].toSql());
        }
    }

    @Test
    public void testAutoIncrementMSSQLDatabase() throws Exception {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!(database instanceof MSSQLDatabase)) continue;
            CreateTableStatement statement = new CreateTableStatement(SCHEMA_NAME, TABLE_NAME);
            statement.addColumn(COLUMN_NAME1, TypeConverterFactory.getInstance().findTypeConverter(database).getDataType("BIGINT", Boolean.valueOf(true)), (Object)new AutoIncrementConstraint(COLUMN_NAME1));
            Sql[] generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
            Assert.assertEquals((Object)"CREATE TABLE [SCHEMA_NAME].[TABLE_NAME] ([COLUMN1_NAME] BIGINT IDENTITY)", (Object)generatedSql[0].toSql());
        }
    }

    @Test
    public void testAutoIncrementStartWithMSSQLDatabase() throws Exception {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!(database instanceof MSSQLDatabase)) continue;
            CreateTableStatement statement = new CreateTableStatement(SCHEMA_NAME, TABLE_NAME);
            statement.addColumn(COLUMN_NAME1, TypeConverterFactory.getInstance().findTypeConverter(database).getDataType("BIGINT", Boolean.valueOf(true)), (Object)new AutoIncrementConstraint(COLUMN_NAME1, BigInteger.ZERO, null));
            Sql[] generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
            Assert.assertEquals((Object)"CREATE TABLE [SCHEMA_NAME].[TABLE_NAME] ([COLUMN1_NAME] BIGINT IDENTITY (0))", (Object)generatedSql[0].toSql());
        }
    }

    @Test
    public void testAutoIncrementStartWithIncrementByMSSQLDatabase() throws Exception {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!(database instanceof MSSQLDatabase)) continue;
            CreateTableStatement statement = new CreateTableStatement(SCHEMA_NAME, TABLE_NAME);
            statement.addColumn(COLUMN_NAME1, TypeConverterFactory.getInstance().findTypeConverter(database).getDataType("BIGINT", Boolean.valueOf(true)), (Object)new AutoIncrementConstraint(COLUMN_NAME1, BigInteger.ZERO, BigInteger.TEN));
            Sql[] generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
            Assert.assertEquals((Object)"CREATE TABLE [SCHEMA_NAME].[TABLE_NAME] ([COLUMN1_NAME] BIGINT IDENTITY (0, 10))", (Object)generatedSql[0].toSql());
        }
    }

    @Test
    public void testAutoIncrementMySQLDatabase() throws Exception {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!(database instanceof MySQLDatabase)) continue;
            CreateTableStatement statement = new CreateTableStatement(SCHEMA_NAME, TABLE_NAME);
            statement.addColumn(COLUMN_NAME1, TypeConverterFactory.getInstance().findTypeConverter(database).getDataType("BIGINT", Boolean.valueOf(true)), (Object)new AutoIncrementConstraint(COLUMN_NAME1));
            Sql[] generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
            Assert.assertEquals((Object)"CREATE TABLE `SCHEMA_NAME`.`TABLE_NAME` (`COLUMN1_NAME` BIGINT AUTO_INCREMENT)", (Object)generatedSql[0].toSql());
        }
    }

    @Test
    public void testAutoIncrementStartWithMySQLDatabase() throws Exception {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!(database instanceof MySQLDatabase)) continue;
            CreateTableStatement statement = new CreateTableStatement(SCHEMA_NAME, TABLE_NAME);
            statement.addColumn(COLUMN_NAME1, TypeConverterFactory.getInstance().findTypeConverter(database).getDataType("BIGINT", Boolean.valueOf(true)), (Object)new AutoIncrementConstraint(COLUMN_NAME1, BigInteger.valueOf(2L), null));
            Sql[] generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
            Assert.assertEquals((Object)"CREATE TABLE `SCHEMA_NAME`.`TABLE_NAME` (`COLUMN1_NAME` BIGINT AUTO_INCREMENT=2)", (Object)generatedSql[0].toSql());
        }
    }

    @Test
    public void testAutoIncrementStartWithIncrementByMySQLDatabase() throws Exception {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!(database instanceof MySQLDatabase)) continue;
            CreateTableStatement statement = new CreateTableStatement(SCHEMA_NAME, TABLE_NAME);
            statement.addColumn(COLUMN_NAME1, TypeConverterFactory.getInstance().findTypeConverter(database).getDataType("BIGINT", Boolean.valueOf(true)), (Object)new AutoIncrementConstraint(COLUMN_NAME1, BigInteger.valueOf(2L), BigInteger.TEN));
            Sql[] generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
            Assert.assertEquals((Object)"CREATE TABLE `SCHEMA_NAME`.`TABLE_NAME` (`COLUMN1_NAME` BIGINT AUTO_INCREMENT=2)", (Object)generatedSql[0].toSql());
        }
    }

    @Test
    public void testAutoIncrementPostgresDatabase() throws Exception {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!(database instanceof PostgresDatabase)) continue;
            CreateTableStatement statement = new CreateTableStatement(SCHEMA_NAME, TABLE_NAME);
            statement.addColumn(COLUMN_NAME1, TypeConverterFactory.getInstance().findTypeConverter(database).getDataType("BIGINT", Boolean.valueOf(true)), (Object)new AutoIncrementConstraint(COLUMN_NAME1));
            Sql[] generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
            Assert.assertEquals((Object)"CREATE TABLE SCHEMA_NAME.TABLE_NAME (COLUMN1_NAME bigserial)", (Object)generatedSql[0].toSql());
        }
    }

    @Test
    public void testAutoIncrementStartWithPostgresDatabase() throws Exception {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!(database instanceof PostgresDatabase)) continue;
            CreateTableStatement statement = new CreateTableStatement(SCHEMA_NAME, TABLE_NAME);
            statement.addColumn(COLUMN_NAME1, TypeConverterFactory.getInstance().findTypeConverter(database).getDataType("BIGINT", Boolean.valueOf(true)), (Object)new AutoIncrementConstraint(COLUMN_NAME1, BigInteger.ZERO, null));
            Sql[] generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
            Assert.assertEquals((Object)"CREATE TABLE SCHEMA_NAME.TABLE_NAME (COLUMN1_NAME bigserial)", (Object)generatedSql[0].toSql());
        }
    }

    @Test
    public void testAutoIncrementStartWithIncrementByPostgresDatabase() throws Exception {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!(database instanceof PostgresDatabase)) continue;
            CreateTableStatement statement = new CreateTableStatement(SCHEMA_NAME, TABLE_NAME);
            statement.addColumn(COLUMN_NAME1, TypeConverterFactory.getInstance().findTypeConverter(database).getDataType("BIGINT", Boolean.valueOf(true)), (Object)new AutoIncrementConstraint(COLUMN_NAME1, BigInteger.ZERO, BigInteger.TEN));
            Sql[] generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
            Assert.assertEquals((Object)"CREATE TABLE SCHEMA_NAME.TABLE_NAME (COLUMN1_NAME bigserial)", (Object)generatedSql[0].toSql());
        }
    }

    @Test
    public void testAutoIncrementSQLiteDatabase() throws Exception {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!(database instanceof SQLiteDatabase)) continue;
            CreateTableStatement statement = new CreateTableStatement(SCHEMA_NAME, TABLE_NAME);
            statement.addColumn(COLUMN_NAME1, TypeConverterFactory.getInstance().findTypeConverter(database).getDataType("BIGINT", Boolean.valueOf(true)), (Object)new AutoIncrementConstraint(COLUMN_NAME1));
            Sql[] generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
            Assert.assertEquals((Object)"CREATE TABLE SCHEMA_NAME.TABLE_NAME (COLUMN1_NAME BIGINT AUTOINCREMENT)", (Object)generatedSql[0].toSql());
        }
    }

    @Test
    public void testAutoIncrementStartWithSQLiteDatabase() throws Exception {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!(database instanceof SQLiteDatabase)) continue;
            CreateTableStatement statement = new CreateTableStatement(SCHEMA_NAME, TABLE_NAME);
            statement.addColumn(COLUMN_NAME1, TypeConverterFactory.getInstance().findTypeConverter(database).getDataType("BIGINT", Boolean.valueOf(true)), (Object)new AutoIncrementConstraint(COLUMN_NAME1, BigInteger.valueOf(2L), null));
            Sql[] generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
            Assert.assertEquals((Object)"CREATE TABLE SCHEMA_NAME.TABLE_NAME (COLUMN1_NAME BIGINT AUTOINCREMENT)", (Object)generatedSql[0].toSql());
        }
    }

    @Test
    public void testAutoIncrementStartWithIncrementBySQLiteDatabase() throws Exception {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!(database instanceof SQLiteDatabase)) continue;
            CreateTableStatement statement = new CreateTableStatement(SCHEMA_NAME, TABLE_NAME);
            statement.addColumn(COLUMN_NAME1, TypeConverterFactory.getInstance().findTypeConverter(database).getDataType("BIGINT", Boolean.valueOf(true)), (Object)new AutoIncrementConstraint(COLUMN_NAME1, BigInteger.valueOf(2L), BigInteger.TEN));
            Sql[] generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
            Assert.assertEquals((Object)"CREATE TABLE SCHEMA_NAME.TABLE_NAME (COLUMN1_NAME BIGINT AUTOINCREMENT)", (Object)generatedSql[0].toSql());
        }
    }

    @Test
    public void testAutoIncrementSybaseASADatabase() throws Exception {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!(database instanceof SybaseASADatabase)) continue;
            CreateTableStatement statement = new CreateTableStatement(SCHEMA_NAME, TABLE_NAME);
            statement.addColumn(COLUMN_NAME1, TypeConverterFactory.getInstance().findTypeConverter(database).getDataType("BIGINT", Boolean.valueOf(true)), (Object)new AutoIncrementConstraint(COLUMN_NAME1));
            Sql[] generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
            Assert.assertEquals((Object)"CREATE TABLE \"SCHEMA_NAME\".\"TABLE_NAME\" (\"COLUMN1_NAME\" BIGINT DEFAULT AUTOINCREMENT NULL)", (Object)generatedSql[0].toSql());
        }
    }

    @Test
    public void testAutoIncrementStartWithSybaseASADatabase() throws Exception {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!(database instanceof SybaseASADatabase)) continue;
            CreateTableStatement statement = new CreateTableStatement(SCHEMA_NAME, TABLE_NAME);
            statement.addColumn(COLUMN_NAME1, TypeConverterFactory.getInstance().findTypeConverter(database).getDataType("BIGINT", Boolean.valueOf(true)), (Object)new AutoIncrementConstraint(COLUMN_NAME1, BigInteger.valueOf(2L), null));
            Sql[] generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
            Assert.assertEquals((Object)"CREATE TABLE \"SCHEMA_NAME\".\"TABLE_NAME\" (\"COLUMN1_NAME\" BIGINT DEFAULT AUTOINCREMENT NULL)", (Object)generatedSql[0].toSql());
        }
    }

    @Test
    public void testAutoIncrementStartWithIncrementBySybaseASADatabase() throws Exception {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!(database instanceof SybaseASADatabase)) continue;
            CreateTableStatement statement = new CreateTableStatement(SCHEMA_NAME, TABLE_NAME);
            statement.addColumn(COLUMN_NAME1, TypeConverterFactory.getInstance().findTypeConverter(database).getDataType("BIGINT", Boolean.valueOf(true)), (Object)new AutoIncrementConstraint(COLUMN_NAME1, BigInteger.valueOf(2L), BigInteger.TEN));
            Sql[] generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
            Assert.assertEquals((Object)"CREATE TABLE \"SCHEMA_NAME\".\"TABLE_NAME\" (\"COLUMN1_NAME\" BIGINT DEFAULT AUTOINCREMENT NULL)", (Object)generatedSql[0].toSql());
        }
    }

    @Test
    public void testAutoIncrementSybaseDatabase() throws Exception {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!(database instanceof SybaseDatabase)) continue;
            CreateTableStatement statement = new CreateTableStatement(SCHEMA_NAME, TABLE_NAME);
            statement.addColumn(COLUMN_NAME1, TypeConverterFactory.getInstance().findTypeConverter(database).getDataType("BIGINT", Boolean.valueOf(true)), (Object)new AutoIncrementConstraint(COLUMN_NAME1));
            Sql[] generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
            Assert.assertEquals((Object)"CREATE TABLE [SCHEMA_NAME].[TABLE_NAME] ([COLUMN1_NAME] BIGINT IDENTITY NULL)", (Object)generatedSql[0].toSql());
        }
    }

    @Test
    public void testAutoIncrementStartWithSybaseDatabase() throws Exception {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!(database instanceof SybaseDatabase)) continue;
            CreateTableStatement statement = new CreateTableStatement(SCHEMA_NAME, TABLE_NAME);
            statement.addColumn(COLUMN_NAME1, TypeConverterFactory.getInstance().findTypeConverter(database).getDataType("BIGINT", Boolean.valueOf(true)), (Object)new AutoIncrementConstraint(COLUMN_NAME1, BigInteger.valueOf(2L), null));
            Sql[] generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
            Assert.assertEquals((Object)"CREATE TABLE [SCHEMA_NAME].[TABLE_NAME] ([COLUMN1_NAME] BIGINT IDENTITY NULL)", (Object)generatedSql[0].toSql());
        }
    }

    @Test
    public void testAutoIncrementStartWithIncrementBySybaseDatabase() throws Exception {
        for (Database database : TestContext.getInstance().getAllDatabases()) {
            if (!(database instanceof SybaseDatabase)) continue;
            CreateTableStatement statement = new CreateTableStatement(SCHEMA_NAME, TABLE_NAME);
            statement.addColumn(COLUMN_NAME1, TypeConverterFactory.getInstance().findTypeConverter(database).getDataType("BIGINT", Boolean.valueOf(true)), (Object)new AutoIncrementConstraint(COLUMN_NAME1, BigInteger.valueOf(2L), BigInteger.TEN));
            Sql[] generatedSql = this.generatorUnderTest.generateSql((SqlStatement)statement, database, null);
            Assert.assertEquals((Object)"CREATE TABLE [SCHEMA_NAME].[TABLE_NAME] ([COLUMN1_NAME] BIGINT IDENTITY NULL)", (Object)generatedSql[0].toSql());
        }
    }
}

