/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sqlgenerator.core;

import java.util.TreeSet;
import junit.framework.Assert;
import liquibase.database.Database;
import liquibase.database.core.PostgresDatabase;
import liquibase.sql.Sql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.DropIndexGenerator;
import liquibase.statement.core.DropIndexStatement;
import org.junit.Test;

public class DropIndexGeneratorTest {
    @Test
    public void shouldDropIndexInPostgreSQL() throws Exception {
        DropIndexGenerator dropIndexGenerator = new DropIndexGenerator();
        DropIndexStatement statement = new DropIndexStatement("indexName", "defaultSchema", "aTable", null);
        PostgresDatabase database = new PostgresDatabase();
        TreeSet sqlGenerators = new TreeSet();
        SqlGeneratorChain sqlGenerationChain = new SqlGeneratorChain(sqlGenerators);
        Sql[] sqls = dropIndexGenerator.generateSql(statement, (Database)database, sqlGenerationChain);
        Assert.assertEquals((String)"DROP INDEX \"defaultSchema\".\"indexName\"", (String)sqls[0].toSql());
        statement = new DropIndexStatement("index_name", "default_schema", "a_table", null);
        sqls = dropIndexGenerator.generateSql(statement, (Database)database, sqlGenerationChain);
        Assert.assertEquals((String)"DROP INDEX default_schema.index_name", (String)sqls[0].toSql());
        statement = new DropIndexStatement("index_name", null, "a_table", null);
        sqls = dropIndexGenerator.generateSql(statement, (Database)database, sqlGenerationChain);
        Assert.assertEquals((String)"DROP INDEX index_name", (String)sqls[0].toSql());
    }
}

