/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sqlgenerator.core;

import liquibase.database.Database;
import liquibase.database.core.OracleDatabase;
import liquibase.sql.Sql;
import liquibase.sqlgenerator.core.InsertOrUpdateGeneratorOracle;
import liquibase.statement.core.InsertOrUpdateStatement;
import org.junit.Assert;
import org.junit.Test;

public class InsertOrUpdateGeneratorOracleTest {
    @Test
    public void ContainsInsertStatement() {
        OracleDatabase database = new OracleDatabase();
        InsertOrUpdateGeneratorOracle generator = new InsertOrUpdateGeneratorOracle();
        InsertOrUpdateStatement statement = new InsertOrUpdateStatement("myschema", "mytable", "pk_col1");
        statement.addColumnValue("pk_col1", (Object)"value1");
        statement.addColumnValue("col2", (Object)"value2");
        Sql[] sql = generator.generateSql(statement, (Database)database, null);
        String theSql = sql[0].toSql();
        junit.framework.Assert.assertTrue((boolean)theSql.contains("INSERT INTO myschema.mytable (col2, pk_col1) VALUES ('value2', 'value1');"));
        junit.framework.Assert.assertTrue((boolean)theSql.contains("UPDATE myschema.mytable"));
        String[] sqlLines = theSql.split("\n");
        int lineToCheck = 0;
        Assert.assertEquals((Object)"DECLARE", (Object)sqlLines[lineToCheck].trim());
        Assert.assertEquals((Object)"v_reccount NUMBER := 0;", (Object)sqlLines[++lineToCheck].trim());
        Assert.assertEquals((Object)"BEGIN", (Object)sqlLines[++lineToCheck].trim());
        Assert.assertEquals((Object)"SELECT COUNT(*) INTO v_reccount FROM myschema.mytable WHERE pk_col1 = 'value1';", (Object)sqlLines[++lineToCheck].trim());
        Assert.assertEquals((Object)"IF v_reccount = 0 THEN", (Object)sqlLines[++lineToCheck].trim());
        Assert.assertEquals((Object)"INSERT INTO myschema.mytable (col2, pk_col1) VALUES ('value2', 'value1');", (Object)sqlLines[++lineToCheck]);
        Assert.assertEquals((Object)"ELSIF v_reccount = 1 THEN", (Object)sqlLines[++lineToCheck].trim());
        Assert.assertEquals((Object)"UPDATE myschema.mytable SET col2 = 'value2' WHERE pk_col1 = 'value1';", (Object)sqlLines[++lineToCheck].trim());
        Assert.assertEquals((Object)"END IF;", (Object)sqlLines[++lineToCheck].trim());
        Assert.assertEquals((Object)"END;", (Object)sqlLines[++lineToCheck].trim());
    }
}

