/*
 * Decompiled with CFR 0.152.
 */
package liquibase.test;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import liquibase.resource.ResourceAccessor;
import liquibase.test.TestContext;
import liquibase.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JUnitResourceAccessor
implements ResourceAccessor {
    private URLClassLoader classLoader;

    public JUnitResourceAccessor() throws Exception {
        File srcDir = new File(TestContext.getInstance().findCoreProjectRoot(), "src");
        File integrationClassesDir = new File(TestContext.getInstance().findIntegrationTestProjectRoot(), "target/classes");
        File integrationTestClassesDir = new File(TestContext.getInstance().findIntegrationTestProjectRoot(), "target/test-classes");
        this.classLoader = new URLClassLoader(new URL[]{new File(TestContext.getInstance().findIntegrationTestProjectRoot(), "src/test/resources/packaged-changelog.jar").toURL(), new File(System.getProperty("java.io.tmpdir")).toURL()});
    }

    public InputStream getResourceAsStream(String file) throws IOException {
        return this.classLoader.getResourceAsStream(file);
    }

    public Enumeration<URL> getResources(String packageName) throws IOException {
        return this.classLoader.getResources(packageName);
    }

    public ClassLoader toClassLoader() {
        return this.classLoader;
    }

    public String toString() {
        ArrayList<String> urls = new ArrayList<String>();
        for (URL url : this.classLoader.getURLs()) {
            urls.add(url.toExternalForm());
        }
        return this.getClass().getName() + "(" + StringUtils.join(urls, (String)",") + ")";
    }
}

