/*
 * Decompiled with CFR 0.152.
 */
package liquibase.test;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import liquibase.database.Database;
import liquibase.database.DatabaseFactory;
import liquibase.database.core.MockDatabase;
import liquibase.database.core.SQLiteDatabase;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestContext {
    private static TestContext instance = new TestContext();
    private Set<Database> allDatabases;
    private ResourceAccessor resourceAccessor;

    public static TestContext getInstance() {
        return instance;
    }

    public Set<Database> getAllDatabases() {
        if (this.allDatabases == null) {
            this.allDatabases = new HashSet<Database>();
            this.allDatabases.addAll(DatabaseFactory.getInstance().getImplementedDatabases());
            ArrayList<Database> toRemove = new ArrayList<Database>();
            for (Database database : this.allDatabases) {
                if (database instanceof SQLiteDatabase || database instanceof MockDatabase) {
                    toRemove.add(database);
                }
                database.setCanCacheLiquibaseTableInfo(false);
            }
            this.allDatabases.removeAll(toRemove);
        }
        return this.allDatabases;
    }

    public File findCoreJvmProjectRoot() throws URISyntaxException {
        return new File(this.findCoreProjectRoot().getParentFile(), "liquibase-core");
    }

    public File findIntegrationTestProjectRoot() throws URISyntaxException {
        return new File(this.findCoreProjectRoot().getParentFile(), "liquibase-integration-tests");
    }

    public File findCoreProjectRoot() throws URISyntaxException {
        URI uri = new URI(this.getClass().getClassLoader().getResource("liquibase/test/TestContext.class").toExternalForm());
        if (!uri.isOpaque()) {
            File thisClassFile = new File(uri);
            return thisClassFile.getParentFile().getParentFile().getParentFile().getParentFile().getParentFile();
        }
        uri = new URI(this.getClass().getClassLoader().getResource("liquibase/integration/commandline/Main.class").toExternalForm());
        if (!uri.isOpaque()) {
            File thisClassFile = new File(uri);
            return new File(thisClassFile.getParentFile().getParentFile().getParentFile().getParentFile().getParentFile().getParentFile(), "liquibase-core");
        }
        uri = new URI(this.getClass().getClassLoader().getResource("liquibase/test/DatabaseTest.class").toExternalForm());
        if (!uri.isOpaque()) {
            File thisClassFile = new File(uri);
            return new File(thisClassFile.getParentFile().getParentFile().getParentFile().getParentFile().getParentFile().getParentFile(), "liquibase-core");
        }
        throw new IllegalStateException("Cannot find liquibase-core project root");
    }

    public ResourceAccessor getTestResourceAccessor() throws URISyntaxException, MalformedURLException {
        if (this.resourceAccessor == null) {
            File integrationJarsDir = new File(TestContext.getInstance().findIntegrationTestProjectRoot(), "src/test/resources/ext/jars");
            this.resourceAccessor = new ClassLoaderResourceAccessor((ClassLoader)new URLClassLoader(new URL[]{new File(TestContext.getInstance().findCoreJvmProjectRoot(), "/target/classes").toURL(), new File(TestContext.getInstance().findCoreProjectRoot(), "/target/classes").toURL()}));
        }
        return this.resourceAccessor;
    }
}

