/*
 * Decompiled with CFR 0.152.
 */
package liquibase.util;

import java.util.regex.PatternSyntaxException;
import liquibase.util.RegexMatcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class RegexMatcherTest {
    private RegexMatcher matcher;
    private static final String text = "Pulp Fiction\nReservoir Dogs\nKill Bill\n";

    @After
    public void tearDown() {
        this.matcher = null;
    }

    @Test(expected=PatternSyntaxException.class)
    public void testBadPatternFails() {
        this.matcher = new RegexMatcher(text, new String[]{"a(j"});
    }

    @Test
    public void testMatchingInSequentialOrder() {
        this.matcher = new RegexMatcher(text, new String[]{"Pulp", "Reservoir", "Kill"});
        Assert.assertTrue((String)"All matched", (boolean)this.matcher.allMatchedInSequentialOrder());
        this.matcher = new RegexMatcher(text, new String[]{"Pulp", "ion"});
        Assert.assertTrue((String)"All matched", (boolean)this.matcher.allMatchedInSequentialOrder());
        this.matcher = new RegexMatcher(text, new String[]{"Pu.p", "^Ki.+ll$"});
        Assert.assertTrue((String)"All matched", (boolean)this.matcher.allMatchedInSequentialOrder());
        this.matcher = new RegexMatcher(text, new String[]{"pulP", "kiLL"});
        Assert.assertTrue((String)"Case insensitive", (boolean)this.matcher.allMatchedInSequentialOrder());
        this.matcher = new RegexMatcher(text, new String[]{"Reservoir", "Pulp", "Dogs"});
        Assert.assertFalse((String)"Not in order", (boolean)this.matcher.allMatchedInSequentialOrder());
        this.matcher = new RegexMatcher(text, new String[]{"Memento"});
        Assert.assertFalse((String)"Not found", (boolean)this.matcher.allMatchedInSequentialOrder());
    }
}

