/*
 * Decompiled with CFR 0.152.
 */
package liquibase.util;

import liquibase.util.StringUtils;
import org.junit.Assert;
import org.junit.Test;

public class StringUtilsTest {
    @Test
    public void windowsDelimiter() {
        String sql = "/*\nThis is a test comment of MS-SQL script\n*/\n\nSelect * from Test;\nUpdate Test set field = 1";
        String[] result = StringUtils.processMutliLineSQL((String)sql, (boolean)true, (boolean)true, (String)";");
        Assert.assertEquals((long)2L, (long)result.length);
        Assert.assertEquals((Object)"Select * from Test", (Object)result[0]);
        Assert.assertEquals((Object)"Update Test set field = 1", (Object)result[1]);
    }

    @Test
    public void multipleComments() {
        String raw = "/**\nSome comments go here\n**/\ncreate table sqlfilerollback (id int);\n\n/**\nSome morecomments go here\n**/\ncreate table sqlfilerollback2 (id int);";
        String[] strings = StringUtils.processMutliLineSQL((String)raw, (boolean)true, (boolean)true, null);
        Assert.assertEquals((long)2L, (long)strings.length);
        Assert.assertEquals((Object)"create table sqlfilerollback (id int)", (Object)strings[0]);
        Assert.assertEquals((Object)"create table sqlfilerollback2 (id int)", (Object)strings[1]);
    }

    @Test
    public void noComments() {
        String noComments = " Some text but no comments";
        String result = StringUtils.stripComments((String)noComments);
        Assert.assertEquals((Object)noComments.trim(), (Object)result);
    }

    @Test
    public void singleLineNoNewLine() {
        String sql = "Some text";
        String comment = " -- with comment";
        String totalLine = sql + comment;
        String result = StringUtils.stripComments((String)totalLine);
        Assert.assertEquals((Object)sql, (Object)result);
    }

    @Test
    public void singleLineNoFollowOnLine() {
        String sql = "Some text";
        String comment = " -- with comment\n";
        String totalLine = sql + comment;
        String result = StringUtils.stripComments((String)totalLine);
        Assert.assertEquals((Object)sql.trim(), (Object)result);
    }

    @Test
    public void singleLineMultipleComments() {
        String sql = "Some text";
        String comment = " -- with comment";
        String totalLine = sql + comment + "\n" + sql + comment;
        String result = StringUtils.stripComments((String)totalLine);
        Assert.assertEquals((Object)(sql + "\n" + sql), (Object)result);
    }

    @Test
    public void singleLineWithFollowupLine() {
        String sql = "Some text";
        String comment = " -- with comment";
        String totalLine = sql + comment + "\n" + sql;
        String result = StringUtils.stripComments((String)totalLine);
        Assert.assertEquals((Object)(sql + "\n" + sql), (Object)result);
    }

    @Test
    public void multiLineOnOwnLine() {
        String sql = "/*Some text\nmore text*/";
        String result = StringUtils.stripComments((String)sql);
        Assert.assertEquals((Object)"", (Object)result);
    }

    @Test
    public void multiLineAfterSQL() {
        String sql = "some sql";
        String comment = "/*Some text\nmore text*/";
        String total = sql + comment;
        String result = StringUtils.stripComments((String)total);
        Assert.assertEquals((Object)sql.trim(), (Object)result);
    }

    @Test
    public void multiLineFinishesWithTextOnLine() {
        String sql = "some sql";
        String comment = "/*Some text\nmore text*/";
        String total = comment + sql;
        String result = StringUtils.stripComments((String)total);
        Assert.assertEquals((Object)sql.trim(), (Object)result);
    }

    @Test
    public void multiLineStartAndFinishWithSQL() {
        String sql = "some sql";
        String comment = "/*Some text\nmore text*/";
        String total = sql + comment + sql;
        String result = StringUtils.stripComments((String)total);
        Assert.assertEquals((Object)(sql.trim() + sql), (Object)result);
    }

    @Test
    public void shouldStripComments() {
        String sql = "some sql";
        String comment = "/*Some text\nmore text*/";
        String total = sql + comment + sql;
        String[] result = StringUtils.processMutliLineSQL((String)total, (boolean)true, (boolean)false, null);
        Assert.assertEquals((long)1L, (long)result.length);
        Assert.assertEquals((Object)(sql + sql), (Object)result[0]);
    }

    @Test
    public void stripComments2() {
        String sql = "insert into test_table values(1, 'hello');\ninsert into test_table values(2, 'hello');\n--insert into test_table values(3, 'hello');\ninsert into test_table values(4, 'hello');";
        String[] result = StringUtils.processMutliLineSQL((String)sql, (boolean)true, (boolean)true, (String)";");
        Assert.assertEquals((long)3L, (long)result.length);
    }

    @Test
    public void shouldNotStripComments() {
        String sql = "some sql";
        String comment = "/*Some text\nmore text*/";
        String total = sql + comment + sql;
        String[] result = StringUtils.processMutliLineSQL((String)total, (boolean)false, (boolean)false, null);
        Assert.assertEquals((long)1L, (long)result.length);
        Assert.assertEquals((Object)total, (Object)result[0]);
    }

    @Test
    public void splitOngo() {
        String sql = "some sql\ngo\nmore sql";
        String[] result = StringUtils.splitSQL((String)sql, null);
        Assert.assertEquals((long)2L, (long)result.length);
        Assert.assertEquals((Object)"some sql", (Object)result[0]);
        Assert.assertEquals((Object)"more sql", (Object)result[1]);
    }

    @Test
    public void splitOnGO() {
        String sql = "some sql\nGO\nmore sql";
        String[] result = StringUtils.splitSQL((String)sql, null);
        Assert.assertEquals((long)2L, (long)result.length);
        Assert.assertEquals((Object)"some sql", (Object)result[0]);
        Assert.assertEquals((Object)"more sql", (Object)result[1]);
    }

    @Test
    public void multilineComment() {
        String sql = "/*\nThis is a test comment of SQL script\n*/\n\nSelect * from Test;\nUpdate Test set field = 1";
        String[] result = StringUtils.processMutliLineSQL((String)sql, (boolean)true, (boolean)true, null);
        Assert.assertEquals((long)2L, (long)result.length);
        Assert.assertEquals((Object)"Select * from Test", (Object)result[0]);
        Assert.assertEquals((Object)"Update Test set field = 1", (Object)result[1]);
    }

    @Test
    public void testSplitWithSemicolon() {
        StringBuilder sb = new StringBuilder();
        sb.append("select * from simple_select_statement;\n");
        sb.append("insert into table ( col ) values (' value with; semicolon ');");
        String[] result = StringUtils.processMutliLineSQL((String)sb.toString(), (boolean)true, (boolean)true, null);
        Assert.assertEquals((String)"Unexpected amount of statements returned", (long)2L, (long)result.length);
    }

    @Test
    public void splitWithGo() {
        String testString = "SELECT *\n                                FROM sys.objects\n                                WHERE object_id = OBJECT_ID(N'[test].[currval]')\n                                AND type in (N'FN', N'IF', N'TF', N'FS', N'FT')\n                        )\n                        DROP FUNCTION [test].[currval]\ngo\n                        IF EXISTS\n                        (\n                        SELECT *\n                        FROM sys.objects\n                        WHERE object_id = OBJECT_ID(N'[test].[nextval]')\n                        AND type in (N'P', N'PC')\n                        )\n                        DROP PROCEDURE [test].[nextval]:";
        String[] strings = StringUtils.splitSQL((String)testString, null);
        Assert.assertEquals((long)2L, (long)strings.length);
    }

    @Test
    public void splitWithX() {
        String testString = "insert into datatable (col) values ('a value with a ;') X\ninsert into datatable (col) values ('another value with a ;') X";
        String[] strings = StringUtils.splitSQL((String)testString, (String)"X");
        Assert.assertEquals((long)2L, (long)strings.length);
        Assert.assertEquals((Object)"insert into datatable (col) values ('a value with a ;')", (Object)strings[0]);
        Assert.assertEquals((Object)"insert into datatable (col) values ('another value with a ;')", (Object)strings[1]);
    }

    @Test
    public void commentRemoval() {
        String testString = "--\n-- Create the blog table.\n--\nCREATE TABLE blog\n(\n    ID                         NUMBER(15)    NOT NULL\n)";
        String[] strings = StringUtils.processMutliLineSQL((String)testString, (boolean)true, (boolean)false, null);
        Assert.assertEquals((long)1L, (long)strings.length);
        Assert.assertTrue((boolean)strings[0].startsWith("CREATE TABLE blog"));
    }
}

