/*
 * Decompiled with CFR 0.152.
 */
package liquibase.osgi;

import java.util.Enumeration;
import java.util.Set;
import liquibase.servicelocator.DefaultPackageScanClassResolver;
import liquibase.servicelocator.PackageScanFilter;
import org.osgi.framework.Bundle;

public class OSGIPackageScanClassResolver
extends DefaultPackageScanClassResolver {
    private final Bundle bundle;

    public OSGIPackageScanClassResolver(Bundle bundle) {
        this.bundle = bundle;
    }

    @Override
    protected void find(PackageScanFilter test, String packageName, Set<Class<?>> classes) {
        packageName = packageName.replace('.', '/');
        Enumeration names = this.bundle.getEntryPaths(packageName);
        while (names != null && names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (name.endsWith("/")) {
                this.find(test, name, classes);
                continue;
            }
            if (!name.endsWith(".class")) continue;
            try {
                String fixedName = name.substring(0, name.indexOf(46)).replace('/', '.');
                Class klass = this.bundle.loadClass(fixedName);
                if (!test.matches(klass)) continue;
                classes.add(klass);
            }
            catch (Exception cce) {
                this.log.debug("Cant load class: " + cce.getMessage());
            }
        }
    }
}

