/*
 * Decompiled with CFR 0.152.
 */
package liquibase.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import liquibase.resource.ResourceAccessor;

public class FileSystemResourceAccessor
implements ResourceAccessor {
    String baseDirectory;

    public FileSystemResourceAccessor() {
        this.baseDirectory = null;
    }

    public FileSystemResourceAccessor(String base) {
        if (new File(base).isFile()) {
            throw new IllegalArgumentException("base must be a directory");
        }
        this.baseDirectory = base;
    }

    @Override
    public InputStream getResourceAsStream(String file) throws IOException {
        File relativeFile;
        File absoluteFile = new File(file);
        File file2 = relativeFile = this.baseDirectory == null ? new File(file) : new File(this.baseDirectory, file);
        if (absoluteFile.exists() && absoluteFile.isFile() && absoluteFile.isAbsolute()) {
            return new FileInputStream(absoluteFile);
        }
        if (relativeFile.exists() && relativeFile.isFile()) {
            return new FileInputStream(relativeFile);
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String packageName) throws IOException {
        String directoryPath = new File(packageName).isAbsolute() || this.baseDirectory == null ? packageName : this.baseDirectory + File.separator + packageName;
        File directoryFile = new File(directoryPath);
        if (!directoryFile.exists()) {
            return new Vector().elements();
        }
        File[] files = directoryFile.listFiles();
        ArrayList<URL> results = new ArrayList<URL>();
        for (File f : files) {
            if (f.isDirectory()) continue;
            results.add(f.toURI().toURL());
        }
        final Iterator it = results.iterator();
        return new Enumeration<URL>(){

            @Override
            public boolean hasMoreElements() {
                return it.hasNext();
            }

            @Override
            public URL nextElement() {
                return (URL)it.next();
            }
        };
    }

    @Override
    public ClassLoader toClassLoader() {
        try {
            return new URLClassLoader(new URL[]{new URL("file://" + this.baseDirectory)});
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        String dir = this.baseDirectory;
        if (dir == null) {
            dir = new File(".").getAbsolutePath();
        }
        return this.getClass().getName() + "(" + dir + ")";
    }
}

