/*
 * Decompiled with CFR 0.152.
 */
package liquibase.servicelocator;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.zip.ZipInputStream;
import liquibase.logging.Logger;
import liquibase.logging.core.DefaultLogger;
import liquibase.servicelocator.AssignableToPackageScanFilter;
import liquibase.servicelocator.CompositePackageScanFilter;
import liquibase.servicelocator.PackageScanClassResolver;
import liquibase.servicelocator.PackageScanFilter;

public class DefaultPackageScanClassResolver
implements PackageScanClassResolver {
    private static Map<String, Set<String>> classesByJarUrl = new HashMap<String, Set<String>>();
    protected final transient Logger log = new DefaultLogger();
    private Set<ClassLoader> classLoaders;
    private Set<PackageScanFilter> scanFilters;

    @Override
    public void addClassLoader(ClassLoader classLoader) {
        try {
            this.getClassLoaders().add(classLoader);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Override
    public void addFilter(PackageScanFilter filter) {
        if (this.scanFilters == null) {
            this.scanFilters = new LinkedHashSet<PackageScanFilter>();
        }
        this.scanFilters.add(filter);
    }

    @Override
    public void removeFilter(PackageScanFilter filter) {
        if (this.scanFilters != null) {
            this.scanFilters.remove(filter);
        }
    }

    @Override
    public Set<ClassLoader> getClassLoaders() {
        if (this.classLoaders == null) {
            this.classLoaders = new HashSet<ClassLoader>();
            ClassLoader ccl = Thread.currentThread().getContextClassLoader();
            if (ccl != null) {
                this.log.debug("The thread context class loader: " + ccl + "  is used to load the class");
                this.classLoaders.add(ccl);
            }
            this.classLoaders.add(DefaultPackageScanClassResolver.class.getClassLoader());
        }
        return this.classLoaders;
    }

    @Override
    public void setClassLoaders(Set<ClassLoader> classLoaders) {
        this.classLoaders = classLoaders;
    }

    public Set<Class<?>> findImplementations(Class parent, String ... packageNames) {
        if (packageNames == null) {
            return Collections.EMPTY_SET;
        }
        this.log.debug("Searching for implementations of " + parent.getName() + " in packages: " + Arrays.asList(packageNames));
        PackageScanFilter test = this.getCompositeFilter(new AssignableToPackageScanFilter(parent));
        LinkedHashSet classes = new LinkedHashSet();
        for (String pkg : packageNames) {
            this.find(test, pkg, classes);
        }
        this.log.debug("Found: " + classes);
        return classes;
    }

    @Override
    public Set<Class<?>> findByFilter(PackageScanFilter filter, String ... packageNames) {
        if (packageNames == null) {
            return Collections.EMPTY_SET;
        }
        LinkedHashSet classes = new LinkedHashSet();
        for (String pkg : packageNames) {
            this.find(filter, pkg, classes);
        }
        this.log.debug("Found: " + classes);
        return classes;
    }

    protected void find(PackageScanFilter test, String packageName, Set<Class<?>> classes) {
        packageName = packageName.replace('.', '/');
        Set<ClassLoader> set = this.getClassLoaders();
        for (ClassLoader classLoader : set) {
            this.find(test, packageName, classLoader, classes);
        }
    }

    protected void find(PackageScanFilter test, String packageName, ClassLoader loader, Set<Class<?>> classes) {
        Enumeration<URL> urls;
        this.log.debug("Searching for: " + test + " in package: " + packageName + " using classloader: " + loader.getClass().getName());
        try {
            urls = this.getResources(loader, packageName);
            if (!urls.hasMoreElements()) {
                this.log.debug("No URLs returned by classloader");
            }
        }
        catch (IOException ioe) {
            this.log.warning("Cannot read package: " + packageName, ioe);
            return;
        }
        while (urls.hasMoreElements()) {
            URL url = null;
            try {
                InputStream stream;
                url = urls.nextElement();
                this.log.debug("URL from classloader: " + url);
                url = this.customResourceLocator(url);
                String urlPath = url.getFile();
                String host = null;
                urlPath = URLDecoder.decode(urlPath, "UTF-8");
                if (url.getProtocol().equals("vfs") && !urlPath.startsWith("vfs")) {
                    urlPath = "vfs:" + urlPath;
                }
                if (url.getProtocol().equals("vfszip") && !urlPath.startsWith("vfszip")) {
                    urlPath = "vfszip:" + urlPath;
                }
                this.log.debug("Decoded urlPath: " + urlPath + " with protocol: " + url.getProtocol());
                if (urlPath.startsWith("file:")) {
                    try {
                        URI uri = new URI(url.getFile());
                        host = uri.getHost();
                        urlPath = uri.getPath();
                    }
                    catch (URISyntaxException e) {
                        // empty catch block
                    }
                    if (urlPath.startsWith("file:")) {
                        urlPath = urlPath.substring(5);
                    }
                }
                if (url.toString().startsWith("bundle:") || urlPath.startsWith("bundle:")) {
                    this.log.debug("It's a virtual osgi bundle, skipping");
                    continue;
                }
                if (urlPath.contains(".jar/") && !urlPath.contains(".jar!/")) {
                    urlPath = urlPath.replace(".jar/", ".jar!/");
                }
                if (urlPath.indexOf(33) > 0) {
                    urlPath = urlPath.substring(0, urlPath.indexOf(33));
                }
                if (host != null) {
                    urlPath = urlPath.startsWith("/") ? "//" + host + urlPath : "//" + host + "/" + urlPath;
                }
                this.log.debug("Scanning for classes in [" + urlPath + "] matching criteria: " + test);
                File file = new File(urlPath);
                if (file.isDirectory()) {
                    this.log.debug("Loading from directory using file: " + file);
                    this.loadImplementationsInDirectory(test, packageName, file, classes);
                    continue;
                }
                if (urlPath.startsWith("http:") || urlPath.startsWith("https:") || urlPath.startsWith("sonicfs:") || urlPath.startsWith("vfs:") || urlPath.startsWith("vfszip:")) {
                    URL urlStream = new URL(urlPath);
                    this.log.debug("Loading from jar using " + urlStream.getProtocol() + ": " + urlPath);
                    URLConnection con = urlStream.openConnection();
                    con.setUseCaches(false);
                    stream = con.getInputStream();
                } else {
                    this.log.debug("Loading from jar using file: " + file);
                    stream = new FileInputStream(file);
                }
                this.loadImplementationsInJar(test, packageName, stream, urlPath, classes);
            }
            catch (IOException e) {
                this.log.debug("Cannot read entries in url: " + url, e);
            }
        }
    }

    protected URL customResourceLocator(URL url) throws IOException {
        return url;
    }

    protected Enumeration<URL> getResources(ClassLoader loader, String packageName) throws IOException {
        this.log.debug("Getting resource URL for package: " + packageName + " with classloader: " + loader);
        if (!packageName.endsWith("/")) {
            packageName = packageName + "/";
        }
        return loader.getResources(packageName);
    }

    private PackageScanFilter getCompositeFilter(PackageScanFilter filter) {
        if (this.scanFilters != null) {
            CompositePackageScanFilter composite = new CompositePackageScanFilter(this.scanFilters);
            composite.addFilter(filter);
            return composite;
        }
        return filter;
    }

    private void loadImplementationsInDirectory(PackageScanFilter test, String parent, File location, Set<Class<?>> classes) {
        File[] files = location.listFiles();
        StringBuilder builder = null;
        for (File file : files) {
            String packageOrClass;
            builder = new StringBuilder(100);
            String name = file.getName();
            if (name == null) continue;
            name = name.trim();
            builder.append(parent).append("/").append(name);
            String string = packageOrClass = parent == null ? name : builder.toString();
            if (file.isDirectory()) {
                this.loadImplementationsInDirectory(test, packageOrClass, file, classes);
                continue;
            }
            if (!name.endsWith(".class")) continue;
            this.addIfMatching(test, packageOrClass, classes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadImplementationsInJar(PackageScanFilter test, String parent, InputStream stream, String urlPath, Set<Class<?>> classes) {
        ZipInputStream jarStream = null;
        try {
            if (!classesByJarUrl.containsKey(urlPath)) {
                JarEntry entry;
                HashSet<String> names = new HashSet<String>();
                jarStream = stream instanceof JarInputStream ? (JarInputStream)stream : new JarInputStream(stream);
                while ((entry = ((JarInputStream)jarStream).getNextJarEntry()) != null) {
                    String name = entry.getName();
                    if (name == null) continue;
                    name = name.trim();
                    if (entry.isDirectory() || !name.endsWith(".class")) continue;
                    names.add(name);
                }
                classesByJarUrl.put(urlPath, names);
            }
            for (String name : classesByJarUrl.get(urlPath)) {
                if (!name.startsWith(parent)) continue;
                this.addIfMatching(test, name, classes);
            }
        }
        catch (IOException ioe) {
            this.log.warning("Cannot search jar file '" + urlPath + "' for classes matching criteria: " + test + " due to an IOException: " + ioe.getMessage(), ioe);
        }
        finally {
            try {
                if (jarStream != null) {
                    jarStream.close();
                }
            }
            catch (IOException ignore) {}
        }
    }

    protected void addIfMatching(PackageScanFilter test, String fqn, Set<Class<?>> classes) {
        try {
            String externalName = fqn.substring(0, fqn.indexOf(46)).replace('/', '.');
            Set<ClassLoader> set = this.getClassLoaders();
            boolean found = false;
            for (ClassLoader classLoader : set) {
                this.log.debug("Testing that class " + externalName + " matches criteria [" + test + "] using classloader:" + classLoader);
                try {
                    Class<?> type = classLoader.loadClass(externalName);
                    this.log.debug("Loaded the class: " + type + " in classloader: " + classLoader);
                    if (test.matches(type)) {
                        this.log.debug("Found class: " + type + " which matches the filter in classloader: " + classLoader);
                        classes.add(type);
                    }
                    found = true;
                    break;
                }
                catch (ClassNotFoundException e) {
                    this.log.debug("Cannot find class '" + fqn + "' in classloader: " + classLoader + ". Reason: " + e, e);
                }
                catch (NoClassDefFoundError e) {
                    this.log.debug("Cannot find the class definition '" + fqn + "' in classloader: " + classLoader + ". Reason: " + e, e);
                }
                catch (Throwable e) {
                    this.log.severe("Cannot load class '" + fqn + "' in classloader: " + classLoader + ".  Reason: " + e, e);
                }
            }
            if (!found) {
                this.log.debug("Cannot find class '" + fqn + "' in any classloaders: " + set);
            }
        }
        catch (Exception e) {
            this.log.warning("Cannot examine class '" + fqn + "' due to a " + e.getClass().getName() + " with message: " + e.getMessage(), e);
        }
    }
}

