/*
 * Decompiled with CFR 0.152.
 */
package org.liyifeng.html;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.openxml4j.util.ZipSecureFile;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.liyifeng.html.HtmlUtil;
import org.liyifeng.html.Table;
import org.liyifeng.html.Td;
import org.liyifeng.html.Tr;

public class ExcelUtils {
    public static File toExcelFile(Collection<?> dataList, String filename) {
        return ExcelUtils.tableToExcelFile(HtmlUtil.toTable(dataList), filename);
    }

    public static SXSSFWorkbook toExcel(Collection<?> dataList) {
        return ExcelUtils.tableToExcel(HtmlUtil.toTable(dataList), true);
    }

    public static File tableToExcelFile(Table table, String filename) {
        return ExcelUtils.tableToExcelFile(table, filename, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File tableToExcelFile(Table table, String filename, boolean striped) {
        File file = ExcelUtils.getTmpFile(filename);
        SXSSFWorkbook wb = ExcelUtils.tableToExcel(table, striped);
        FileOutputStream fileOut = null;
        FilterOutputStream out = null;
        try {
            fileOut = new FileOutputStream(file);
            out = new BufferedOutputStream(fileOut);
            ZipSecureFile.setMinInflateRatio((double)9.0E-4);
            wb.write((OutputStream)out);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                out.close();
                fileOut.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return file;
    }

    public static File tablesToExcelFile(Collection<Table> tables, String filename) {
        return ExcelUtils.tablesToExcelFile(tables, filename, true);
    }

    public static File tablesToExcelFile(Collection<Table> tables, String filename, boolean striped) {
        File file = ExcelUtils.getTmpFile(filename);
        SXSSFWorkbook wb = ExcelUtils.tablesToExcel(tables, striped);
        try {
            FileOutputStream fileOut = new FileOutputStream(file);
            wb.write((OutputStream)fileOut);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return file;
    }

    public static SXSSFWorkbook tablesToExcel(Collection<Table> tableList, boolean striped) {
        SXSSFWorkbook wb = new SXSSFWorkbook();
        for (Table table : tableList) {
            ExcelUtils.tableToSheet(wb, table, striped);
        }
        return wb;
    }

    public static SXSSFWorkbook tableToExcel(Table table, boolean striped) {
        SXSSFWorkbook wb = new SXSSFWorkbook();
        ExcelUtils.tableToSheet(wb, table, striped);
        return wb;
    }

    private static void tableToSheet(SXSSFWorkbook wb, Table table, boolean striped) {
        String sheetName = table.title() == null ? "table" : table.title();
        SXSSFSheet sheet = wb.createSheet(sheetName);
        List<Tr> allTrList = table.tr();
        int totalSize = allTrList.size();
        int bodySize = table.bodySize();
        int headSize = totalSize - bodySize;
        boolean hasSetColWidth = false;
        for (int i = 0; i < totalSize; ++i) {
            Tr tr = allTrList.get(i);
            Row row = sheet.createRow(i);
            int cell_index = 0;
            CellStyle style = null;
            if (i < headSize) {
                style = ExcelUtils.getHeadStyle(wb);
                if (i < headSize - 1) {
                    style.setBorderBottom((short)0);
                }
            } else {
                style = ExcelUtils.getBodyStyle(wb, i, striped);
            }
            int hasSetColWidthFlag = 0;
            for (Td td : tr.allTds()) {
                Integer excelColWidth;
                int col = td.colspan() == null ? 1 : td.colspan();
                Cell cell = row.createCell(cell_index);
                ExcelUtils.setValue(cell, td.text());
                cell.setCellStyle(style);
                if (!hasSetColWidth && (excelColWidth = td.width()) != null) {
                    ++hasSetColWidthFlag;
                    sheet.setColumnWidth(cell_index, excelColWidth * 2 * 256);
                }
                if (col > 1) {
                    CellRangeAddress region = new CellRangeAddress(i, i, cell_index, cell_index + col - 1);
                    sheet.addMergedRegion(region);
                }
                cell_index += col;
            }
            if (hasSetColWidthFlag <= 0) continue;
            hasSetColWidth = true;
        }
    }

    private static void setValue(Cell cell, String text) {
        try {
            if (ExcelUtils.isNumType(text)) {
                Long val = Long.parseLong(text);
                cell.setCellValue((double)val.longValue());
            } else if (ExcelUtils.isDoubleType(text)) {
                Double val = Double.parseDouble(text);
                cell.setCellValue(val.doubleValue());
            } else {
                cell.setCellValue(text);
            }
        }
        catch (Exception e) {
            cell.setCellValue(text);
        }
    }

    private static boolean isNumType(String text) {
        Pattern pattern = Pattern.compile("[0-9]*");
        Matcher isNum = pattern.matcher(text);
        return isNum.matches();
    }

    private static boolean isDoubleType(String text) {
        Pattern pattern = Pattern.compile("^(-?\\d+)(\\.\\d+)?$");
        Matcher isNum = pattern.matcher(text);
        return isNum.matches();
    }

    private static CellStyle getHeadStyle(SXSSFWorkbook wb) {
        Font f = wb.createFont();
        f.setFontName("\u5fae\u8f6f\u96c5\u9ed1");
        f.setCharSet((byte)1);
        f.setFontHeightInPoints((short)11);
        CellStyle style = wb.createCellStyle();
        style.setFont(f);
        style.setAlignment((short)2);
        style.setVerticalAlignment((short)1);
        style.setBorderBottom((short)1);
        return style;
    }

    private static CellStyle getBodyStyle(SXSSFWorkbook wb, int rowNum, boolean striped) {
        Font f = wb.createFont();
        f.setFontName("\u5fae\u8f6f\u96c5\u9ed1");
        CellStyle style = wb.createCellStyle();
        style.setFont(f);
        style.setAlignment((short)2);
        style.setVerticalAlignment((short)1);
        if (striped && rowNum % 2 == 0) {
            style.setFillForegroundColor((short)26);
            style.setFillPattern((short)1);
        }
        return style;
    }

    private static File getTmpFile(String filename) {
        if (filename.endsWith(".xlsx")) {
            filename = filename.substring(0, filename.indexOf(".xlsx"));
        }
        File file = null;
        try {
            file = File.createTempFile(filename, ".xlsx");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return file;
    }
}

