/*
 * Decompiled with CFR 0.152.
 */
package org.liyifeng.html;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.liyifeng.html.ITableSort;
import org.liyifeng.html.Table;
import org.liyifeng.html.TableTag;
import org.liyifeng.html.Td;
import org.liyifeng.html.Tr;

public class HtmlUtil {
    private static <E> Table collectionToTable(Table table, Collection<E> objectList) {
        Tr headTr = new Tr();
        List<Field> fields = null;
        HashSet<String> hasValueFieldSet = HtmlUtil.getFieldsHasValue(objectList);
        for (E obj : objectList) {
            Tr tr = new Tr();
            if (fields == null) {
                fields = HtmlUtil.getAllFields(obj, hasValueFieldSet);
                if (obj instanceof ITableSort) {
                    fields = HtmlUtil.sort((ITableSort)obj, fields);
                }
            }
            for (Field field : fields) {
                TableTag tableTag = field.getAnnotation(TableTag.class);
                if (tableTag == null) continue;
                if (headTr != null) {
                    Td td = new Td(tableTag.value());
                    if (tableTag.width() != -1) {
                        td.width(tableTag.width());
                    }
                    headTr.add(td);
                }
                try {
                    field.setAccessible(true);
                    tr.add(new Td(field.get(obj)));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (headTr != null) {
                table.head(headTr);
                headTr = null;
            }
            table.tr(tr);
        }
        return table;
    }

    private static List<Field> sort(ITableSort obj, List<Field> fields) {
        Map<String, Field> map = fields.stream().collect(Collectors.toMap(Field::getName, Field2 -> Field2));
        List<String> sortFieldList = obj.fieldSortList();
        ArrayList<Field> result = new ArrayList<Field>();
        if (sortFieldList != null && sortFieldList.size() > 0) {
            for (String fieldName : sortFieldList) {
                if (!map.containsKey(fieldName)) continue;
                result.add(map.get(fieldName));
                map.remove(fieldName);
            }
        }
        result.addAll(map.values());
        return result;
    }

    private static <E> HashSet<String> getFieldsHasValue(Collection<E> objectList) {
        HashSet<String> newSet = new HashSet<String>();
        if (objectList != null && objectList.size() > 0) {
            for (E e : objectList) {
                List<Field> fields = HtmlUtil.getAllFields(e, null);
                for (Field field : fields) {
                    field.setAccessible(true);
                    try {
                        Object val = field.get(e);
                        if (val == null) continue;
                        newSet.add(field.getName());
                    }
                    catch (IllegalAccessException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }
        return newSet;
    }

    private static List<Field> getAllFields(Object object, Set<String> expectedFieldSet) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        ArrayList<Field> resultList = new ArrayList<Field>();
        for (Class<?> clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            fieldList.addAll(new ArrayList<Field>(Arrays.asList(clazz.getDeclaredFields())));
        }
        if (expectedFieldSet != null) {
            fieldList.forEach(f -> {
                if (expectedFieldSet.contains(f.getName())) {
                    resultList.add((Field)f);
                }
            });
        } else {
            resultList.addAll(fieldList);
        }
        return resultList;
    }

    public static <E> Table toDefaultTable(Collection<E> objectList) {
        return HtmlUtil.collectionToTable(Table.table(), objectList);
    }

    public static <E> Table toTable(Collection<E> objectList) {
        return HtmlUtil.collectionToTable(new Table(), objectList);
    }
}

