/*
 * Decompiled with CFR 0.152.
 */
package org.liyifeng.html;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.liyifeng.html.AbstractHtmlTag;
import org.liyifeng.html.Td;
import org.liyifeng.html.Tr;

public class Table
extends AbstractHtmlTag {
    private List<Tr> tbody = new ArrayList<Tr>();
    private List<Tr> thead = new ArrayList<Tr>();
    private Integer border;
    private String oddColor;
    private String evenColor;
    private String headBackgroundColor;
    private String title;

    public Table() {
        this.border = 1;
        this.style("border-collapse", "collapse");
    }

    public Table(Tr ... headTrs) {
        for (Tr tr : headTrs) {
            this.thead.add(tr);
        }
    }

    public void addAll(Table table) {
        if (table != null) {
            this.tr(table.tr());
        }
    }

    public static Table table() {
        return new Table().border(1).style("border-collapse", "collapse").headBackgroundColor("#87CEFA");
    }

    public Table trInterlaceColor(String oddColor, String evenColor) {
        this.oddColor = oddColor;
        this.evenColor = evenColor;
        return this;
    }

    public void tr(Tr tr) {
        this.tbody.add(tr);
    }

    public void tr(Tr ... trs) {
        for (Tr tr : trs) {
            this.tbody.add(tr);
        }
    }

    public void tr(Collection<Tr> trs) {
        for (Tr tr : trs) {
            this.tbody.add(tr);
        }
    }

    public Table append(Tr tr) {
        this.tbody.add(tr);
        return this;
    }

    public void setBorder(int border) {
        this.border = border;
    }

    public Table border(int border) {
        this.border = border;
        return this;
    }

    public void head(Tr tr) {
        this.thead.add(tr);
    }

    public Table headBackgroundColor(String color) {
        this.headBackgroundColor = color;
        return this;
    }

    @Override
    public String html() {
        StringBuilder sb = new StringBuilder();
        sb.append("<table");
        if (this.border != null) {
            sb.append(" border='" + this.border + "'");
        }
        sb.append(this.tagStyle());
        sb.append(">\n");
        if (this.title != null) {
            sb.append("<caption>");
            sb.append(this.title);
            sb.append("</caption>");
        }
        if (this.thead.size() > 0) {
            StringBuilder headSB = new StringBuilder();
            for (Tr tr : this.thead) {
                if (this.headBackgroundColor != null) {
                    tr.addStyle("background-color", this.headBackgroundColor);
                }
                headSB.append(tr.html());
            }
            String head = headSB.toString();
            head = head.replace("<td", "<th");
            head = head.replace("</td>", "</th>");
            sb.append("<thead>\n" + head + "</thead>\n");
        }
        sb.append("<tbody>\n");
        int tbodySize = this.tbody.size();
        if (tbodySize > 0) {
            for (int i = 0; i < tbodySize; ++i) {
                Tr tr = this.tbody.get(i);
                if (i % 2 == 0) {
                    if (this.oddColor != null) {
                        tr.addStyle("background-color", this.oddColor);
                    }
                } else if (this.evenColor != null) {
                    tr.addStyle("background-color", this.evenColor);
                }
                sb.append(tr.html());
            }
        }
        sb.append("</tbody>\n");
        sb.append("</table>");
        return sb.toString();
    }

    public String toString() {
        return this.html();
    }

    @Override
    public void clearStyle() {
        this.border = null;
        this.oddColor = null;
        this.evenColor = null;
        this.headBackgroundColor = null;
        super.clearStyle();
    }

    @Override
    public void clearElement() {
        this.thead.clear();
        this.tbody.clear();
    }

    @Override
    public Table style(String key, String val) {
        this.styleMap.put(key, val);
        return this;
    }

    public List<Tr> tr() {
        ArrayList<Tr> trs = new ArrayList<Tr>();
        trs.addAll(this.thead);
        trs.addAll(this.tbody);
        return trs;
    }

    @Override
    public String text() {
        StringBuilder sb = new StringBuilder();
        for (Tr tr : this.thead) {
            sb.append(tr.text());
        }
        for (Tr tr : this.tbody) {
            sb.append(tr.text());
        }
        return sb.toString();
    }

    public int size() {
        return this.thead.size() + this.tbody.size();
    }

    public int bodySize() {
        return this.tbody.size();
    }

    public Table title(String title) {
        this.title = title;
        return this;
    }

    public String title() {
        return this.title;
    }

    public int colSize() {
        Tr tr;
        int colSize = 0;
        if (this.thead.size() > 0) {
            tr = this.thead.get(0);
        } else if (this.tbody.size() > 0) {
            tr = this.tbody.get(0);
        } else {
            return colSize;
        }
        for (Td td : tr.allTds()) {
            Integer colspan = td.colspan();
            colSize += colspan == null ? 1 : colspan;
        }
        return colSize;
    }

    public boolean replace(int index, Object newTr) {
        try {
            this.tbody.remove(index);
        }
        catch (Exception e) {
            return false;
        }
        return this.insert(index, newTr);
    }

    public boolean insert(int index, Object newTr) {
        try {
            if (newTr instanceof Tr) {
                this.tbody.add(index, (Tr)newTr);
            } else {
                this.tbody.add(index, new Tr(newTr));
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

