/*
 * Decompiled with CFR 0.152.
 */
package org.liyifeng.html;

import org.liyifeng.html.AbstractHtmlTag;

public class Td
extends AbstractHtmlTag {
    private Integer colspan;
    private Integer rowspan;
    private Object text;
    private Integer width;

    public Td(Object text, Integer rowspan, Integer colspan) {
        this.text = text;
        if (rowspan != null) {
            this.rowspan = rowspan;
        }
        if (colspan != null) {
            this.colspan = colspan;
        }
    }

    public Td(Object text) {
        this.text = text;
    }

    public Td() {
    }

    @Override
    public void addStyle(String key, String val) {
        this.styleMap.put(key, val);
    }

    public Td appendStyle(String key, String val) {
        this.styleMap.put(key, val);
        return this;
    }

    @Override
    public String html() {
        StringBuilder sb = new StringBuilder();
        sb.append("<td");
        sb.append(this.tagStyle());
        if (this.colspan != null) {
            sb.append(" colspan='" + this.colspan + "'");
        }
        if (this.rowspan != null) {
            sb.append(" rowspan='" + this.rowspan + "'");
        }
        sb.append(">");
        if (this.text != null) {
            sb.append(this.text);
        }
        sb.append("</td>");
        return sb.toString();
    }

    public String toString() {
        return this.html();
    }

    public Td colspan(Integer colspan) {
        this.colspan = colspan;
        return this;
    }

    public Td rowspan(Integer rowspan) {
        this.rowspan = rowspan;
        return this;
    }

    @Override
    public void clearStyle() {
        this.colspan = null;
        this.rowspan = null;
        super.clearStyle();
    }

    @Override
    public void clearElement() {
        this.text = null;
    }

    @Override
    public Td style(String styleKey, String styleVal) {
        this.styleMap.put(styleKey, styleVal);
        return this;
    }

    @Override
    public String text() {
        return this.text == null ? "" : this.text.toString();
    }

    public Integer colspan() {
        return this.colspan;
    }

    public Integer rowspan() {
        return this.rowspan;
    }

    public void width(Integer width) {
        this.width = width;
    }

    public Integer width() {
        return this.width;
    }
}

