/*
 * Decompiled with CFR 0.152.
 */
package org.liyifeng.html;

import java.util.ArrayList;
import java.util.List;
import org.liyifeng.html.AbstractHtmlTag;
import org.liyifeng.html.Td;

public class Tr
extends AbstractHtmlTag {
    private List<Td> tdList = new ArrayList<Td>();
    private String align;

    public Tr(Object ... tdTexts) {
        for (Object obj : tdTexts) {
            if (obj instanceof Td) {
                this.tdList.add((Td)obj);
                continue;
            }
            this.tdList.add(new Td(obj));
        }
    }

    public Tr alignCenter() {
        this.align = "center";
        return this;
    }

    public Tr alignLeft() {
        this.align = "left";
        return this;
    }

    public Tr alignRight() {
        this.align = "right";
        return this;
    }

    public Tr() {
    }

    public Tr append(Td td) {
        this.tdList.add(td);
        return this;
    }

    public void add(Td td) {
        this.tdList.add(td);
    }

    public void add(Td ... tds) {
        for (Td td : tds) {
            this.tdList.add(td);
        }
    }

    public Tr addAll(Tr tr) {
        if (tr != null) {
            for (Td td : tr.allTds()) {
                this.add(td);
            }
        }
        return this;
    }

    @Override
    public Tr style(String key, String val) {
        this.styleMap.put(key, val);
        return this;
    }

    @Override
    public String html() {
        StringBuilder sb = new StringBuilder("<tr");
        if (this.align != null) {
            sb.append(" align='" + this.align + "'");
        }
        sb.append(this.tagStyle());
        sb.append(">");
        for (Td td : this.tdList) {
            sb.append(td.html());
        }
        sb.append("</tr>\n");
        return sb.toString();
    }

    public String toString() {
        return this.html();
    }

    @Override
    public void clearStyle() {
        this.align = null;
        super.clearStyle();
    }

    @Override
    public void clearElement() {
        this.tdList.clear();
    }

    @Override
    public String text() {
        StringBuilder sb = new StringBuilder();
        for (Td td : this.tdList) {
            sb.append(td.text());
        }
        return sb.toString();
    }

    public List<Td> allTds() {
        return this.tdList;
    }

    public int size() {
        return this.tdList.size();
    }

    public boolean replace(int index, Object newTd) {
        try {
            this.tdList.remove(index);
        }
        catch (Exception e) {
            return false;
        }
        return this.insert(index, newTd);
    }

    public boolean insert(int index, Object newTd) {
        try {
            if (newTd instanceof Td) {
                this.tdList.add(index, (Td)newTd);
            } else {
                this.tdList.add(index, new Td(newTd));
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

