/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.lambda.data;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.time.Clock;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.NewTopic;
import org.geotools.data.DataStore;
import org.geotools.data.DefaultServiceInfo;
import org.geotools.data.FeatureReader;
import org.geotools.data.LockingManager;
import org.geotools.data.Query;
import org.geotools.data.ServiceInfo;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureReader;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.simple.SimpleFeatureWriter;
import org.geotools.feature.FeatureTypes;
import org.locationtech.geomesa.accumulo.data.AccumuloDataStore;
import org.locationtech.geomesa.index.geotools.GeoMesaFeatureReader$;
import org.locationtech.geomesa.index.geotools.GeoMesaFeatureStore;
import org.locationtech.geomesa.index.planning.QueryRunner;
import org.locationtech.geomesa.index.stats.GeoMesaStats;
import org.locationtech.geomesa.index.stats.package;
import org.locationtech.geomesa.lambda.data.LambdaDataStore$;
import org.locationtech.geomesa.lambda.data.LambdaFeatureWriter;
import org.locationtech.geomesa.lambda.data.LambdaQueryRunner;
import org.locationtech.geomesa.lambda.data.LambdaStats;
import org.locationtech.geomesa.lambda.stream.OffsetManager;
import org.locationtech.geomesa.lambda.stream.TransientStore;
import org.locationtech.geomesa.lambda.stream.kafka.KafkaStore;
import org.locationtech.geomesa.lambda.stream.kafka.KafkaStore$;
import org.locationtech.geomesa.security.AuthorizationsProvider;
import org.locationtech.geomesa.security.VisibilityChecker;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.collection.SelfClosingIterator;
import org.locationtech.geomesa.utils.collection.SelfClosingIterator$;
import org.locationtech.geomesa.utils.conf.GeoMesaSystemProperties;
import org.locationtech.geomesa.utils.geotools.FeatureUtils$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.io.IsCloseable;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.package;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.immutable.StringOps;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\r\rh\u0001\u0002'N\u0001aC!\"!\u0006\u0001\u0005\u000b\u0007I\u0011AA\f\u0011%\tI\u0002\u0001B\u0001B\u0003%\u0011\r\u0003\u0006\u0002\u001c\u0001\u0011\t\u0011)A\u0005\u0003;A!\"a\u000e\u0001\u0005\u0003\u0005\u000b\u0011BA\u000f\u0011)\tI\u0004\u0001B\u0001B\u0003%\u00111\b\u0005\u000b\u0003\u000f\u0002!\u0011!Q\u0001\n\u0005%\u0003B\u0003BM\u0001\t\u0005\t\u0015a\u0003\u0003\u0004\"9\u0011Q\r\u0001\u0005\u0002\tm\u0005\"\u0003BW\u0001\t\u0007I\u0011\u0002BX\u0011!\u0011y\f\u0001Q\u0001\n\tE\u0006B\u0003Ba\u0001\t\u0007I\u0011A(\u0003D\"A!1\u001d\u0001!\u0002\u0013\u0011)\r\u0003\u0005y\u0001\t\u0007I\u0011\tBs\u0011!\u0011y\u000f\u0001Q\u0001\n\t\u001d\b\"\u0003By\u0001\t\u0007I\u0011\u0002Bz\u0011!\u0011Y\u0010\u0001Q\u0001\n\tU\bbBAU\u0001\u0011\u0005!Q \u0005\b\u0007\u0013\u0001A\u0011IB\u0006\u0011\u001d\u0019\u0019\u0002\u0001C!\u0007+Aqaa\u000e\u0001\t\u0003\u001aI\u0004C\u0004\u0004L\u0001!\te!\u0014\t\u000f\r-\u0003\u0001\"\u0011\u0004R!91Q\u000b\u0001\u0005B\r]\u0003bBB+\u0001\u0011\u00053q\f\u0005\b\u0007K\u0002A\u0011IB4\u0011\u001d\u0019)\u0007\u0001C!\u0007WBqaa\u001c\u0001\t\u0003\u001a\t\bC\u0004\u0004p\u0001!\tea \t\u000f\r\r\u0005\u0001\"\u0011\u0004\u0006\"91\u0011\u0015\u0001\u0005B\r\r\u0006bBBX\u0001\u0011\u00053\u0011\u0017\u0005\b\u0007_\u0003A\u0011IB\\\u0011\u001d\u0019Y\r\u0001C!\u0007\u001bDqaa4\u0001\t\u0003\u001a\t\u000eC\u0004\u0004Z\u0002!\tea7\b\u000f\u0005US\n#\u0001\u0002X\u00191A*\u0014E\u0001\u00037Bq!!\u001a&\t\u0003\t9G\u0002\u0004\u0002j\u0015\u0002\u00151\u000e\u0005\u000b\u0003s:#Q3A\u0005\u0002\u0005m\u0004BCA?O\tE\t\u0015!\u0003\u00022!Q\u0011qP\u0014\u0003\u0016\u0004%\t!a\u001f\t\u0015\u0005\u0005uE!E!\u0002\u0013\t\t\u0004\u0003\u0006\u0002\u0004\u001e\u0012)\u001a!C\u0001\u0003\u000bC!\"!$(\u0005#\u0005\u000b\u0011BAD\u0011)\tyi\nBK\u0002\u0013\u0005\u0011Q\u0011\u0005\u000b\u0003#;#\u0011#Q\u0001\n\u0005\u001d\u0005BCAJO\tU\r\u0011\"\u0001\u0002\u0016\"Q\u0011qU\u0014\u0003\u0012\u0003\u0006I!a&\t\u0015\u0005%vE!f\u0001\n\u0003\tY\u000b\u0003\u0006\u00024\u001e\u0012\t\u0012)A\u0005\u0003[Cq!!\u001a(\t\u0003\t)\fC\u0005\u0002H\u001e\n\t\u0011\"\u0001\u0002J\"I\u0011q[\u0014\u0012\u0002\u0013\u0005\u0011\u0011\u001c\u0005\n\u0003_<\u0013\u0013!C\u0001\u00033D\u0011\"!=(#\u0003%\t!a=\t\u0013\u0005]x%%A\u0005\u0002\u0005M\b\"CA}OE\u0005I\u0011AA~\u0011%\typJI\u0001\n\u0003\u0011\t\u0001C\u0005\u0003\u0006\u001d\n\t\u0011\"\u0011\u0003\b!I!QB\u0014\u0002\u0002\u0013\u0005\u0011Q\u0011\u0005\n\u0005\u001f9\u0013\u0011!C\u0001\u0005#A\u0011B!\b(\u0003\u0003%\tEa\b\t\u0013\t5r%!A\u0005\u0002\t=\u0002\"\u0003B\u001aO\u0005\u0005I\u0011\tB\u001b\u0011%\u00119dJA\u0001\n\u0003\u0012I\u0004C\u0005\u0003<\u001d\n\t\u0011\"\u0011\u0003>\u001dI!\u0011I\u0013\u0002\u0002#\u0005!1\t\u0004\n\u0003S*\u0013\u0011!E\u0001\u0005\u000bBq!!\u001aF\t\u0003\u0011\u0019\u0006C\u0005\u00038\u0015\u000b\t\u0011\"\u0012\u0003:!I!QK#\u0002\u0002\u0013\u0005%q\u000b\u0005\n\u0005K*\u0015\u0011!CA\u0005OB\u0011B!\u001fF\u0003\u0003%IAa\u001f\t\u0013\tuT%%A\u0005\u0002\t}$a\u0004'b[\n$\u0017\rR1uCN#xN]3\u000b\u00059{\u0015\u0001\u00023bi\u0006T!\u0001U)\u0002\r1\fWN\u00193b\u0015\t\u00116+A\u0004hK>lWm]1\u000b\u0005Q+\u0016\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"\u0001,\u0002\u0007=\u0014xm\u0001\u0001\u0014\r\u0001I\u0016\r[A\u0001!\tQv,D\u0001\\\u0015\taV,\u0001\u0003mC:<'\"\u00010\u0002\t)\fg/Y\u0005\u0003An\u0013aa\u00142kK\u000e$\bC\u00012g\u001b\u0005\u0019'B\u0001(e\u0015\t)W+\u0001\u0005hK>$xn\u001c7t\u0013\t97MA\u0005ECR\f7\u000b^8sKB\u0011\u0011. \b\u0003Ujt!a[<\u000f\u00051,hBA7u\u001d\tq7O\u0004\u0002pe6\t\u0001O\u0003\u0002r/\u00061AH]8pizJ\u0011AV\u0005\u0003)VK!AU*\n\u0005Y\f\u0016!B5oI\u0016D\u0018B\u0001=z\u0003\u0015\u0019H/\u0019;t\u0015\t1\u0018+\u0003\u0002|y\u00069\u0001/Y2lC\u001e,'B\u0001=z\u0013\tqxPA\bICN<Um\\'fg\u0006\u001cF/\u0019;t\u0015\tYH\u0010\u0005\u0003\u0002\u0004\u0005EQBAA\u0003\u0015\u0011\t9!!\u0003\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\t\u0005-\u0011QB\u0001\tif\u0004Xm]1gK*\u0011\u0011qB\u0001\u0004G>l\u0017\u0002BA\n\u0003\u000b\u00111\u0002T1{s2{wmZ5oO\u0006Y\u0001/\u001a:tSN$XM\\2f+\u0005\t\u0017\u0001\u00049feNL7\u000f^3oG\u0016\u0004\u0013A\u00049s_\u0012,8-\u001a:D_:4\u0017n\u001a\t\t\u0003?\tY#!\r\u000229!\u0011\u0011EA\u0014!\ry\u00171\u0005\u0006\u0003\u0003K\tQa]2bY\u0006LA!!\u000b\u0002$\u00051\u0001K]3eK\u001aLA!!\f\u00020\t\u0019Q*\u00199\u000b\t\u0005%\u00121\u0005\t\u0005\u0003?\t\u0019$\u0003\u0003\u00026\u0005=\"AB*ue&tw-\u0001\bd_:\u001cX/\\3s\u0007>tg-[4\u0002\u001b=4gm]3u\u001b\u0006t\u0017mZ3s!\u0011\ti$a\u0011\u000e\u0005\u0005}\"bAA!\u001f\u000611\u000f\u001e:fC6LA!!\u0012\u0002@\tiqJ\u001a4tKRl\u0015M\\1hKJ\faaY8oM&<\u0007cAA&O9\u0019\u0011Q\n\u0013\u000f\t\u0005=\u00131\u000b\b\u0004Y\u0006E\u0013B\u0001)R\u0013\tqu*A\bMC6\u0014G-\u0019#bi\u0006\u001cFo\u001c:f!\r\tI&J\u0007\u0002\u001bN\u0019Q%!\u0018\u0011\t\u0005}\u0013\u0011M\u0007\u0003\u0003GIA!a\u0019\u0002$\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtDCAA,\u00051a\u0015-\u001c2eC\u000e{gNZ5h'\u001d9\u0013QLA7\u0003g\u0002B!a\u0018\u0002p%!\u0011\u0011OA\u0012\u0005\u001d\u0001&o\u001c3vGR\u0004B!a\u0018\u0002v%!\u0011qOA\u0012\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003)Qxn\\6fKB,'o]\u000b\u0003\u0003c\t1B_8pW\u0016,\u0007/\u001a:tA\u0005Y!p\u001b(b[\u0016\u001c\b/Y2f\u00031Q8NT1nKN\u0004\u0018mY3!\u0003)\u0001\u0018M\u001d;ji&|gn]\u000b\u0003\u0003\u000f\u0003B!a\u0018\u0002\n&!\u00111RA\u0012\u0005\rIe\u000e^\u0001\fa\u0006\u0014H/\u001b;j_:\u001c\b%A\u0005d_:\u001cX/\\3sg\u0006Q1m\u001c8tk6,'o\u001d\u0011\u0002\r\u0015D\b/\u001b:z+\t\t9\n\u0005\u0003\u0002\u001a\u0006\rVBAAN\u0015\u0011\ti*a(\u0002\u0011\u0011,(/\u0019;j_:TA!!)\u0002$\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u0005\u0015\u00161\u0014\u0002\t\tV\u0014\u0018\r^5p]\u00069Q\r\u001f9jef\u0004\u0013a\u00029feNL7\u000f^\u000b\u0003\u0003[\u0003B!a\u0018\u00020&!\u0011\u0011WA\u0012\u0005\u001d\u0011un\u001c7fC:\f\u0001\u0002]3sg&\u001cH\u000f\t\u000b\u000f\u0003o\u000bY,!0\u0002@\u0006\u0005\u00171YAc!\r\tIlJ\u0007\u0002K!9\u0011\u0011\u0010\u001bA\u0002\u0005E\u0002bBA@i\u0001\u0007\u0011\u0011\u0007\u0005\b\u0003\u0007#\u0004\u0019AAD\u0011\u001d\ty\t\u000ea\u0001\u0003\u000fCq!a%5\u0001\u0004\t9\nC\u0004\u0002*R\u0002\r!!,\u0002\t\r|\u0007/\u001f\u000b\u000f\u0003o\u000bY-!4\u0002P\u0006E\u00171[Ak\u0011%\tI(\u000eI\u0001\u0002\u0004\t\t\u0004C\u0005\u0002\u0000U\u0002\n\u00111\u0001\u00022!I\u00111Q\u001b\u0011\u0002\u0003\u0007\u0011q\u0011\u0005\n\u0003\u001f+\u0004\u0013!a\u0001\u0003\u000fC\u0011\"a%6!\u0003\u0005\r!a&\t\u0013\u0005%V\u0007%AA\u0002\u00055\u0016AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u00037TC!!\r\u0002^.\u0012\u0011q\u001c\t\u0005\u0003C\fY/\u0004\u0002\u0002d*!\u0011Q]At\u0003%)hn\u00195fG.,GM\u0003\u0003\u0002j\u0006\r\u0012AC1o]>$\u0018\r^5p]&!\u0011Q^Ar\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"!!>+\t\u0005\u001d\u0015Q\\\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00135\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIU*\"!!@+\t\u0005]\u0015Q\\\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00137+\t\u0011\u0019A\u000b\u0003\u0002.\u0006u\u0017!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0003\nA\u0019!La\u0003\n\u0007\u0005U2,\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\tM!\u0011\u0004\t\u0005\u0003?\u0012)\"\u0003\u0003\u0003\u0018\u0005\r\"aA!os\"I!1\u0004 \u0002\u0002\u0003\u0007\u0011qQ\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\t\u0005\u0002C\u0002B\u0012\u0005S\u0011\u0019\"\u0004\u0002\u0003&)!!qEA\u0012\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005W\u0011)C\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BAW\u0005cA\u0011Ba\u0007A\u0003\u0003\u0005\rAa\u0005\u0002\u0011!\f7\u000f[\"pI\u0016$\"!a\"\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"A!\u0003\u0002\r\u0015\fX/\u00197t)\u0011\tiKa\u0010\t\u0013\tm1)!AA\u0002\tM\u0011\u0001\u0004'b[\n$\u0017mQ8oM&<\u0007cAA]\u000bN)QIa\u0012\u0002tA\u0011\"\u0011\nB(\u0003c\t\t$a\"\u0002\b\u0006]\u0015QVA\\\u001b\t\u0011YE\u0003\u0003\u0003N\u0005\r\u0012a\u0002:v]RLW.Z\u0005\u0005\u0005#\u0012YEA\tBEN$(/Y2u\rVt7\r^5p]Z\"\"Aa\u0011\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u001d\u0005]&\u0011\fB.\u0005;\u0012yF!\u0019\u0003d!9\u0011\u0011\u0010%A\u0002\u0005E\u0002bBA@\u0011\u0002\u0007\u0011\u0011\u0007\u0005\b\u0003\u0007C\u0005\u0019AAD\u0011\u001d\ty\t\u0013a\u0001\u0003\u000fCq!a%I\u0001\u0004\t9\nC\u0004\u0002*\"\u0003\r!!,\u0002\u000fUt\u0017\r\u001d9msR!!\u0011\u000eB;!\u0019\tyFa\u001b\u0003p%!!QNA\u0012\u0005\u0019y\u0005\u000f^5p]B\u0001\u0012q\fB9\u0003c\t\t$a\"\u0002\b\u0006]\u0015QV\u0005\u0005\u0005g\n\u0019C\u0001\u0004UkBdWM\u000e\u0005\n\u0005oJ\u0015\u0011!a\u0001\u0003o\u000b1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0003e\u000b1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u00122D\u0003\u0004BA\u0005\u001f\u0013\tJa%\u0003\u0016\n]%\u0006\u0002BB\u0003;\u0004BA!\"\u0003\f6\u0011!q\u0011\u0006\u0004\u0005\u0013k\u0016\u0001\u0002;j[\u0016LAA!$\u0003\b\n)1\t\\8dW\"1\u0011QC&A\u0002\u0005Dq!a\u0007L\u0001\u0004\ti\u0002C\u0004\u00028-\u0003\r!!\b\t\u000f\u0005e2\n1\u0001\u0002<!9\u0011qI&A\u0002\u0005]\u0016!B2m_\u000e\\G\u0003\u0004BO\u0005G\u0013)Ka*\u0003*\n-F\u0003\u0002BP\u0005C\u00032!!\u0017\u0001\u0011%\u0011I\n\u0003I\u0001\u0002\b\u0011\u0019\t\u0003\u0004\u0002\u0016!\u0001\r!\u0019\u0005\b\u00037A\u0001\u0019AA\u000f\u0011\u001d\t9\u0004\u0003a\u0001\u0003;Aq!!\u000f\t\u0001\u0004\tY\u0004C\u0004\u0002H!\u0001\r!!\u0013\u0002\u0019\u0005,H\u000f\u001b)s_ZLG-\u001a:\u0016\u0005\tE\u0006CBA0\u0005W\u0012\u0019\f\u0005\u0003\u00036\nmVB\u0001B\\\u0015\r\u0011I,U\u0001\tg\u0016\u001cWO]5us&!!Q\u0018B\\\u0005Y\tU\u000f\u001e5pe&T\u0018\r^5p]N\u0004&o\u001c<jI\u0016\u0014\u0018!D1vi\"\u0004&o\u001c<jI\u0016\u0014\b%\u0001\u0006ue\u0006t7/[3oiN,\"A!2\u0011\u0011\t\u001d'\u0011\\A\u0019\u0005;l!A!3\u000b\t\t-'QZ\u0001\u0006G\u0006\u001c\u0007.\u001a\u0006\u0005\u0005\u001f\u0014\t.\u0001\u0005dC\u001a4W-\u001b8f\u0015\u0011\u0011\u0019N!6\u0002\u0011\t,g.\\1oKNTAAa6\u0002\u000e\u00051q-\u001b;ik\nLAAa7\u0003J\naAj\\1eS:<7)Y2iKB!\u0011Q\bBp\u0013\u0011\u0011\t/a\u0010\u0003\u001dQ\u0013\u0018M\\:jK:$8\u000b^8sK\u0006YAO]1og&,g\u000e^:!+\t\u00119\u000f\u0005\u0003\u0003j\n-X\"\u0001?\n\u0007\t5HP\u0001\u0007HK>lUm]1Ti\u0006$8/\u0001\u0004ti\u0006$8\u000fI\u0001\u0007eVtg.\u001a:\u0016\u0005\tU\b\u0003BA-\u0005oL1A!?N\u0005Ea\u0015-\u001c2eCF+XM]=Sk:tWM]\u0001\beVtg.\u001a:!)\u0011\u0011yp!\u0002\u0011\t\u0005}3\u0011A\u0005\u0005\u0007\u0007\t\u0019C\u0001\u0003V]&$\bbBB\u0004#\u0001\u0007\u0011\u0011G\u0001\tif\u0004XMT1nK\u0006aq-\u001a;UsB,g*Y7fgR\u00111Q\u0002\t\u0007\u0003?\u001ay!!\r\n\t\rE\u00111\u0005\u0002\u0006\u0003J\u0014\u0018-_\u0001\tO\u0016$h*Y7fgR\u00111q\u0003\t\u0007\u00073\u0019yba\t\u000e\u0005\rm!bAB\u000f;\u0006!Q\u000f^5m\u0013\u0011\u0019\tca\u0007\u0003\t1K7\u000f\u001e\t\u0005\u0007K\u0019\u0019$\u0004\u0002\u0004()!1\u0011FB\u0016\u0003\u0011!\u0018\u0010]3\u000b\t\r52qF\u0001\bM\u0016\fG/\u001e:f\u0015\r\u0019\t$V\u0001\b_B,gnZ5t\u0013\u0011\u0019)da\n\u0003\t9\u000bW.Z\u0001\rGJ,\u0017\r^3TG\",W.\u0019\u000b\u0005\u0005\u007f\u001cY\u0004C\u0004\u0004>Q\u0001\raa\u0010\u0002\u0007M4G\u000f\u0005\u0003\u0004B\r\u001dSBAB\"\u0015\u0011\u0019)ea\u000b\u0002\rMLW\u000e\u001d7f\u0013\u0011\u0019Iea\u0011\u0003#MKW\u000e\u001d7f\r\u0016\fG/\u001e:f)f\u0004X-A\u0005hKR\u001c6\r[3nCR!1qHB(\u0011\u001d\u00199!\u0006a\u0001\u0007G!Baa\u0010\u0004T!91q\u0001\fA\u0002\u0005E\u0012\u0001D;qI\u0006$XmU2iK6\fGC\u0002B\u0000\u00073\u001aY\u0006C\u0004\u0004\b]\u0001\raa\t\t\u000f\rus\u00031\u0001\u0004@\u0005Ya-Z1ukJ,G+\u001f9f)\u0019\u0011yp!\u0019\u0004d!91q\u0001\rA\u0002\u0005E\u0002bBB/1\u0001\u00071qH\u0001\re\u0016lwN^3TG\",W.\u0019\u000b\u0005\u0005\u007f\u001cI\u0007C\u0004\u0004\be\u0001\raa\t\u0015\t\t}8Q\u000e\u0005\b\u0007\u000fQ\u0002\u0019AA\u0019\u0003A9W\r\u001e$fCR,(/Z*pkJ\u001cW\r\u0006\u0003\u0004t\ru\u0004\u0003BB;\u0007sj!aa\u001e\u000b\u0007\r\u00153-\u0003\u0003\u0004|\r]$aE*j[BdWMR3biV\u0014XmU8ve\u000e,\u0007bBB\u00047\u0001\u000711\u0005\u000b\u0005\u0007g\u001a\t\tC\u0004\u0004\bq\u0001\r!!\r\u0002!\u001d,GOR3biV\u0014XMU3bI\u0016\u0014HCBBD\u0007\u001b\u001b9\n\u0005\u0003\u0004v\r%\u0015\u0002BBF\u0007o\u00121cU5na2,g)Z1ukJ,'+Z1eKJDqaa$\u001e\u0001\u0004\u0019\t*A\u0003rk\u0016\u0014\u0018\u0010E\u0002c\u0007'K1a!&d\u0005\u0015\tV/\u001a:z\u0011\u001d\u0019I*\ba\u0001\u00077\u000b1\u0002\u001e:b]N\f7\r^5p]B\u0019!m!(\n\u0007\r}5MA\u0006Ue\u0006t7/Y2uS>t\u0017AF4fi\u001a+\u0017\r^;sK^\u0013\u0018\u000e^3s\u0003B\u0004XM\u001c3\u0015\r\r\u001561VBW!\u0011\u0019)ha*\n\t\r%6q\u000f\u0002\u0014'&l\u0007\u000f\\3GK\u0006$XO]3Xe&$XM\u001d\u0005\b\u0007\u000fq\u0002\u0019AA\u0019\u0011\u001d\u0019IJ\ba\u0001\u00077\u000b\u0001cZ3u\r\u0016\fG/\u001e:f/JLG/\u001a:\u0015\r\r\u001561WB[\u0011\u001d\u00199a\ba\u0001\u0003cAqa!' \u0001\u0004\u0019Y\n\u0006\u0005\u0004&\u000ee61XBe\u0011\u001d\u00199\u0001\ta\u0001\u0003cAqa!0!\u0001\u0004\u0019y,\u0001\u0004gS2$XM\u001d\t\u0005\u0007\u0003\u001c)-\u0004\u0002\u0004D*!1QXB\u0018\u0013\u0011\u00199ma1\u0003\r\u0019KG\u000e^3s\u0011\u001d\u0019I\n\ta\u0001\u00077\u000bq\u0001Z5ta>\u001cX\r\u0006\u0002\u0003\u0000\u00069q-\u001a;J]\u001a|GCABj!\r\u00117Q[\u0005\u0004\u0007/\u001c'aC*feZL7-Z%oM>\f\u0011cZ3u\u0019>\u001c7.\u001b8h\u001b\u0006t\u0017mZ3s)\t\u0019i\u000eE\u0002c\u0007?L1a!9d\u00059aunY6j]\u001el\u0015M\\1hKJ\u0004")
public class LambdaDataStore
implements DataStore,
package.HasGeoMesaStats,
LazyLogging {
    private final DataStore persistence;
    public final scala.collection.immutable.Map<String, String> org$locationtech$geomesa$lambda$data$LambdaDataStore$$producerConfig;
    public final scala.collection.immutable.Map<String, String> org$locationtech$geomesa$lambda$data$LambdaDataStore$$consumerConfig;
    public final OffsetManager org$locationtech$geomesa$lambda$data$LambdaDataStore$$offsetManager;
    public final LambdaConfig org$locationtech$geomesa$lambda$data$LambdaDataStore$$config;
    public final Clock org$locationtech$geomesa$lambda$data$LambdaDataStore$$clock;
    private final Option<AuthorizationsProvider> org$locationtech$geomesa$lambda$data$LambdaDataStore$$authProvider;
    private final LoadingCache<String, TransientStore> transients;
    private final GeoMesaStats stats;
    private final LambdaQueryRunner runner;
    private Logger logger;
    private volatile boolean bitmap$0;

    public static Clock $lessinit$greater$default$6(DataStore dataStore, scala.collection.immutable.Map<String, String> map, scala.collection.immutable.Map<String, String> map2, OffsetManager offsetManager, LambdaConfig lambdaConfig) {
        return LambdaDataStore$.MODULE$.$lessinit$greater$default$6(dataStore, map, map2, offsetManager, lambdaConfig);
    }

    private Logger logger$lzycompute() {
        LambdaDataStore lambdaDataStore = this;
        synchronized (lambdaDataStore) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public DataStore persistence() {
        return this.persistence;
    }

    public Option<AuthorizationsProvider> org$locationtech$geomesa$lambda$data$LambdaDataStore$$authProvider() {
        return this.org$locationtech$geomesa$lambda$data$LambdaDataStore$$authProvider;
    }

    public LoadingCache<String, TransientStore> transients() {
        return this.transients;
    }

    public GeoMesaStats stats() {
        return this.stats;
    }

    private LambdaQueryRunner runner() {
        return this.runner;
    }

    public void persist(String typeName) {
        ((TransientStore)this.transients().get((Object)typeName)).persist();
    }

    public String[] getTypeNames() {
        return this.persistence().getTypeNames();
    }

    public List<Name> getNames() {
        return this.persistence().getNames();
    }

    public void createSchema(SimpleFeatureType sft) {
        this.persistence().createSchema((FeatureType)sft);
        String topic = KafkaStore$.MODULE$.topic(this.org$locationtech$geomesa$lambda$data$LambdaDataStore$$config.zkNamespace(), sft);
        Properties props = new Properties();
        this.org$locationtech$geomesa$lambda$data$LambdaDataStore$$producerConfig.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            Object object = props.put(k, v);
            return object;
        });
        package.WithClose$.MODULE$.apply((Object)AdminClient.create((Properties)props), (Function1 & Serializable & scala.Serializable)admin -> {
            Object object;
            if (((Set)admin.listTopics().names().get()).contains(topic)) {
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Topic [{}] already exists - it may contain stale data", new Object[]{topic});
                    object = BoxedUnit.UNIT;
                } else {
                    object = BoxedUnit.UNIT;
                }
            } else {
                int replication = BoxesRunTime.unboxToInt((Object)new GeoMesaSystemProperties.SystemProperty("geomesa.kafka.replication", GeoMesaSystemProperties.SystemProperty$.MODULE$.apply$default$2()).option().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)LambdaDataStore.$anonfun$createSchema$3(x$1))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 1));
                NewTopic newTopic = new NewTopic(topic, $this.org$locationtech$geomesa$lambda$data$LambdaDataStore$$config.partitions(), (short)replication);
                object = admin.createTopics(Collections.singletonList(newTopic)).all().get();
            }
            return object;
        }, IsCloseable$.MODULE$.closeableIsCloseable());
    }

    public SimpleFeatureType getSchema(Name typeName) {
        return this.getSchema(typeName.getLocalPart());
    }

    /*
     * WARNING - void declaration
     */
    public SimpleFeatureType getSchema(String typeName) {
        void var2_2;
        SimpleFeatureType sft = this.persistence().getSchema(typeName);
        Object object = sft != null ? this.transients().get((Object)typeName) : BoxedUnit.UNIT;
        return var2_2;
    }

    public void updateSchema(Name typeName, SimpleFeatureType featureType) {
        this.updateSchema(typeName.getLocalPart(), featureType);
    }

    public void updateSchema(String typeName, SimpleFeatureType featureType) {
        Object object;
        TransientStore transientStore = (TransientStore)this.transients().get((Object)typeName);
        String string = typeName;
        String string2 = featureType.getTypeName();
        if (string == null ? string2 != null : !string.equals(string2)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Update schema: entering quiet period");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            Thread.sleep(((Duration)new GeoMesaSystemProperties.SystemProperty("geomesa.lambda.update.quiet.period", "10 seconds").toDuration().get()).toMillis());
            object = package.WithClose$.MODULE$.apply(transientStore.read(transientStore.read$default$1(), transientStore.read$default$2(), transientStore.read$default$3(), transientStore.read$default$4()), (Function1 & Serializable & scala.Serializable)toPersist -> {
                LambdaDataStore.$anonfun$updateSchema$1(this, typeName, toPersist);
                return BoxedUnit.UNIT;
            }, IsCloseable$.MODULE$.closeableIsCloseable());
        } else {
            object = BoxedUnit.UNIT;
        }
        package.CloseWithLogging$.MODULE$.apply((Object)transientStore, IsCloseable$.MODULE$.closeableIsCloseable());
        this.transients().invalidate((Object)typeName);
        this.persistence().updateSchema(typeName, featureType);
    }

    public void removeSchema(Name typeName) {
        this.removeSchema(typeName.getLocalPart());
    }

    public void removeSchema(String typeName) {
        TransientStore transientStore = (TransientStore)this.transients().get((Object)typeName);
        transientStore.removeSchema();
        package.CloseWithLogging$.MODULE$.apply((Object)transientStore, IsCloseable$.MODULE$.closeableIsCloseable());
        this.transients().invalidate((Object)typeName);
        this.persistence().removeSchema(typeName);
    }

    public SimpleFeatureSource getFeatureSource(Name typeName) {
        return this.getFeatureSource(typeName.getLocalPart());
    }

    public SimpleFeatureSource getFeatureSource(String typeName) {
        return new GeoMesaFeatureStore((DataStore)this, this.getSchema(typeName), (QueryRunner)this.runner());
    }

    public SimpleFeatureReader getFeatureReader(Query query, Transaction transaction) {
        return GeoMesaFeatureReader$.MODULE$.apply(this.getSchema(query.getTypeName()), query, (QueryRunner)this.runner(), (Option)None$.MODULE$, (Option)None$.MODULE$);
    }

    public SimpleFeatureWriter getFeatureWriterAppend(String typeName, Transaction transaction) {
        TransientStore transientStore = (TransientStore)this.transients().get((Object)typeName);
        return RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.isVisibilityRequired$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(transientStore.sft())) ? new LambdaFeatureWriter.RequiredVisibilityWriter(null, transientStore){

            public /* synthetic */ void org$locationtech$geomesa$lambda$data$LambdaFeatureWriter$RequiredVisibilityWriter$$super$write() {
                super.write();
            }

            public void write() {
                LambdaFeatureWriter.RequiredVisibilityWriter.write$(this);
            }

            public void requireVisibilities(SimpleFeature feature) throws IllegalArgumentException {
                VisibilityChecker.requireVisibilities$((VisibilityChecker)this, (SimpleFeature)feature);
            }
            {
                VisibilityChecker.$init$((VisibilityChecker)this);
                LambdaFeatureWriter.RequiredVisibilityWriter.$init$(this);
            }
        } : new LambdaFeatureWriter.AppendLambdaFeatureWriter(transientStore);
    }

    public SimpleFeatureWriter getFeatureWriter(String typeName, Transaction transaction) {
        return this.getFeatureWriter(typeName, (Filter)Filter.INCLUDE, transaction);
    }

    public SimpleFeatureWriter getFeatureWriter(String typeName, Filter filter, Transaction transaction) {
        Query query = new Query(typeName, filter);
        SelfClosingIterator features = SelfClosingIterator$.MODULE$.apply((FeatureReader)this.getFeatureReader(query, transaction));
        TransientStore transientStore = (TransientStore)this.transients().get((Object)typeName);
        return RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.isVisibilityRequired$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(transientStore.sft())) ? new LambdaFeatureWriter.RequiredVisibilityWriter(null, transientStore, features){

            public /* synthetic */ void org$locationtech$geomesa$lambda$data$LambdaFeatureWriter$RequiredVisibilityWriter$$super$write() {
                super.write();
            }

            public void write() {
                LambdaFeatureWriter.RequiredVisibilityWriter.write$(this);
            }

            public void requireVisibilities(SimpleFeature feature) throws IllegalArgumentException {
                VisibilityChecker.requireVisibilities$((VisibilityChecker)this, (SimpleFeature)feature);
            }
            {
                VisibilityChecker.$init$((VisibilityChecker)this);
                LambdaFeatureWriter.RequiredVisibilityWriter.$init$(this);
            }
        } : new LambdaFeatureWriter.ModifyLambdaFeatureWriter(transientStore, (CloseableIterator<SimpleFeature>)features);
    }

    public void dispose() {
        package.CloseWithLogging$.MODULE$.apply((Object)((MapLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.transients().asMap()).asScala()).values(), (IsCloseable)IsCloseable$.MODULE$.iterableIsCloseable());
        this.transients().invalidateAll();
        package.CloseWithLogging$.MODULE$.apply((Object)this.org$locationtech$geomesa$lambda$data$LambdaDataStore$$offsetManager, IsCloseable$.MODULE$.closeableIsCloseable());
        this.persistence().dispose();
    }

    /*
     * WARNING - void declaration
     */
    public ServiceInfo getInfo() {
        void var1_1;
        DefaultServiceInfo info = new DefaultServiceInfo();
        info.setDescription(new StringBuilder(14).append("Features from ").append(this.getClass().getSimpleName()).toString());
        info.setSchema(FeatureTypes.DEFAULT_NAMESPACE);
        return var1_1;
    }

    public LockingManager getLockingManager() {
        return null;
    }

    public static final /* synthetic */ int $anonfun$createSchema$3(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toInt();
    }

    public static final /* synthetic */ void $anonfun$updateSchema$1(LambdaDataStore $this, String typeName$1, CloseableIterator toPersist) {
        block2: {
            BoxedUnit boxedUnit;
            if (!toPersist.nonEmpty()) break block2;
            if ($this.logger().underlying().isDebugEnabled()) {
                $this.logger().underlying().debug("Update schema: persisting transient features");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            package.WithClose$.MODULE$.apply((Object)$this.persistence().getFeatureWriter(typeName$1, Transaction.AUTO_COMMIT), (Function1 & Serializable & scala.Serializable)writer -> {
                toPersist.foreach((Function1 & Serializable & scala.Serializable)x$2 -> FeatureUtils$.MODULE$.write(writer, x$2, true));
                return BoxedUnit.UNIT;
            }, IsCloseable$.MODULE$.closeableIsCloseable());
        }
    }

    public LambdaDataStore(DataStore persistence, scala.collection.immutable.Map<String, String> producerConfig, scala.collection.immutable.Map<String, String> consumerConfig, OffsetManager offsetManager, LambdaConfig config, Clock clock) {
        Object object;
        None$ none$;
        this.persistence = persistence;
        this.org$locationtech$geomesa$lambda$data$LambdaDataStore$$producerConfig = producerConfig;
        this.org$locationtech$geomesa$lambda$data$LambdaDataStore$$consumerConfig = consumerConfig;
        this.org$locationtech$geomesa$lambda$data$LambdaDataStore$$offsetManager = offsetManager;
        this.org$locationtech$geomesa$lambda$data$LambdaDataStore$$config = config;
        this.org$locationtech$geomesa$lambda$data$LambdaDataStore$$clock = clock;
        LazyLogging.$init$((LazyLogging)this);
        DataStore dataStore = persistence;
        if (dataStore instanceof AccumuloDataStore) {
            AccumuloDataStore accumuloDataStore = (AccumuloDataStore)dataStore;
            none$ = new Some((Object)accumuloDataStore.config().authProvider());
        } else {
            none$ = None$.MODULE$;
        }
        this.org$locationtech$geomesa$lambda$data$LambdaDataStore$$authProvider = none$;
        this.transients = Caffeine.newBuilder().build((CacheLoader)new CacheLoader<String, TransientStore>(this){
            private final /* synthetic */ LambdaDataStore $outer;

            @Nonnull
            public Map<String, TransientStore> loadAll(Iterable<? extends String> x$1) throws Exception {
                return super.loadAll(x$1);
            }

            @Nonnull
            public CompletableFuture asyncLoad(Object x$1, Executor x$2) {
                return super.asyncLoad(x$1, x$2);
            }

            @Nonnull
            public CompletableFuture<Map<String, TransientStore>> asyncLoadAll(Iterable<? extends String> x$1, Executor x$2) {
                return super.asyncLoadAll(x$1, x$2);
            }

            @CheckForNull
            public Object reload(Object x$1, Object x$2) throws Exception {
                return super.reload(x$1, x$2);
            }

            @Nonnull
            public CompletableFuture asyncReload(Object x$1, Object x$2, Executor x$3) {
                return super.asyncReload(x$1, x$2, x$3);
            }

            public TransientStore load(String key) {
                SimpleFeatureType sft = this.$outer.persistence().getSchema(key);
                return new KafkaStore(this.$outer.persistence(), sft, this.$outer.org$locationtech$geomesa$lambda$data$LambdaDataStore$$authProvider(), this.$outer.org$locationtech$geomesa$lambda$data$LambdaDataStore$$offsetManager, this.$outer.org$locationtech$geomesa$lambda$data$LambdaDataStore$$producerConfig, this.$outer.org$locationtech$geomesa$lambda$data$LambdaDataStore$$consumerConfig, this.$outer.org$locationtech$geomesa$lambda$data$LambdaDataStore$$config, this.$outer.org$locationtech$geomesa$lambda$data$LambdaDataStore$$clock);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        DataStore dataStore2 = persistence;
        if (dataStore2 instanceof package.HasGeoMesaStats) {
            DataStore dataStore3 = dataStore2;
            object = new LambdaStats(((package.HasGeoMesaStats)dataStore3).stats(), this.transients());
        } else {
            object = package.NoopStats$.MODULE$;
        }
        this.stats = object;
        this.runner = new LambdaQueryRunner(this, persistence, this.transients());
    }

    public static class LambdaConfig
    implements Product,
    scala.Serializable {
        private final String zookeepers;
        private final String zkNamespace;
        private final int partitions;
        private final int consumers;
        private final Duration expiry;
        private final boolean persist;

        public String zookeepers() {
            return this.zookeepers;
        }

        public String zkNamespace() {
            return this.zkNamespace;
        }

        public int partitions() {
            return this.partitions;
        }

        public int consumers() {
            return this.consumers;
        }

        public Duration expiry() {
            return this.expiry;
        }

        public boolean persist() {
            return this.persist;
        }

        public LambdaConfig copy(String zookeepers, String zkNamespace, int partitions, int consumers, Duration expiry, boolean persist) {
            return new LambdaConfig(zookeepers, zkNamespace, partitions, consumers, expiry, persist);
        }

        public String copy$default$1() {
            return this.zookeepers();
        }

        public String copy$default$2() {
            return this.zkNamespace();
        }

        public int copy$default$3() {
            return this.partitions();
        }

        public int copy$default$4() {
            return this.consumers();
        }

        public Duration copy$default$5() {
            return this.expiry();
        }

        public boolean copy$default$6() {
            return this.persist();
        }

        public String productPrefix() {
            return "LambdaConfig";
        }

        public int productArity() {
            return 6;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.zookeepers();
                    break;
                }
                case 1: {
                    object = this.zkNamespace();
                    break;
                }
                case 2: {
                    object = BoxesRunTime.boxToInteger((int)this.partitions());
                    break;
                }
                case 3: {
                    object = BoxesRunTime.boxToInteger((int)this.consumers());
                    break;
                }
                case 4: {
                    object = this.expiry();
                    break;
                }
                case 5: {
                    object = BoxesRunTime.boxToBoolean((boolean)this.persist());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(Integer.toString(x$1));
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof LambdaConfig;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.zookeepers()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.zkNamespace()));
            n = Statics.mix((int)n, (int)this.partitions());
            n = Statics.mix((int)n, (int)this.consumers());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.expiry()));
            n = Statics.mix((int)n, (int)(this.persist() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)6);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof LambdaConfig)) return false;
            boolean bl = true;
            if (!bl) return false;
            LambdaConfig lambdaConfig = (LambdaConfig)x$1;
            String string = this.zookeepers();
            String string2 = lambdaConfig.zookeepers();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.zkNamespace();
            String string4 = lambdaConfig.zkNamespace();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            if (this.partitions() != lambdaConfig.partitions()) return false;
            if (this.consumers() != lambdaConfig.consumers()) return false;
            Duration duration = this.expiry();
            Duration duration2 = lambdaConfig.expiry();
            if (duration == null) {
                if (duration2 != null) {
                    return false;
                }
            } else if (!duration.equals(duration2)) return false;
            if (this.persist() != lambdaConfig.persist()) return false;
            if (!lambdaConfig.canEqual(this)) return false;
            return true;
        }

        public LambdaConfig(String zookeepers, String zkNamespace, int partitions, int consumers, Duration expiry, boolean persist) {
            this.zookeepers = zookeepers;
            this.zkNamespace = zkNamespace;
            this.partitions = partitions;
            this.consumers = consumers;
            this.expiry = expiry;
            this.persist = persist;
            Product.$init$((Product)this);
        }
    }
}

