/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.lambda.stream.kafka;

import java.time.Duration;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.locationtech.geomesa.features.kryo.KryoFeatureSerializer;
import org.locationtech.geomesa.kafka.consumer.ThreadedConsumer;
import org.locationtech.geomesa.kafka.consumer.ThreadedConsumer$;
import org.locationtech.geomesa.lambda.stream.kafka.KafkaFeatureCache;
import org.locationtech.geomesa.lambda.stream.kafka.KafkaStore$;
import org.locationtech.geomesa.lambda.stream.kafka.KafkaStore$MessageTypes$;
import org.opengis.feature.simple.SimpleFeature;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001m4A\u0001C\u0005\u0001-!Aa\u0004\u0001B\u0001B\u0003%q\u0004\u0003\u0005?\u0001\t\u0005\t\u0015!\u0003@\u0011!9\u0005A!A!\u0002\u0013A\u0005\u0002C&\u0001\u0005\u0003\u0005\u000b\u0011\u0002'\t\u0011Q\u0003!\u0011!Q\u0001\nUCQ\u0001\u001b\u0001\u0005\u0002%DQ!\u001d\u0001\u0005RI\u0014\u0001cS1gW\u0006\u001c\u0015m\u00195f\u0019>\fG-\u001a:\u000b\u0005)Y\u0011!B6bM.\f'B\u0001\u0007\u000e\u0003\u0019\u0019HO]3b[*\u0011abD\u0001\u0007Y\u0006l'\rZ1\u000b\u0005A\t\u0012aB4f_6,7/\u0019\u0006\u0003%M\tA\u0002\\8dCRLwN\u001c;fG\"T\u0011\u0001F\u0001\u0004_J<7\u0001A\n\u0003\u0001]\u0001\"\u0001\u0007\u000f\u000e\u0003eQ!AG\u000e\u0002\u0011\r|gn];nKJT!AC\b\n\u0005uI\"\u0001\u0005+ie\u0016\fG-\u001a3D_:\u001cX/\\3s\u0003%\u0019wN\\:v[\u0016\u00148\u000fE\u0002!U5r!!I\u0014\u000f\u0005\t*S\"A\u0012\u000b\u0005\u0011*\u0012A\u0002\u001fs_>$h(C\u0001'\u0003\u0015\u00198-\u00197b\u0013\tA\u0013&A\u0004qC\u000e\\\u0017mZ3\u000b\u0003\u0019J!a\u000b\u0017\u0003\u0007M+\u0017O\u0003\u0002)SA!a&N\u001c8\u001b\u0005y#B\u0001\u000e1\u0015\t\t$'A\u0004dY&,g\u000e^:\u000b\u0005)\u0019$B\u0001\u001b\u0014\u0003\u0019\t\u0007/Y2iK&\u0011ag\f\u0002\t\u0007>t7/^7feB\u0019\u0001(O\u001e\u000e\u0003%J!AO\u0015\u0003\u000b\u0005\u0013(/Y=\u0011\u0005ab\u0014BA\u001f*\u0005\u0011\u0011\u0015\u0010^3\u0002\u000bQ|\u0007/[2\u0011\u0005\u0001#eBA!C!\t\u0011\u0013&\u0003\u0002DS\u00051\u0001K]3eK\u001aL!!\u0012$\u0003\rM#(/\u001b8h\u0015\t\u0019\u0015&A\u0005ge\u0016\fX/\u001a8dsB\u0011\u0001(S\u0005\u0003\u0015&\u0012A\u0001T8oO\u0006Q1/\u001a:jC2L'0\u001a:\u0011\u00055\u0013V\"\u0001(\u000b\u0005=\u0003\u0016\u0001B6ss>T!!U\b\u0002\u0011\u0019,\u0017\r^;sKNL!a\u0015(\u0003+-\u0013\u0018p\u001c$fCR,(/Z*fe&\fG.\u001b>fe\u0006)1-Y2iKB\u0011a+\u001a\b\u0003/\u000et!\u0001\u00172\u000f\u0005e\u000bgB\u0001.a\u001d\tYvL\u0004\u0002]=:\u0011!%X\u0005\u0002)%\u0011!cE\u0005\u0003!EI!AD\b\n\u00051i\u0011B\u0001\u0006\f\u0013\t!\u0017\"A\tLC\u001a\\\u0017MR3biV\u0014XmQ1dQ\u0016L!AZ4\u0003)]\u0013\u0018\u000e^1cY\u00164U-\u0019;ve\u0016\u001c\u0015m\u00195f\u0015\t!\u0017\"\u0001\u0004=S:LGO\u0010\u000b\u0007U2lgn\u001c9\u0011\u0005-\u0004Q\"A\u0005\t\u000by1\u0001\u0019A\u0010\t\u000by2\u0001\u0019A \t\u000b\u001d3\u0001\u0019\u0001%\t\u000b-3\u0001\u0019\u0001'\t\u000bQ3\u0001\u0019A+\u0002\u000f\r|gn];nKR\u00111O\u001e\t\u0003qQL!!^\u0015\u0003\tUs\u0017\u000e\u001e\u0005\u0006o\u001e\u0001\r\u0001_\u0001\u0007e\u0016\u001cwN\u001d3\u0011\t9JxgN\u0005\u0003u>\u0012abQ8ogVlWM\u001d*fG>\u0014H\r")
public class KafkaCacheLoader
extends ThreadedConsumer {
    private final KryoFeatureSerializer serializer;
    private final KafkaFeatureCache.WritableFeatureCache cache;

    public void consume(ConsumerRecord<byte[], byte[]> record) {
        Tuple2<Object, Object> tuple2 = KafkaStore$.MODULE$.deserializeKey((byte[])record.key());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        long time = tuple2._1$mcJ$sp();
        byte action = BoxesRunTime.unboxToByte((Object)tuple2._2());
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)time), (Object)BoxesRunTime.boxToByte((byte)action));
        Tuple2 tuple23 = tuple22;
        long time2 = tuple23._1$mcJ$sp();
        byte action2 = BoxesRunTime.unboxToByte((Object)tuple23._2());
        SimpleFeature feature = this.serializer.deserialize((byte[])record.value());
        byte by = action2;
        if (KafkaStore$MessageTypes$.MODULE$.Write() == by) {
            this.cache.add(feature, record.partition(), record.offset(), time2);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (KafkaStore$MessageTypes$.MODULE$.Delete() == by) {
            this.cache.delete(feature, record.partition(), record.offset(), time2);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Unhandled message type: {}", new Object[]{BoxesRunTime.boxToByte((byte)action2)});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }
    }

    public KafkaCacheLoader(Seq<Consumer<byte[], byte[]>> consumers, String topic, long frequency, KryoFeatureSerializer serializer, KafkaFeatureCache.WritableFeatureCache cache) {
        this.serializer = serializer;
        this.cache = cache;
        super(consumers, Duration.ofMillis(frequency), ThreadedConsumer$.MODULE$.$lessinit$greater$default$3());
        this.startConsumers(this.startConsumers$default$1());
    }
}

