/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.lambda.stream.kafka;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayDeque;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.locationtech.geomesa.lambda.stream.OffsetManager;
import org.opengis.feature.simple.SimpleFeature;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t\u001db\u0001B\u0012%\u0001EB\u0011\"!\u001b\u0001\u0005\u0003\u0005\u000b\u0011\u00026\t\r5\u0003A\u0011AA6\u0011%\t\t\b\u0001b\u0001\n\u0013\t\u0019\b\u0003\u0005\u0002\n\u0002\u0001\u000b\u0011BA;\u0011%\tY\t\u0001b\u0001\n\u0013\ti\t\u0003\u0005\u0002<\u0002\u0001\u000b\u0011BAH\u0011%\ti\f\u0001b\u0001\n\u0013\ty\f\u0003\u0005\u0002P\u0002\u0001\u000b\u0011BAa\u0011%\t\t\u000e\u0001b\u0001\n\u0013\t\u0019\u000e\u0003\u0005\u0002\\\u0002\u0001\u000b\u0011BAk\u0011\u0019!\b\u0001\"\u0011\u0002^\"1a\r\u0001C!\u0003GDQ!\u0015\u0001\u0005BICq!a\u0002\u0001\t\u0003\n9\u000fC\u0004\u0002\u0016\u0001!\t%!=\t\u000f\u0005\u0015\u0002\u0001\"\u0011\u0002|\"9\u0011Q\u0005\u0001\u0005B\u0005}\bb\u0002B\u0003\u0001\u0011\u0005#q\u0001\u0005\b\u0005\u001b\u0001A\u0011\u0002B\b\u0011\u001d\u0011)\u0002\u0001C\u0005\u0005/AqAa\u0007\u0001\t\u0013\u0011ibB\u0003JI!\u0005!JB\u0003$I!\u0005A\nC\u0003N/\u0011\u0005aJB\u0004P/A\u0005\u0019\u0013\u0001)\t\u000bEKb\u0011\u0001*\t\u000b\u0019Lb\u0011A4\u0007\u000fI<\u0002\u0013aI\u0001g\")A\u000f\bD\u0001k\"9\u0011q\u0001\u000f\u0007\u0002\u0005%\u0001bBA\u000b9\u0019\u0005\u0011q\u0003\u0004\n\u0003C9\u0002\u0013aI\u0001\u0003GAq!!\n!\r\u0003\t9\u0003C\u0004\u0002&\u00012\t!a\r\u0003#-\u000bgm[1GK\u0006$XO]3DC\u000eDWM\u0003\u0002&M\u0005)1.\u00194lC*\u0011q\u0005K\u0001\u0007gR\u0014X-Y7\u000b\u0005%R\u0013A\u00027b[\n$\u0017M\u0003\u0002,Y\u00059q-Z8nKN\f'BA\u0017/\u00031awnY1uS>tG/Z2i\u0015\u0005y\u0013aA8sO\u000e\u00011c\u0003\u00013q\u0005\r\u0013QIA$\u0003+\u0002\"a\r\u001c\u000e\u0003QR\u0011!N\u0001\u0006g\u000e\fG.Y\u0005\u0003oQ\u0012a!\u00118z%\u00164\u0007CA\u001d\u001d\u001d\tQdC\u0004\u0002<\u0011:\u0011Ah\u0012\b\u0003{\u0019s!AP#\u000f\u0005}\"eB\u0001!D\u001b\u0005\t%B\u0001\"1\u0003\u0019a$o\\8u}%\tq&\u0003\u0002.]%\u00111\u0006L\u0005\u0003S)J!a\n\u0015\n\u0005\u00152\u0013!E&bM.\fg)Z1ukJ,7)Y2iKB\u00111jF\u0007\u0002IM\u0011qCM\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003)\u0013ACU3bI\u0006\u0014G.\u001a$fCR,(/Z\"bG\",7CA\r3\u0003\r\tG\u000e\u001c\u000b\u0002'B\u0019A+\u0017/\u000f\u0005U;fB\u0001!W\u0013\u0005)\u0014B\u0001-5\u0003\u001d\u0001\u0018mY6bO\u0016L!AW.\u0003\u0011%#XM]1u_JT!\u0001\u0017\u001b\u0011\u0005u#W\"\u00010\u000b\u0005}\u0003\u0017AB:j[BdWM\u0003\u0002bE\u00069a-Z1ukJ,'BA2/\u0003\u001dy\u0007/\u001a8hSNL!!\u001a0\u0003\u001bMKW\u000e\u001d7f\r\u0016\fG/\u001e:f\u0003\r9W\r\u001e\u000b\u00039\"DQ![\u000eA\u0002)\f!!\u001b3\u0011\u0005-|gB\u00017n!\t\u0001E'\u0003\u0002oi\u00051\u0001K]3eK\u001aL!\u0001]9\u0003\rM#(/\u001b8h\u0015\tqGG\u0001\u000bXe&$\u0018M\u00197f\r\u0016\fG/\u001e:f\u0007\u0006\u001c\u0007.Z\n\u00039I\n\u0011\u0003]1si&$\u0018n\u001c8BgNLwM\\3e)\r1\u0018P \t\u0003g]L!\u0001\u001f\u001b\u0003\tUs\u0017\u000e\u001e\u0005\u0006uv\u0001\ra_\u0001\na\u0006\u0014H/\u001b;j_:\u0004\"a\r?\n\u0005u$$aA%oi\"1q0\ba\u0001\u0003\u0003\taa\u001c4gg\u0016$\bcA\u001a\u0002\u0004%\u0019\u0011Q\u0001\u001b\u0003\t1{gnZ\u0001\u0004C\u0012$G#\u0003<\u0002\f\u00055\u0011qBA\t\u0011\u0015\tg\u00041\u0001]\u0011\u0015Qh\u00041\u0001|\u0011\u0019yh\u00041\u0001\u0002\u0002!9\u00111\u0003\u0010A\u0002\u0005\u0005\u0011aB2sK\u0006$X\rZ\u0001\u0007I\u0016dW\r^3\u0015\u0013Y\fI\"a\u0007\u0002\u001e\u0005}\u0001\"B1 \u0001\u0004a\u0006\"\u0002> \u0001\u0004Y\bBB@ \u0001\u0004\t\t\u0001C\u0004\u0002\u0014}\u0001\r!!\u0001\u0003)\u0015C\b/\u001b:j]\u001e4U-\u0019;ve\u0016\u001c\u0015m\u00195f'\t\u0001#'A\u0004fqBL'/\u001a3\u0015\t\u0005%\u0012q\u0006\t\u0005)\u0006-20C\u0002\u0002.m\u00131aU3r\u0011\u001d\t\t$\ta\u0001\u0003\u0003\ta!\u001a=qSJLHCBA\u001b\u0003\u007f\t\t\u0005E\u00044\u0003o\t\t!a\u000f\n\u0007\u0005eBG\u0001\u0004UkBdWM\r\t\u0006)\u0006-\u0012Q\b\t\u0007g\u0005]\u0012\u0011\u0001/\t\u000bi\u0014\u0003\u0019A>\t\u000f\u0005E\"\u00051\u0001\u0002\u0002A\u0011\u0011(\u0007\t\u0003s\u0001\u0002B!!\u0013\u0002P9\u00191(a\u0013\n\u0007\u00055c%A\u0007PM\u001a\u001cX\r^'b]\u0006<WM]\u0005\u0005\u0003#\n\u0019F\u0001\bPM\u001a\u001cX\r\u001e'jgR,g.\u001a:\u000b\u0007\u00055c\u0005\u0005\u0003\u0002X\u0005\u0015TBAA-\u0015\u0011\tY&!\u0018\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\t\u0005}\u0013\u0011M\u0001\tif\u0004Xm]1gK*\u0011\u00111M\u0001\u0004G>l\u0017\u0002BA4\u00033\u00121\u0002T1{s2{wmZ5oO\u0006)Ao\u001c9jGR!\u0011QNA8!\tY\u0005\u0001\u0003\u0004\u0002j\t\u0001\rA[\u0001\tM\u0016\fG/\u001e:fgV\u0011\u0011Q\u000f\t\u0007\u0003o\n)I\u001b/\u000e\u0005\u0005e$\u0002BA>\u0003{\n!bY8oGV\u0014(/\u001a8u\u0015\u0011\ty(!!\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003\u0007\u000bAA[1wC&!\u0011qQA=\u0005E\u0019uN\\2veJ,g\u000e\u001e%bg\"l\u0015\r]\u0001\nM\u0016\fG/\u001e:fg\u0002\na!];fk\u0016\u001cXCAAH!\u0019\t\t*a'\u0002 6\u0011\u00111\u0013\u0006\u0005\u0003+\u000b9*A\u0004nkR\f'\r\\3\u000b\u0007\u0005eE'\u0001\u0006d_2dWm\u0019;j_:LA!!(\u0002\u0014\nY\u0011I\u001d:bs\n+hMZ3s!\u001d\u0019\u0014qGAQ\u0003[\u0003B!a)\u0002*6\u0011\u0011Q\u0015\u0006\u0005\u0003O\u000bI(A\u0003m_\u000e\\7/\u0003\u0003\u0002,\u0006\u0015&!\u0004*fK:$(/\u00198u\u0019>\u001c7\u000e\u0005\u0004\u00020\u0006E\u0016QW\u0007\u0003\u0003{JA!a-\u0002~\tQ\u0011I\u001d:bs\u0012+\u0017/^3\u0011\u0011M\n9,!\u0001\u0002\u0002qK1!!/5\u0005\u0019!V\u000f\u001d7fg\u00059\u0011/^3vKN\u0004\u0013aB8gMN,Go]\u000b\u0003\u0003\u0003\u0004b!!%\u0002\u001c\u0006\r\u0007\u0003BAc\u0003\u0017l!!a2\u000b\t\u0005%\u0017\u0011P\u0001\u0007CR|W.[2\n\t\u00055\u0017q\u0019\u0002\u000b\u0003R|W.[2M_:<\u0017\u0001C8gMN,Go\u001d\u0011\u0002\u000b\u0011,'-^4\u0016\u0005\u0005U\u0007cA\u001a\u0002X&\u0019\u0011\u0011\u001c\u001b\u0003\u000f\t{w\u000e\\3b]\u00061A-\u001a2vO\u0002\"RA^Ap\u0003CDQA_\u0006A\u0002mDaa`\u0006A\u0002\u0005\u0005Ac\u0001/\u0002f\")\u0011\u000e\u0004a\u0001URIa/!;\u0002l\u00065\u0018q\u001e\u0005\u0006C:\u0001\r\u0001\u0018\u0005\u0006u:\u0001\ra\u001f\u0005\u0007\u007f:\u0001\r!!\u0001\t\u000f\u0005Ma\u00021\u0001\u0002\u0002QIa/a=\u0002v\u0006]\u0018\u0011 \u0005\u0006C>\u0001\r\u0001\u0018\u0005\u0006u>\u0001\ra\u001f\u0005\u0007\u007f>\u0001\r!!\u0001\t\u000f\u0005Mq\u00021\u0001\u0002\u0002Q!\u0011\u0011FA\u007f\u0011\u001d\t\t\u0004\u0005a\u0001\u0003\u0003!b!!\u000e\u0003\u0002\t\r\u0001\"\u0002>\u0012\u0001\u0004Y\bbBA\u0019#\u0001\u0007\u0011\u0011A\u0001\u000e_\u001a47/\u001a;DQ\u0006tw-\u001a3\u0015\u000bY\u0014IAa\u0003\t\u000bi\u0014\u0002\u0019A>\t\r}\u0014\u0002\u0019AA\u0001\u0003=)gn];sKB\u000b'\u000f^5uS>tG#\u0002<\u0003\u0012\tM\u0001\"\u0002>\u0014\u0001\u0004Y\bBB@\u0014\u0001\u0004\t\t!\u0001\u0004sK6|g/\u001a\u000b\u0005\u0003+\u0014I\u0002C\u0003b)\u0001\u0007A,\u0001\u0003eS\u001a4G#\u00026\u0003 \t\r\u0002B\u0002B\u0011+\u0001\u000710\u0001\u0005pe&<\u0017N\\1m\u0011\u0019\u0011)#\u0006a\u0001w\u00069Q\u000f\u001d3bi\u0016$\u0007")
public class KafkaFeatureCache
implements WritableFeatureCache,
ReadableFeatureCache,
ExpiringFeatureCache,
OffsetManager.OffsetListener,
LazyLogging {
    private final String topic;
    private final ConcurrentHashMap<String, SimpleFeature> features;
    private final ArrayBuffer<Tuple2<ReentrantLock, ArrayDeque<Tuple3<Object, Object, SimpleFeature>>>> queues;
    private final ArrayBuffer<AtomicLong> offsets;
    private final boolean debug;
    private Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        KafkaFeatureCache kafkaFeatureCache = this;
        synchronized (kafkaFeatureCache) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    private ConcurrentHashMap<String, SimpleFeature> features() {
        return this.features;
    }

    private ArrayBuffer<Tuple2<ReentrantLock, ArrayDeque<Tuple3<Object, Object, SimpleFeature>>>> queues() {
        return this.queues;
    }

    private ArrayBuffer<AtomicLong> offsets() {
        return this.offsets;
    }

    private boolean debug() {
        return this.debug;
    }

    @Override
    public void partitionAssigned(int partition, long offset) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Partition assigned: [{}:{}:{}]", new Object[]{this.topic, BoxesRunTime.boxToInteger((int)partition), BoxesRunTime.boxToLong((long)offset)});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.ensurePartition(partition, offset);
    }

    @Override
    public SimpleFeature get(String id) {
        return this.features().get(id);
    }

    @Override
    public Iterator<SimpleFeature> all() {
        return (Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(this.features().values().iterator()).asScala();
    }

    @Override
    public void add(SimpleFeature feature, int partition, long offset, long created) {
        BoxedUnit boxedUnit;
        if (((AtomicLong)this.offsets().apply(partition)).get() < offset) {
            BoxedUnit boxedUnit2;
            if (this.logger().underlying().isTraceEnabled()) {
                this.logger().underlying().trace(new StringBuilder(23).append("Adding [").append(partition).append(":").append(offset).append("] ").append(feature).append(" created at ").append(ZonedDateTime.ofInstant(Instant.ofEpochMilli(created), ZoneOffset.UTC)).toString());
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            this.features().put(feature.getID(), feature);
            Tuple2 tuple2 = (Tuple2)this.queues().apply(partition);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ReentrantLock lock = (ReentrantLock)tuple2._1();
            ArrayDeque queue = (ArrayDeque)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)lock, (Object)queue);
            Tuple2 tuple23 = tuple22;
            ReentrantLock lock2 = (ReentrantLock)tuple23._1();
            ArrayDeque queue2 = (ArrayDeque)tuple23._2();
            lock2.lock();
            try {
                queue2.addLast(new Tuple3((Object)BoxesRunTime.boxToLong((long)offset), (Object)BoxesRunTime.boxToLong((long)created), (Object)feature));
            }
            finally {
                lock2.unlock();
            }
        } else if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace(new StringBuilder(25).append("Ignoring [").append(partition).append(":").append(offset).append("] ").append(feature).append(" created at ").append(ZonedDateTime.ofInstant(Instant.ofEpochMilli(created), ZoneOffset.UTC)).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    @Override
    public void delete(SimpleFeature feature, int partition, long offset, long created) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace(new StringBuilder(25).append("Deleting [").append(partition).append(":").append(offset).append("] ").append(feature).append(" created at ").append(ZonedDateTime.ofInstant(Instant.ofEpochMilli(created), ZoneOffset.UTC)).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.features().remove(feature.getID());
    }

    @Override
    public Seq<Object> expired(long expiry) {
        ArrayBuffer result = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        for (int i = 0; i < this.queues().length(); ++i) {
            BoxedUnit boxedUnit;
            Tuple3 peek;
            Tuple3 tuple3;
            Tuple2 tuple2 = (Tuple2)this.queues().apply(i);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ReentrantLock lock = (ReentrantLock)tuple2._1();
            ArrayDeque queue = (ArrayDeque)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)lock, (Object)queue);
            Tuple2 tuple23 = tuple22;
            ReentrantLock lock2 = (ReentrantLock)tuple23._1();
            ArrayDeque queue2 = (ArrayDeque)tuple23._2();
            lock2.lock();
            try {
                tuple3 = (Tuple3)queue2.peek();
            }
            finally {
                lock2.unlock();
            }
            Tuple3 tuple32 = peek = tuple3;
            if (tuple32 == null) {
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (tuple32 != null) {
                long created = BoxesRunTime.unboxToLong((Object)tuple32._2());
                boxedUnit = expiry > created ? result.$plus$eq((Object)BoxesRunTime.boxToInteger((int)i)) : BoxedUnit.UNIT;
                continue;
            }
            throw new MatchError((Object)tuple32);
        }
        return result;
    }

    @Override
    public Tuple2<Object, Seq<Tuple2<Object, SimpleFeature>>> expired(int partition, long expiry) {
        BoxedUnit boxedUnit;
        ArrayBuffer expired = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        Tuple2 tuple2 = (Tuple2)this.queues().apply(partition);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ReentrantLock lock = (ReentrantLock)tuple2._1();
        ArrayDeque queue = (ArrayDeque)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)lock, (Object)queue);
        Tuple2 tuple23 = tuple22;
        ReentrantLock lock2 = (ReentrantLock)tuple23._1();
        ArrayDeque queue2 = (ArrayDeque)tuple23._2();
        boolean loop = true;
        while (loop) {
            BoxedUnit boxedUnit2;
            lock2.lock();
            Tuple3 poll = (Tuple3)queue2.poll();
            if (poll == null) {
                lock2.unlock();
                loop = false;
                boxedUnit2 = BoxedUnit.UNIT;
                continue;
            }
            if (BoxesRunTime.unboxToLong((Object)poll._2()) > expiry) {
                try {
                    queue2.addFirst(poll);
                }
                finally {
                    lock2.unlock();
                }
                loop = false;
                boxedUnit2 = BoxedUnit.UNIT;
                continue;
            }
            lock2.unlock();
            boxedUnit2 = expired.$plus$eq((Object)new Tuple2(poll._1(), poll._3()));
        }
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Checking [{}:{}] for expired entries: found {} expired and {} remaining", new Object[]{this.topic, BoxesRunTime.boxToInteger((int)partition), BoxesRunTime.boxToInteger((int)expired.size()), BoxesRunTime.boxToInteger((int)queue2.size())});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        long maxExpiredOffset = expired.isEmpty() ? -1L : ((Tuple2)expired.apply(expired.length() - 1))._1$mcJ$sp();
        ArrayBuffer latest = (ArrayBuffer)expired.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)KafkaFeatureCache.$anonfun$expired$1(this, x0$1)));
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)maxExpiredOffset), (Object)latest);
    }

    @Override
    public void offsetChanged(int partition, long offset) {
        BoxedUnit boxedUnit;
        Tuple3 tuple3;
        BoxedUnit boxedUnit2;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Offsets changed for [{}:{}]: -> {}", new Object[]{this.topic, BoxesRunTime.boxToInteger((int)partition), BoxesRunTime.boxToLong((long)offset)});
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (this.queues().length() <= partition) {
            this.ensurePartition(partition, offset);
            return;
        }
        Tuple2 tuple2 = (Tuple2)this.queues().apply(partition);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ReentrantLock lock = (ReentrantLock)tuple2._1();
        ArrayDeque queue = (ArrayDeque)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)lock, (Object)queue);
        Tuple2 tuple23 = tuple22;
        ReentrantLock lock2 = (ReentrantLock)tuple23._1();
        ArrayDeque queue2 = (ArrayDeque)tuple23._2();
        Tuple3 tuple32 = tuple3 = !this.debug() ? new Tuple3((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToLong((long)0L)) : new Tuple3((Object)BoxesRunTime.boxToInteger((int)this.features().size()), (Object)BoxesRunTime.boxToInteger((int)queue2.size()), (Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis()));
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        int featureSize = BoxesRunTime.unboxToInt((Object)tuple3._1());
        int queueSize = BoxesRunTime.unboxToInt((Object)tuple3._2());
        long start = BoxesRunTime.unboxToLong((Object)tuple3._3());
        Tuple3 tuple33 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)featureSize), (Object)BoxesRunTime.boxToInteger((int)queueSize), (Object)BoxesRunTime.boxToLong((long)start));
        Tuple3 tuple34 = tuple33;
        int featureSize2 = BoxesRunTime.unboxToInt((Object)tuple34._1());
        int queueSize2 = BoxesRunTime.unboxToInt((Object)tuple34._2());
        long start2 = BoxesRunTime.unboxToLong((Object)tuple34._3());
        boolean loop = true;
        while (loop) {
            Object object;
            lock2.lock();
            Tuple3 poll = (Tuple3)queue2.poll();
            if (poll == null) {
                lock2.unlock();
                loop = false;
                object = BoxedUnit.UNIT;
                continue;
            }
            if (BoxesRunTime.unboxToLong((Object)poll._1()) > offset) {
                try {
                    queue2.addFirst(poll);
                }
                finally {
                    lock2.unlock();
                }
                loop = false;
                object = BoxedUnit.UNIT;
                continue;
            }
            lock2.unlock();
            object = BoxesRunTime.boxToBoolean((boolean)this.remove((SimpleFeature)poll._3()));
        }
        long last = ((AtomicLong)this.offsets().apply(partition)).get();
        while (last < offset && !((AtomicLong)this.offsets().apply(partition)).compareAndSet(last, offset)) {
            last = ((AtomicLong)this.offsets().apply(partition)).get();
        }
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder(65).append("Size of cached state for [").append(this.topic).append(":").append(partition).append("]: features (total): ").append(this.diff(featureSize2, this.features().size())).append(", offsets: ").append(this.diff(queueSize2, queue2.size())).append(" in ").append(System.currentTimeMillis() - start2).append("ms").toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    private synchronized void ensurePartition(int partition, long offset) {
        while (this.queues().length() <= partition) {
            this.queues().$plus$eq((Object)new Tuple2((Object)new ReentrantLock(), new ArrayDeque()));
            this.offsets().$plus$eq((Object)new AtomicLong(-1L));
        }
        ((AtomicLong)this.offsets().apply(partition)).set(offset);
    }

    private boolean remove(SimpleFeature feature) {
        return feature == this.features().get(feature.getID()) && this.features().remove(feature.getID(), feature);
    }

    private String diff(int original, int updated) {
        int arg$macro$1 = updated;
        int arg$macro$2 = updated - original;
        return new StringOps("%d (%+d)").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)arg$macro$1), BoxesRunTime.boxToInteger((int)arg$macro$2)}));
    }

    public static final /* synthetic */ boolean $anonfun$expired$1(KafkaFeatureCache $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        SimpleFeature feature = (SimpleFeature)tuple2._2();
        boolean bl = $this.remove(feature);
        return bl;
    }

    public KafkaFeatureCache(String topic) {
        this.topic = topic;
        LazyLogging.$init$((LazyLogging)this);
        this.features = new ConcurrentHashMap();
        this.queues = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        this.offsets = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        this.debug = this.logger().underlying().isDebugEnabled();
    }

    public static interface ExpiringFeatureCache {
        public Seq<Object> expired(long var1);

        public Tuple2<Object, Seq<Tuple2<Object, SimpleFeature>>> expired(int var1, long var2);
    }

    public static interface ReadableFeatureCache {
        public Iterator<SimpleFeature> all();

        public SimpleFeature get(String var1);
    }

    public static interface WritableFeatureCache {
        public void partitionAssigned(int var1, long var2);

        public void add(SimpleFeature var1, int var2, long var3, long var5);

        public void delete(SimpleFeature var1, int var2, long var3, long var5);
    }
}

