/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.lambda.stream.kafka;

import java.io.Serializable;
import java.time.Clock;
import java.util.Properties;
import java.util.UUID;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.geotools.data.DataStore;
import org.locationtech.geomesa.kafka.KafkaConsumerVersions$;
import org.locationtech.geomesa.lambda.data.LambdaDataStore;
import org.locationtech.geomesa.lambda.stream.OffsetManager;
import org.locationtech.geomesa.lambda.stream.kafka.KafkaStore;
import org.locationtech.geomesa.security.AuthorizationsProvider;
import org.locationtech.geomesa.utils.conf.GeoMesaSystemProperties;
import org.locationtech.geomesa.utils.index.ByteArrays$;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class KafkaStore$ {
    public static KafkaStore$ MODULE$;
    private final GeoMesaSystemProperties.SystemProperty LoadIntervalProperty;

    static {
        new KafkaStore$();
    }

    public Clock $lessinit$greater$default$8(DataStore ds, SimpleFeatureType sft, Option<AuthorizationsProvider> authProvider, OffsetManager offsetManager, Map<String, String> producerConfig, Map<String, String> consumerConfig, LambdaDataStore.LambdaConfig config) {
        return Clock.systemUTC();
    }

    public GeoMesaSystemProperties.SystemProperty LoadIntervalProperty() {
        return this.LoadIntervalProperty;
    }

    public String topic(String ns, SimpleFeatureType sft) {
        return this.topic(ns, sft.getTypeName());
    }

    public String topic(String ns, String typeName) {
        return new StringBuilder(1).append(ns).append("_").append(typeName).toString().replaceAll("[^a-zA-Z0-9_\\-]", "_");
    }

    public Producer<byte[], byte[]> producer(Map<String, String> connect) {
        Properties props = new Properties();
        props.put("acks", "1");
        props.put("retries", BoxesRunTime.boxToInteger((int)3));
        props.put("linger.ms", BoxesRunTime.boxToInteger((int)3));
        connect.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            Object object = props.put(k, v);
            return object;
        });
        props.put("partitioner.class", KafkaStore.FeatureIdPartitioner.class.getName());
        props.put("key.serializer", ByteArraySerializer.class.getName());
        props.put("value.serializer", ByteArraySerializer.class.getName());
        return new KafkaProducer(props);
    }

    public Consumer<byte[], byte[]> consumer(Map<String, String> connect, String group) {
        Properties props = new Properties();
        props.put("group.id", group);
        connect.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            Object object = props.put(k, v);
            return object;
        });
        props.put("enable.auto.commit", "false");
        props.put("auto.offset.reset", "earliest");
        props.put("key.deserializer", ByteArrayDeserializer.class.getName());
        props.put("value.deserializer", ByteArrayDeserializer.class.getName());
        return new KafkaConsumer(props);
    }

    public Seq<Consumer<byte[], byte[]>> consumers(Map<String, String> connect, String topic, OffsetManager manager, int parallelism, Function2<Object, Object, BoxedUnit> callback) {
        Predef$.MODULE$.require(parallelism > 0, (Function0 & Serializable & scala.Serializable)() -> "Parallelism must be greater than 0");
        String group = UUID.randomUUID().toString();
        return (Seq)Seq$.MODULE$.fill(parallelism, (Function0 & Serializable & scala.Serializable)() -> {
            Consumer<byte[], byte[]> consumer = MODULE$.consumer(connect, group);
            KafkaStore.OffsetRebalanceListener listener = new KafkaStore.OffsetRebalanceListener(consumer, manager, callback);
            KafkaConsumerVersions$.MODULE$.subscribe(consumer, topic, (ConsumerRebalanceListener)listener);
            return consumer;
        });
    }

    public byte[] serializeKey(long time, byte action) {
        byte[] result = (byte[])Array$.MODULE$.ofDim(9, ClassTag$.MODULE$.Byte());
        result[0] = (byte)(time >> 56 & 0xFFL);
        result[1] = (byte)(time >> 48 & 0xFFL);
        result[2] = (byte)(time >> 40 & 0xFFL);
        result[3] = (byte)(time >> 32 & 0xFFL);
        result[4] = (byte)(time >> 24 & 0xFFL);
        result[5] = (byte)(time >> 16 & 0xFFL);
        result[6] = (byte)(time >> 8 & 0xFFL);
        result[7] = (byte)(time & 0xFFL);
        result[8] = action;
        return result;
    }

    public Tuple2<Object, Object> deserializeKey(byte[] key) {
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)ByteArrays$.MODULE$.readLong(key, ByteArrays$.MODULE$.readLong$default$2())), (Object)BoxesRunTime.boxToByte((byte)key[8]));
    }

    private KafkaStore$() {
        MODULE$ = this;
        this.LoadIntervalProperty = new GeoMesaSystemProperties.SystemProperty("geomesa.lambda.load.interval", "100ms");
    }
}

