/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.lambda.stream.kafka;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Flushable;
import java.io.Serializable;
import java.time.Clock;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.producer.Partitioner;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.TopicPartition;
import org.geotools.data.DataStore;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.util.factory.Hints;
import org.locationtech.geomesa.features.SerializationOption;
import org.locationtech.geomesa.features.kryo.KryoFeatureSerializer;
import org.locationtech.geomesa.features.kryo.KryoFeatureSerializer$;
import org.locationtech.geomesa.features.kryo.impl.KryoFeatureDeserialization$;
import org.locationtech.geomesa.filter.package$;
import org.locationtech.geomesa.index.geotools.GeoMesaFeatureWriter$;
import org.locationtech.geomesa.index.planning.QueryInterceptor;
import org.locationtech.geomesa.index.stats.GeoMesaStats;
import org.locationtech.geomesa.index.utils.ExplainLogging;
import org.locationtech.geomesa.index.utils.Explainer;
import org.locationtech.geomesa.kafka.KafkaConsumerVersions$;
import org.locationtech.geomesa.lambda.data.LambdaDataStore;
import org.locationtech.geomesa.lambda.stream.OffsetManager;
import org.locationtech.geomesa.lambda.stream.TransientStore;
import org.locationtech.geomesa.lambda.stream.kafka.DataStorePersistence;
import org.locationtech.geomesa.lambda.stream.kafka.KafkaCacheLoader;
import org.locationtech.geomesa.lambda.stream.kafka.KafkaFeatureCache;
import org.locationtech.geomesa.lambda.stream.kafka.KafkaQueryRunner;
import org.locationtech.geomesa.lambda.stream.kafka.KafkaStore$;
import org.locationtech.geomesa.lambda.stream.kafka.KafkaStore$MessageTypes$;
import org.locationtech.geomesa.security.AuthorizationsProvider;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.conf.GeoMesaSystemProperties;
import org.locationtech.geomesa.utils.io.IsCloseable;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.package;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.Id;
import org.opengis.filter.identity.FeatureId;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction2;
import scala.util.control.NonFatal$;
import scala.util.hashing.MurmurHash3$;

@ScalaSignature(bytes="\u0006\u0001\u0011Mb\u0001B$I\u0001UC\u0001B\u001d\u0001\u0003\u0002\u0003\u0006Ia\u001d\u0005\tw\u0002\u0011)\u0019!C\u0001y\"I\u0011q\u0002\u0001\u0003\u0002\u0003\u0006I! \u0005\u000b\u0003#\u0001!\u0011!Q\u0001\n\u0005M\u0001BCA\u0013\u0001\t\u0005\t\u0015!\u0003\u0002(!Q\u0011Q\u0006\u0001\u0003\u0002\u0003\u0006I!a\f\t\u0015\u0005-\u0003A!A!\u0002\u0013\ty\u0003\u0003\u0006\u0002N\u0001\u0011\t\u0011)A\u0005\u0003\u001fB!\"a\u001d\u0001\u0005\u0003\u0005\u000b1BA;\u0011\u001d\t\t\t\u0001C\u0001\u0003\u0007C\u0011\"a'\u0001\u0005\u0004%I!!(\t\u0011\u0005}\u0006\u0001)A\u0005\u0003?C\u0011\"!1\u0001\u0005\u0004%I!a1\t\u0011\u0005\u0015\u0007\u0001)A\u0005\u0003\u000bB\u0011\"a2\u0001\u0005\u0004%I!!3\t\u0011\u0005E\u0007\u0001)A\u0005\u0003\u0017D\u0011\"a5\u0001\u0005\u0004%I!!6\t\u0011\u0005\u001d\b\u0001)A\u0005\u0003/D\u0011\"!;\u0001\u0005\u0004%I!a;\t\u0011\t-\u0001\u0001)A\u0005\u0003[D\u0011B!\u0004\u0001\u0005\u0004%IAa\u0004\t\u0011\t]\u0001\u0001)A\u0005\u0005#A\u0011B!\u0007\u0001\u0005\u0004%IAa\u0007\t\u0011\t\r\u0002\u0001)A\u0005\u0005;A\u0011B!\n\u0001\u0005\u0004%IAa\n\t\u0011\tE\u0002\u0001)A\u0005\u0005SAqAa\r\u0001\t\u0003\u0012)\u0004C\u0004\u0003>\u0001!\tE!\u000e\t\u000f\t}\u0002\u0001\"\u0011\u0003B!I!Q\u0013\u0001\u0012\u0002\u0013\u0005!q\u0013\u0005\n\u0005[\u0003\u0011\u0013!C\u0001\u0005_C\u0011Ba-\u0001#\u0003%\tA!.\t\u0013\te\u0006!%A\u0005\u0002\tm\u0006b\u0002B`\u0001\u0011\u0005#\u0011\u0019\u0005\b\u0005\u000f\u0004A\u0011\tBe\u0011\u001d\u0011i\r\u0001C!\u0005kAqAa4\u0001\t\u0003\u0012)\u0004C\u0004\u0003R\u0002!\tE!\u000e\b\u000f\tM\u0007\n#\u0001\u0003V\u001a1q\t\u0013E\u0001\u0005/Dq!!!)\t\u0003\u0011I\u000eC\u0005\u0003\\\"\u0012\r\u0011\"\u0001\u0003^\"A!\u0011 \u0015!\u0002\u0013\u0011ynB\u0004\u0003|\"B\tA!@\u0007\u000f\r\u0005\u0001\u0006#\u0001\u0004\u0004!9\u0011\u0011Q\u0017\u0005\u0002\r\u0015\u0001\"CB\u0004[\t\u0007I\u0011AB\u0005\u0011!\u0019Y!\fQ\u0001\n\u0005e\u0006\"CB\u0007[\t\u0007I\u0011AB\u0005\u0011!\u0019y!\fQ\u0001\n\u0005e\u0006bBAaQ\u0011\u00051\u0011\u0003\u0005\b\u0003\u0003DC\u0011AB\r\u0011\u001d\tY\n\u000bC\u0001\u0007CAqaa\n)\t\u0003\u0019I\u0003\u0003\u0005\u0004<!\"\t\u0001SB\u001f\u0011!\u0019\u0019\b\u000bC\u0001\u0011\u000eU\u0004\u0002CB?Q\u0011\u0005\u0001ja \u0007\u000f\r-\u0005\u0006\u0001%\u0004\u000e\"Q1q\u0005\u001e\u0003\u0002\u0003\u0006Iaa\u000b\t\u0015\r]#H!A!\u0002\u0013\t9\u0003\u0003\u0006\u0004fi\u0012\t\u0011)A\u0005\u0007OBq!!!;\t\u0003\u0019\t\u000bC\u0004\u0004,j\"\te!,\t\u000f\r%'\b\"\u0011\u0004L\u001a11q\u001a\u0015\u0001\u0007#Dq!!!B\t\u0003\u0019I\u000eC\u0004\u0004^\u0006#\tea8\t\u000f\u0011\u0005\u0011\t\"\u0011\u0005\u0004!9!\u0011[!\u0005B\tU\u0002\"\u0003C\u0010QE\u0005I\u0011\u0001C\u0011\u0005)Y\u0015MZ6b'R|'/\u001a\u0006\u0003\u0013*\u000bQa[1gW\u0006T!a\u0013'\u0002\rM$(/Z1n\u0015\tie*\u0001\u0004mC6\u0014G-\u0019\u0006\u0003\u001fB\u000bqaZ3p[\u0016\u001c\u0018M\u0003\u0002R%\u0006aAn\\2bi&|g\u000e^3dQ*\t1+A\u0002pe\u001e\u001c\u0001aE\u0003\u0001-r\u0003\u0007\u000e\u0005\u0002X56\t\u0001LC\u0001Z\u0003\u0015\u00198-\u00197b\u0013\tY\u0006L\u0001\u0004B]f\u0014VM\u001a\t\u0003;zk\u0011AS\u0005\u0003?*\u0013a\u0002\u0016:b]NLWM\u001c;Ti>\u0014X\r\u0005\u0002bM6\t!M\u0003\u0002dI\u0006\u0011\u0011n\u001c\u0006\u0002K\u0006!!.\u0019<b\u0013\t9'MA\u0005GYV\u001c\b.\u00192mKB\u0011\u0011\u000e]\u0007\u0002U*\u00111\u000e\\\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003[:\f\u0001\u0002^=qKN\fg-\u001a\u0006\u0002_\u0006\u00191m\\7\n\u0005ET'a\u0003'bufdunZ4j]\u001e\f!\u0001Z:\u0011\u0005QLX\"A;\u000b\u0005Y<\u0018\u0001\u00023bi\u0006T!\u0001\u001f*\u0002\u0011\u001d,w\u000e^8pYNL!A_;\u0003\u0013\u0011\u000bG/Y*u_J,\u0017aA:giV\tQ\u0010E\u0002\u007f\u0003\u0017i\u0011a \u0006\u0005\u0003\u0003\t\u0019!\u0001\u0004tS6\u0004H.\u001a\u0006\u0005\u0003\u000b\t9!A\u0004gK\u0006$XO]3\u000b\u0007\u0005%!+A\u0004pa\u0016tw-[:\n\u0007\u00055qPA\tTS6\u0004H.\u001a$fCR,(/\u001a+za\u0016\fAa\u001d4uA\u0005a\u0011-\u001e;i!J|g/\u001b3feB)q+!\u0006\u0002\u001a%\u0019\u0011q\u0003-\u0003\r=\u0003H/[8o!\u0011\tY\"!\t\u000e\u0005\u0005u!bAA\u0010\u001d\u0006A1/Z2ve&$\u00180\u0003\u0003\u0002$\u0005u!AF!vi\"|'/\u001b>bi&|gn\u001d)s_ZLG-\u001a:\u0002\u001b=4gm]3u\u001b\u0006t\u0017mZ3s!\ri\u0016\u0011F\u0005\u0004\u0003WQ%!D(gMN,G/T1oC\u001e,'/\u0001\bqe>$WoY3s\u0007>tg-[4\u0011\u0011\u0005E\u0012qHA#\u0003\u000brA!a\r\u0002<A\u0019\u0011Q\u0007-\u000e\u0005\u0005]\"bAA\u001d)\u00061AH]8pizJ1!!\u0010Y\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011IA\"\u0005\ri\u0015\r\u001d\u0006\u0004\u0003{A\u0006\u0003BA\u0019\u0003\u000fJA!!\u0013\u0002D\t11\u000b\u001e:j]\u001e\fabY8ogVlWM]\"p]\u001aLw-\u0001\u0004d_:4\u0017n\u001a\t\u0005\u0003#\niG\u0004\u0003\u0002T\u0005\u001dd\u0002BA+\u0003KrA!a\u0016\u0002d9!\u0011\u0011LA1\u001d\u0011\tY&a\u0018\u000f\t\u0005U\u0012QL\u0005\u0002'&\u0011\u0011KU\u0005\u0003\u001fBK!!\u0014(\n\u0005Yd\u0015\u0002BA5\u0003W\nq\u0002T1nE\u0012\fG)\u0019;b'R|'/\u001a\u0006\u0003m2KA!a\u001c\u0002r\taA*Y7cI\u0006\u001cuN\u001c4jO*!\u0011\u0011NA6\u0003\u0015\u0019Gn\\2l!\u0011\t9(! \u000e\u0005\u0005e$bAA>I\u0006!A/[7f\u0013\u0011\ty(!\u001f\u0003\u000b\rcwnY6\u0002\rqJg.\u001b;?)A\t))!$\u0002\u0010\u0006E\u00151SAK\u0003/\u000bI\n\u0006\u0003\u0002\b\u0006-\u0005cAAE\u00015\t\u0001\nC\u0005\u0002t)\u0001\n\u0011q\u0001\u0002v!)!O\u0003a\u0001g\")1P\u0003a\u0001{\"9\u0011\u0011\u0003\u0006A\u0002\u0005M\u0001bBA\u0013\u0015\u0001\u0007\u0011q\u0005\u0005\b\u0003[Q\u0001\u0019AA\u0018\u0011\u001d\tYE\u0003a\u0001\u0003_Aq!!\u0014\u000b\u0001\u0004\ty%\u0001\u0005qe>$WoY3s+\t\ty\n\u0005\u0005\u0002\"\u0006=\u00161WAZ\u001b\t\t\u0019K\u0003\u0003\u0002\u001c\u0006\u0015&\u0002BAT\u0003S\u000bqa\u00197jK:$8OC\u0002J\u0003WS1!!,S\u0003\u0019\t\u0007/Y2iK&!\u0011\u0011WAR\u0005!\u0001&o\u001c3vG\u0016\u0014\b#B,\u00026\u0006e\u0016bAA\\1\n)\u0011I\u001d:bsB\u0019q+a/\n\u0007\u0005u\u0006L\u0001\u0003CsR,\u0017!\u00039s_\u0012,8-\u001a:!\u0003\u0015!x\u000e]5d+\t\t)%\u0001\u0004u_BL7\rI\u0001\u0006G\u0006\u001c\u0007.Z\u000b\u0003\u0003\u0017\u0004B!!#\u0002N&\u0019\u0011q\u001a%\u0003#-\u000bgm[1GK\u0006$XO]3DC\u000eDW-\u0001\u0004dC\u000eDW\rI\u0001\u000bg\u0016\u0014\u0018.\u00197ju\u0016\u0014XCAAl!\u0011\tI.a9\u000e\u0005\u0005m'\u0002BAo\u0003?\fAa\u001b:z_*\u0019\u0011\u0011\u001d(\u0002\u0011\u0019,\u0017\r^;sKNLA!!:\u0002\\\n)2J]=p\r\u0016\fG/\u001e:f'\u0016\u0014\u0018.\u00197ju\u0016\u0014\u0018aC:fe&\fG.\u001b>fe\u0002\nA\"\u001b8uKJ\u001cW\r\u001d;peN,\"!!<\u0011\t\u0005=(Q\u0001\b\u0005\u0003c\fyP\u0004\u0003\u0002t\u0006eh\u0002BA,\u0003kL1!a>O\u0003\u0015Ig\u000eZ3y\u0013\u0011\tY0!@\u0002\u0011Ad\u0017M\u001c8j]\u001eT1!a>O\u0013\u0011\u0011\tAa\u0001\u0002!E+XM]=J]R,'oY3qi>\u0014(\u0002BA~\u0003{LAAa\u0002\u0003\n\t9\u0012+^3ss&sG/\u001a:dKB$xN\u001d$bGR|'/\u001f\u0006\u0005\u0005\u0003\u0011\u0019!A\u0007j]R,'oY3qi>\u00148\u000fI\u0001\fcV,'/\u001f*v]:,'/\u0006\u0002\u0003\u0012A!\u0011\u0011\u0012B\n\u0013\r\u0011)\u0002\u0013\u0002\u0011\u0017\u000647.Y)vKJL(+\u001e8oKJ\fA\"];fef\u0014VO\u001c8fe\u0002\na\u0001\\8bI\u0016\u0014XC\u0001B\u000f!\u0011\tIIa\b\n\u0007\t\u0005\u0002J\u0001\tLC\u001a\\\u0017mQ1dQ\u0016du.\u00193fe\u00069An\\1eKJ\u0004\u0013a\u00039feNL7\u000f^3oG\u0016,\"A!\u000b\u0011\u000b]\u000b)Ba\u000b\u0011\t\u0005%%QF\u0005\u0004\u0005_A%\u0001\u0006#bi\u0006\u001cFo\u001c:f!\u0016\u00148/[:uK:\u001cW-\u0001\u0007qKJ\u001c\u0018n\u001d;f]\u000e,\u0007%\u0001\u0007de\u0016\fG/Z*dQ\u0016l\u0017\r\u0006\u0002\u00038A\u0019qK!\u000f\n\u0007\tm\u0002L\u0001\u0003V]&$\u0018\u0001\u0004:f[>4XmU2iK6\f\u0017\u0001\u0002:fC\u0012$\"Ba\u0011\u0003Z\t%$\u0011\u000fBD!\u0019\u0011)Ea\u0014\u0003T5\u0011!q\t\u0006\u0005\u0005\u0013\u0012Y%\u0001\u0006d_2dWm\u0019;j_:T1A!\u0014O\u0003\u0015)H/\u001b7t\u0013\u0011\u0011\tFa\u0012\u0003#\rcwn]3bE2,\u0017\n^3sCR|'\u000fE\u0002\u007f\u0005+J1Aa\u0016\u0000\u00055\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sK\"I!1L\u000f\u0011\u0002\u0003\u0007!QL\u0001\u0007M&dG/\u001a:\u0011\u000b]\u000b)Ba\u0018\u0011\t\t\u0005$QM\u0007\u0003\u0005GRAAa\u0017\u0002\b%!!q\rB2\u0005\u00191\u0015\u000e\u001c;fe\"I!1N\u000f\u0011\u0002\u0003\u0007!QN\u0001\u000biJ\fgn\u001d4pe6\u001c\b#B,\u0002\u0016\t=\u0004#B,\u00026\u0006\u0015\u0003\"\u0003B:;A\u0005\t\u0019\u0001B;\u0003\u0015A\u0017N\u001c;t!\u00159\u0016Q\u0003B<!\u0011\u0011IHa!\u000e\u0005\tm$\u0002\u0002B?\u0005\u007f\nqAZ1di>\u0014\u0018PC\u0002\u0003\u0002^\fA!\u001e;jY&!!Q\u0011B>\u0005\u0015A\u0015N\u001c;t\u0011%\u0011I)\bI\u0001\u0002\u0004\u0011Y)A\u0004fqBd\u0017-\u001b8\u0011\t\t5%\u0011S\u0007\u0003\u0005\u001fSAA!\u0014\u0002~&!!1\u0013BH\u0005%)\u0005\u0010\u001d7bS:,'/\u0001\bsK\u0006$G\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\te%\u0006\u0002B/\u00057[#A!(\u0011\t\t}%\u0011V\u0007\u0003\u0005CSAAa)\u0003&\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005OC\u0016AC1o]>$\u0018\r^5p]&!!1\u0016BQ\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fe\u0016\fG\r\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011\tL\u000b\u0003\u0003n\tm\u0015A\u0004:fC\u0012$C-\u001a4bk2$HeM\u000b\u0003\u0005oSCA!\u001e\u0003\u001c\u0006q!/Z1eI\u0011,g-Y;mi\u0012\"TC\u0001B_U\u0011\u0011YIa'\u0002\u000b]\u0014\u0018\u000e^3\u0015\t\t]\"1\u0019\u0005\b\u0005\u000b\u0014\u0003\u0019\u0001B*\u0003!y'/[4j]\u0006d\u0017A\u00023fY\u0016$X\r\u0006\u0003\u00038\t-\u0007b\u0002BcG\u0001\u0007!1K\u0001\ba\u0016\u00148/[:u\u0003\u00151G.^:i\u0003\u0015\u0019Gn\\:f\u0003)Y\u0015MZ6b'R|'/\u001a\t\u0004\u0003\u0013C3C\u0001\u0015W)\t\u0011).\u0001\u000bM_\u0006$\u0017J\u001c;feZ\fG\u000e\u0015:pa\u0016\u0014H/_\u000b\u0003\u0005?\u0004BA!9\u0003t:!!1\u001dBw\u001d\u0011\u0011)O!;\u000f\t\u0005]#q]\u0005\u0004\u0005\u001br\u0015\u0002\u0002Bv\u0005\u0017\nAaY8oM&!!q\u001eBy\u0003]9Um\\'fg\u0006\u001c\u0016p\u001d;f[B\u0013x\u000e]3si&,7O\u0003\u0003\u0003l\n-\u0013\u0002\u0002B{\u0005o\u0014abU=ti\u0016l\u0007K]8qKJ$\u0018P\u0003\u0003\u0003p\nE\u0018!\u0006'pC\u0012Le\u000e^3sm\u0006d\u0007K]8qKJ$\u0018\u0010I\u0001\r\u001b\u0016\u001c8/Y4f)f\u0004Xm\u001d\t\u0004\u0005\u007flS\"\u0001\u0015\u0003\u00195+7o]1hKRK\b/Z:\u0014\u000552FC\u0001B\u007f\u0003\u00159&/\u001b;f+\t\tI,\u0001\u0004Xe&$X\rI\u0001\u0007\t\u0016dW\r^3\u0002\u000f\u0011+G.\u001a;fAQ1\u0011QIB\n\u0007/Aqa!\u00064\u0001\u0004\t)%\u0001\u0002og\")1p\ra\u0001{R1\u0011QIB\u000e\u0007;Aqa!\u00065\u0001\u0004\t)\u0005C\u0004\u0004 Q\u0002\r!!\u0012\u0002\u0011QL\b/\u001a(b[\u0016$B!a(\u0004$!91QE\u001bA\u0002\u0005=\u0012aB2p]:,7\r^\u0001\tG>t7/^7feR111FB\u001b\u0007o\u0001\u0002b!\f\u00042\u0005M\u00161W\u0007\u0003\u0007_QAaa\n\u0002&&!11GB\u0018\u0005!\u0019uN\\:v[\u0016\u0014\bbBB\u0013m\u0001\u0007\u0011q\u0006\u0005\b\u0007s1\u0004\u0019AA#\u0003\u00159'o\\;q\u0003%\u0019wN\\:v[\u0016\u00148\u000f\u0006\u0007\u0004@\rE31KB+\u00073\u001a\u0019\u0007\u0005\u0004\u0004B\r-31\u0006\b\u0005\u0007\u0007\u001a9E\u0004\u0003\u00026\r\u0015\u0013\"A-\n\u0007\r%\u0003,A\u0004qC\u000e\\\u0017mZ3\n\t\r53q\n\u0002\u0004'\u0016\f(bAB%1\"91QE\u001cA\u0002\u0005=\u0002bBAao\u0001\u0007\u0011Q\t\u0005\b\u0007/:\u0004\u0019AA\u0014\u0003\u001di\u0017M\\1hKJDqaa\u00178\u0001\u0004\u0019i&A\u0006qCJ\fG\u000e\\3mSNl\u0007cA,\u0004`%\u00191\u0011\r-\u0003\u0007%sG\u000fC\u0004\u0004f]\u0002\raa\u001a\u0002\u0011\r\fG\u000e\u001c2bG.\u0004\u0012bVB5\u0007;\u001aiGa\u000e\n\u0007\r-\u0004LA\u0005Gk:\u001cG/[8oeA\u0019qka\u001c\n\u0007\rE\u0004L\u0001\u0003M_:<\u0017\u0001D:fe&\fG.\u001b>f\u0017\u0016LHCBAZ\u0007o\u001aI\bC\u0004\u0002|a\u0002\ra!\u001c\t\u000f\rm\u0004\b1\u0001\u0002:\u00061\u0011m\u0019;j_:\fa\u0002Z3tKJL\u0017\r\\5{K.+\u0017\u0010\u0006\u0003\u0004\u0002\u000e\u001d\u0005cB,\u0004\u0004\u000e5\u0014\u0011X\u0005\u0004\u0007\u000bC&A\u0002+va2,'\u0007C\u0004\u0004\nf\u0002\r!a-\u0002\u0007-,\u0017PA\fPM\u001a\u001cX\r\u001e*fE\u0006d\u0017M\\2f\u0019&\u001cH/\u001a8feN1!ha$\u0004\u001c\"\u0004Ba!%\u0004\u00186\u001111\u0013\u0006\u0004\u0007+#\u0017\u0001\u00027b]\u001eLAa!'\u0004\u0014\n1qJ\u00196fGR\u0004Ba!\f\u0004\u001e&!1qTB\u0018\u0005e\u0019uN\\:v[\u0016\u0014(+\u001a2bY\u0006t7-\u001a'jgR,g.\u001a:\u0015\u0011\r\r6QUBT\u0007S\u00032Aa@;\u0011\u001d\u00199C\u0010a\u0001\u0007WAqaa\u0016?\u0001\u0004\t9\u0003C\u0004\u0004fy\u0002\raa\u001a\u0002'=t\u0007+\u0019:uSRLwN\\:SKZ|7.\u001a3\u0015\t\t]2q\u0016\u0005\b\u0007c{\u0004\u0019ABZ\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u001c\bCBB[\u0007s\u001bi,\u0004\u0002\u00048*\u0019!\u0011\u00113\n\t\rm6q\u0017\u0002\u000b\u0007>dG.Z2uS>t\u0007\u0003BB`\u0007\u000bl!a!1\u000b\t\r\r\u0017\u0011V\u0001\u0007G>lWn\u001c8\n\t\r\u001d7\u0011\u0019\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003Qyg\u000eU1si&$\u0018n\u001c8t\u0003N\u001c\u0018n\u001a8fIR!!qGBg\u0011\u001d\u0019\t\f\u0011a\u0001\u0007g\u0013ACR3biV\u0014X-\u00133QCJ$\u0018\u000e^5p]\u0016\u00148#B!\u0004\u0010\u000eM\u0007\u0003BAQ\u0007+LAaa6\u0002$\nY\u0001+\u0019:uSRLwN\\3s)\t\u0019Y\u000eE\u0002\u0003\u0000\u0006\u000b\u0011\u0002]1si&$\u0018n\u001c8\u0015\u001d\ru3\u0011]Br\u0007W\u001cyoa=\u0004x\"9\u0011\u0011Y\"A\u0002\u0005\u0015\u0003bBBE\u0007\u0002\u00071Q\u001d\t\u0004/\u000e\u001d\u0018bABu1\n\u0019\u0011I\\=\t\u000f\r58\t1\u0001\u00024\u0006A1.Z=CsR,7\u000fC\u0004\u0004r\u000e\u0003\ra!:\u0002\u000bY\fG.^3\t\u000f\rU8\t1\u0001\u00024\u0006Qa/\u00197vK\nKH/Z:\t\u000f\re8\t1\u0001\u0004|\u000691\r\\;ti\u0016\u0014\b\u0003BB`\u0007{LAaa@\u0004B\n91\t\\;ti\u0016\u0014\u0018!C2p]\u001aLw-\u001e:f)\u0011\u00119\u0004\"\u0002\t\u000f\u0011\u001dA\t1\u0001\u0005\n\u000591m\u001c8gS\u001e\u001c\b\u0007\u0002C\u0006\t'\u0001\u0002b!.\u0005\u000e\u0005\u0015CqB\u0005\u0005\u0003\u0003\u001a9\f\u0005\u0003\u0005\u0012\u0011MA\u0002\u0001\u0003\r\t+!)!!A\u0001\u0002\u000b\u0005Aq\u0003\u0002\u0004?\u0012\n\u0014\u0003\u0002C\r\u0007K\u00042a\u0016C\u000e\u0013\r!i\u0002\u0017\u0002\b\u001d>$\b.\u001b8h\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%qQ\u0001B1\u0005C\u0013\tO!I\u0003b\u000b\u0005.\u0011=B\u0011\u0007\u0016\u0005\u0003k\u0012Y\nC\u0003s\r\u0002\u00071\u000fC\u0003|\r\u0002\u0007Q\u0010C\u0004\u0002\u0012\u0019\u0003\r!a\u0005\t\u000f\u0005\u0015b\t1\u0001\u0002(!9\u0011Q\u0006$A\u0002\u0005=\u0002bBA&\r\u0002\u0007\u0011q\u0006\u0005\b\u0003\u001b2\u0005\u0019AA(\u0001")
public class KafkaStore
implements TransientStore,
Flushable,
LazyLogging {
    private final DataStore ds;
    private final SimpleFeatureType sft;
    private final OffsetManager offsetManager;
    private final scala.collection.immutable.Map<String, String> producerConfig;
    private final LambdaDataStore.LambdaConfig config;
    private final Clock clock;
    private final Producer<byte[], byte[]> producer;
    private final String topic;
    private final KafkaFeatureCache cache;
    private final KryoFeatureSerializer serializer;
    private final QueryInterceptor.QueryInterceptorFactory interceptors;
    private final KafkaQueryRunner queryRunner;
    private final KafkaCacheLoader loader;
    private final Option<DataStorePersistence> persistence;
    private Logger logger;
    private final GeoMesaStats stats;
    private volatile boolean bitmap$0;

    public static Clock $lessinit$greater$default$8(DataStore dataStore, SimpleFeatureType simpleFeatureType, Option<AuthorizationsProvider> option, OffsetManager offsetManager, scala.collection.immutable.Map<String, String> map, scala.collection.immutable.Map<String, String> map2, LambdaDataStore.LambdaConfig lambdaConfig) {
        return KafkaStore$.MODULE$.$lessinit$greater$default$8(dataStore, simpleFeatureType, option, offsetManager, map, map2, lambdaConfig);
    }

    public static Consumer<byte[], byte[]> consumer(scala.collection.immutable.Map<String, String> map, String string) {
        return KafkaStore$.MODULE$.consumer(map, string);
    }

    public static GeoMesaSystemProperties.SystemProperty LoadIntervalProperty() {
        return KafkaStore$.MODULE$.LoadIntervalProperty();
    }

    private Logger logger$lzycompute() {
        KafkaStore kafkaStore = this;
        synchronized (kafkaStore) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public GeoMesaStats stats() {
        return this.stats;
    }

    @Override
    public void org$locationtech$geomesa$lambda$stream$TransientStore$_setter_$stats_$eq(GeoMesaStats x$1) {
        this.stats = x$1;
    }

    @Override
    public SimpleFeatureType sft() {
        return this.sft;
    }

    private Producer<byte[], byte[]> producer() {
        return this.producer;
    }

    private String topic() {
        return this.topic;
    }

    private KafkaFeatureCache cache() {
        return this.cache;
    }

    private KryoFeatureSerializer serializer() {
        return this.serializer;
    }

    private QueryInterceptor.QueryInterceptorFactory interceptors() {
        return this.interceptors;
    }

    private KafkaQueryRunner queryRunner() {
        return this.queryRunner;
    }

    private KafkaCacheLoader loader() {
        return this.loader;
    }

    private Option<DataStorePersistence> persistence() {
        return this.persistence;
    }

    @Override
    public void createSchema() {
        Properties props = new Properties();
        this.producerConfig.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            Object object = props.put(k, v);
            return object;
        });
        package.WithClose$.MODULE$.apply((Object)AdminClient.create((Properties)props), (Function1 & Serializable & scala.Serializable)admin -> {
            Object object;
            if (((Set)admin.listTopics().names().get()).contains(this.topic())) {
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Topic [{}] already exists - it may contain stale data", new Object[]{this.topic()});
                    object = BoxedUnit.UNIT;
                } else {
                    object = BoxedUnit.UNIT;
                }
            } else {
                int replication = BoxesRunTime.unboxToInt((Object)new GeoMesaSystemProperties.SystemProperty("geomesa.kafka.replication", GeoMesaSystemProperties.SystemProperty$.MODULE$.apply$default$2()).option().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)KafkaStore.$anonfun$createSchema$3(x$1))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 1));
                NewTopic newTopic = new NewTopic(this.topic(), $this.config.partitions(), (short)replication);
                object = admin.createTopics(Collections.singletonList(newTopic)).all().get();
            }
            return object;
        }, IsCloseable$.MODULE$.closeableIsCloseable());
    }

    @Override
    public void removeSchema() {
        this.offsetManager.deleteOffsets(this.topic());
        Properties props = new Properties();
        this.producerConfig.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            Object object = props.put(k, v);
            return object;
        });
        package.WithClose$.MODULE$.apply((Object)AdminClient.create((Properties)props), (Function1 & Serializable & scala.Serializable)admin -> {
            Object object;
            if (((Set)admin.listTopics().names().get()).contains(this.topic())) {
                object = admin.deleteTopics(Collections.singletonList(this.topic())).all().get();
            } else if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Topic [{}] does not exist, can't delete it", new Object[]{this.topic()});
                object = BoxedUnit.UNIT;
            } else {
                object = BoxedUnit.UNIT;
            }
            return object;
        }, IsCloseable$.MODULE$.closeableIsCloseable());
    }

    @Override
    public CloseableIterator<SimpleFeature> read(Option<Filter> filter, Option<String[]> transforms, Option<Hints> hints, Explainer explain) {
        Query query = new Query();
        filter.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            query.setFilter(x$1);
            return BoxedUnit.UNIT;
        });
        transforms.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            query.setPropertyNames(x$1);
            return BoxedUnit.UNIT;
        });
        hints.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            query.setHints(x$1);
            return BoxedUnit.UNIT;
        });
        return this.queryRunner().runQuery(this.sft(), query, explain);
    }

    @Override
    public Option<Filter> read$default$1() {
        return None$.MODULE$;
    }

    @Override
    public Option<String[]> read$default$2() {
        return None$.MODULE$;
    }

    @Override
    public Option<Hints> read$default$3() {
        return None$.MODULE$;
    }

    @Override
    public Explainer read$default$4() {
        return new ExplainLogging();
    }

    @Override
    public void write(SimpleFeature original) {
        BoxedUnit boxedUnit;
        SimpleFeature feature = GeoMesaFeatureWriter$.MODULE$.featureWithFid(original);
        byte[] key = KafkaStore$.MODULE$.serializeKey(this.clock.millis(), KafkaStore$MessageTypes$.MODULE$.Write());
        this.producer().send(new ProducerRecord(this.topic(), (Object)key, (Object)this.serializer().serialize(feature)));
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("Wrote feature to [{}]: {}", new Object[]{this.topic(), feature});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    @Override
    public void delete(SimpleFeature original) {
        block0: {
            SimpleFeature feature = GeoMesaFeatureWriter$.MODULE$.featureWithFid(original);
            byte[] key = KafkaStore$.MODULE$.serializeKey(this.clock.millis(), KafkaStore$MessageTypes$.MODULE$.Delete());
            this.producer().send(new ProducerRecord(this.topic(), (Object)key, (Object)this.serializer().serialize(feature)));
            if (!this.config.persist()) break block0;
            Id filter = package$.MODULE$.ff().id(new FeatureId[]{package$.MODULE$.ff().featureId(feature.getID())});
            package.WithClose$.MODULE$.apply((Object)this.ds.getFeatureWriter(this.sft().getTypeName(), (Filter)filter, Transaction.AUTO_COMMIT), (Function1 & Serializable & scala.Serializable)writer -> {
                KafkaStore.$anonfun$delete$1(writer);
                return BoxedUnit.UNIT;
            }, IsCloseable$.MODULE$.closeableIsCloseable());
        }
    }

    @Override
    public void persist() {
        Option<DataStorePersistence> option = this.persistence();
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new IllegalStateException("Persistence disabled for this store");
            }
            throw new MatchError(option);
        }
        Some some = (Some)option;
        DataStorePersistence p = (DataStorePersistence)some.value();
        p.run();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    @Override
    public void flush() {
        this.producer().flush();
    }

    @Override
    public void close() {
        package.CloseWithLogging$.MODULE$.apply((Object)this.loader(), IsCloseable$.MODULE$.closeableIsCloseable());
        package.CloseWithLogging$.MODULE$.apply((Object)this.interceptors(), IsCloseable$.MODULE$.closeableIsCloseable());
        package.CloseWithLogging$.MODULE$.apply(this.persistence(), (IsCloseable)IsCloseable$.MODULE$.optionIsCloseable());
        this.offsetManager.removeOffsetListener(this.topic(), this.cache());
    }

    public static final /* synthetic */ int $anonfun$createSchema$3(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toInt();
    }

    public static final /* synthetic */ void $anonfun$delete$1(FeatureWriter writer) {
        while (writer.hasNext()) {
            writer.next();
            writer.remove();
        }
    }

    public KafkaStore(DataStore ds, SimpleFeatureType sft, Option<AuthorizationsProvider> authProvider, OffsetManager offsetManager, scala.collection.immutable.Map<String, String> producerConfig, scala.collection.immutable.Map<String, String> consumerConfig, LambdaDataStore.LambdaConfig config, Clock clock) {
        this.ds = ds;
        this.sft = sft;
        this.offsetManager = offsetManager;
        this.producerConfig = producerConfig;
        this.config = config;
        this.clock = clock;
        TransientStore.$init$(this);
        LazyLogging.$init$((LazyLogging)this);
        this.producer = KafkaStore$.MODULE$.producer(producerConfig);
        this.topic = KafkaStore$.MODULE$.topic(config.zkNamespace(), sft);
        this.cache = new KafkaFeatureCache(this.topic());
        scala.collection.immutable.Set options = SerializationOption.SerializationOptions$.MODULE$.builder().withUserData().immutable().lazy().build();
        this.serializer = KryoFeatureSerializer$.MODULE$.apply(sft, options);
        this.interceptors = QueryInterceptor.QueryInterceptorFactory$.MODULE$.apply(ds);
        this.queryRunner = new KafkaQueryRunner(this.cache(), this.stats(), authProvider, this.interceptors());
        Seq<Consumer<byte[], byte[]>> consumers = KafkaStore$.MODULE$.consumers(consumerConfig, this.topic(), offsetManager, config.consumers(), (Function2<Object, Object, BoxedUnit>)(JFunction2.mcVIJ.sp & Serializable & scala.Serializable)(partition, offset) -> this.cache().partitionAssigned(partition, offset));
        long frequency = ((Duration)KafkaStore$.MODULE$.LoadIntervalProperty().toDuration().get()).toMillis();
        this.loader = new KafkaCacheLoader(consumers, this.topic(), frequency, this.serializer(), this.cache());
        Duration duration = config.expiry();
        Duration.Infinite infinite = Duration$.MODULE$.Inf();
        this.persistence = !(duration != null ? !duration.equals(infinite) : infinite != null) ? None$.MODULE$ : new Some((Object)new DataStorePersistence(ds, sft, offsetManager, this.cache(), this.topic(), config.expiry().toMillis(), config.persist(), clock));
        offsetManager.addOffsetListener(this.topic(), this.cache());
    }

    public static class FeatureIdPartitioner
    implements Partitioner {
        public int partition(String topic, Object key, byte[] keyBytes, Object value, byte[] valueBytes, Cluster cluster) {
            int count = cluster.partitionsForTopic(topic).size();
            String id = KryoFeatureDeserialization$.MODULE$.getInput(valueBytes, 5, valueBytes.length - 5).readString();
            return Math.abs(MurmurHash3$.MODULE$.stringHash(id)) % count;
        }

        public void configure(Map<String, ?> configs) {
        }

        public void close() {
        }
    }

    public static class OffsetRebalanceListener
    implements ConsumerRebalanceListener,
    LazyLogging {
        private final Consumer<byte[], byte[]> consumer;
        private final OffsetManager manager;
        private final Function2<Object, Object, BoxedUnit> callback;
        private Logger logger;
        private volatile boolean bitmap$0;

        private Logger logger$lzycompute() {
            OffsetRebalanceListener offsetRebalanceListener = this;
            synchronized (offsetRebalanceListener) {
                if (!this.bitmap$0) {
                    this.logger = LazyLogging.logger$((LazyLogging)this);
                    this.bitmap$0 = true;
                }
            }
            return this.logger;
        }

        public Logger logger() {
            return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
        }

        public void onPartitionsRevoked(Collection<TopicPartition> topicPartitions) {
        }

        public void onPartitionsAssigned(Collection<TopicPartition> topicPartitions) {
            ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(topicPartitions).asScala()).foreach((Function1 & Serializable & scala.Serializable)tp -> {
                OffsetRebalanceListener.$anonfun$onPartitionsAssigned$1(this, tp);
                return BoxedUnit.UNIT;
            });
        }

        private final long seekToBeginning$1(TopicPartition tp$1) {
            KafkaConsumerVersions$.MODULE$.seekToBeginning(this.consumer, tp$1);
            return this.consumer.position(tp$1) - 1L;
        }

        public static final /* synthetic */ void $anonfun$onPartitionsAssigned$1(OffsetRebalanceListener $this, TopicPartition tp) {
            long l;
            long lastRead = $this.manager.getOffset(tp.topic(), tp.partition());
            KafkaConsumerVersions$.MODULE$.pause($this.consumer, tp);
            if (lastRead < 0L) {
                l = $this.seekToBeginning$1(tp);
            } else {
                try {
                    $this.consumer.seek(tp, lastRead + 1L);
                    l = lastRead;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (!option.isEmpty()) {
                        BoxedUnit boxedUnit;
                        Throwable e = (Throwable)option.get();
                        if ($this.logger().underlying().isWarnEnabled()) {
                            $this.logger().underlying().warn(new StringBuilder(61).append("Error seeking to initial offset: [").append(tp.topic()).append(":").append(tp.partition()).append(":").append(lastRead).append("]").append(", seeking to beginning: ").append(e).toString());
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    } else {
                        throw throwable;
                    }
                    long l2 = $this.seekToBeginning$1(tp);
                    l = l2;
                }
            }
            long offset = l;
            $this.callback.apply$mcVIJ$sp(tp.partition(), offset);
            KafkaConsumerVersions$.MODULE$.resume($this.consumer, tp);
        }

        public OffsetRebalanceListener(Consumer<byte[], byte[]> consumer, OffsetManager manager, Function2<Object, Object, BoxedUnit> callback) {
            this.consumer = consumer;
            this.manager = manager;
            this.callback = callback;
            LazyLogging.$init$((LazyLogging)this);
        }
    }
}

