/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.lambda.data;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.time.Clock;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.NewTopic;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.FeatureReader;
import org.geotools.api.data.LockingManager;
import org.geotools.api.data.Query;
import org.geotools.api.data.ServiceInfo;
import org.geotools.api.data.SimpleFeatureReader;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.data.SimpleFeatureWriter;
import org.geotools.api.data.Transaction;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.Filter;
import org.geotools.data.DefaultServiceInfo;
import org.geotools.feature.FeatureTypes;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStore;
import org.locationtech.geomesa.index.geotools.GeoMesaFeatureReader;
import org.locationtech.geomesa.index.geotools.GeoMesaFeatureReader$;
import org.locationtech.geomesa.index.geotools.GeoMesaFeatureStore;
import org.locationtech.geomesa.index.planning.QueryRunner;
import org.locationtech.geomesa.index.stats.GeoMesaStats;
import org.locationtech.geomesa.index.stats.package;
import org.locationtech.geomesa.lambda.data.LambdaDataStore$;
import org.locationtech.geomesa.lambda.data.LambdaFeatureWriter;
import org.locationtech.geomesa.lambda.data.LambdaQueryRunner;
import org.locationtech.geomesa.lambda.data.LambdaStats;
import org.locationtech.geomesa.lambda.stream.OffsetManager;
import org.locationtech.geomesa.lambda.stream.TransientStore;
import org.locationtech.geomesa.lambda.stream.kafka.KafkaStore;
import org.locationtech.geomesa.security.AuthorizationsProvider;
import org.locationtech.geomesa.security.VisibilityChecker;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.collection.SelfClosingIterator;
import org.locationtech.geomesa.utils.collection.SelfClosingIterator$;
import org.locationtech.geomesa.utils.conf.GeoMesaSystemProperties;
import org.locationtech.geomesa.utils.geotools.FeatureUtils$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.io.IsCloseable;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.package;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.immutable.StringOps;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0011\rc\u0001\u0002,X\u0001\tD!\"!\u0011\u0001\u0005\u000b\u0007I\u0011AA\"\u0011%\t)\u0005\u0001B\u0001B\u0003%1\u000e\u0003\u0006\u0002H\u0001\u0011\t\u0011)A\u0005\u0003\u0013B!b!\u0003\u0001\u0005\u0003\u0005\u000b1\u0002B}\u0011\u001d\tI\u0007\u0001C\u0001\u0007\u0017A\u0011ba\u0006\u0001\u0005\u0004%Ia!\u0007\t\u0011\r%\u0002\u0001)A\u0005\u00077A!ba\u000b\u0001\u0005\u0004%\t!WB\u0017\u0011!\u0019i\u0005\u0001Q\u0001\n\r=\u0002\"CA\u0005\u0001\t\u0007I\u0011IB(\u0011!\u0019I\u0006\u0001Q\u0001\n\rE\u0003\"CB.\u0001\t\u0007I\u0011BB/\u0011!\u0019)\u0007\u0001Q\u0001\n\r}\u0003bBAz\u0001\u0011\u00051q\r\u0005\b\u0007g\u0002A\u0011IB;\u0011\u001d\u0019i\b\u0001C!\u0007\u007fBqa!'\u0001\t\u0003\u001aY\nC\u0004\u0004 \u0002!\te!)\t\u000f\r}\u0005\u0001\"\u0011\u0004&\"91\u0011\u0016\u0001\u0005B\r-\u0006bBBU\u0001\u0011\u000531\u0017\u0005\b\u0007s\u0003A\u0011IB^\u0011\u001d\u0019I\f\u0001C!\u0007\u007fCqaa1\u0001\t\u0003\u001a)\rC\u0004\u0004D\u0002!\tea4\t\u000f\rM\u0007\u0001\"\u0011\u0004V\"A11\u001b\u0001\u0005Bm\u001b\t\u0010C\u0004\u0005\u0002\u0001!\t\u0005b\u0001\t\u000f\u0011=\u0001\u0001\"\u0011\u0005\u0012!9Aq\u0002\u0001\u0005B\u0011]\u0001b\u0002C\u0016\u0001\u0011\u0005CQ\u0006\u0005\b\t_\u0001A\u0011\tC\u0019\u0011\u001d!I\u0004\u0001C!\tw9q!!\u0016X\u0011\u0003\t9F\u0002\u0004W/\"\u0005\u00111\f\u0005\b\u0003S\u001aC\u0011AA6\u0011%\tig\tb\u0001\n\u0003\ty\u0007\u0003\u0005\u0002x\r\u0002\u000b\u0011BA9\u0011\u001d\tIh\tC\u0001\u0003w2a!a)$\u0001\u0006\u0015\u0006BCAZQ\tU\r\u0011\"\u0001\u00026\"Q\u0011q\u0017\u0015\u0003\u0012\u0003\u0006I!! \t\u0015\u0005e\u0006F!f\u0001\n\u0003\t)\f\u0003\u0006\u0002<\"\u0012\t\u0012)A\u0005\u0003{B!\"!0)\u0005+\u0007I\u0011AA`\u0011)\t9\r\u000bB\tB\u0003%\u0011\u0011\u0019\u0005\u000b\u0003\u0013D#Q3A\u0005\u0002\u0005}\u0006BCAfQ\tE\t\u0015!\u0003\u0002B\"Q\u0011Q\u001a\u0015\u0003\u0016\u0004%\t!a4\t\u0015\u0005]\u0007F!E!\u0002\u0013\t\t\u000e\u0003\u0006\u0002Z\"\u0012)\u001a!C\u0001\u0003\u001fD!\"a7)\u0005#\u0005\u000b\u0011BAi\u0011)\ti\u000e\u000bBK\u0002\u0013\u0005\u0011q\u001c\u0005\u000b\u0003cD#\u0011#Q\u0001\n\u0005\u0005\bBCAzQ\tU\r\u0011\"\u0001\u0002v\"Q\u0011Q \u0015\u0003\u0012\u0003\u0006I!a>\t\u0015\u0005}\bF!f\u0001\n\u0003\u0011\t\u0001\u0003\u0006\u0003\u0010!\u0012\t\u0012)A\u0005\u0005\u0007Aq!!\u001b)\t\u0003\u0011\t\u0002C\u0005\u0003*!\n\t\u0011\"\u0001\u0003,!I!q\b\u0015\u0012\u0002\u0013\u0005!\u0011\t\u0005\n\u0005/B\u0013\u0013!C\u0001\u0005\u0003B\u0011B!\u0017)#\u0003%\tAa\u0017\t\u0013\t}\u0003&%A\u0005\u0002\tm\u0003\"\u0003B1QE\u0005I\u0011\u0001B2\u0011%\u00119\u0007KI\u0001\n\u0003\u0011\u0019\u0007C\u0005\u0003j!\n\n\u0011\"\u0001\u0003l!I!q\u000e\u0015\u0012\u0002\u0013\u0005!\u0011\u000f\u0005\n\u0005kB\u0013\u0013!C\u0001\u0005oB\u0011Ba\u001f)\u0003\u0003%\t%a\u001c\t\u0013\tu\u0004&!A\u0005\u0002\u0005=\u0007\"\u0003B@Q\u0005\u0005I\u0011\u0001BA\u0011%\u0011i\tKA\u0001\n\u0003\u0012y\tC\u0005\u0003\u001e\"\n\t\u0011\"\u0001\u0003 \"I!1\u0015\u0015\u0002\u0002\u0013\u0005#Q\u0015\u0005\n\u0005OC\u0013\u0011!C!\u0005SC\u0011Ba+)\u0003\u0003%\tE!,\b\u0013\tE6%!A\t\u0002\tMf!CARG\u0005\u0005\t\u0012\u0001B[\u0011\u001d\tIg\u0014C\u0001\u0005\u0007D\u0011Ba*P\u0003\u0003%)E!+\t\u0013\t\u0015w*!A\u0005\u0002\n\u001d\u0007\"\u0003Bn\u001f\u0006\u0005I\u0011\u0011Bo\u0011%\u0011yoTA\u0001\n\u0013\u0011\t\u0010C\u0005\u0003t\u000e\n\n\u0011\"\u0001\u0003v\nyA*Y7cI\u0006$\u0015\r^1Ti>\u0014XM\u0003\u0002Y3\u0006!A-\u0019;b\u0015\tQ6,\u0001\u0004mC6\u0014G-\u0019\u0006\u00039v\u000bqaZ3p[\u0016\u001c\u0018M\u0003\u0002_?\u0006aAn\\2bi&|g\u000e^3dQ*\t\u0001-A\u0002pe\u001e\u001c\u0001a\u0005\u0005\u0001G.$\u0018\u0011DA\u0017!\t!\u0017.D\u0001f\u0015\t1w-\u0001\u0003mC:<'\"\u00015\u0002\t)\fg/Y\u0005\u0003U\u0016\u0014aa\u00142kK\u000e$\bC\u00017s\u001b\u0005i'B\u0001-o\u0015\ty\u0007/A\u0002ba&T!!]0\u0002\u0011\u001d,w\u000e^8pYNL!a]7\u0003\u0013\u0011\u000bG/Y*u_J,\u0007cA;\u0002\u00149\u0019a/!\u0004\u000f\u0007]\f9AD\u0002y\u0003\u0007q1!_A\u0001\u001d\tQxP\u0004\u0002|}6\tAP\u0003\u0002~C\u00061AH]8pizJ\u0011\u0001Y\u0005\u0003=~K!\u0001X/\n\u0007\u0005\u00151,A\u0003j]\u0012,\u00070\u0003\u0003\u0002\n\u0005-\u0011!B:uCR\u001c(bAA\u00037&!\u0011qBA\t\u0003\u001d\u0001\u0018mY6bO\u0016TA!!\u0003\u0002\f%!\u0011QCA\f\u0005=A\u0015m]$f_6+7/Y*uCR\u001c(\u0002BA\b\u0003#\u0001B!a\u0007\u0002(9!\u0011QDA\u0011\u001d\r9\u0018qD\u0005\u0004c\u0006-\u0011\u0002BA\u0012\u0003K\tAcR3p\u001b\u0016\u001c\u0018MR3biV\u0014XMU3bI\u0016\u0014(bA9\u0002\f%!\u0011\u0011FA\u0016\u0005]A\u0015m]$f_6+7/\u0019$fCR,(/\u001a*fC\u0012,'O\u0003\u0003\u0002$\u0005\u0015\u0002\u0003BA\u0018\u0003{i!!!\r\u000b\t\u0005M\u0012QG\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0005\u0003o\tI$\u0001\u0005usB,7/\u00194f\u0015\t\tY$A\u0002d_6LA!a\u0010\u00022\tYA*\u0019>z\u0019><w-\u001b8h\u0003-\u0001XM]:jgR,gnY3\u0016\u0003-\fA\u0002]3sg&\u001cH/\u001a8dK\u0002\naaY8oM&<\u0007cAA&Q9\u0019\u0011Q\n\u0012\u000f\t\u0005=\u00131\u000b\b\u0004q\u0006E\u0013B\u0001.\\\u0013\tA\u0016,A\bMC6\u0014G-\u0019#bi\u0006\u001cFo\u001c:f!\r\tIfI\u0007\u0002/N\u00191%!\u0018\u0011\t\u0005}\u0013QM\u0007\u0003\u0003CR!!a\u0019\u0002\u000bM\u001c\u0017\r\\1\n\t\u0005\u001d\u0014\u0011\r\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\t\t9&\u0001\u0005U_BL7mS3z+\t\t\t\bE\u0002e\u0003gJ1!!\u001ef\u0005\u0019\u0019FO]5oO\u0006IAk\u001c9jG.+\u0017\u0010I\u0001\u0006i>\u0004\u0018n\u0019\u000b\u0007\u0003{\nY)a(\u0011\t\u0005}\u0014q\u0011\b\u0005\u0003\u0003\u000b\u0019\tE\u0002|\u0003CJA!!\"\u0002b\u00051\u0001K]3eK\u001aLA!!\u001e\u0002\n*!\u0011QQA1\u0011\u001d\tii\na\u0001\u0003\u001f\u000b1a\u001d4u!\u0011\t\t*a'\u000e\u0005\u0005M%\u0002BAK\u0003/\u000baa]5na2,'bAAM]\u00069a-Z1ukJ,\u0017\u0002BAO\u0003'\u0013\u0011cU5na2,g)Z1ukJ,G+\u001f9f\u0011\u001d\t\tk\na\u0001\u0003{\n\u0011B\\1nKN\u0004\u0018mY3\u0003\u00191\u000bWN\u00193b\u0007>tg-[4\u0014\u000f!\ni&a*\u0002.B!\u0011qLAU\u0013\u0011\tY+!\u0019\u0003\u000fA\u0013x\u000eZ;diB!\u0011qLAX\u0013\u0011\t\t,!\u0019\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u0015i|wn[3fa\u0016\u00148/\u0006\u0002\u0002~\u0005Y!p\\8lK\u0016\u0004XM]:!\u0003-Q8NT1nKN\u0004\u0018mY3\u0002\u0019i\\g*Y7fgB\f7-\u001a\u0011\u0002\u001dA\u0014x\u000eZ;dKJ\u001cuN\u001c4jOV\u0011\u0011\u0011\u0019\t\t\u0003\u007f\n\u0019-! \u0002~%!\u0011QYAE\u0005\ri\u0015\r]\u0001\u0010aJ|G-^2fe\u000e{gNZ5hA\u0005q1m\u001c8tk6,'oQ8oM&<\u0017aD2p]N,X.\u001a:D_:4\u0017n\u001a\u0011\u0002\u0015A\f'\u000f^5uS>t7/\u0006\u0002\u0002RB!\u0011qLAj\u0013\u0011\t).!\u0019\u0003\u0007%sG/A\u0006qCJ$\u0018\u000e^5p]N\u0004\u0013!C2p]N,X.\u001a:t\u0003)\u0019wN\\:v[\u0016\u00148\u000fI\u0001\u0007Kb\u0004\u0018N]=\u0016\u0005\u0005\u0005\b\u0003BAr\u0003[l!!!:\u000b\t\u0005\u001d\u0018\u0011^\u0001\tIV\u0014\u0018\r^5p]*!\u00111^A1\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0003_\f)O\u0001\u0005EkJ\fG/[8o\u0003\u001d)\u0007\u0010]5ss\u0002\nq\u0001]3sg&\u001cH/\u0006\u0002\u0002xB!\u0011qLA}\u0013\u0011\tY0!\u0019\u0003\u000f\t{w\u000e\\3b]\u0006A\u0001/\u001a:tSN$\b%A\u0007pM\u001a\u001cX\r^'b]\u0006<WM]\u000b\u0003\u0005\u0007\u0001BA!\u0002\u0003\f5\u0011!q\u0001\u0006\u0004\u0005\u0013I\u0016AB:ue\u0016\fW.\u0003\u0003\u0003\u000e\t\u001d!!D(gMN,G/T1oC\u001e,'/\u0001\bpM\u001a\u001cX\r^'b]\u0006<WM\u001d\u0011\u0015)\tM!q\u0003B\r\u00057\u0011iBa\b\u0003\"\t\r\"Q\u0005B\u0014!\r\u0011)\u0002K\u0007\u0002G!9\u00111W\u001eA\u0002\u0005u\u0004bBA]w\u0001\u0007\u0011Q\u0010\u0005\b\u0003{[\u0004\u0019AAa\u0011\u001d\tIm\u000fa\u0001\u0003\u0003Dq!!4<\u0001\u0004\t\t\u000eC\u0004\u0002Zn\u0002\r!!5\t\u000f\u0005u7\b1\u0001\u0002b\"9\u00111_\u001eA\u0002\u0005]\bbBA\u0000w\u0001\u0007!1A\u0001\u0005G>\u0004\u0018\u0010\u0006\u000b\u0003\u0014\t5\"q\u0006B\u0019\u0005g\u0011)Da\u000e\u0003:\tm\"Q\b\u0005\n\u0003gc\u0004\u0013!a\u0001\u0003{B\u0011\"!/=!\u0003\u0005\r!! \t\u0013\u0005uF\b%AA\u0002\u0005\u0005\u0007\"CAeyA\u0005\t\u0019AAa\u0011%\ti\r\u0010I\u0001\u0002\u0004\t\t\u000eC\u0005\u0002Zr\u0002\n\u00111\u0001\u0002R\"I\u0011Q\u001c\u001f\u0011\u0002\u0003\u0007\u0011\u0011\u001d\u0005\n\u0003gd\u0004\u0013!a\u0001\u0003oD\u0011\"a@=!\u0003\u0005\rAa\u0001\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!1\t\u0016\u0005\u0003{\u0012)e\u000b\u0002\u0003HA!!\u0011\nB*\u001b\t\u0011YE\u0003\u0003\u0003N\t=\u0013!C;oG\",7m[3e\u0015\u0011\u0011\t&!\u0019\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003V\t-#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0005;RC!!1\u0003F\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\"\u0014AD2paf$C-\u001a4bk2$H%N\u000b\u0003\u0005KRC!!5\u0003F\u0005q1m\u001c9zI\u0011,g-Y;mi\u00122\u0014AD2paf$C-\u001a4bk2$HeN\u000b\u0003\u0005[RC!!9\u0003F\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012BTC\u0001B:U\u0011\t9P!\u0012\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%sU\u0011!\u0011\u0010\u0016\u0005\u0005\u0007\u0011)%A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u0001\raJ|G-^2u\u0003JLG/_\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\u0011\u0019I!#\u0011\t\u0005}#QQ\u0005\u0005\u0005\u000f\u000b\tGA\u0002B]fD\u0011Ba#I\u0003\u0003\u0005\r!!5\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011\t\n\u0005\u0004\u0003\u0014\ne%1Q\u0007\u0003\u0005+SAAa&\u0002b\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\tm%Q\u0013\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002x\n\u0005\u0006\"\u0003BF\u0015\u0006\u0005\t\u0019\u0001BB\u0003!A\u0017m\u001d5D_\u0012,GCAAi\u0003!!xn\u0015;sS:<GCAA9\u0003\u0019)\u0017/^1mgR!\u0011q\u001fBX\u0011%\u0011Y)TA\u0001\u0002\u0004\u0011\u0019)\u0001\u0007MC6\u0014G-Y\"p]\u001aLw\rE\u0002\u0003\u0016=\u001bRa\u0014B\\\u0003[\u0003\u0002D!/\u0003@\u0006u\u0014QPAa\u0003\u0003\f\t.!5\u0002b\u0006](1\u0001B\n\u001b\t\u0011YL\u0003\u0003\u0003>\u0006\u0005\u0014a\u0002:v]RLW.Z\u0005\u0005\u0005\u0003\u0014YLA\tBEN$(/Y2u\rVt7\r^5p]f\"\"Aa-\u0002\u000b\u0005\u0004\b\u000f\\=\u0015)\tM!\u0011\u001aBf\u0005\u001b\u0014yM!5\u0003T\nU'q\u001bBm\u0011\u001d\t\u0019L\u0015a\u0001\u0003{Bq!!/S\u0001\u0004\ti\bC\u0004\u0002>J\u0003\r!!1\t\u000f\u0005%'\u000b1\u0001\u0002B\"9\u0011Q\u001a*A\u0002\u0005E\u0007bBAm%\u0002\u0007\u0011\u0011\u001b\u0005\b\u0003;\u0014\u0006\u0019AAq\u0011\u001d\t\u0019P\u0015a\u0001\u0003oDq!a@S\u0001\u0004\u0011\u0019!A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\t}'1\u001e\t\u0007\u0003?\u0012\tO!:\n\t\t\r\u0018\u0011\r\u0002\u0007\u001fB$\u0018n\u001c8\u0011-\u0005}#q]A?\u0003{\n\t-!1\u0002R\u0006E\u0017\u0011]A|\u0005\u0007IAA!;\u0002b\t1A+\u001e9mKfB\u0011B!<T\u0003\u0003\u0005\rAa\u0005\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,G#A2\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134)\u0019\u00119p!\u0002\u0004\b)\"!\u0011 B#!\u0011\u0011Yp!\u0001\u000e\u0005\tu(b\u0001B\u0000O\u0006!A/[7f\u0013\u0011\u0019\u0019A!@\u0003\u000b\rcwnY6\t\r\u0005\u0005S\u000b1\u0001l\u0011\u001d\t9%\u0016a\u0001\u0005'\tQa\u00197pG.$ba!\u0004\u0004\u0014\rUA\u0003BB\b\u0007#\u00012!!\u0017\u0001\u0011%\u0019I!\u0002I\u0001\u0002\b\u0011I\u0010\u0003\u0004\u0002B\u0015\u0001\ra\u001b\u0005\b\u0003\u000f*\u0001\u0019AA%\u00031\tW\u000f\u001e5Qe>4\u0018\u000eZ3s+\t\u0019Y\u0002\u0005\u0004\u0002`\t\u00058Q\u0004\t\u0005\u0007?\u0019)#\u0004\u0002\u0004\")\u001911E.\u0002\u0011M,7-\u001e:jifLAaa\n\u0004\"\t1\u0012)\u001e;i_JL'0\u0019;j_:\u001c\bK]8wS\u0012,'/A\u0007bkRD\u0007K]8wS\u0012,'\u000fI\u0001\u000biJ\fgn]5f]R\u001cXCAB\u0018!!\u0019\tda\u0011\u0002~\r\u001dSBAB\u001a\u0015\u0011\u0019)da\u000e\u0002\u000b\r\f7\r[3\u000b\t\re21H\u0001\tG\u00064g-Z5oK*!1QHB \u0003!\u0011WM\\7b]\u0016\u001c(\u0002BB!\u0003s\taaZ5uQV\u0014\u0017\u0002BB#\u0007g\u0011A\u0002T8bI&twmQ1dQ\u0016\u0004BA!\u0002\u0004J%!11\nB\u0004\u00059!&/\u00198tS\u0016tGo\u0015;pe\u0016\f1\u0002\u001e:b]NLWM\u001c;tAU\u00111\u0011\u000b\t\u0005\u0007'\u001a)&\u0004\u0002\u0002\u0012%!1qKA\t\u000519Um\\'fg\u0006\u001cF/\u0019;t\u0003\u0019\u0019H/\u0019;tA\u00051!/\u001e8oKJ,\"aa\u0018\u0011\t\u0005e3\u0011M\u0005\u0004\u0007G:&!\u0005'b[\n$\u0017-U;fef\u0014VO\u001c8fe\u00069!/\u001e8oKJ\u0004C\u0003BB5\u0007_\u0002B!a\u0018\u0004l%!1QNA1\u0005\u0011)f.\u001b;\t\u000f\rEd\u00021\u0001\u0002~\u0005AA/\u001f9f\u001d\u0006lW-\u0001\u0007hKR$\u0016\u0010]3OC6,7\u000f\u0006\u0002\u0004xA1\u0011qLB=\u0003{JAaa\u001f\u0002b\t)\u0011I\u001d:bs\u0006Aq-\u001a;OC6,7\u000f\u0006\u0002\u0004\u0002B111QBE\u0007\u001bk!a!\"\u000b\u0007\r\u001du-\u0001\u0003vi&d\u0017\u0002BBF\u0007\u000b\u0013A\u0001T5tiB!1qRBK\u001b\t\u0019\tJ\u0003\u0003\u0004\u0014\u0006]\u0015\u0001\u0002;za\u0016LAaa&\u0004\u0012\n!a*Y7f\u00031\u0019'/Z1uKN\u001b\u0007.Z7b)\u0011\u0019Ig!(\t\u000f\u00055\u0015\u00031\u0001\u0002\u0010\u0006Iq-\u001a;TG\",W.\u0019\u000b\u0005\u0003\u001f\u001b\u0019\u000bC\u0004\u0004rI\u0001\ra!$\u0015\t\u0005=5q\u0015\u0005\b\u0007c\u001a\u0002\u0019AA?\u00031)\b\u000fZ1uKN\u001b\u0007.Z7b)\u0019\u0019Ig!,\u00040\"91\u0011\u000f\u000bA\u0002\r5\u0005bBBY)\u0001\u0007\u0011qR\u0001\fM\u0016\fG/\u001e:f)f\u0004X\r\u0006\u0004\u0004j\rU6q\u0017\u0005\b\u0007c*\u0002\u0019AA?\u0011\u001d\u0019\t,\u0006a\u0001\u0003\u001f\u000bAB]3n_Z,7k\u00195f[\u0006$Ba!\u001b\u0004>\"91\u0011\u000f\fA\u0002\r5E\u0003BB5\u0007\u0003Dqa!\u001d\u0018\u0001\u0004\ti(\u0001\thKR4U-\u0019;ve\u0016\u001cv.\u001e:dKR!1qYBg!\ra7\u0011Z\u0005\u0004\u0007\u0017l'aE*j[BdWMR3biV\u0014XmU8ve\u000e,\u0007bBB91\u0001\u00071Q\u0012\u000b\u0005\u0007\u000f\u001c\t\u000eC\u0004\u0004re\u0001\r!! \u0002!\u001d,GOR3biV\u0014XMU3bI\u0016\u0014HCBBl\u0007;\u001c9\u000fE\u0002m\u00073L1aa7n\u0005M\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sKJ+\u0017\rZ3s\u0011\u001d\u0019yN\u0007a\u0001\u0007C\fQ!];fef\u00042\u0001\\Br\u0013\r\u0019)/\u001c\u0002\u0006#V,'/\u001f\u0005\b\u0007ST\u0002\u0019ABv\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\u0011\u00071\u001ci/C\u0002\u0004p6\u00141\u0002\u0016:b]N\f7\r^5p]RA11_B~\u0007{\u001cy\u0010\u0005\u0003\u0004v\u000e]XBAA\u0013\u0013\u0011\u0019I0!\n\u0003)\u001d+w.T3tC\u001a+\u0017\r^;sKJ+\u0017\rZ3s\u0011\u001d\tii\u0007a\u0001\u0003\u001fCqa!;\u001c\u0001\u0004\u0019Y\u000fC\u0004\u0004`n\u0001\ra!9\u0002-\u001d,GOR3biV\u0014Xm\u0016:ji\u0016\u0014\u0018\t\u001d9f]\u0012$b\u0001\"\u0002\u0005\f\u00115\u0001c\u00017\u0005\b%\u0019A\u0011B7\u0003'MKW\u000e\u001d7f\r\u0016\fG/\u001e:f/JLG/\u001a:\t\u000f\rED\u00041\u0001\u0002~!91\u0011\u001e\u000fA\u0002\r-\u0018\u0001E4fi\u001a+\u0017\r^;sK^\u0013\u0018\u000e^3s)\u0019!)\u0001b\u0005\u0005\u0016!91\u0011O\u000fA\u0002\u0005u\u0004bBBu;\u0001\u000711\u001e\u000b\t\t\u000b!I\u0002b\u0007\u0005*!91\u0011\u000f\u0010A\u0002\u0005u\u0004b\u0002C\u000f=\u0001\u0007AqD\u0001\u0007M&dG/\u001a:\u0011\t\u0011\u0005BQE\u0007\u0003\tGQ1\u0001\"\bo\u0013\u0011!9\u0003b\t\u0003\r\u0019KG\u000e^3s\u0011\u001d\u0019IO\ba\u0001\u0007W\fq\u0001Z5ta>\u001cX\r\u0006\u0002\u0004j\u00059q-\u001a;J]\u001a|GC\u0001C\u001a!\raGQG\u0005\u0004\toi'aC*feZL7-Z%oM>\f\u0011cZ3u\u0019>\u001c7.\u001b8h\u001b\u0006t\u0017mZ3s)\t!i\u0004E\u0002m\t\u007fI1\u0001\"\u0011n\u00059aunY6j]\u001el\u0015M\\1hKJ\u0004")
public class LambdaDataStore
implements DataStore,
package.HasGeoMesaStats,
GeoMesaFeatureReader.HasGeoMesaFeatureReader,
LazyLogging {
    private final DataStore persistence;
    public final LambdaConfig org$locationtech$geomesa$lambda$data$LambdaDataStore$$config;
    public final Clock org$locationtech$geomesa$lambda$data$LambdaDataStore$$clock;
    private final Option<AuthorizationsProvider> org$locationtech$geomesa$lambda$data$LambdaDataStore$$authProvider;
    private final LoadingCache<String, TransientStore> transients;
    private final GeoMesaStats stats;
    private final LambdaQueryRunner runner;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static Clock $lessinit$greater$default$3(DataStore dataStore, LambdaConfig lambdaConfig) {
        return LambdaDataStore$.MODULE$.$lessinit$greater$default$3(dataStore, lambdaConfig);
    }

    public static String topic(SimpleFeatureType simpleFeatureType, String string) {
        return LambdaDataStore$.MODULE$.topic(simpleFeatureType, string);
    }

    public static String TopicKey() {
        return LambdaDataStore$.MODULE$.TopicKey();
    }

    private Logger logger$lzycompute() {
        LambdaDataStore lambdaDataStore = this;
        synchronized (lambdaDataStore) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public DataStore persistence() {
        return this.persistence;
    }

    public Option<AuthorizationsProvider> org$locationtech$geomesa$lambda$data$LambdaDataStore$$authProvider() {
        return this.org$locationtech$geomesa$lambda$data$LambdaDataStore$$authProvider;
    }

    public LoadingCache<String, TransientStore> transients() {
        return this.transients;
    }

    public GeoMesaStats stats() {
        return this.stats;
    }

    private LambdaQueryRunner runner() {
        return this.runner;
    }

    public void persist(String typeName) {
        ((TransientStore)this.transients().get((Object)typeName)).persist();
    }

    public String[] getTypeNames() {
        return this.persistence().getTypeNames();
    }

    public List<Name> getNames() {
        return this.persistence().getNames();
    }

    public void createSchema(SimpleFeatureType sft) {
        String topic = LambdaDataStore$.MODULE$.topic(sft, this.org$locationtech$geomesa$lambda$data$LambdaDataStore$$config.zkNamespace());
        if (topic.contains("/")) {
            throw new IllegalArgumentException(new StringBuilder(26).append("Topic cannot contain '/': ").append(topic).toString());
        }
        this.persistence().createSchema((FeatureType)sft);
        Properties props = new Properties();
        this.org$locationtech$geomesa$lambda$data$LambdaDataStore$$config.producerConfig().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return props.put(k, v);
            }
            throw new MatchError((Object)tuple2);
        });
        package.WithClose$.MODULE$.apply((Object)AdminClient.create((Properties)props), (Function1 & Serializable & scala.Serializable)admin -> {
            if (((Set)admin.listTopics().names().get()).contains(topic)) {
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Topic [{}] already exists - it may contain stale data", new Object[]{topic});
                    return BoxedUnit.UNIT;
                }
                return BoxedUnit.UNIT;
            }
            int replication = BoxesRunTime.unboxToInt((Object)new GeoMesaSystemProperties.SystemProperty("geomesa.kafka.replication", GeoMesaSystemProperties.SystemProperty$.MODULE$.apply$default$2()).option().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)LambdaDataStore.$anonfun$createSchema$3(x$1))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 1));
            NewTopic newTopic = new NewTopic(topic, $this.org$locationtech$geomesa$lambda$data$LambdaDataStore$$config.partitions(), (short)replication);
            return admin.createTopics(Collections.singletonList(newTopic)).all().get();
        }, IsCloseable$.MODULE$.closeableIsCloseable());
    }

    public SimpleFeatureType getSchema(Name typeName) {
        return this.getSchema(typeName.getLocalPart());
    }

    public SimpleFeatureType getSchema(String typeName) {
        SimpleFeatureType sft = this.persistence().getSchema(typeName);
        Object object = sft != null ? this.transients().get((Object)typeName) : BoxedUnit.UNIT;
        return sft;
    }

    public void updateSchema(Name typeName, SimpleFeatureType featureType) {
        this.updateSchema(typeName.getLocalPart(), featureType);
    }

    public void updateSchema(String typeName, SimpleFeatureType featureType) {
        Object object;
        TransientStore transientStore = (TransientStore)this.transients().get((Object)typeName);
        String string = typeName;
        String string2 = featureType.getTypeName();
        if (string == null ? string2 != null : !string.equals(string2)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Update schema: entering quiet period");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            Thread.sleep(((Duration)new GeoMesaSystemProperties.SystemProperty("geomesa.lambda.update.quiet.period", "10 seconds").toDuration().get()).toMillis());
            object = package.WithClose$.MODULE$.apply(transientStore.read(transientStore.read$default$1(), transientStore.read$default$2(), transientStore.read$default$3(), transientStore.read$default$4()).iterator().apply(), (Function1 & Serializable & scala.Serializable)toPersist -> {
                LambdaDataStore.$anonfun$updateSchema$1(this, typeName, toPersist);
                return BoxedUnit.UNIT;
            }, IsCloseable$.MODULE$.closeableIsCloseable());
        } else {
            object = BoxedUnit.UNIT;
        }
        package.CloseWithLogging$.MODULE$.apply((Object)transientStore, IsCloseable$.MODULE$.closeableIsCloseable());
        this.transients().invalidate((Object)typeName);
        this.persistence().updateSchema(typeName, featureType);
    }

    public void removeSchema(Name typeName) {
        this.removeSchema(typeName.getLocalPart());
    }

    public void removeSchema(String typeName) {
        TransientStore transientStore = (TransientStore)this.transients().get((Object)typeName);
        transientStore.removeSchema();
        package.CloseWithLogging$.MODULE$.apply((Object)transientStore, IsCloseable$.MODULE$.closeableIsCloseable());
        this.transients().invalidate((Object)typeName);
        this.persistence().removeSchema(typeName);
    }

    public SimpleFeatureSource getFeatureSource(Name typeName) {
        return this.getFeatureSource(typeName.getLocalPart());
    }

    public SimpleFeatureSource getFeatureSource(String typeName) {
        return new GeoMesaFeatureStore((DataStore)this, this.getSchema(typeName));
    }

    public SimpleFeatureReader getFeatureReader(Query query, Transaction transaction) {
        return this.getFeatureReader(this.getSchema(query.getTypeName()), transaction, query).reader();
    }

    public GeoMesaFeatureReader getFeatureReader(SimpleFeatureType sft, Transaction transaction, Query query) {
        return GeoMesaFeatureReader$.MODULE$.apply(sft, query, (QueryRunner)this.runner(), (Option)None$.MODULE$);
    }

    public SimpleFeatureWriter getFeatureWriterAppend(String typeName, Transaction transaction) {
        TransientStore transientStore = (TransientStore)this.transients().get((Object)typeName);
        if (RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.isVisibilityRequired$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(transientStore.sft()))) {
            return new LambdaFeatureWriter.RequiredVisibilityWriter(null, transientStore){

                public /* synthetic */ void org$locationtech$geomesa$lambda$data$LambdaFeatureWriter$RequiredVisibilityWriter$$super$write() {
                    super.write();
                }

                public void write() {
                    LambdaFeatureWriter.RequiredVisibilityWriter.write$(this);
                }

                public void requireVisibilities(SimpleFeature feature) throws IllegalArgumentException {
                    VisibilityChecker.requireVisibilities$((VisibilityChecker)this, (SimpleFeature)feature);
                }
                {
                    VisibilityChecker.$init$((VisibilityChecker)this);
                    LambdaFeatureWriter.RequiredVisibilityWriter.$init$(this);
                }
            };
        }
        return new LambdaFeatureWriter.AppendLambdaFeatureWriter(transientStore);
    }

    public SimpleFeatureWriter getFeatureWriter(String typeName, Transaction transaction) {
        return this.getFeatureWriter(typeName, (Filter)Filter.INCLUDE, transaction);
    }

    public SimpleFeatureWriter getFeatureWriter(String typeName, Filter filter, Transaction transaction) {
        Query query = new Query(typeName, filter);
        SelfClosingIterator features = SelfClosingIterator$.MODULE$.apply((FeatureReader)this.getFeatureReader(query, transaction));
        TransientStore transientStore = (TransientStore)this.transients().get((Object)typeName);
        if (RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.isVisibilityRequired$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(transientStore.sft()))) {
            return new LambdaFeatureWriter.RequiredVisibilityWriter(null, transientStore, features){

                public /* synthetic */ void org$locationtech$geomesa$lambda$data$LambdaFeatureWriter$RequiredVisibilityWriter$$super$write() {
                    super.write();
                }

                public void write() {
                    LambdaFeatureWriter.RequiredVisibilityWriter.write$(this);
                }

                public void requireVisibilities(SimpleFeature feature) throws IllegalArgumentException {
                    VisibilityChecker.requireVisibilities$((VisibilityChecker)this, (SimpleFeature)feature);
                }
                {
                    VisibilityChecker.$init$((VisibilityChecker)this);
                    LambdaFeatureWriter.RequiredVisibilityWriter.$init$(this);
                }
            };
        }
        return new LambdaFeatureWriter.ModifyLambdaFeatureWriter(transientStore, (CloseableIterator<SimpleFeature>)features);
    }

    public void dispose() {
        package.CloseWithLogging$.MODULE$.apply((Object)((MapLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.transients().asMap()).asScala()).values(), (IsCloseable)IsCloseable$.MODULE$.iterableIsCloseable());
        this.transients().invalidateAll();
        package.CloseWithLogging$.MODULE$.apply((Object)this.org$locationtech$geomesa$lambda$data$LambdaDataStore$$config.offsetManager(), IsCloseable$.MODULE$.closeableIsCloseable());
        this.persistence().dispose();
    }

    public ServiceInfo getInfo() {
        DefaultServiceInfo info = new DefaultServiceInfo();
        info.setDescription(new StringBuilder(14).append("Features from ").append(this.getClass().getSimpleName()).toString());
        info.setSchema(FeatureTypes.DEFAULT_NAMESPACE);
        return info;
    }

    public LockingManager getLockingManager() {
        return null;
    }

    public static final /* synthetic */ int $anonfun$createSchema$3(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toInt();
    }

    public static final /* synthetic */ void $anonfun$updateSchema$1(LambdaDataStore $this, String typeName$1, CloseableIterator toPersist) {
        if (toPersist.nonEmpty()) {
            BoxedUnit boxedUnit;
            if ($this.logger().underlying().isDebugEnabled()) {
                $this.logger().underlying().debug("Update schema: persisting transient features");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            package.WithClose$.MODULE$.apply((Object)$this.persistence().getFeatureWriter(typeName$1, Transaction.AUTO_COMMIT), (Function1 & Serializable & scala.Serializable)writer -> {
                toPersist.foreach((Function1 & Serializable & scala.Serializable)x$2 -> FeatureUtils$.MODULE$.write(writer, x$2, true));
                return BoxedUnit.UNIT;
            }, IsCloseable$.MODULE$.closeableIsCloseable());
            return;
        }
    }

    public LambdaDataStore(DataStore persistence, LambdaConfig config, Clock clock) {
        Object object;
        GeoMesaDataStore geoMesaDataStore;
        this.persistence = persistence;
        this.org$locationtech$geomesa$lambda$data$LambdaDataStore$$config = config;
        this.org$locationtech$geomesa$lambda$data$LambdaDataStore$$clock = clock;
        LazyLogging.$init$((LazyLogging)this);
        DataStore dataStore = persistence;
        this.org$locationtech$geomesa$lambda$data$LambdaDataStore$$authProvider = dataStore instanceof GeoMesaDataStore && (geoMesaDataStore = (GeoMesaDataStore)dataStore).config().authProvider().getAuthorizations() != null ? new Some((Object)geoMesaDataStore.config().authProvider()) : None$.MODULE$;
        this.transients = Caffeine.newBuilder().build((CacheLoader)new CacheLoader<String, TransientStore>(this){
            private final /* synthetic */ LambdaDataStore $outer;

            public Map<? extends String, ? extends TransientStore> loadAll(Set<? extends String> x$1) throws Exception {
                return super.loadAll(x$1);
            }

            public CompletableFuture asyncLoad(Object x$1, Executor x$2) throws Exception {
                return super.asyncLoad(x$1, x$2);
            }

            public CompletableFuture<? extends Map<? extends String, ? extends TransientStore>> asyncLoadAll(Set<? extends String> x$1, Executor x$2) throws Exception {
                return super.asyncLoadAll(x$1, x$2);
            }

            public Object reload(Object x$1, Object x$2) throws Exception {
                return super.reload(x$1, x$2);
            }

            public CompletableFuture asyncReload(Object x$1, Object x$2, Executor x$3) throws Exception {
                return super.asyncReload(x$1, x$2, x$3);
            }

            public TransientStore load(String key) {
                return new KafkaStore(this.$outer.persistence(), this.$outer.persistence().getSchema(key), this.$outer.org$locationtech$geomesa$lambda$data$LambdaDataStore$$authProvider(), this.$outer.org$locationtech$geomesa$lambda$data$LambdaDataStore$$config, this.$outer.org$locationtech$geomesa$lambda$data$LambdaDataStore$$clock);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        DataStore dataStore2 = persistence;
        if (dataStore2 instanceof package.HasGeoMesaStats) {
            DataStore dataStore3 = dataStore2;
            object = new LambdaStats(((package.HasGeoMesaStats)dataStore3).stats(), this.transients());
        } else {
            object = package.NoopStats$.MODULE$;
        }
        this.stats = object;
        this.runner = new LambdaQueryRunner(this, persistence, this.transients());
    }

    public static class LambdaConfig
    implements Product,
    scala.Serializable {
        private final String zookeepers;
        private final String zkNamespace;
        private final scala.collection.immutable.Map<String, String> producerConfig;
        private final scala.collection.immutable.Map<String, String> consumerConfig;
        private final int partitions;
        private final int consumers;
        private final Duration expiry;
        private final boolean persist;
        private final OffsetManager offsetManager;

        public String zookeepers() {
            return this.zookeepers;
        }

        public String zkNamespace() {
            return this.zkNamespace;
        }

        public scala.collection.immutable.Map<String, String> producerConfig() {
            return this.producerConfig;
        }

        public scala.collection.immutable.Map<String, String> consumerConfig() {
            return this.consumerConfig;
        }

        public int partitions() {
            return this.partitions;
        }

        public int consumers() {
            return this.consumers;
        }

        public Duration expiry() {
            return this.expiry;
        }

        public boolean persist() {
            return this.persist;
        }

        public OffsetManager offsetManager() {
            return this.offsetManager;
        }

        public LambdaConfig copy(String zookeepers, String zkNamespace, scala.collection.immutable.Map<String, String> producerConfig, scala.collection.immutable.Map<String, String> consumerConfig, int partitions, int consumers, Duration expiry, boolean persist, OffsetManager offsetManager) {
            return new LambdaConfig(zookeepers, zkNamespace, producerConfig, consumerConfig, partitions, consumers, expiry, persist, offsetManager);
        }

        public String copy$default$1() {
            return this.zookeepers();
        }

        public String copy$default$2() {
            return this.zkNamespace();
        }

        public scala.collection.immutable.Map<String, String> copy$default$3() {
            return this.producerConfig();
        }

        public scala.collection.immutable.Map<String, String> copy$default$4() {
            return this.consumerConfig();
        }

        public int copy$default$5() {
            return this.partitions();
        }

        public int copy$default$6() {
            return this.consumers();
        }

        public Duration copy$default$7() {
            return this.expiry();
        }

        public boolean copy$default$8() {
            return this.persist();
        }

        public OffsetManager copy$default$9() {
            return this.offsetManager();
        }

        public String productPrefix() {
            return "LambdaConfig";
        }

        public int productArity() {
            return 9;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.zookeepers();
                }
                case 1: {
                    return this.zkNamespace();
                }
                case 2: {
                    return this.producerConfig();
                }
                case 3: {
                    return this.consumerConfig();
                }
                case 4: {
                    return BoxesRunTime.boxToInteger((int)this.partitions());
                }
                case 5: {
                    return BoxesRunTime.boxToInteger((int)this.consumers());
                }
                case 6: {
                    return this.expiry();
                }
                case 7: {
                    return BoxesRunTime.boxToBoolean((boolean)this.persist());
                }
                case 8: {
                    return this.offsetManager();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof LambdaConfig;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.zookeepers()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.zkNamespace()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.producerConfig()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.consumerConfig()));
            n = Statics.mix((int)n, (int)this.partitions());
            n = Statics.mix((int)n, (int)this.consumers());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.expiry()));
            n = Statics.mix((int)n, (int)(this.persist() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.offsetManager()));
            return Statics.finalizeHash((int)n, (int)9);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof LambdaConfig)) return false;
            boolean bl = true;
            if (!bl) return false;
            LambdaConfig lambdaConfig = (LambdaConfig)x$1;
            String string = this.zookeepers();
            String string2 = lambdaConfig.zookeepers();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.zkNamespace();
            String string4 = lambdaConfig.zkNamespace();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            scala.collection.immutable.Map<String, String> map = this.producerConfig();
            scala.collection.immutable.Map<String, String> map2 = lambdaConfig.producerConfig();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            scala.collection.immutable.Map<String, String> map3 = this.consumerConfig();
            scala.collection.immutable.Map<String, String> map4 = lambdaConfig.consumerConfig();
            if (map3 == null) {
                if (map4 != null) {
                    return false;
                }
            } else if (!map3.equals(map4)) return false;
            if (this.partitions() != lambdaConfig.partitions()) return false;
            if (this.consumers() != lambdaConfig.consumers()) return false;
            Duration duration = this.expiry();
            Duration duration2 = lambdaConfig.expiry();
            if (duration == null) {
                if (duration2 != null) {
                    return false;
                }
            } else if (!duration.equals(duration2)) return false;
            if (this.persist() != lambdaConfig.persist()) return false;
            OffsetManager offsetManager = this.offsetManager();
            OffsetManager offsetManager2 = lambdaConfig.offsetManager();
            if (offsetManager == null) {
                if (offsetManager2 != null) {
                    return false;
                }
            } else if (!offsetManager.equals(offsetManager2)) return false;
            if (!lambdaConfig.canEqual(this)) return false;
            return true;
        }

        public LambdaConfig(String zookeepers, String zkNamespace, scala.collection.immutable.Map<String, String> producerConfig, scala.collection.immutable.Map<String, String> consumerConfig, int partitions, int consumers, Duration expiry, boolean persist, OffsetManager offsetManager) {
            this.zookeepers = zookeepers;
            this.zkNamespace = zkNamespace;
            this.producerConfig = producerConfig;
            this.consumerConfig = consumerConfig;
            this.partitions = partitions;
            this.consumers = consumers;
            this.expiry = expiry;
            this.persist = persist;
            this.offsetManager = offsetManager;
            Product.$init$((Product)this);
        }
    }
}

