/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.lambda.stream.kafka;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayDeque;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.geotools.api.feature.simple.SimpleFeature;
import org.locationtech.geomesa.lambda.stream.OffsetManager;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\r\u0005d\u0001\u0002'N\u0001iC!B!.\u0001\u0005\u0003\u0005\u000b\u0011BA\u0016\u0011\u00191\b\u0001\"\u0001\u00038\"I\u0011Q\u0015\u0001C\u0002\u0013%!Q\u0018\u0005\t\u0003g\u0003\u0001\u0015!\u0003\u0003@\"I!\u0011\u001b\u0001C\u0002\u0013%!1\u001b\u0005\t\u0005o\u0004\u0001\u0015!\u0003\u0003V\"I!\u0011 \u0001C\u0002\u0013%!1 \u0005\t\u0007\u0017\u0001\u0001\u0015!\u0003\u0003~\"I1Q\u0002\u0001C\u0002\u0013%1q\u0002\u0005\t\u0007#\u0001\u0001\u0015!\u0003\u0003\u0018!9\u0011q\b\u0001\u0005B\rM\u0001bBA\u0012\u0001\u0011\u00053\u0011\u0004\u0005\u0006u\u0002!\te\u001f\u0005\b\u0003;\u0002A\u0011IB\u000f\u0011\u001d\tY\u0007\u0001C!\u0007OAq!a\u001f\u0001\t\u0003\u001a\t\u0004C\u0004\u0002|\u0001!\te!\u000e\t\u000f\ru\u0002\u0001\"\u0011\u0004@!91Q\t\u0001\u0005\n\r\u001d\u0003bBB'\u0001\u0011%1q\n\u0005\b\u0007+\u0002A\u0011BB,\u000f\u0015\u0011X\n#\u0001t\r\u0015aU\n#\u0001v\u0011\u00151x\u0003\"\u0001x\r\u001dAx\u0003%A\u0012\u0002eDQA_\r\u0007\u0002mDq!a\t\u001a\r\u0003\t)CB\u0005\u0002<]\u0001\n1%\u0001\u0002>!9\u0011q\b\u000f\u0007\u0002\u0005\u0005\u0003bBA/9\u0019\u0005\u0011q\f\u0005\b\u0003Wbb\u0011AA7\r%\t9h\u0006I\u0001$\u0003\tI\bC\u0004\u0002|\u00012\t!! \t\u000f\u0005m\u0004E\"\u0001\u0002\n\u001a1\u0011qR\fA\u0003#C!\"a($\u0005+\u0007I\u0011AAQ\u0011)\t\u0019k\tB\tB\u0003%\u0011q\u000b\u0005\u000b\u0003K\u001b#Q3A\u0005\u0002\u0005\u001d\u0006BCAZG\tE\t\u0015!\u0003\u0002*\"1ao\tC\u0001\u0003kC\u0011\"a/$\u0003\u0003%\t!!0\t\u0013\u0005\r7%%A\u0005\u0002\u0005\u0015\u0007\"CAnGE\u0005I\u0011AAo\u0011%\t\toIA\u0001\n\u0003\n\u0019\u000fC\u0005\u0002t\u000e\n\t\u0011\"\u0001\u0002v\"I\u0011q_\u0012\u0002\u0002\u0013\u0005\u0011\u0011 \u0005\n\u0005\u000b\u0019\u0013\u0011!C!\u0005\u000fA\u0011Ba\u0005$\u0003\u0003%\tA!\u0006\t\u0013\t}1%!A\u0005B\t\u0005\u0002\"\u0003B\u0012G\u0005\u0005I\u0011\tB\u0013\u0011%\u00119cIA\u0001\n\u0003\u0012IcB\u0005\u00032]\t\t\u0011#\u0001\u00034\u0019I\u0011qR\f\u0002\u0002#\u0005!Q\u0007\u0005\u0007mV\"\tAa\u0011\t\u0013\t\rR'!A\u0005F\t\u0015\u0002\"\u0003B#k\u0005\u0005I\u0011\u0011B$\u0011%\u0011i%NA\u0001\n\u0003\u0013y\u0005C\u0005\u0003bU\n\t\u0011\"\u0003\u0003d\u0019I\u0011QV\f\u0011\u0002G\u0005\u0011q\u0016\u0005\b\u0003+Zd\u0011AAQ\u0011\u001d\t)b\u000fD\u0001\u0003c3aAa\u001b\u0018\t\t5\u0004BCA\u000b}\t\u0015\r\u0011\"\u0001\u00022\"Q!q\u000e \u0003\u0002\u0003\u0006I!a\u0003\t\u0015\u0005%bH!b\u0001\n\u0003\u0011\t\b\u0003\u0006\u0003ty\u0012\t\u0011)A\u0005\u0003WA!\"a\u0013?\u0005\u000b\u0007I\u0011AA{\u0011)\u0011)H\u0010B\u0001B\u0003%\u0011Q\n\u0005\u000b\u0003+r$Q1A\u0005\u0002\u0005\u0005\u0006B\u0003B<}\t\u0005\t\u0015!\u0003\u0002X!Q\u0011\u0011\u000e \u0003\u0006\u0004%\t!!)\t\u0015\tedH!A!\u0002\u0013\t9\u0006\u0003\u0004w}\u0011\u0005!1\u0010\u0005\b\u0005OqD\u0011\tBE\u0011\u001d\u0011yB\u0010C!\u0005C\u0011\u0011cS1gW\u00064U-\u0019;ve\u0016\u001c\u0015m\u00195f\u0015\tqu*A\u0003lC\u001a\\\u0017M\u0003\u0002Q#\u000611\u000f\u001e:fC6T!AU*\u0002\r1\fWN\u00193b\u0015\t!V+A\u0004hK>lWm]1\u000b\u0005Y;\u0016\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"\u0001-\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0017\u0001Y\u0016Ma$\u0003\u0012\nM%\u0011\u0015\t\u00039~k\u0011!\u0018\u0006\u0002=\u0006)1oY1mC&\u0011\u0001-\u0018\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\tdbBA2\u0017\u001d\t!\u0017O\u0004\u0002fa:\u0011am\u001c\b\u0003O:t!\u0001[7\u000f\u0005%dW\"\u00016\u000b\u0005-L\u0016A\u0002\u001fs_>$h(C\u0001Y\u0013\t1v+\u0003\u0002U+&\u0011!kU\u0005\u0003!FK!AT(\u0002#-\u000bgm[1GK\u0006$XO]3DC\u000eDW\r\u0005\u0002u/5\tQj\u0005\u0002\u00187\u00061A(\u001b8jiz\"\u0012a\u001d\u0002\u0015%\u0016\fG-\u00192mK\u001a+\u0017\r^;sK\u000e\u000b7\r[3\u0014\u0005eY\u0016aA1mYR\tA\u0010E\u0003~\u0003\u000b\tYAD\u0002\u007f\u0003\u0003q!![@\n\u0003yK1!a\u0001^\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u0002\u0002\n\tA\u0011\n^3sCR|'OC\u0002\u0002\u0004u\u0003B!!\u0004\u0002 5\u0011\u0011q\u0002\u0006\u0005\u0003#\t\u0019\"\u0001\u0004tS6\u0004H.\u001a\u0006\u0005\u0003+\t9\"A\u0004gK\u0006$XO]3\u000b\t\u0005e\u00111D\u0001\u0004CBL'bAA\u000f/\u0006Aq-Z8u_>d7/\u0003\u0003\u0002\"\u0005=!!D*j[BdWMR3biV\u0014X-A\u0002hKR$B!a\u0003\u0002(!9\u0011\u0011F\u000eA\u0002\u0005-\u0012AA5e!\u0011\ti#!\u000e\u000f\t\u0005=\u0012\u0011\u0007\t\u0003SvK1!a\r^\u0003\u0019\u0001&/\u001a3fM&!\u0011qGA\u001d\u0005\u0019\u0019FO]5oO*\u0019\u00111G/\u0003)]\u0013\u0018\u000e^1cY\u00164U-\u0019;ve\u0016\u001c\u0015m\u00195f'\ta2,A\tqCJ$\u0018\u000e^5p]\u0006\u001b8/[4oK\u0012$b!a\u0011\u0002J\u0005M\u0003c\u0001/\u0002F%\u0019\u0011qI/\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003\u0017j\u0002\u0019AA'\u0003%\u0001\u0018M\u001d;ji&|g\u000eE\u0002]\u0003\u001fJ1!!\u0015^\u0005\rIe\u000e\u001e\u0005\b\u0003+j\u0002\u0019AA,\u0003\u0019ygMZ:fiB\u0019A,!\u0017\n\u0007\u0005mSL\u0001\u0003M_:<\u0017aA1eIRQ\u00111IA1\u0003G\n)'a\u001a\t\u000f\u0005Ua\u00041\u0001\u0002\f!9\u00111\n\u0010A\u0002\u00055\u0003bBA+=\u0001\u0007\u0011q\u000b\u0005\b\u0003Sr\u0002\u0019AA,\u0003\u001d\u0019'/Z1uK\u0012\fa\u0001Z3mKR,GCCA\"\u0003_\n\t(a\u001d\u0002v!9\u0011QC\u0010A\u0002\u0005-\u0001bBA&?\u0001\u0007\u0011Q\n\u0005\b\u0003+z\u0002\u0019AA,\u0011\u001d\tIg\ba\u0001\u0003/\u0012A#\u0012=qSJLgn\u001a$fCR,(/Z\"bG\",7C\u0001\u0011\\\u0003\u001d)\u0007\u0010]5sK\u0012$B!a \u0002\u0006B)Q0!!\u0002N%!\u00111QA\u0005\u0005\r\u0019V-\u001d\u0005\b\u0003\u000f\u000b\u0003\u0019AA,\u0003\u0019)\u0007\u0010]5ssR1\u00111\u0012B\u0017\u0005_\u00012!!$$\u001b\u00059\"aD#ya&\u0014X\r\u001a$fCR,(/Z:\u0014\r\rZ\u00161SAM!\ra\u0016QS\u0005\u0004\u0003/k&a\u0002)s_\u0012,8\r\u001e\t\u00049\u0006m\u0015bAAO;\na1+\u001a:jC2L'0\u00192mK\u0006IQ.\u0019=PM\u001a\u001cX\r^\u000b\u0003\u0003/\n!\"\\1y\u001f\u001a47/\u001a;!\u0003!1W-\u0019;ve\u0016\u001cXCAAU!\u0015i\u0018\u0011QAV!\r\tii\u000f\u0002\u000e\u001f\u001a47/\u001a;GK\u0006$XO]3\u0014\u0005mZVCAA\u0006\u0003%1W-\u0019;ve\u0016\u001c\b\u0005\u0006\u0004\u0002\f\u0006]\u0016\u0011\u0018\u0005\b\u0003?C\u0003\u0019AA,\u0011\u001d\t)\u000b\u000ba\u0001\u0003S\u000bAaY8qsR1\u00111RA`\u0003\u0003D\u0011\"a(*!\u0003\u0005\r!a\u0016\t\u0013\u0005\u0015\u0016\u0006%AA\u0002\u0005%\u0016AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003\u000fTC!a\u0016\u0002J.\u0012\u00111\u001a\t\u0005\u0003\u001b\f9.\u0004\u0002\u0002P*!\u0011\u0011[Aj\u0003%)hn\u00195fG.,GMC\u0002\u0002Vv\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\tI.a4\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005}'\u0006BAU\u0003\u0013\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAAs!\u0011\t9/!=\u000e\u0005\u0005%(\u0002BAv\u0003[\fA\u0001\\1oO*\u0011\u0011q^\u0001\u0005U\u00064\u0018-\u0003\u0003\u00028\u0005%\u0018\u0001\u00049s_\u0012,8\r^!sSRLXCAA'\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a?\u0003\u0002A\u0019A,!@\n\u0007\u0005}XLA\u0002B]fD\u0011Ba\u0001/\u0003\u0003\u0005\r!!\u0014\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011I\u0001\u0005\u0004\u0003\f\tE\u00111`\u0007\u0003\u0005\u001bQ1Aa\u0004^\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u000f\u0011i!\u0001\u0005dC:,\u0015/^1m)\u0011\u00119B!\b\u0011\u0007q\u0013I\"C\u0002\u0003\u001cu\u0013qAQ8pY\u0016\fg\u000eC\u0005\u0003\u0004A\n\t\u00111\u0001\u0002|\u0006A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002N\u0005AAo\\*ue&tw\r\u0006\u0002\u0002f\u00061Q-];bYN$BAa\u0006\u0003,!I!1A\u001a\u0002\u0002\u0003\u0007\u00111 \u0005\b\u0003\u0017\u0012\u0003\u0019AA'\u0011\u001d\t9I\ta\u0001\u0003/\nq\"\u0012=qSJ,GMR3biV\u0014Xm\u001d\t\u0004\u0003\u001b+4#B\u001b\u00038\u0005e\u0005C\u0003B\u001d\u0005\u007f\t9&!+\u0002\f6\u0011!1\b\u0006\u0004\u0005{i\u0016a\u0002:v]RLW.Z\u0005\u0005\u0005\u0003\u0012YDA\tBEN$(/Y2u\rVt7\r^5p]J\"\"Aa\r\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\r\u0005-%\u0011\nB&\u0011\u001d\ty\n\u000fa\u0001\u0003/Bq!!*9\u0001\u0004\tI+A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\tE#Q\f\t\u00069\nM#qK\u0005\u0004\u0005+j&AB(qi&|g\u000eE\u0004]\u00053\n9&!+\n\u0007\tmSL\u0001\u0004UkBdWM\r\u0005\n\u0005?J\u0014\u0011!a\u0001\u0003\u0017\u000b1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\t\u0015\u0004\u0003BAt\u0005OJAA!\u001b\u0002j\n1qJ\u00196fGR\u0014\u0001CR3biV\u0014XMU3gKJ,gnY3\u0014\tyZ\u00161V\u0001\tM\u0016\fG/\u001e:fAU\u0011\u00111F\u0001\u0004S\u0012\u0004\u0013A\u00039beRLG/[8oA\u00059qN\u001a4tKR\u0004\u0013\u0001C2sK\u0006$X\r\u001a\u0011\u0015\u0019\tu$q\u0010BA\u0005\u0007\u0013)Ia\"\u0011\u0007\u00055e\bC\u0004\u0002\u0016%\u0003\r!a\u0003\t\u000f\u0005%\u0012\n1\u0001\u0002,!9\u00111J%A\u0002\u00055\u0003bBA+\u0013\u0002\u0007\u0011q\u000b\u0005\b\u0003SJ\u0005\u0019AA,)\u0011\u00119Ba#\t\u000f\t5%\n1\u0001\u0002|\u0006)q\u000e\u001e5feB\u0011!-\u0007\t\u0003E\u0002\u0002BA!&\u0003\u001c:\u0019AMa&\n\u0007\teu*A\u0007PM\u001a\u001cX\r^'b]\u0006<WM]\u0005\u0005\u0005;\u0013yJ\u0001\bPM\u001a\u001cX\r\u001e'jgR,g.\u001a:\u000b\u0007\teu\n\u0005\u0003\u0003$\nEVB\u0001BS\u0015\u0011\u00119K!+\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\t\t-&QV\u0001\tif\u0004Xm]1gK*\u0011!qV\u0001\u0004G>l\u0017\u0002\u0002BZ\u0005K\u00131\u0002T1{s2{wmZ5oO\u0006)Ao\u001c9jGR!!\u0011\u0018B^!\t!\b\u0001C\u0004\u00036\n\u0001\r!a\u000b\u0016\u0005\t}\u0006\u0003\u0003Ba\u0005\u0017\fYCa4\u000e\u0005\t\r'\u0002\u0002Bc\u0005\u000f\f!bY8oGV\u0014(/\u001a8u\u0015\u0011\u0011I-!<\u0002\tU$\u0018\u000e\\\u0005\u0005\u0005\u001b\u0014\u0019MA\tD_:\u001cWO\u001d:f]RD\u0015m\u001d5NCB\u0004\"A\u0019 \u0002\rE,X-^3t+\t\u0011)\u000e\u0005\u0004\u0003X\nu'\u0011]\u0007\u0003\u00053TAAa7\u0003\u000e\u00059Q.\u001e;bE2,\u0017\u0002\u0002Bp\u00053\u00141\"\u0011:sCf\u0014UO\u001a4feB9AL!\u0017\u0003d\n=\b\u0003\u0002Bs\u0005Wl!Aa:\u000b\t\t%(1Y\u0001\u0006Y>\u001c7n]\u0005\u0005\u0005[\u00149OA\u0007SK\u0016tGO]1oi2{7m\u001b\t\u0007\u0005c\u0014\u0019Pa4\u000e\u0005\t\u001d\u0017\u0002\u0002B{\u0005\u000f\u0014!\"\u0011:sCf$U-];f\u0003\u001d\tX/Z;fg\u0002\nqa\u001c4gg\u0016$8/\u0006\u0002\u0003~B1!q\u001bBo\u0005\u007f\u0004Ba!\u0001\u0004\b5\u001111\u0001\u0006\u0005\u0007\u000b\u0011\u0019-\u0001\u0004bi>l\u0017nY\u0005\u0005\u0007\u0013\u0019\u0019A\u0001\u0006Bi>l\u0017n\u0019'p]\u001e\f\u0001b\u001c4gg\u0016$8\u000fI\u0001\u0006I\u0016\u0014WoZ\u000b\u0003\u0005/\ta\u0001Z3ck\u001e\u0004CCBA\"\u0007+\u00199\u0002C\u0004\u0002L-\u0001\r!!\u0014\t\u000f\u0005U3\u00021\u0001\u0002XQ!\u00111BB\u000e\u0011\u001d\tI\u0003\u0004a\u0001\u0003W!\"\"a\u0011\u0004 \r\u000521EB\u0013\u0011\u001d\t)B\u0004a\u0001\u0003\u0017Aq!a\u0013\u000f\u0001\u0004\ti\u0005C\u0004\u0002V9\u0001\r!a\u0016\t\u000f\u0005%d\u00021\u0001\u0002XQQ\u00111IB\u0015\u0007W\u0019ica\f\t\u000f\u0005Uq\u00021\u0001\u0002\f!9\u00111J\bA\u0002\u00055\u0003bBA+\u001f\u0001\u0007\u0011q\u000b\u0005\b\u0003Sz\u0001\u0019AA,)\u0011\tyha\r\t\u000f\u0005\u001d\u0005\u00031\u0001\u0002XQ11qGB\u001d\u0007w\u0001\"AY\u0012\t\u000f\u0005-\u0013\u00031\u0001\u0002N!9\u0011qQ\tA\u0002\u0005]\u0013!D8gMN,Go\u00115b]\u001e,G\r\u0006\u0004\u0002D\r\u000531\t\u0005\b\u0003\u0017\u0012\u0002\u0019AA'\u0011\u001d\t)F\u0005a\u0001\u0003/\nq\"\u001a8tkJ,\u0007+\u0019:uSRLwN\u001c\u000b\u0007\u0003\u0007\u001aIea\u0013\t\u000f\u0005-3\u00031\u0001\u0002N!9\u0011QK\nA\u0002\u0005]\u0013A\u0002:f[>4X\r\u0006\u0003\u0004R\rM\u0003#\u0002/\u0003T\t=\u0007bBA\u000b)\u0001\u0007!qZ\u0001\u0005I&4g\r\u0006\u0004\u0002,\re3Q\f\u0005\b\u00077*\u0002\u0019AA'\u0003!y'/[4j]\u0006d\u0007bBB0+\u0001\u0007\u0011QJ\u0001\bkB$\u0017\r^3e\u0001")
public class KafkaFeatureCache
implements WritableFeatureCache,
ReadableFeatureCache,
ExpiringFeatureCache,
OffsetManager.OffsetListener,
LazyLogging {
    private final String topic;
    private final ConcurrentHashMap<String, FeatureReference> features;
    private final ArrayBuffer<Tuple2<ReentrantLock, ArrayDeque<FeatureReference>>> queues;
    private final ArrayBuffer<AtomicLong> offsets;
    private final boolean debug;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        KafkaFeatureCache kafkaFeatureCache = this;
        synchronized (kafkaFeatureCache) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private ConcurrentHashMap<String, FeatureReference> features() {
        return this.features;
    }

    private ArrayBuffer<Tuple2<ReentrantLock, ArrayDeque<FeatureReference>>> queues() {
        return this.queues;
    }

    private ArrayBuffer<AtomicLong> offsets() {
        return this.offsets;
    }

    private boolean debug() {
        return this.debug;
    }

    @Override
    public void partitionAssigned(int partition, long offset) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Partition assigned: [{}:{}:{}]", new Object[]{this.topic, BoxesRunTime.boxToInteger((int)partition), BoxesRunTime.boxToLong((long)offset)});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.ensurePartition(partition, offset);
    }

    @Override
    public SimpleFeature get(String id) {
        FeatureReference result = this.features().get(id);
        if (result == null) {
            return null;
        }
        return result.feature();
    }

    @Override
    public Iterator<SimpleFeature> all() {
        return ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(this.features().values().iterator()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.feature());
    }

    @Override
    public void add(SimpleFeature feature, int partition, long offset, long created) {
        BoxedUnit boxedUnit;
        if (((AtomicLong)this.offsets().apply(partition)).get() < offset) {
            BoxedUnit boxedUnit2;
            if (this.logger().underlying().isTraceEnabled()) {
                this.logger().underlying().trace(new StringBuilder(23).append("Adding [").append(partition).append(":").append(offset).append("] ").append(feature).append(" created at ").append(ZonedDateTime.ofInstant(Instant.ofEpochMilli(created), ZoneOffset.UTC)).toString());
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            String id = feature.getID();
            FeatureReference ref = new FeatureReference(feature, id, partition, offset, created);
            this.features().put(id, ref);
            Tuple2 tuple2 = (Tuple2)this.queues().apply(partition);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ReentrantLock lock = (ReentrantLock)tuple2._1();
            ArrayDeque queue = (ArrayDeque)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)lock, (Object)queue);
            ReentrantLock lock2 = (ReentrantLock)tuple22._1();
            ArrayDeque queue2 = (ArrayDeque)tuple22._2();
            lock2.lock();
            try {
                queue2.addLast(new FeatureReference(null, id, partition, offset, created));
            }
            finally {
                lock2.unlock();
            }
            return;
        }
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace(new StringBuilder(25).append("Ignoring [").append(partition).append(":").append(offset).append("] ").append(feature).append(" created at ").append(ZonedDateTime.ofInstant(Instant.ofEpochMilli(created), ZoneOffset.UTC)).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    @Override
    public void delete(SimpleFeature feature, int partition, long offset, long created) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace(new StringBuilder(25).append("Deleting [").append(partition).append(":").append(offset).append("] ").append(feature).append(" created at ").append(ZonedDateTime.ofInstant(Instant.ofEpochMilli(created), ZoneOffset.UTC)).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.features().remove(feature.getID());
    }

    @Override
    public Seq<Object> expired(long expiry) {
        ArrayBuffer result = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        for (int i = 0; i < this.queues().length(); ++i) {
            FeatureReference peek;
            FeatureReference featureReference;
            Tuple2 tuple2 = (Tuple2)this.queues().apply(i);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ReentrantLock lock = (ReentrantLock)tuple2._1();
            ArrayDeque queue = (ArrayDeque)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)lock, (Object)queue);
            ReentrantLock lock2 = (ReentrantLock)tuple22._1();
            ArrayDeque queue2 = (ArrayDeque)tuple22._2();
            lock2.lock();
            try {
                featureReference = (FeatureReference)queue2.peek();
            }
            finally {
                lock2.unlock();
            }
            FeatureReference featureReference2 = peek = featureReference;
            if (featureReference2 == null) {
                continue;
            }
            if (expiry <= featureReference2.created()) continue;
            result.$plus$eq((Object)BoxesRunTime.boxToInteger((int)i));
        }
        return result.toSeq();
    }

    @Override
    public ExpiredFeatures expired(int partition, long expiry) {
        BoxedUnit boxedUnit;
        ArrayBuffer expired = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        Tuple2 tuple2 = (Tuple2)this.queues().apply(partition);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ReentrantLock lock = (ReentrantLock)tuple2._1();
        ArrayDeque queue = (ArrayDeque)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)lock, (Object)queue);
        ReentrantLock lock2 = (ReentrantLock)tuple22._1();
        ArrayDeque queue2 = (ArrayDeque)tuple22._2();
        boolean loop = true;
        while (loop) {
            BoxedUnit boxedUnit2;
            lock2.lock();
            FeatureReference poll = (FeatureReference)queue2.poll();
            if (poll == null) {
                lock2.unlock();
                loop = false;
                boxedUnit2 = BoxedUnit.UNIT;
                continue;
            }
            if (poll.created() > expiry) {
                try {
                    queue2.addFirst(poll);
                }
                finally {
                    lock2.unlock();
                }
                loop = false;
                boxedUnit2 = BoxedUnit.UNIT;
                continue;
            }
            lock2.unlock();
            boxedUnit2 = expired.$plus$eq((Object)poll);
        }
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Checking [{}:{}] for expired entries: found {} expired and {} remaining", new Object[]{this.topic, BoxesRunTime.boxToInteger((int)partition), BoxesRunTime.boxToInteger((int)expired.size()), BoxesRunTime.boxToInteger((int)queue2.size())});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        long maxExpiredOffset = expired.isEmpty() ? -1L : ((FeatureReference)expired.apply(expired.length() - 1)).offset();
        ArrayBuffer latest = (ArrayBuffer)expired.flatMap((Function1 & Serializable & scala.Serializable)ref -> Option$.MODULE$.option2Iterable(this.remove((FeatureReference)ref)), ArrayBuffer$.MODULE$.canBuildFrom());
        return new ExpiredFeatures(maxExpiredOffset, (Seq<OffsetFeature>)latest.toSeq());
    }

    @Override
    public void offsetChanged(int partition, long offset) {
        BoxedUnit boxedUnit;
        Tuple3 tuple3;
        BoxedUnit boxedUnit2;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Offsets changed for [{}:{}]: -> {}", new Object[]{this.topic, BoxesRunTime.boxToInteger((int)partition), BoxesRunTime.boxToLong((long)offset)});
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (this.queues().length() <= partition) {
            this.ensurePartition(partition, offset);
            return;
        }
        Tuple2 tuple2 = (Tuple2)this.queues().apply(partition);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ReentrantLock lock = (ReentrantLock)tuple2._1();
        ArrayDeque queue = (ArrayDeque)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)lock, (Object)queue);
        ReentrantLock lock2 = (ReentrantLock)tuple22._1();
        ArrayDeque queue2 = (ArrayDeque)tuple22._2();
        Tuple3 tuple32 = tuple3 = !this.debug() ? new Tuple3((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToLong((long)0L)) : new Tuple3((Object)BoxesRunTime.boxToInteger((int)this.features().size()), (Object)BoxesRunTime.boxToInteger((int)queue2.size()), (Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis()));
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        int featureSize = BoxesRunTime.unboxToInt((Object)tuple3._1());
        int queueSize = BoxesRunTime.unboxToInt((Object)tuple3._2());
        long start = BoxesRunTime.unboxToLong((Object)tuple3._3());
        Tuple3 tuple33 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)featureSize), (Object)BoxesRunTime.boxToInteger((int)queueSize), (Object)BoxesRunTime.boxToLong((long)start));
        int featureSize2 = BoxesRunTime.unboxToInt((Object)tuple33._1());
        int queueSize2 = BoxesRunTime.unboxToInt((Object)tuple33._2());
        long start2 = BoxesRunTime.unboxToLong((Object)tuple33._3());
        boolean loop = true;
        while (loop) {
            BoxedUnit boxedUnit3;
            lock2.lock();
            FeatureReference poll = (FeatureReference)queue2.poll();
            if (poll == null) {
                lock2.unlock();
                loop = false;
                boxedUnit3 = BoxedUnit.UNIT;
                continue;
            }
            if (poll.offset() > offset) {
                try {
                    queue2.addFirst(poll);
                }
                finally {
                    lock2.unlock();
                }
                loop = false;
                boxedUnit3 = BoxedUnit.UNIT;
                continue;
            }
            lock2.unlock();
            boxedUnit3 = this.remove(poll);
        }
        long last = ((AtomicLong)this.offsets().apply(partition)).get();
        while (last < offset && !((AtomicLong)this.offsets().apply(partition)).compareAndSet(last, offset)) {
            last = ((AtomicLong)this.offsets().apply(partition)).get();
        }
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder(65).append("Size of cached state for [").append(this.topic).append(":").append(partition).append("]: features (total): ").append(this.diff(featureSize2, this.features().size())).append(", offsets: ").append(this.diff(queueSize2, queue2.size())).append(" in ").append(System.currentTimeMillis() - start2).append("ms").toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    private synchronized void ensurePartition(int partition, long offset) {
        while (this.queues().length() <= partition) {
            this.queues().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ReentrantLock()), new ArrayDeque()));
            this.offsets().$plus$eq((Object)new AtomicLong(-1L));
        }
        ((AtomicLong)this.offsets().apply(partition)).set(offset);
    }

    private Option<FeatureReference> remove(FeatureReference feature) {
        FeatureReference current = this.features().get(feature.id());
        if (this.features().remove(feature.id(), feature)) {
            return Option$.MODULE$.apply((Object)current);
        }
        return None$.MODULE$;
    }

    private String diff(int original, int updated) {
        int arg$macro$1 = updated;
        int arg$macro$2 = updated - original;
        return new StringOps("%d (%+d)").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)arg$macro$1), BoxesRunTime.boxToInteger((int)arg$macro$2)}));
    }

    public KafkaFeatureCache(String topic) {
        this.topic = topic;
        LazyLogging.$init$((LazyLogging)this);
        this.features = new ConcurrentHashMap();
        this.queues = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        this.offsets = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        this.debug = this.logger().underlying().isDebugEnabled();
    }

    public static class ExpiredFeatures
    implements Product,
    scala.Serializable {
        private final long maxOffset;
        private final Seq<OffsetFeature> features;

        public long maxOffset() {
            return this.maxOffset;
        }

        public Seq<OffsetFeature> features() {
            return this.features;
        }

        public ExpiredFeatures copy(long maxOffset, Seq<OffsetFeature> features) {
            return new ExpiredFeatures(maxOffset, features);
        }

        public long copy$default$1() {
            return this.maxOffset();
        }

        public Seq<OffsetFeature> copy$default$2() {
            return this.features();
        }

        public String productPrefix() {
            return "ExpiredFeatures";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return BoxesRunTime.boxToLong((long)this.maxOffset());
                }
                case 1: {
                    return this.features();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ExpiredFeatures;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.maxOffset()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.features()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ExpiredFeatures)) return false;
            boolean bl = true;
            if (!bl) return false;
            ExpiredFeatures expiredFeatures = (ExpiredFeatures)x$1;
            if (this.maxOffset() != expiredFeatures.maxOffset()) return false;
            Seq<OffsetFeature> seq = this.features();
            Seq<OffsetFeature> seq2 = expiredFeatures.features();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            if (!expiredFeatures.canEqual(this)) return false;
            return true;
        }

        public ExpiredFeatures(long maxOffset, Seq<OffsetFeature> features) {
            this.maxOffset = maxOffset;
            this.features = features;
            Product.$init$((Product)this);
        }
    }

    public static interface ExpiringFeatureCache {
        public Seq<Object> expired(long var1);

        public ExpiredFeatures expired(int var1, long var2);
    }

    private static class FeatureReference
    implements OffsetFeature {
        private final SimpleFeature feature;
        private final String id;
        private final int partition;
        private final long offset;
        private final long created;

        @Override
        public SimpleFeature feature() {
            return this.feature;
        }

        public String id() {
            return this.id;
        }

        public int partition() {
            return this.partition;
        }

        @Override
        public long offset() {
            return this.offset;
        }

        public long created() {
            return this.created;
        }

        public boolean equals(Object other) {
            Object object = other;
            if (object instanceof FeatureReference) {
                FeatureReference featureReference = (FeatureReference)object;
                return this.partition() == featureReference.partition() && this.offset() == featureReference.offset();
            }
            return false;
        }

        public int hashCode() {
            Seq state = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{this.partition(), this.offset()}));
            return BoxesRunTime.unboxToInt((Object)((TraversableOnce)state.map((Function1)(JFunction1.mcIJ.sp & Serializable & scala.Serializable)x$7 -> Long.hashCode(x$7), Seq$.MODULE$.canBuildFrom())).foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)(JFunction2.mcIII.sp & Serializable & scala.Serializable)(a, b) -> 31 * a + b));
        }

        public FeatureReference(SimpleFeature feature, String id, int partition, long offset, long created) {
            this.feature = feature;
            this.id = id;
            this.partition = partition;
            this.offset = offset;
            this.created = created;
        }
    }

    public static interface OffsetFeature {
        public long offset();

        public SimpleFeature feature();
    }

    public static interface ReadableFeatureCache {
        public Iterator<SimpleFeature> all();

        public SimpleFeature get(String var1);
    }

    public static interface WritableFeatureCache {
        public void partitionAssigned(int var1, long var2);

        public void add(SimpleFeature var1, int var2, long var3, long var5);

        public void delete(SimpleFeature var1, int var2, long var3, long var5);
    }
}

