/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.lambda.stream.kafka;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Flushable;
import java.io.Serializable;
import java.time.Clock;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.producer.Partitioner;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.TopicPartition;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.FeatureWriter;
import org.geotools.api.data.Query;
import org.geotools.api.data.Transaction;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.Id;
import org.geotools.api.filter.identity.FeatureId;
import org.geotools.util.factory.Hints;
import org.locationtech.geomesa.features.SerializationOption;
import org.locationtech.geomesa.features.kryo.KryoBufferSimpleFeature;
import org.locationtech.geomesa.features.kryo.KryoFeatureSerializer;
import org.locationtech.geomesa.features.kryo.KryoFeatureSerializer$;
import org.locationtech.geomesa.filter.package$;
import org.locationtech.geomesa.index.geotools.GeoMesaFeatureWriter$;
import org.locationtech.geomesa.index.planning.QueryInterceptor;
import org.locationtech.geomesa.index.planning.QueryRunner;
import org.locationtech.geomesa.index.stats.GeoMesaStats;
import org.locationtech.geomesa.index.utils.ExplainLogging;
import org.locationtech.geomesa.index.utils.Explainer;
import org.locationtech.geomesa.kafka.versions.KafkaConsumerVersions$;
import org.locationtech.geomesa.lambda.data.LambdaDataStore;
import org.locationtech.geomesa.lambda.data.LambdaDataStore$;
import org.locationtech.geomesa.lambda.stream.OffsetManager;
import org.locationtech.geomesa.lambda.stream.TransientStore;
import org.locationtech.geomesa.lambda.stream.kafka.DataStorePersistence;
import org.locationtech.geomesa.lambda.stream.kafka.KafkaCacheLoader;
import org.locationtech.geomesa.lambda.stream.kafka.KafkaFeatureCache;
import org.locationtech.geomesa.lambda.stream.kafka.KafkaQueryRunner;
import org.locationtech.geomesa.lambda.stream.kafka.KafkaStore$;
import org.locationtech.geomesa.lambda.stream.kafka.KafkaStore$MessageTypes$;
import org.locationtech.geomesa.security.AuthorizationsProvider;
import org.locationtech.geomesa.utils.conf.GeoMesaSystemProperties;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.locationtech.geomesa.utils.io.IsCloseable;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.package;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction2;
import scala.util.control.NonFatal$;
import scala.util.hashing.MurmurHash3$;

@ScalaSignature(bytes="\u0006\u0001\u0011\u0015e\u0001B'O\u0001mC\u0001\u0002\u001f\u0001\u0003\u0002\u0003\u0006I!\u001f\u0005\u000b\u0003\u000f\u0001!Q1A\u0005\u0002\u0005%\u0001BCA\u000e\u0001\t\u0005\t\u0015!\u0003\u0002\f!Q\u0011Q\u0004\u0001\u0003\u0002\u0003\u0006I!a\b\t\u0015\u0005E\u0002A!A!\u0002\u0013\t\u0019\u0004\u0003\u0006\u0002^\u0001\u0011\t\u0011)A\u0006\u0003?Bq!a\u001b\u0001\t\u0003\ti\u0007C\u0005\u0002\u0000\u0001\u0011\r\u0011\"\u0003\u0002\u0002\"A\u0011\u0011\u0012\u0001!\u0002\u0013\t\u0019\tC\u0005\u0002\f\u0002\u0011\r\u0011\"\u0003\u0002\u000e\"A\u0011q\u0016\u0001!\u0002\u0013\ty\tC\u0005\u00022\u0002\u0011\r\u0011\"\u0003\u00024\"A\u0011Q\u0019\u0001!\u0002\u0013\t)\fC\u0005\u0002H\u0002\u0011\r\u0011\"\u0003\u0002J\"A\u0011\u0011\u001b\u0001!\u0002\u0013\tY\rC\u0005\u0002T\u0002\u0011\r\u0011\"\u0003\u0002V\"A\u0011q\u001d\u0001!\u0002\u0013\t9\u000eC\u0005\u0002j\u0002\u0011\r\u0011\"\u0003\u0002l\"A!1\u0002\u0001!\u0002\u0013\ti\u000fC\u0005\u0003\u000e\u0001\u0011\r\u0011\"\u0003\u0003\u0010!A!q\u0003\u0001!\u0002\u0013\u0011\t\u0002C\u0005\u0003\u001a\u0001\u0011\r\u0011\"\u0003\u0003\u001c!A!1\u0005\u0001!\u0002\u0013\u0011i\u0002C\u0005\u0003&\u0001\u0011\r\u0011\"\u0003\u0003(!A!\u0011\u0007\u0001!\u0002\u0013\u0011I\u0003C\u0004\u00034\u0001!\tE!\u000e\t\u000f\tu\u0002\u0001\"\u0011\u00036!9!q\b\u0001\u0005B\t\u0005\u0003\"\u0003BH\u0001E\u0005I\u0011\u0001BI\u0011%\u00119\u000bAI\u0001\n\u0003\u0011I\u000bC\u0005\u0003.\u0002\t\n\u0011\"\u0001\u00030\"I!1\u0017\u0001\u0012\u0002\u0013\u0005!Q\u0017\u0005\b\u0005s\u0003A\u0011\tB^\u0011\u001d\u00119\r\u0001C!\u0005\u0013DqA!4\u0001\t\u0003\u0012)\u0004C\u0004\u0003P\u0002!\tE!\u000e\t\u000f\tE\u0007\u0001\"\u0011\u00036\u001d9!1\u001b(\t\u0002\tUgAB'O\u0011\u0003\u00119\u000eC\u0004\u0002l\u001d\"\tA!7\t\u0013\tmwE1A\u0005\u0002\tu\u0007\u0002\u0003BuO\u0001\u0006IAa8\t\u0013\t-xE1A\u0005\u0002\t5\b\u0002CB\u0006O\u0001\u0006IAa<\b\u000f\r5q\u0005#\u0001\u0004\u0010\u0019911C\u0014\t\u0002\rU\u0001bBA6]\u0011\u00051q\u0003\u0005\n\u00073q#\u0019!C\u0001\u00077A\u0001b!\b/A\u0003%\u0011\u0011\u0016\u0005\n\u0007?q#\u0019!C\u0001\u00077A\u0001b!\t/A\u0003%\u0011\u0011\u0016\u0005\b\u0003c;C\u0011AB\u0012\u0011\u001d\t\tl\nC\u0001\u0007\u0017Bq!a#(\t\u0003\u0019y\u0006C\u0004\u0004n\u001d\"\taa\u001c\t\u0011\r\u0005u\u0005\"\u0001O\u0007\u0007C\u0001b!/(\t\u0003q51\u0018\u0005\t\u0007\u0007<C\u0011\u0001(\u0004F\u001a91\u0011[\u0014\u0001\u001d\u000eM\u0007BCB7w\t\u0005\t\u0015!\u0003\u0004r!Q1QT\u001e\u0003\u0002\u0003\u0006I!a!\t\u0015\r-6H!A!\u0002\u0013\u0019i\u000bC\u0004\u0002lm\"\ta!9\t\u000f\r-8\b\"\u0011\u0004n\"9A\u0011B\u001e\u0005B\u0011-aA\u0002C\bO\u0001!\t\u0002C\u0004\u0002l\t#\t\u0001\"\u0007\t\u0017\u0005M'\t1AA\u0002\u0013%\u0011Q\u001b\u0005\f\t;\u0011\u0005\u0019!a\u0001\n\u0013!y\u0002C\u0006\u0002h\n\u0003\r\u0011!Q!\n\u0005]\u0007\"CAq\u0005\n\u0007I\u0011\u0002C\u0013\u0011!!\u0019D\u0011Q\u0001\n\u0011\u001d\u0002b\u0002C\u001b\u0005\u0012\u0005Cq\u0007\u0005\b\t3\u0012E\u0011\tC.\u0011\u001d\u0011\tN\u0011C!\u0005kA\u0011\u0002b\u001e(#\u0003%\t\u0001\"\u001f\u0003\u0015-\u000bgm[1Ti>\u0014XM\u0003\u0002P!\u0006)1.\u00194lC*\u0011\u0011KU\u0001\u0007gR\u0014X-Y7\u000b\u0005M#\u0016A\u00027b[\n$\u0017M\u0003\u0002V-\u00069q-Z8nKN\f'BA,Y\u00031awnY1uS>tG/Z2i\u0015\u0005I\u0016aA8sO\u000e\u00011#\u0002\u0001]E\u001at\u0007CA/a\u001b\u0005q&\"A0\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005t&AB!osJ+g\r\u0005\u0002dI6\t\u0001+\u0003\u0002f!\nqAK]1og&,g\u000e^*u_J,\u0007CA4m\u001b\u0005A'BA5k\u0003\tIwNC\u0001l\u0003\u0011Q\u0017M^1\n\u00055D'!\u0003$mkND\u0017M\u00197f!\tyg/D\u0001q\u0015\t\t(/\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0002ti\u0006AA/\u001f9fg\u00064WMC\u0001v\u0003\r\u0019w.\\\u0005\u0003oB\u00141\u0002T1{s2{wmZ5oO\u0006\u0011Am\u001d\t\u0004u\u0006\rQ\"A>\u000b\u0005ql\u0018\u0001\u00023bi\u0006T!A`@\u0002\u0007\u0005\u0004\u0018NC\u0002\u0002\u0002a\u000b\u0001bZ3pi>|Gn]\u0005\u0004\u0003\u000bY(!\u0003#bi\u0006\u001cFo\u001c:f\u0003\r\u0019h\r^\u000b\u0003\u0003\u0017\u0001B!!\u0004\u0002\u00185\u0011\u0011q\u0002\u0006\u0005\u0003#\t\u0019\"\u0001\u0004tS6\u0004H.\u001a\u0006\u0004\u0003+i\u0018a\u00024fCR,(/Z\u0005\u0005\u00033\tyAA\tTS6\u0004H.\u001a$fCR,(/\u001a+za\u0016\fAa\u001d4uA\u0005a\u0011-\u001e;i!J|g/\u001b3feB)Q,!\t\u0002&%\u0019\u00111\u00050\u0003\r=\u0003H/[8o!\u0011\t9#!\f\u000e\u0005\u0005%\"bAA\u0016)\u0006A1/Z2ve&$\u00180\u0003\u0003\u00020\u0005%\"AF!vi\"|'/\u001b>bi&|gn\u001d)s_ZLG-\u001a:\u0002\r\r|gNZ5h!\u0011\t)$a\u0016\u000f\t\u0005]\u0012\u0011\u000b\b\u0005\u0003s\tyE\u0004\u0003\u0002<\u00055c\u0002BA\u001f\u0003\u0017rA!a\u0010\u0002J9!\u0011\u0011IA$\u001b\t\t\u0019EC\u0002\u0002Fi\u000ba\u0001\u0010:p_Rt\u0014\"A-\n\u0005]C\u0016BA+W\u0013\t\u0019F+\u0003\u0002}%&!\u00111KA+\u0003=a\u0015-\u001c2eC\u0012\u000bG/Y*u_J,'B\u0001?S\u0013\u0011\tI&a\u0017\u0003\u00191\u000bWN\u00193b\u0007>tg-[4\u000b\t\u0005M\u0013QK\u0001\u0006G2|7m\u001b\t\u0005\u0003C\n9'\u0004\u0002\u0002d)\u0019\u0011Q\r6\u0002\tQLW.Z\u0005\u0005\u0003S\n\u0019GA\u0003DY>\u001c7.\u0001\u0004=S:LGO\u0010\u000b\u000b\u0003_\n9(!\u001f\u0002|\u0005uD\u0003BA9\u0003k\u00022!a\u001d\u0001\u001b\u0005q\u0005\"CA/\u000fA\u0005\t9AA0\u0011\u0015Ax\u00011\u0001z\u0011\u001d\t9a\u0002a\u0001\u0003\u0017Aq!!\b\b\u0001\u0004\ty\u0002C\u0004\u00022\u001d\u0001\r!a\r\u0002\u001b=4gm]3u\u001b\u0006t\u0017mZ3s+\t\t\u0019\tE\u0002d\u0003\u000bK1!a\"Q\u00055yeMZ:fi6\u000bg.Y4fe\u0006qqN\u001a4tKRl\u0015M\\1hKJ\u0004\u0013\u0001\u00039s_\u0012,8-\u001a:\u0016\u0005\u0005=\u0005\u0003CAI\u0003?\u000b\u0019+a)\u000e\u0005\u0005M%\u0002BAF\u0003+SA!a&\u0002\u001a\u000691\r\\5f]R\u001c(bA(\u0002\u001c*\u0019\u0011Q\u0014-\u0002\r\u0005\u0004\u0018m\u00195f\u0013\u0011\t\t+a%\u0003\u0011A\u0013x\u000eZ;dKJ\u0004R!XAS\u0003SK1!a*_\u0005\u0015\t%O]1z!\ri\u00161V\u0005\u0004\u0003[s&\u0001\u0002\"zi\u0016\f\u0011\u0002\u001d:pIV\u001cWM\u001d\u0011\u0002\u000bQ|\u0007/[2\u0016\u0005\u0005U\u0006\u0003BA\\\u0003\u007fsA!!/\u0002<B\u0019\u0011\u0011\t0\n\u0007\u0005uf,\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0003\f\u0019M\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003{s\u0016A\u0002;pa&\u001c\u0007%A\u0003dC\u000eDW-\u0006\u0002\u0002LB!\u00111OAg\u0013\r\tyM\u0014\u0002\u0012\u0017\u000647.\u0019$fCR,(/Z\"bG\",\u0017AB2bG\",\u0007%\u0001\u0006tKJL\u0017\r\\5{KJ,\"!a6\u0011\t\u0005e\u00171]\u0007\u0003\u00037TA!!8\u0002`\u0006!1N]=p\u0015\r\t\t\u000fV\u0001\tM\u0016\fG/\u001e:fg&!\u0011Q]An\u0005UY%/_8GK\u0006$XO]3TKJL\u0017\r\\5{KJ\f1b]3sS\u0006d\u0017N_3sA\u0005a\u0011N\u001c;fe\u000e,\u0007\u000f^8sgV\u0011\u0011Q\u001e\t\u0005\u0003_\u0014)A\u0004\u0003\u0002r\u0006}h\u0002BAz\u0003stA!a\u000f\u0002v&\u0019\u0011q\u001f+\u0002\u000b%tG-\u001a=\n\t\u0005m\u0018Q`\u0001\ta2\fgN\\5oO*\u0019\u0011q\u001f+\n\t\t\u0005!1A\u0001\u0011#V,'/_%oi\u0016\u00148-\u001a9u_JTA!a?\u0002~&!!q\u0001B\u0005\u0005]\tV/\u001a:z\u0013:$XM]2faR|'OR1di>\u0014\u0018P\u0003\u0003\u0003\u0002\t\r\u0011!D5oi\u0016\u00148-\u001a9u_J\u001c\b%A\u0006rk\u0016\u0014\u0018PU;o]\u0016\u0014XC\u0001B\t!\u0011\t\u0019Ha\u0005\n\u0007\tUaJ\u0001\tLC\u001a\\\u0017-U;fef\u0014VO\u001c8fe\u0006a\u0011/^3ssJ+hN\\3sA\u00051An\\1eKJ,\"A!\b\u0011\t\u0005M$qD\u0005\u0004\u0005Cq%\u0001E&bM.\f7)Y2iK2{\u0017\rZ3s\u0003\u001daw.\u00193fe\u0002\n1\u0002]3sg&\u001cH/\u001a8dKV\u0011!\u0011\u0006\t\u0006;\u0006\u0005\"1\u0006\t\u0005\u0003g\u0012i#C\u0002\u000309\u0013A\u0003R1uCN#xN]3QKJ\u001c\u0018n\u001d;f]\u000e,\u0017\u0001\u00049feNL7\u000f^3oG\u0016\u0004\u0013\u0001D2sK\u0006$XmU2iK6\fGC\u0001B\u001c!\ri&\u0011H\u0005\u0004\u0005wq&\u0001B+oSR\fAB]3n_Z,7k\u00195f[\u0006\fAA]3bIRQ!1\tB)\u0005C\u0012IGa \u0011\t\t\u0015#1\n\b\u0005\u0003c\u00149%\u0003\u0003\u0003J\t\r\u0011aC)vKJL(+\u001e8oKJLAA!\u0014\u0003P\tY\u0011+^3ssJ+7/\u001e7u\u0015\u0011\u0011IEa\u0001\t\u0013\tMC\u0004%AA\u0002\tU\u0013A\u00024jYR,'\u000fE\u0003^\u0003C\u00119\u0006\u0005\u0003\u0003Z\tuSB\u0001B.\u0015\r\u0011\u0019&`\u0005\u0005\u0005?\u0012YF\u0001\u0004GS2$XM\u001d\u0005\n\u0005Gb\u0002\u0013!a\u0001\u0005K\n!\u0002\u001e:b]N4wN]7t!\u0015i\u0016\u0011\u0005B4!\u0015i\u0016QUA[\u0011%\u0011Y\u0007\bI\u0001\u0002\u0004\u0011i'A\u0003iS:$8\u000fE\u0003^\u0003C\u0011y\u0007\u0005\u0003\u0003r\tmTB\u0001B:\u0015\u0011\u0011)Ha\u001e\u0002\u000f\u0019\f7\r^8ss*\u0019!\u0011P@\u0002\tU$\u0018\u000e\\\u0005\u0005\u0005{\u0012\u0019HA\u0003IS:$8\u000fC\u0005\u0003\u0002r\u0001\n\u00111\u0001\u0003\u0004\u00069Q\r\u001f9mC&t\u0007\u0003\u0002BC\u0005\u0017k!Aa\"\u000b\t\t%\u0015Q`\u0001\u0006kRLGn]\u0005\u0005\u0005\u001b\u00139IA\u0005FqBd\u0017-\u001b8fe\u0006q!/Z1eI\u0011,g-Y;mi\u0012\nTC\u0001BJU\u0011\u0011)F!&,\u0005\t]\u0005\u0003\u0002BM\u0005Gk!Aa'\u000b\t\tu%qT\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!)_\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005K\u0013YJA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\faB]3bI\u0012\"WMZ1vYR$#'\u0006\u0002\u0003,*\"!Q\rBK\u00039\u0011X-\u00193%I\u00164\u0017-\u001e7uIM*\"A!-+\t\t5$QS\u0001\u000fe\u0016\fG\r\n3fM\u0006,H\u000e\u001e\u00135+\t\u00119L\u000b\u0003\u0003\u0004\nU\u0015!B<sSR,G\u0003\u0002B\u001c\u0005{CqAa0\"\u0001\u0004\u0011\t-\u0001\u0005pe&<\u0017N\\1m!\u0011\tiAa1\n\t\t\u0015\u0017q\u0002\u0002\u000e'&l\u0007\u000f\\3GK\u0006$XO]3\u0002\r\u0011,G.\u001a;f)\u0011\u00119Da3\t\u000f\t}&\u00051\u0001\u0003B\u00069\u0001/\u001a:tSN$\u0018!\u00024mkND\u0017!B2m_N,\u0017AC&bM.\f7\u000b^8sKB\u0019\u00111O\u0014\u0014\u0005\u001dbFC\u0001Bk\u0003]\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sKN\u0003XmY\"p]\u001aLw-\u0006\u0002\u0003`B!!\u0011\u001dBt\u001b\t\u0011\u0019OC\u0002\u0003f*\fA\u0001\\1oO&!\u0011\u0011\u0019Br\u0003a\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sKN\u0003XmY\"p]\u001aLw\rI\u0001\u0015\u0019>\fG-\u00138uKJ4\u0018\r\u001c)s_B,'\u000f^=\u0016\u0005\t=\b\u0003\u0002By\u0007\u000bqAAa=\u0003\u0000:!!Q\u001fB}\u001d\u0011\tYDa>\n\u0007\t%E+\u0003\u0003\u0003|\nu\u0018\u0001B2p]\u001aT1A!#U\u0013\u0011\u0019\taa\u0001\u0002/\u001d+w.T3tCNK8\u000f^3n!J|\u0007/\u001a:uS\u0016\u001c(\u0002\u0002B~\u0005{LAaa\u0002\u0004\n\tq1+_:uK6\u0004&o\u001c9feRL(\u0002BB\u0001\u0007\u0007\tQ\u0003T8bI&sG/\u001a:wC2\u0004&o\u001c9feRL\b%\u0001\u0007NKN\u001c\u0018mZ3UsB,7\u000fE\u0002\u0004\u00129j\u0011a\n\u0002\r\u001b\u0016\u001c8/Y4f)f\u0004Xm]\n\u0003]q#\"aa\u0004\u0002\u000b]\u0013\u0018\u000e^3\u0016\u0005\u0005%\u0016AB,sSR,\u0007%\u0001\u0004EK2,G/Z\u0001\b\t\u0016dW\r^3!)\u0019\t)l!\n\u0004*!91q\u0005\u001bA\u0002\u0005U\u0016A\u00018t\u0011\u001d\t9\u0001\u000ea\u0001\u0003\u0017As\u0001NB\u0017\u0007g\u00199\u0004E\u0002^\u0007_I1a!\r_\u0005)!W\r\u001d:fG\u0006$X\rZ\u0011\u0003\u0007k\t1EU3qY\u0006\u001cW\r\u001a\u0011xSRD\u0007\u0005T1nE\u0012\fG)\u0019;b'R|'/\u001a\u0018u_BL7-M\u0005$\u0003k\u001bId!\u0011\u0004<%!11HB\u001f\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%e)\u00191q\b0\u0002\u0015\u0011,\u0007O]3dCR,G-M\u0005$\u0007\u0007\u001a)ea\u0012\u0004@9\u0019Ql!\u0012\n\u0007\r}b,M\u0003#;z\u001bIEA\u0003tG\u0006d\u0017\r\u0006\u0004\u00026\u000e53q\n\u0005\b\u0007O)\u0004\u0019AA[\u0011\u001d\u0019\t&\u000ea\u0001\u0003k\u000b\u0001\u0002^=qK:\u000bW.\u001a\u0015\bk\r52QKB-C\t\u00199&\u00018E_\u0016\u001c\bE\\8uAI,G/\u001e:oA\r|'O]3di\u0002\"x\u000e]5dA%4\u0007\u0005^8qS\u000e\u0004\u0013n\u001d\u0011pm\u0016\u0014(/\u001b3eK:\u0004\u0013N\u001c\u0011uQ\u0016\u0004c-Z1ukJ,\u0007\u0005^=qK\u0002j\u0003E]3qY\u0006\u001cW\r\u001a\u0011xSRD\u0007\u0005T1nE\u0012\fG)\u0019;b'R|'/\u001a\u0018u_BL7-M\u0005$\u0003k\u001bIda\u0017\u0004<EJ1ea\u0011\u0004F\ru3qH\u0019\u0006Eus6\u0011\n\u000b\u0007\u0003\u001f\u001b\tga\u0019\t\u000f\u0005\u001da\u00071\u0001\u0002\f!91Q\r\u001cA\u0002\r\u001d\u0014aB2p]:,7\r\u001e\t\t\u0003o\u001bI'!.\u00026&!11NAb\u0005\ri\u0015\r]\u0001\tG>t7/^7feR11\u0011OB>\u0007{\u0002\u0002ba\u001d\u0004x\u0005\r\u00161U\u0007\u0003\u0007kRAa!\u001c\u0002\u0016&!1\u0011PB;\u0005!\u0019uN\\:v[\u0016\u0014\bbBB3o\u0001\u00071q\r\u0005\b\u0007\u007f:\u0004\u0019AA[\u0003\u00159'o\\;q\u0003%\u0019wN\\:v[\u0016\u00148\u000f\u0006\u0007\u0004\u0006\u000e]5\u0011TBN\u0007?\u001bI\u000b\u0005\u0004\u0004\b\u000eE5\u0011\u000f\b\u0005\u0007\u0013\u001biI\u0004\u0003\u0002B\r-\u0015\"A0\n\u0007\r=e,A\u0004qC\u000e\\\u0017mZ3\n\t\rM5Q\u0013\u0002\u0004'\u0016\f(bABH=\"91Q\r\u001dA\u0002\r\u001d\u0004bBAYq\u0001\u0007\u0011Q\u0017\u0005\b\u0007;C\u0004\u0019AAB\u0003\u001di\u0017M\\1hKJDqa!)9\u0001\u0004\u0019\u0019+A\u0006qCJ\fG\u000e\\3mSNl\u0007cA/\u0004&&\u00191q\u00150\u0003\u0007%sG\u000fC\u0004\u0004,b\u0002\ra!,\u0002\u0011\r\fG\u000e\u001c2bG.\u0004\u0012\"XBX\u0007G\u001b\u0019La\u000e\n\u0007\rEfLA\u0005Gk:\u001cG/[8oeA\u0019Ql!.\n\u0007\r]fL\u0001\u0003M_:<\u0017\u0001D:fe&\fG.\u001b>f\u0017\u0016LHCBAR\u0007{\u001by\fC\u0004\u0002fe\u0002\raa-\t\u000f\r\u0005\u0017\b1\u0001\u0002*\u00061\u0011m\u0019;j_:\fa\u0002Z3tKJL\u0017\r\\5{K.+\u0017\u0010\u0006\u0003\u0004H\u000e5\u0007cB/\u0004J\u000eM\u0016\u0011V\u0005\u0004\u0007\u0017t&A\u0002+va2,'\u0007C\u0004\u0004Pj\u0002\r!a)\u0002\u0007-,\u0017PA\fPM\u001a\u001cX\r\u001e*fE\u0006d\u0017M\\2f\u0019&\u001cH/\u001a8feN11h!6\u0004\\:\u0004BA!9\u0004X&!1\u0011\u001cBr\u0005\u0019y%M[3diB!11OBo\u0013\u0011\u0019yn!\u001e\u00033\r{gn];nKJ\u0014VMY1mC:\u001cW\rT5ti\u0016tWM\u001d\u000b\t\u0007G\u001c)oa:\u0004jB\u00191\u0011C\u001e\t\u000f\r5t\b1\u0001\u0004r!91QT A\u0002\u0005\r\u0005bBBV\u007f\u0001\u00071QV\u0001\u0014_:\u0004\u0016M\u001d;ji&|gn\u001d*fm>\\W\r\u001a\u000b\u0005\u0005o\u0019y\u000fC\u0004\u0004r\u0002\u0003\raa=\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]N\u0004ba!>\u0004z\u000euXBAB|\u0015\r\u0011IH[\u0005\u0005\u0007w\u001c9P\u0001\u0006D_2dWm\u0019;j_:\u0004Baa@\u0005\u00065\u0011A\u0011\u0001\u0006\u0005\t\u0007\tI*\u0001\u0004d_6lwN\\\u0005\u0005\t\u000f!\tA\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002)=t\u0007+\u0019:uSRLwN\\:BgNLwM\\3e)\u0011\u00119\u0004\"\u0004\t\u000f\rE\u0018\t1\u0001\u0004t\n!b)Z1ukJ,\u0017\n\u001a)beRLG/[8oKJ\u001cRAQBk\t'\u0001B!!%\u0005\u0016%!AqCAJ\u0005-\u0001\u0016M\u001d;ji&|g.\u001a:\u0015\u0005\u0011m\u0001cAB\t\u0005\u0006q1/\u001a:jC2L'0\u001a:`I\u0015\fH\u0003\u0002B\u001c\tCA\u0011\u0002b\tF\u0003\u0003\u0005\r!a6\u0002\u0007a$\u0013'\u0006\u0002\u0005(A1!\u0011\u001dC\u0015\t[IA\u0001b\u000b\u0003d\nYA\u000b\u001b:fC\u0012dunY1m!\u0011\tI\u000eb\f\n\t\u0011E\u00121\u001c\u0002\u0018\u0017JLxNQ;gM\u0016\u00148+[7qY\u00164U-\u0019;ve\u0016\f\u0011BZ3biV\u0014Xm\u001d\u0011\u0002\u0013A\f'\u000f^5uS>tGCDBR\ts!Y\u0004b\u0011\u0005H\u0011-Cq\n\u0005\b\u0003cK\u0005\u0019AA[\u0011\u001d\u0019y-\u0013a\u0001\t{\u00012!\u0018C \u0013\r!\tE\u0018\u0002\u0004\u0003:L\bb\u0002C#\u0013\u0002\u0007\u00111U\u0001\tW\u0016L()\u001f;fg\"9A\u0011J%A\u0002\u0011u\u0012!\u0002<bYV,\u0007b\u0002C'\u0013\u0002\u0007\u00111U\u0001\u000bm\u0006dW/\u001a\"zi\u0016\u001c\bb\u0002C)\u0013\u0002\u0007A1K\u0001\bG2,8\u000f^3s!\u0011\u0019y\u0010\"\u0016\n\t\u0011]C\u0011\u0001\u0002\b\u00072,8\u000f^3s\u0003%\u0019wN\u001c4jOV\u0014X\r\u0006\u0003\u00038\u0011u\u0003b\u0002C0\u0015\u0002\u0007A\u0011M\u0001\bG>tg-[4ta\u0011!\u0019\u0007b\u001b\u0011\u0011\rUHQMA[\tOJAaa\u001b\u0004xB!A\u0011\u000eC6\u0019\u0001!A\u0002\"\u001c\u0005^\u0005\u0005\t\u0011!B\u0001\t_\u00121a\u0018\u00132#\u0011!\t\b\"\u0010\u0011\u0007u#\u0019(C\u0002\u0005vy\u0013qAT8uQ&tw-A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%\u000e\u000b\u000b\tw\"i\bb \u0005\u0002\u0012\r%\u0006BA0\u0005+CQ\u0001\u001f'A\u0002eDq!a\u0002M\u0001\u0004\tY\u0001C\u0004\u0002\u001e1\u0003\r!a\b\t\u000f\u0005EB\n1\u0001\u00024\u0001")
public class KafkaStore
implements TransientStore,
Flushable,
LazyLogging {
    private final DataStore ds;
    private final SimpleFeatureType sft;
    private final LambdaDataStore.LambdaConfig config;
    private final Clock clock;
    private final OffsetManager offsetManager;
    private final Producer<byte[], byte[]> producer;
    private final String topic;
    private final KafkaFeatureCache cache;
    private final KryoFeatureSerializer serializer;
    private final QueryInterceptor.QueryInterceptorFactory interceptors;
    private final KafkaQueryRunner queryRunner;
    private final KafkaCacheLoader loader;
    private final Option<DataStorePersistence> persistence;
    private transient Logger logger;
    private final GeoMesaStats stats;
    private volatile transient boolean bitmap$trans$0;

    public static Clock $lessinit$greater$default$5(DataStore dataStore, SimpleFeatureType simpleFeatureType, Option<AuthorizationsProvider> option, LambdaDataStore.LambdaConfig lambdaConfig) {
        return KafkaStore$.MODULE$.$lessinit$greater$default$5(dataStore, simpleFeatureType, option, lambdaConfig);
    }

    public static Consumer<byte[], byte[]> consumer(scala.collection.immutable.Map<String, String> map, String string) {
        return KafkaStore$.MODULE$.consumer(map, string);
    }

    public static GeoMesaSystemProperties.SystemProperty LoadIntervalProperty() {
        return KafkaStore$.MODULE$.LoadIntervalProperty();
    }

    public static String SimpleFeatureSpecConfig() {
        return KafkaStore$.MODULE$.SimpleFeatureSpecConfig();
    }

    private Logger logger$lzycompute() {
        KafkaStore kafkaStore = this;
        synchronized (kafkaStore) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public GeoMesaStats stats() {
        return this.stats;
    }

    @Override
    public void org$locationtech$geomesa$lambda$stream$TransientStore$_setter_$stats_$eq(GeoMesaStats x$1) {
        this.stats = x$1;
    }

    @Override
    public SimpleFeatureType sft() {
        return this.sft;
    }

    private OffsetManager offsetManager() {
        return this.offsetManager;
    }

    private Producer<byte[], byte[]> producer() {
        return this.producer;
    }

    private String topic() {
        return this.topic;
    }

    private KafkaFeatureCache cache() {
        return this.cache;
    }

    private KryoFeatureSerializer serializer() {
        return this.serializer;
    }

    private QueryInterceptor.QueryInterceptorFactory interceptors() {
        return this.interceptors;
    }

    private KafkaQueryRunner queryRunner() {
        return this.queryRunner;
    }

    private KafkaCacheLoader loader() {
        return this.loader;
    }

    private Option<DataStorePersistence> persistence() {
        return this.persistence;
    }

    @Override
    public void createSchema() {
        Properties props = new Properties();
        this.config.producerConfig().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return props.put(k, v);
            }
            throw new MatchError((Object)tuple2);
        });
        package.WithClose$.MODULE$.apply((Object)AdminClient.create((Properties)props), (Function1 & Serializable & scala.Serializable)admin -> {
            if (((Set)admin.listTopics().names().get()).contains(this.topic())) {
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Topic [{}] already exists - it may contain stale data", new Object[]{this.topic()});
                    return BoxedUnit.UNIT;
                }
                return BoxedUnit.UNIT;
            }
            int replication = BoxesRunTime.unboxToInt((Object)new GeoMesaSystemProperties.SystemProperty("geomesa.kafka.replication", GeoMesaSystemProperties.SystemProperty$.MODULE$.apply$default$2()).option().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)KafkaStore.$anonfun$createSchema$3(x$1))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 1));
            NewTopic newTopic = new NewTopic(this.topic(), $this.config.partitions(), (short)replication);
            return admin.createTopics(Collections.singletonList(newTopic)).all().get();
        }, IsCloseable$.MODULE$.closeableIsCloseable());
    }

    @Override
    public void removeSchema() {
        this.offsetManager().deleteOffsets(this.topic());
        Properties props = new Properties();
        this.config.producerConfig().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return props.put(k, v);
            }
            throw new MatchError((Object)tuple2);
        });
        package.WithClose$.MODULE$.apply((Object)AdminClient.create((Properties)props), (Function1 & Serializable & scala.Serializable)admin -> {
            if (((Set)admin.listTopics().names().get()).contains(this.topic())) {
                return admin.deleteTopics(Collections.singletonList(this.topic())).all().get();
            }
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Topic [{}] does not exist, can't delete it", new Object[]{this.topic()});
                return BoxedUnit.UNIT;
            }
            return BoxedUnit.UNIT;
        }, IsCloseable$.MODULE$.closeableIsCloseable());
    }

    @Override
    public QueryRunner.QueryResult read(Option<Filter> filter, Option<String[]> transforms, Option<Hints> hints, Explainer explain) {
        Query query = new Query();
        filter.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            query.setFilter(x$1);
            return BoxedUnit.UNIT;
        });
        transforms.foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            query.setPropertyNames(x$2);
            return BoxedUnit.UNIT;
        });
        hints.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            query.setHints(x$1);
            return BoxedUnit.UNIT;
        });
        return this.queryRunner().runQuery(this.sft(), query, explain);
    }

    @Override
    public Option<Filter> read$default$1() {
        return None$.MODULE$;
    }

    @Override
    public Option<String[]> read$default$2() {
        return None$.MODULE$;
    }

    @Override
    public Option<Hints> read$default$3() {
        return None$.MODULE$;
    }

    @Override
    public Explainer read$default$4() {
        return new ExplainLogging();
    }

    @Override
    public void write(SimpleFeature original) {
        BoxedUnit boxedUnit;
        SimpleFeature feature = GeoMesaFeatureWriter$.MODULE$.featureWithFid(original);
        byte[] key = KafkaStore$.MODULE$.serializeKey(this.clock.millis(), KafkaStore$MessageTypes$.MODULE$.Write());
        this.producer().send(new ProducerRecord(this.topic(), (Object)key, (Object)this.serializer().serialize(feature)));
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("Wrote feature to [{}]: {}", new Object[]{this.topic(), feature});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    @Override
    public void delete(SimpleFeature original) {
        SimpleFeature feature = GeoMesaFeatureWriter$.MODULE$.featureWithFid(original);
        byte[] key = KafkaStore$.MODULE$.serializeKey(this.clock.millis(), KafkaStore$MessageTypes$.MODULE$.Delete());
        this.producer().send(new ProducerRecord(this.topic(), (Object)key, (Object)this.serializer().serialize(feature)));
        if (this.config.persist()) {
            Id filter = package$.MODULE$.ff().id(new FeatureId[]{package$.MODULE$.ff().featureId(feature.getID())});
            package.WithClose$.MODULE$.apply((Object)this.ds.getFeatureWriter(this.sft().getTypeName(), (Filter)filter, Transaction.AUTO_COMMIT), (Function1 & Serializable & scala.Serializable)writer -> {
                KafkaStore.$anonfun$delete$1(writer);
                return BoxedUnit.UNIT;
            }, IsCloseable$.MODULE$.closeableIsCloseable());
            return;
        }
    }

    @Override
    public void persist() {
        Option<DataStorePersistence> option = this.persistence();
        if (option instanceof Some) {
            Some some = (Some)option;
            DataStorePersistence p = (DataStorePersistence)some.value();
            p.run();
            return;
        }
        if (None$.MODULE$.equals(option)) {
            throw new IllegalStateException("Persistence disabled for this store");
        }
        throw new MatchError(option);
    }

    @Override
    public void flush() {
        this.producer().flush();
    }

    @Override
    public void close() {
        package.CloseWithLogging$.MODULE$.apply((Object)this.loader(), IsCloseable$.MODULE$.closeableIsCloseable());
        package.CloseWithLogging$.MODULE$.apply((Object)this.interceptors(), IsCloseable$.MODULE$.closeableIsCloseable());
        package.CloseWithLogging$.MODULE$.apply(this.persistence(), (IsCloseable)IsCloseable$.MODULE$.optionIsCloseable());
        this.offsetManager().removeOffsetListener(this.topic(), this.cache());
    }

    public static final /* synthetic */ int $anonfun$createSchema$3(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toInt();
    }

    public static final /* synthetic */ void $anonfun$delete$1(FeatureWriter writer) {
        while (writer.hasNext()) {
            writer.next();
            writer.remove();
        }
    }

    public KafkaStore(DataStore ds, SimpleFeatureType sft, Option<AuthorizationsProvider> authProvider, LambdaDataStore.LambdaConfig config, Clock clock) {
        this.ds = ds;
        this.sft = sft;
        this.config = config;
        this.clock = clock;
        TransientStore.$init$(this);
        LazyLogging.$init$((LazyLogging)this);
        this.offsetManager = config.offsetManager();
        this.producer = KafkaStore$.MODULE$.producer(sft, config.producerConfig());
        this.topic = LambdaDataStore$.MODULE$.topic(sft, config.zkNamespace());
        this.cache = new KafkaFeatureCache(this.topic());
        scala.collection.immutable.Set options = SerializationOption.SerializationOptions$.MODULE$.builder().withUserData().withoutFidHints().immutable().lazy().build();
        this.serializer = KryoFeatureSerializer$.MODULE$.apply(sft, options);
        this.interceptors = QueryInterceptor.QueryInterceptorFactory$.MODULE$.apply(ds);
        this.queryRunner = new KafkaQueryRunner(this.cache(), authProvider, this.interceptors());
        Seq<Consumer<byte[], byte[]>> consumers = KafkaStore$.MODULE$.consumers(config.consumerConfig(), this.topic(), this.offsetManager(), config.consumers(), (Function2<Object, Object, BoxedUnit>)(JFunction2.mcVIJ.sp & Serializable & scala.Serializable)(partition, offset) -> this.cache().partitionAssigned(partition, offset));
        long frequency = ((Duration)KafkaStore$.MODULE$.LoadIntervalProperty().toDuration().get()).toMillis();
        this.loader = new KafkaCacheLoader(consumers, this.topic(), frequency, this.serializer(), this.cache());
        Duration duration = config.expiry();
        Duration.Infinite infinite = Duration$.MODULE$.Inf();
        this.persistence = !(duration != null ? !duration.equals(infinite) : infinite != null) ? None$.MODULE$ : new Some((Object)new DataStorePersistence(ds, sft, this.offsetManager(), this.cache(), this.topic(), config.expiry().toMillis(), config.persist(), clock));
        this.offsetManager().addOffsetListener(this.topic(), this.cache());
    }

    public static class FeatureIdPartitioner
    implements Partitioner {
        private KryoFeatureSerializer org$locationtech$geomesa$lambda$stream$kafka$KafkaStore$FeatureIdPartitioner$$serializer;
        private final ThreadLocal<KryoBufferSimpleFeature> features = new ThreadLocal<KryoBufferSimpleFeature>(this){
            private final /* synthetic */ FeatureIdPartitioner $outer;

            public KryoBufferSimpleFeature initialValue() {
                return this.$outer.org$locationtech$geomesa$lambda$stream$kafka$KafkaStore$FeatureIdPartitioner$$serializer().getReusableFeature();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };

        @Deprecated
        public void onNewBatch(String x$1, Cluster x$2, int x$3) {
            super.onNewBatch(x$1, x$2, x$3);
        }

        public KryoFeatureSerializer org$locationtech$geomesa$lambda$stream$kafka$KafkaStore$FeatureIdPartitioner$$serializer() {
            return this.org$locationtech$geomesa$lambda$stream$kafka$KafkaStore$FeatureIdPartitioner$$serializer;
        }

        private void org$locationtech$geomesa$lambda$stream$kafka$KafkaStore$FeatureIdPartitioner$$serializer_$eq(KryoFeatureSerializer x$1) {
            this.org$locationtech$geomesa$lambda$stream$kafka$KafkaStore$FeatureIdPartitioner$$serializer = x$1;
        }

        private ThreadLocal<KryoBufferSimpleFeature> features() {
            return this.features;
        }

        public int partition(String topic, Object key, byte[] keyBytes, Object value, byte[] valueBytes, Cluster cluster) {
            int numPartitions = cluster.partitionsForTopic(topic).size();
            if (numPartitions < 2) {
                return 0;
            }
            KryoBufferSimpleFeature feature = this.features().get();
            feature.setBuffer(valueBytes);
            return Math.abs(MurmurHash3$.MODULE$.stringHash(feature.getID())) % numPartitions;
        }

        public void configure(Map<String, ?> configs) {
            Object obj = configs.get(KafkaStore$.MODULE$.SimpleFeatureSpecConfig());
            if (!(obj instanceof String)) {
                throw new IllegalStateException(new StringBuilder(26).append("Invalid spec config for ").append(KafkaStore$.MODULE$.SimpleFeatureSpecConfig()).append(": ").append(obj).toString());
            }
            String string = (String)obj;
            String spec = string;
            scala.collection.immutable.Set options = SerializationOption.SerializationOptions$.MODULE$.builder().immutable().lazy().build();
            this.org$locationtech$geomesa$lambda$stream$kafka$KafkaStore$FeatureIdPartitioner$$serializer_$eq(KryoFeatureSerializer$.MODULE$.apply(SimpleFeatureTypes$.MODULE$.createType("", spec), options));
        }

        public void close() {
        }
    }

    public static class OffsetRebalanceListener
    implements ConsumerRebalanceListener,
    LazyLogging {
        private final Consumer<byte[], byte[]> consumer;
        private final OffsetManager manager;
        private final Function2<Object, Object, BoxedUnit> callback;
        private transient Logger logger;
        private volatile transient boolean bitmap$trans$0;

        public void onPartitionsLost(Collection<TopicPartition> x$1) {
            super.onPartitionsLost(x$1);
        }

        private Logger logger$lzycompute() {
            OffsetRebalanceListener offsetRebalanceListener = this;
            synchronized (offsetRebalanceListener) {
                if (!this.bitmap$trans$0) {
                    this.logger = LazyLogging.logger$((LazyLogging)this);
                    this.bitmap$trans$0 = true;
                }
            }
            return this.logger;
        }

        public Logger logger() {
            if (!this.bitmap$trans$0) {
                return this.logger$lzycompute();
            }
            return this.logger;
        }

        public void onPartitionsRevoked(Collection<TopicPartition> topicPartitions) {
        }

        public void onPartitionsAssigned(Collection<TopicPartition> topicPartitions) {
            ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(topicPartitions).asScala()).foreach((Function1 & Serializable & scala.Serializable)tp -> {
                OffsetRebalanceListener.$anonfun$onPartitionsAssigned$1(this, tp);
                return BoxedUnit.UNIT;
            });
        }

        private final long seekToBeginning$1(TopicPartition tp$1) {
            KafkaConsumerVersions$.MODULE$.seekToBeginning(this.consumer, tp$1);
            return this.consumer.position(tp$1) - 1L;
        }

        public static final /* synthetic */ void $anonfun$onPartitionsAssigned$1(OffsetRebalanceListener $this, TopicPartition tp) {
            long l;
            long lastRead = $this.manager.getOffset(tp.topic(), tp.partition());
            KafkaConsumerVersions$.MODULE$.pause($this.consumer, tp);
            if (lastRead < 0L) {
                l = $this.seekToBeginning$1(tp);
            } else {
                try {
                    $this.consumer.seek(tp, lastRead + 1L);
                    l = lastRead;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (!option.isEmpty()) {
                        BoxedUnit boxedUnit;
                        Throwable e = (Throwable)option.get();
                        if ($this.logger().underlying().isWarnEnabled()) {
                            $this.logger().underlying().warn(new StringBuilder(61).append("Error seeking to initial offset: [").append(tp.topic()).append(":").append(tp.partition()).append(":").append(lastRead).append("]").append(", seeking to beginning: ").append(e).toString());
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        l = $this.seekToBeginning$1(tp);
                    }
                    throw throwable;
                }
            }
            long offset = l;
            $this.callback.apply$mcVIJ$sp(tp.partition(), offset);
            KafkaConsumerVersions$.MODULE$.resume($this.consumer, tp);
        }

        public OffsetRebalanceListener(Consumer<byte[], byte[]> consumer, OffsetManager manager, Function2<Object, Object, BoxedUnit> callback) {
            this.consumer = consumer;
            this.manager = manager;
            this.callback = callback;
            LazyLogging.$init$((LazyLogging)this);
        }
    }
}

