/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.mapreduce;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;

public class CountofDoubleWritable
implements Writable,
WritableComparable {
    private double value = 0.0;
    private double count = 0.0;

    public CountofDoubleWritable() {
    }

    public CountofDoubleWritable(double value, double count) {
        this.set(value, count);
    }

    public void readFields(DataInput in) throws IOException {
        this.value = in.readDouble();
        this.count = in.readDouble();
    }

    public void write(DataOutput out) throws IOException {
        out.writeDouble(this.value);
        out.writeDouble(this.count);
    }

    public void set(double value, double count) {
        this.value = value;
        this.count = count;
    }

    public double getValue() {
        return this.value;
    }

    public double getCount() {
        return this.count;
    }

    public boolean equals(Object o) {
        if (!(o instanceof CountofDoubleWritable)) {
            return false;
        }
        return this.compareTo(o) == 0;
    }

    public int hashCode() {
        return (int)Double.doubleToLongBits(this.value / this.count);
    }

    public int compareTo(Object o) {
        CountofDoubleWritable other = (CountofDoubleWritable)o;
        double diff = this.value / this.count - other.value / other.count;
        return Math.abs(diff) < 1.0E-7 ? 0 : (diff < 0.0 ? -1 : 0);
    }

    public String toString() {
        return Double.toString(this.value) + "/" + Double.toString(this.count);
    }

    static {
        WritableComparator.define(CountofDoubleWritable.class, (WritableComparator)new Comparator());
    }

    public static class Comparator
    extends WritableComparator
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public Comparator() {
            super(CountofDoubleWritable.class);
        }

        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            double thisValue = Comparator.readDouble((byte[])b1, (int)s1);
            double thatValue = Comparator.readDouble((byte[])b2, (int)s2);
            return Double.compare(thisValue, thatValue);
        }
    }
}

