/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.analytic.mapreduce;

import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;

public class DoubleOutputFormat<K, V>
extends FileOutputFormat<K, V> {
    public RecordWriter<K, V> getRecordWriter(TaskAttemptContext job) throws IOException, InterruptedException {
        Configuration conf = job.getConfiguration();
        Path file = this.getDefaultWorkFile(job, "");
        FileSystem fs = file.getFileSystem(conf);
        FSDataOutputStream fileOut = fs.create(file, false);
        return new DoubleRecordWriter((DataOutputStream)fileOut);
    }

    protected static class DoubleRecordWriter<K, V>
    extends RecordWriter<K, V> {
        protected DataOutputStream out;

        public DoubleRecordWriter(DataOutputStream out) {
            this.out = out;
        }

        public synchronized void write(K key, V value) throws IOException {
            if (value != null && !(value instanceof NullWritable)) {
                this.out.writeDouble(((DoubleWritable)value).get());
            }
        }

        public synchronized void close(TaskAttemptContext context) throws IOException {
            this.out.close();
        }
    }
}

